/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse;

public class DescribeReservedInstancesIterable
implements SdkIterable<DescribeReservedInstancesResponse> {
    private final OpenSearchClient client;
    private final DescribeReservedInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedInstancesIterable(OpenSearchClient client, DescribeReservedInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedInstancesResponseFetcher();
    }

    public Iterator<DescribeReservedInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeReservedInstancesResponseFetcher
    implements SyncPageFetcher<DescribeReservedInstancesResponse> {
        private DescribeReservedInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeReservedInstancesResponse nextPage(DescribeReservedInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesIterable.this.client.describeReservedInstances(DescribeReservedInstancesIterable.this.firstRequest);
            }
            return DescribeReservedInstancesIterable.this.client.describeReservedInstances((DescribeReservedInstancesRequest)((Object)DescribeReservedInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

