/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainRequest;
import software.amazon.awssdk.services.opensearch.model.ListPackagesForDomainResponse;

public class ListPackagesForDomainPublisher
implements SdkPublisher<ListPackagesForDomainResponse> {
    private final OpenSearchAsyncClient client;
    private final ListPackagesForDomainRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPackagesForDomainPublisher(OpenSearchAsyncClient client, ListPackagesForDomainRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPackagesForDomainPublisher(OpenSearchAsyncClient client, ListPackagesForDomainRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPackagesForDomainResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPackagesForDomainResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPackagesForDomainResponseFetcher
    implements AsyncPageFetcher<ListPackagesForDomainResponse> {
        private ListPackagesForDomainResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagesForDomainResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPackagesForDomainResponse> nextPage(ListPackagesForDomainResponse previousPage) {
            if (previousPage == null) {
                return ListPackagesForDomainPublisher.this.client.listPackagesForDomain(ListPackagesForDomainPublisher.this.firstRequest);
            }
            return ListPackagesForDomainPublisher.this.client.listPackagesForDomain((ListPackagesForDomainRequest)((Object)ListPackagesForDomainPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

