/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse;

public class GetUpgradeHistoryPublisher
implements SdkPublisher<GetUpgradeHistoryResponse> {
    private final OpenSearchAsyncClient client;
    private final GetUpgradeHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUpgradeHistoryPublisher(OpenSearchAsyncClient client, GetUpgradeHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUpgradeHistoryPublisher(OpenSearchAsyncClient client, GetUpgradeHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUpgradeHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUpgradeHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetUpgradeHistoryResponseFetcher
    implements AsyncPageFetcher<GetUpgradeHistoryResponse> {
        private GetUpgradeHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetUpgradeHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetUpgradeHistoryResponse> nextPage(GetUpgradeHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetUpgradeHistoryPublisher.this.client.getUpgradeHistory(GetUpgradeHistoryPublisher.this.firstRequest);
            }
            return GetUpgradeHistoryPublisher.this.client.getUpgradeHistory((GetUpgradeHistoryRequest)((Object)GetUpgradeHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

