/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse;

public class DescribeOutboundConnectionsIterable
implements SdkIterable<DescribeOutboundConnectionsResponse> {
    private final OpenSearchClient client;
    private final DescribeOutboundConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOutboundConnectionsIterable(OpenSearchClient client, DescribeOutboundConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOutboundConnectionsResponseFetcher();
    }

    public Iterator<DescribeOutboundConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeOutboundConnectionsResponseFetcher
    implements SyncPageFetcher<DescribeOutboundConnectionsResponse> {
        private DescribeOutboundConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOutboundConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeOutboundConnectionsResponse nextPage(DescribeOutboundConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOutboundConnectionsIterable.this.client.describeOutboundConnections(DescribeOutboundConnectionsIterable.this.firstRequest);
            }
            return DescribeOutboundConnectionsIterable.this.client.describeOutboundConnections((DescribeOutboundConnectionsRequest)((Object)DescribeOutboundConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

