/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.DomainInformationContainer;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.services.opensearch.model.OutboundConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOutboundConnectionResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, CreateOutboundConnectionResponse> {
    private static final SdkField<DomainInformationContainer> LOCAL_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalDomainInfo").getter(CreateOutboundConnectionResponse.getter(CreateOutboundConnectionResponse::localDomainInfo)).setter(CreateOutboundConnectionResponse.setter(Builder::localDomainInfo)).constructor(DomainInformationContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDomainInfo").build()}).build();
    private static final SdkField<DomainInformationContainer> REMOTE_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteDomainInfo").getter(CreateOutboundConnectionResponse.getter(CreateOutboundConnectionResponse::remoteDomainInfo)).setter(CreateOutboundConnectionResponse.setter(Builder::remoteDomainInfo)).constructor(DomainInformationContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainInfo").build()}).build();
    private static final SdkField<String> CONNECTION_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionAlias").getter(CreateOutboundConnectionResponse.getter(CreateOutboundConnectionResponse::connectionAlias)).setter(CreateOutboundConnectionResponse.setter(Builder::connectionAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAlias").build()}).build();
    private static final SdkField<OutboundConnectionStatus> CONNECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionStatus").getter(CreateOutboundConnectionResponse.getter(CreateOutboundConnectionResponse::connectionStatus)).setter(CreateOutboundConnectionResponse.setter(Builder::connectionStatus)).constructor(OutboundConnectionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionStatus").build()}).build();
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionId").getter(CreateOutboundConnectionResponse.getter(CreateOutboundConnectionResponse::connectionId)).setter(CreateOutboundConnectionResponse.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_DOMAIN_INFO_FIELD, REMOTE_DOMAIN_INFO_FIELD, CONNECTION_ALIAS_FIELD, CONNECTION_STATUS_FIELD, CONNECTION_ID_FIELD));
    private final DomainInformationContainer localDomainInfo;
    private final DomainInformationContainer remoteDomainInfo;
    private final String connectionAlias;
    private final OutboundConnectionStatus connectionStatus;
    private final String connectionId;

    private CreateOutboundConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.localDomainInfo = builder.localDomainInfo;
        this.remoteDomainInfo = builder.remoteDomainInfo;
        this.connectionAlias = builder.connectionAlias;
        this.connectionStatus = builder.connectionStatus;
        this.connectionId = builder.connectionId;
    }

    public final DomainInformationContainer localDomainInfo() {
        return this.localDomainInfo;
    }

    public final DomainInformationContainer remoteDomainInfo() {
        return this.remoteDomainInfo;
    }

    public final String connectionAlias() {
        return this.connectionAlias;
    }

    public final OutboundConnectionStatus connectionStatus() {
        return this.connectionStatus;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.localDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOutboundConnectionResponse)) {
            return false;
        }
        CreateOutboundConnectionResponse other = (CreateOutboundConnectionResponse)((Object)obj);
        return Objects.equals(this.localDomainInfo(), other.localDomainInfo()) && Objects.equals(this.remoteDomainInfo(), other.remoteDomainInfo()) && Objects.equals(this.connectionAlias(), other.connectionAlias()) && Objects.equals(this.connectionStatus(), other.connectionStatus()) && Objects.equals(this.connectionId(), other.connectionId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOutboundConnectionResponse").add("LocalDomainInfo", (Object)this.localDomainInfo()).add("RemoteDomainInfo", (Object)this.remoteDomainInfo()).add("ConnectionAlias", (Object)this.connectionAlias()).add("ConnectionStatus", (Object)this.connectionStatus()).add("ConnectionId", (Object)this.connectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.localDomainInfo()));
            }
            case "RemoteDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainInfo()));
            }
            case "ConnectionAlias": {
                return Optional.ofNullable(clazz.cast(this.connectionAlias()));
            }
            case "ConnectionStatus": {
                return Optional.ofNullable(clazz.cast(this.connectionStatus()));
            }
            case "ConnectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOutboundConnectionResponse, T> g) {
        return obj -> g.apply((CreateOutboundConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private DomainInformationContainer localDomainInfo;
        private DomainInformationContainer remoteDomainInfo;
        private String connectionAlias;
        private OutboundConnectionStatus connectionStatus;
        private String connectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOutboundConnectionResponse model) {
            super(model);
            this.localDomainInfo(model.localDomainInfo);
            this.remoteDomainInfo(model.remoteDomainInfo);
            this.connectionAlias(model.connectionAlias);
            this.connectionStatus(model.connectionStatus);
            this.connectionId(model.connectionId);
        }

        public final DomainInformationContainer.Builder getLocalDomainInfo() {
            return this.localDomainInfo != null ? this.localDomainInfo.toBuilder() : null;
        }

        public final void setLocalDomainInfo(DomainInformationContainer.BuilderImpl localDomainInfo) {
            this.localDomainInfo = localDomainInfo != null ? localDomainInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder localDomainInfo(DomainInformationContainer localDomainInfo) {
            this.localDomainInfo = localDomainInfo;
            return this;
        }

        public final DomainInformationContainer.Builder getRemoteDomainInfo() {
            return this.remoteDomainInfo != null ? this.remoteDomainInfo.toBuilder() : null;
        }

        public final void setRemoteDomainInfo(DomainInformationContainer.BuilderImpl remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo != null ? remoteDomainInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder remoteDomainInfo(DomainInformationContainer remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo;
            return this;
        }

        public final String getConnectionAlias() {
            return this.connectionAlias;
        }

        public final void setConnectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
        }

        @Override
        @Transient
        public final Builder connectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
            return this;
        }

        public final OutboundConnectionStatus.Builder getConnectionStatus() {
            return this.connectionStatus != null ? this.connectionStatus.toBuilder() : null;
        }

        public final void setConnectionStatus(OutboundConnectionStatus.BuilderImpl connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder connectionStatus(OutboundConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus;
            return this;
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        @Transient
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        @Override
        public CreateOutboundConnectionResponse build() {
            return new CreateOutboundConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOutboundConnectionResponse> {
        public Builder localDomainInfo(DomainInformationContainer var1);

        default public Builder localDomainInfo(Consumer<DomainInformationContainer.Builder> localDomainInfo) {
            return this.localDomainInfo((DomainInformationContainer)((DomainInformationContainer.Builder)DomainInformationContainer.builder().applyMutation(localDomainInfo)).build());
        }

        public Builder remoteDomainInfo(DomainInformationContainer var1);

        default public Builder remoteDomainInfo(Consumer<DomainInformationContainer.Builder> remoteDomainInfo) {
            return this.remoteDomainInfo((DomainInformationContainer)((DomainInformationContainer.Builder)DomainInformationContainer.builder().applyMutation(remoteDomainInfo)).build());
        }

        public Builder connectionAlias(String var1);

        public Builder connectionStatus(OutboundConnectionStatus var1);

        default public Builder connectionStatus(Consumer<OutboundConnectionStatus.Builder> connectionStatus) {
            return this.connectionStatus((OutboundConnectionStatus)((OutboundConnectionStatus.Builder)OutboundConnectionStatus.builder().applyMutation(connectionStatus)).build());
        }

        public Builder connectionId(String var1);
    }
}

