/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListCopier;
import software.amazon.awssdk.services.omics.model.CompleteReadSetUploadPartListItem;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompleteMultipartReadSetUploadRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CompleteMultipartReadSetUploadRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(CompleteMultipartReadSetUploadRequest.getter(CompleteMultipartReadSetUploadRequest::sequenceStoreId)).setter(CompleteMultipartReadSetUploadRequest.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(CompleteMultipartReadSetUploadRequest.getter(CompleteMultipartReadSetUploadRequest::uploadId)).setter(CompleteMultipartReadSetUploadRequest.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()}).build();
    private static final SdkField<List<CompleteReadSetUploadPartListItem>> PARTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parts").getter(CompleteMultipartReadSetUploadRequest.getter(CompleteMultipartReadSetUploadRequest::parts)).setter(CompleteMultipartReadSetUploadRequest.setter(Builder::parts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompleteReadSetUploadPartListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD, UPLOAD_ID_FIELD, PARTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompleteMultipartReadSetUploadRequest.memberNameToFieldInitializer();
    private final String sequenceStoreId;
    private final String uploadId;
    private final List<CompleteReadSetUploadPartListItem> parts;

    private CompleteMultipartReadSetUploadRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.uploadId = builder.uploadId;
        this.parts = builder.parts;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final boolean hasParts() {
        return this.parts != null && !(this.parts instanceof SdkAutoConstructList);
    }

    public final List<CompleteReadSetUploadPartListItem> parts() {
        return this.parts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParts() ? this.parts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteMultipartReadSetUploadRequest)) {
            return false;
        }
        CompleteMultipartReadSetUploadRequest other = (CompleteMultipartReadSetUploadRequest)((Object)obj);
        return Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.uploadId(), other.uploadId()) && this.hasParts() == other.hasParts() && Objects.equals(this.parts(), other.parts());
    }

    public final String toString() {
        return ToString.builder((String)"CompleteMultipartReadSetUploadRequest").add("SequenceStoreId", (Object)this.sequenceStoreId()).add("UploadId", (Object)this.uploadId()).add("Parts", this.hasParts() ? this.parts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "parts": {
                return Optional.ofNullable(clazz.cast(this.parts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("parts", PARTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompleteMultipartReadSetUploadRequest, T> g) {
        return obj -> g.apply((CompleteMultipartReadSetUploadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String sequenceStoreId;
        private String uploadId;
        private List<CompleteReadSetUploadPartListItem> parts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteMultipartReadSetUploadRequest model) {
            super(model);
            this.sequenceStoreId(model.sequenceStoreId);
            this.uploadId(model.uploadId);
            this.parts(model.parts);
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final List<CompleteReadSetUploadPartListItem.Builder> getParts() {
            List<CompleteReadSetUploadPartListItem.Builder> result = CompleteReadSetUploadPartListCopier.copyToBuilder(this.parts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParts(Collection<CompleteReadSetUploadPartListItem.BuilderImpl> parts) {
            this.parts = CompleteReadSetUploadPartListCopier.copyFromBuilder(parts);
        }

        @Override
        public final Builder parts(Collection<CompleteReadSetUploadPartListItem> parts) {
            this.parts = CompleteReadSetUploadPartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(CompleteReadSetUploadPartListItem ... parts) {
            this.parts(Arrays.asList(parts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(Consumer<CompleteReadSetUploadPartListItem.Builder> ... parts) {
            this.parts(Stream.of(parts).map(c -> (CompleteReadSetUploadPartListItem)((CompleteReadSetUploadPartListItem.Builder)CompleteReadSetUploadPartListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteMultipartReadSetUploadRequest build() {
            return new CompleteMultipartReadSetUploadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompleteMultipartReadSetUploadRequest> {
        public Builder sequenceStoreId(String var1);

        public Builder uploadId(String var1);

        public Builder parts(Collection<CompleteReadSetUploadPartListItem> var1);

        public Builder parts(CompleteReadSetUploadPartListItem ... var1);

        public Builder parts(Consumer<CompleteReadSetUploadPartListItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

