/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReferenceItem;
import software.amazon.awssdk.services.omics.model.StoreFormat;
import software.amazon.awssdk.services.omics.model.StoreOptions;
import software.amazon.awssdk.services.omics.model.StoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnnotationStoreResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, UpdateAnnotationStoreResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateAnnotationStoreResponse.getter(UpdateAnnotationStoreResponse::id)).setter(UpdateAnnotationStoreResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reference").getter(UpdateAnnotationStoreResponse.getter(UpdateAnnotationStoreResponse::reference)).setter(UpdateAnnotationStoreResponse.setter(Builder::reference)).constructor(ReferenceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateAnnotationStoreResponse.getter(UpdateAnnotationStoreResponse::statusAsString)).setter(UpdateAnnotationStoreResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateAnnotationStoreResponse.getter(UpdateAnnotationStoreResponse::name)).setter(UpdateAnnotationStoreResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAnnotationStoreResponse.getter(UpdateAnnotationStoreResponse::description)).setter(UpdateAnnotationStoreResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(UpdateAnnotationStoreResponse.getter(UpdateAnnotationStoreResponse::creationTime)).setter(UpdateAnnotationStoreResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(UpdateAnnotationStoreResponse.getter(UpdateAnnotationStoreResponse::updateTime)).setter(UpdateAnnotationStoreResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<StoreOptions> STORE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storeOptions").getter(UpdateAnnotationStoreResponse.getter(UpdateAnnotationStoreResponse::storeOptions)).setter(UpdateAnnotationStoreResponse.setter(Builder::storeOptions)).constructor(StoreOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeOptions").build()}).build();
    private static final SdkField<String> STORE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeFormat").getter(UpdateAnnotationStoreResponse.getter(UpdateAnnotationStoreResponse::storeFormatAsString)).setter(UpdateAnnotationStoreResponse.setter(Builder::storeFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REFERENCE_FIELD, STATUS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, UPDATE_TIME_FIELD, STORE_OPTIONS_FIELD, STORE_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAnnotationStoreResponse.memberNameToFieldInitializer();
    private final String id;
    private final ReferenceItem reference;
    private final String status;
    private final String name;
    private final String description;
    private final Instant creationTime;
    private final Instant updateTime;
    private final StoreOptions storeOptions;
    private final String storeFormat;

    private UpdateAnnotationStoreResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.reference = builder.reference;
        this.status = builder.status;
        this.name = builder.name;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
        this.storeOptions = builder.storeOptions;
        this.storeFormat = builder.storeFormat;
    }

    public final String id() {
        return this.id;
    }

    public final ReferenceItem reference() {
        return this.reference;
    }

    public final StoreStatus status() {
        return StoreStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final StoreOptions storeOptions() {
        return this.storeOptions;
    }

    public final StoreFormat storeFormat() {
        return StoreFormat.fromValue(this.storeFormat);
    }

    public final String storeFormatAsString() {
        return this.storeFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnnotationStoreResponse)) {
            return false;
        }
        UpdateAnnotationStoreResponse other = (UpdateAnnotationStoreResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.reference(), other.reference()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.storeOptions(), other.storeOptions()) && Objects.equals(this.storeFormatAsString(), other.storeFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnnotationStoreResponse").add("Id", (Object)this.id()).add("Reference", (Object)this.reference()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("UpdateTime", (Object)this.updateTime()).add("StoreOptions", (Object)this.storeOptions()).add("StoreFormat", (Object)this.storeFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "storeOptions": {
                return Optional.ofNullable(clazz.cast(this.storeOptions()));
            }
            case "storeFormat": {
                return Optional.ofNullable(clazz.cast(this.storeFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("reference", REFERENCE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("storeOptions", STORE_OPTIONS_FIELD);
        map.put("storeFormat", STORE_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnnotationStoreResponse, T> g) {
        return obj -> g.apply((UpdateAnnotationStoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String id;
        private ReferenceItem reference;
        private String status;
        private String name;
        private String description;
        private Instant creationTime;
        private Instant updateTime;
        private StoreOptions storeOptions;
        private String storeFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnnotationStoreResponse model) {
            super(model);
            this.id(model.id);
            this.reference(model.reference);
            this.status(model.status);
            this.name(model.name);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.updateTime(model.updateTime);
            this.storeOptions(model.storeOptions);
            this.storeFormat(model.storeFormat);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ReferenceItem.Builder getReference() {
            return this.reference != null ? this.reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final StoreOptions.Builder getStoreOptions() {
            return this.storeOptions != null ? this.storeOptions.toBuilder() : null;
        }

        public final void setStoreOptions(StoreOptions.BuilderImpl storeOptions) {
            this.storeOptions = storeOptions != null ? storeOptions.build() : null;
        }

        @Override
        public final Builder storeOptions(StoreOptions storeOptions) {
            this.storeOptions = storeOptions;
            return this;
        }

        public final String getStoreFormat() {
            return this.storeFormat;
        }

        public final void setStoreFormat(String storeFormat) {
            this.storeFormat = storeFormat;
        }

        @Override
        public final Builder storeFormat(String storeFormat) {
            this.storeFormat = storeFormat;
            return this;
        }

        @Override
        public final Builder storeFormat(StoreFormat storeFormat) {
            this.storeFormat(storeFormat == null ? null : storeFormat.toString());
            return this;
        }

        @Override
        public UpdateAnnotationStoreResponse build() {
            return new UpdateAnnotationStoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnnotationStoreResponse> {
        public Builder id(String var1);

        public Builder reference(ReferenceItem var1);

        default public Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return this.reference((ReferenceItem)((ReferenceItem.Builder)ReferenceItem.builder().applyMutation(reference)).build());
        }

        public Builder status(String var1);

        public Builder status(StoreStatus var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder creationTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder storeOptions(StoreOptions var1);

        default public Builder storeOptions(Consumer<StoreOptions.Builder> storeOptions) {
            return this.storeOptions((StoreOptions)((StoreOptions.Builder)StoreOptions.builder().applyMutation(storeOptions)).build());
        }

        public Builder storeFormat(String var1);

        public Builder storeFormat(StoreFormat var1);
    }
}

