/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.VariantImportJobItem;
import software.amazon.awssdk.services.omics.model.VariantImportJobItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVariantImportJobsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListVariantImportJobsResponse> {
    private static final SdkField<List<VariantImportJobItem>> VARIANT_IMPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variantImportJobs").getter(ListVariantImportJobsResponse.getter(ListVariantImportJobsResponse::variantImportJobs)).setter(ListVariantImportJobsResponse.setter(Builder::variantImportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variantImportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariantImportJobItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVariantImportJobsResponse.getter(ListVariantImportJobsResponse::nextToken)).setter(ListVariantImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIANT_IMPORT_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVariantImportJobsResponse.memberNameToFieldInitializer();
    private final List<VariantImportJobItem> variantImportJobs;
    private final String nextToken;

    private ListVariantImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.variantImportJobs = builder.variantImportJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVariantImportJobs() {
        return this.variantImportJobs != null && !(this.variantImportJobs instanceof SdkAutoConstructList);
    }

    public final List<VariantImportJobItem> variantImportJobs() {
        return this.variantImportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariantImportJobs() ? this.variantImportJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVariantImportJobsResponse)) {
            return false;
        }
        ListVariantImportJobsResponse other = (ListVariantImportJobsResponse)((Object)obj);
        return this.hasVariantImportJobs() == other.hasVariantImportJobs() && Objects.equals(this.variantImportJobs(), other.variantImportJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVariantImportJobsResponse").add("VariantImportJobs", this.hasVariantImportJobs() ? this.variantImportJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variantImportJobs": {
                return Optional.ofNullable(clazz.cast(this.variantImportJobs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("variantImportJobs", VARIANT_IMPORT_JOBS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVariantImportJobsResponse, T> g) {
        return obj -> g.apply((ListVariantImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private List<VariantImportJobItem> variantImportJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVariantImportJobsResponse model) {
            super(model);
            this.variantImportJobs(model.variantImportJobs);
            this.nextToken(model.nextToken);
        }

        public final List<VariantImportJobItem.Builder> getVariantImportJobs() {
            List<VariantImportJobItem.Builder> result = VariantImportJobItemsCopier.copyToBuilder(this.variantImportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariantImportJobs(Collection<VariantImportJobItem.BuilderImpl> variantImportJobs) {
            this.variantImportJobs = VariantImportJobItemsCopier.copyFromBuilder(variantImportJobs);
        }

        @Override
        public final Builder variantImportJobs(Collection<VariantImportJobItem> variantImportJobs) {
            this.variantImportJobs = VariantImportJobItemsCopier.copy(variantImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantImportJobs(VariantImportJobItem ... variantImportJobs) {
            this.variantImportJobs(Arrays.asList(variantImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantImportJobs(Consumer<VariantImportJobItem.Builder> ... variantImportJobs) {
            this.variantImportJobs(Stream.of(variantImportJobs).map(c -> (VariantImportJobItem)((VariantImportJobItem.Builder)VariantImportJobItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVariantImportJobsResponse build() {
            return new ListVariantImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVariantImportJobsResponse> {
        public Builder variantImportJobs(Collection<VariantImportJobItem> var1);

        public Builder variantImportJobs(VariantImportJobItem ... var1);

        public Builder variantImportJobs(Consumer<VariantImportJobItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

