/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.AnnotationFieldMapCopier;
import software.amazon.awssdk.services.omics.model.AnnotationImportItemSource;
import software.amazon.awssdk.services.omics.model.AnnotationImportItemSourcesCopier;
import software.amazon.awssdk.services.omics.model.FormatOptions;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAnnotationImportJobRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, StartAnnotationImportJobRequest> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationName").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::destinationName)).setter(StartAnnotationImportJobRequest.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::roleArn)).setter(StartAnnotationImportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<List<AnnotationImportItemSource>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::items)).setter(StartAnnotationImportJobRequest.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnnotationImportItemSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::versionName)).setter(StartAnnotationImportJobRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("formatOptions").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::formatOptions)).setter(StartAnnotationImportJobRequest.setter(Builder::formatOptions)).constructor(FormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatOptions").build()}).build();
    private static final SdkField<Boolean> RUN_LEFT_NORMALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("runLeftNormalization").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::runLeftNormalization)).setter(StartAnnotationImportJobRequest.setter(Builder::runLeftNormalization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runLeftNormalization").build()}).build();
    private static final SdkField<Map<String, String>> ANNOTATION_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("annotationFields").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::annotationFields)).setter(StartAnnotationImportJobRequest.setter(Builder::annotationFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD, ROLE_ARN_FIELD, ITEMS_FIELD, VERSION_NAME_FIELD, FORMAT_OPTIONS_FIELD, RUN_LEFT_NORMALIZATION_FIELD, ANNOTATION_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartAnnotationImportJobRequest.memberNameToFieldInitializer();
    private final String destinationName;
    private final String roleArn;
    private final List<AnnotationImportItemSource> items;
    private final String versionName;
    private final FormatOptions formatOptions;
    private final Boolean runLeftNormalization;
    private final Map<String, String> annotationFields;

    private StartAnnotationImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.roleArn = builder.roleArn;
        this.items = builder.items;
        this.versionName = builder.versionName;
        this.formatOptions = builder.formatOptions;
        this.runLeftNormalization = builder.runLeftNormalization;
        this.annotationFields = builder.annotationFields;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<AnnotationImportItemSource> items() {
        return this.items;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final FormatOptions formatOptions() {
        return this.formatOptions;
    }

    public final Boolean runLeftNormalization() {
        return this.runLeftNormalization;
    }

    public final boolean hasAnnotationFields() {
        return this.annotationFields != null && !(this.annotationFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> annotationFields() {
        return this.annotationFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.runLeftNormalization());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotationFields() ? this.annotationFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAnnotationImportJobRequest)) {
            return false;
        }
        StartAnnotationImportJobRequest other = (StartAnnotationImportJobRequest)((Object)obj);
        return Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.formatOptions(), other.formatOptions()) && Objects.equals(this.runLeftNormalization(), other.runLeftNormalization()) && this.hasAnnotationFields() == other.hasAnnotationFields() && Objects.equals(this.annotationFields(), other.annotationFields());
    }

    public final String toString() {
        return ToString.builder((String)"StartAnnotationImportJobRequest").add("DestinationName", (Object)this.destinationName()).add("RoleArn", (Object)this.roleArn()).add("Items", this.hasItems() ? this.items() : null).add("VersionName", (Object)this.versionName()).add("FormatOptions", (Object)this.formatOptions()).add("RunLeftNormalization", (Object)this.runLeftNormalization()).add("AnnotationFields", this.hasAnnotationFields() ? this.annotationFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "formatOptions": {
                return Optional.ofNullable(clazz.cast(this.formatOptions()));
            }
            case "runLeftNormalization": {
                return Optional.ofNullable(clazz.cast(this.runLeftNormalization()));
            }
            case "annotationFields": {
                return Optional.ofNullable(clazz.cast(this.annotationFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destinationName", DESTINATION_NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("formatOptions", FORMAT_OPTIONS_FIELD);
        map.put("runLeftNormalization", RUN_LEFT_NORMALIZATION_FIELD);
        map.put("annotationFields", ANNOTATION_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAnnotationImportJobRequest, T> g) {
        return obj -> g.apply((StartAnnotationImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String destinationName;
        private String roleArn;
        private List<AnnotationImportItemSource> items = DefaultSdkAutoConstructList.getInstance();
        private String versionName;
        private FormatOptions formatOptions;
        private Boolean runLeftNormalization;
        private Map<String, String> annotationFields = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartAnnotationImportJobRequest model) {
            super(model);
            this.destinationName(model.destinationName);
            this.roleArn(model.roleArn);
            this.items(model.items);
            this.versionName(model.versionName);
            this.formatOptions(model.formatOptions);
            this.runLeftNormalization(model.runLeftNormalization);
            this.annotationFields(model.annotationFields);
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<AnnotationImportItemSource.Builder> getItems() {
            List<AnnotationImportItemSource.Builder> result = AnnotationImportItemSourcesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AnnotationImportItemSource.BuilderImpl> items) {
            this.items = AnnotationImportItemSourcesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AnnotationImportItemSource> items) {
            this.items = AnnotationImportItemSourcesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AnnotationImportItemSource ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AnnotationImportItemSource.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (AnnotationImportItemSource)((AnnotationImportItemSource.Builder)AnnotationImportItemSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return this.formatOptions != null ? this.formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final Boolean getRunLeftNormalization() {
            return this.runLeftNormalization;
        }

        public final void setRunLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
        }

        @Override
        public final Builder runLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
            return this;
        }

        public final Map<String, String> getAnnotationFields() {
            if (this.annotationFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.annotationFields;
        }

        public final void setAnnotationFields(Map<String, String> annotationFields) {
            this.annotationFields = AnnotationFieldMapCopier.copy(annotationFields);
        }

        @Override
        public final Builder annotationFields(Map<String, String> annotationFields) {
            this.annotationFields = AnnotationFieldMapCopier.copy(annotationFields);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAnnotationImportJobRequest build() {
            return new StartAnnotationImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAnnotationImportJobRequest> {
        public Builder destinationName(String var1);

        public Builder roleArn(String var1);

        public Builder items(Collection<AnnotationImportItemSource> var1);

        public Builder items(AnnotationImportItemSource ... var1);

        public Builder items(Consumer<AnnotationImportItemSource.Builder> ... var1);

        public Builder versionName(String var1);

        public Builder formatOptions(FormatOptions var1);

        default public Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return this.formatOptions((FormatOptions)((FormatOptions.Builder)FormatOptions.builder().applyMutation(formatOptions)).build());
        }

        public Builder runLeftNormalization(Boolean var1);

        public Builder annotationFields(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

