/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CacheBehavior {
    CACHE_ON_FAILURE("CACHE_ON_FAILURE"),
    CACHE_ALWAYS("CACHE_ALWAYS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CacheBehavior> VALUE_MAP;
    private final String value;

    private CacheBehavior(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CacheBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CacheBehavior> knownValues() {
        EnumSet<CacheBehavior> knownValues = EnumSet.allOf(CacheBehavior.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CacheBehavior.class, CacheBehavior::toString);
    }
}

