/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.VersionOptions;
import software.amazon.awssdk.services.omics.model.VersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnnotationStoreVersionResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, CreateAnnotationStoreVersionResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateAnnotationStoreVersionResponse.getter(CreateAnnotationStoreVersionResponse::id)).setter(CreateAnnotationStoreVersionResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(CreateAnnotationStoreVersionResponse.getter(CreateAnnotationStoreVersionResponse::versionName)).setter(CreateAnnotationStoreVersionResponse.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<String> STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeId").getter(CreateAnnotationStoreVersionResponse.getter(CreateAnnotationStoreVersionResponse::storeId)).setter(CreateAnnotationStoreVersionResponse.setter(Builder::storeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeId").build()}).build();
    private static final SdkField<VersionOptions> VERSION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("versionOptions").getter(CreateAnnotationStoreVersionResponse.getter(CreateAnnotationStoreVersionResponse::versionOptions)).setter(CreateAnnotationStoreVersionResponse.setter(Builder::versionOptions)).constructor(VersionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionOptions").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAnnotationStoreVersionResponse.getter(CreateAnnotationStoreVersionResponse::name)).setter(CreateAnnotationStoreVersionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateAnnotationStoreVersionResponse.getter(CreateAnnotationStoreVersionResponse::statusAsString)).setter(CreateAnnotationStoreVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(CreateAnnotationStoreVersionResponse.getter(CreateAnnotationStoreVersionResponse::creationTime)).setter(CreateAnnotationStoreVersionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VERSION_NAME_FIELD, STORE_ID_FIELD, VERSION_OPTIONS_FIELD, NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAnnotationStoreVersionResponse.memberNameToFieldInitializer();
    private final String id;
    private final String versionName;
    private final String storeId;
    private final VersionOptions versionOptions;
    private final String name;
    private final String status;
    private final Instant creationTime;

    private CreateAnnotationStoreVersionResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.versionName = builder.versionName;
        this.storeId = builder.storeId;
        this.versionOptions = builder.versionOptions;
        this.name = builder.name;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String storeId() {
        return this.storeId;
    }

    public final VersionOptions versionOptions() {
        return this.versionOptions;
    }

    public final String name() {
        return this.name;
    }

    public final VersionStatus status() {
        return VersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnnotationStoreVersionResponse)) {
            return false;
        }
        CreateAnnotationStoreVersionResponse other = (CreateAnnotationStoreVersionResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.storeId(), other.storeId()) && Objects.equals(this.versionOptions(), other.versionOptions()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnnotationStoreVersionResponse").add("Id", (Object)this.id()).add("VersionName", (Object)this.versionName()).add("StoreId", (Object)this.storeId()).add("VersionOptions", (Object)this.versionOptions()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "storeId": {
                return Optional.ofNullable(clazz.cast(this.storeId()));
            }
            case "versionOptions": {
                return Optional.ofNullable(clazz.cast(this.versionOptions()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("storeId", STORE_ID_FIELD);
        map.put("versionOptions", VERSION_OPTIONS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnnotationStoreVersionResponse, T> g) {
        return obj -> g.apply((CreateAnnotationStoreVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String id;
        private String versionName;
        private String storeId;
        private VersionOptions versionOptions;
        private String name;
        private String status;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnnotationStoreVersionResponse model) {
            super(model);
            this.id(model.id);
            this.versionName(model.versionName);
            this.storeId(model.storeId);
            this.versionOptions(model.versionOptions);
            this.name(model.name);
            this.status(model.status);
            this.creationTime(model.creationTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getStoreId() {
            return this.storeId;
        }

        public final void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        @Override
        public final Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public final VersionOptions.Builder getVersionOptions() {
            return this.versionOptions != null ? this.versionOptions.toBuilder() : null;
        }

        public final void setVersionOptions(VersionOptions.BuilderImpl versionOptions) {
            this.versionOptions = versionOptions != null ? versionOptions.build() : null;
        }

        @Override
        public final Builder versionOptions(VersionOptions versionOptions) {
            this.versionOptions = versionOptions;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateAnnotationStoreVersionResponse build() {
            return new CreateAnnotationStoreVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnnotationStoreVersionResponse> {
        public Builder id(String var1);

        public Builder versionName(String var1);

        public Builder storeId(String var1);

        public Builder versionOptions(VersionOptions var1);

        default public Builder versionOptions(Consumer<VersionOptions.Builder> versionOptions) {
            return this.versionOptions((VersionOptions)((VersionOptions.Builder)VersionOptions.builder().applyMutation(versionOptions)).build());
        }

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(VersionStatus var1);

        public Builder creationTime(Instant var1);
    }
}

