/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReferenceItem;
import software.amazon.awssdk.services.omics.model.StoreFormat;
import software.amazon.awssdk.services.omics.model.StoreOptions;
import software.amazon.awssdk.services.omics.model.StoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnnotationStoreResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, CreateAnnotationStoreResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateAnnotationStoreResponse.getter(CreateAnnotationStoreResponse::id)).setter(CreateAnnotationStoreResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reference").getter(CreateAnnotationStoreResponse.getter(CreateAnnotationStoreResponse::reference)).setter(CreateAnnotationStoreResponse.setter(Builder::reference)).constructor(ReferenceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final SdkField<String> STORE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeFormat").getter(CreateAnnotationStoreResponse.getter(CreateAnnotationStoreResponse::storeFormatAsString)).setter(CreateAnnotationStoreResponse.setter(Builder::storeFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeFormat").build()}).build();
    private static final SdkField<StoreOptions> STORE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storeOptions").getter(CreateAnnotationStoreResponse.getter(CreateAnnotationStoreResponse::storeOptions)).setter(CreateAnnotationStoreResponse.setter(Builder::storeOptions)).constructor(StoreOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeOptions").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateAnnotationStoreResponse.getter(CreateAnnotationStoreResponse::statusAsString)).setter(CreateAnnotationStoreResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAnnotationStoreResponse.getter(CreateAnnotationStoreResponse::name)).setter(CreateAnnotationStoreResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(CreateAnnotationStoreResponse.getter(CreateAnnotationStoreResponse::versionName)).setter(CreateAnnotationStoreResponse.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(CreateAnnotationStoreResponse.getter(CreateAnnotationStoreResponse::creationTime)).setter(CreateAnnotationStoreResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REFERENCE_FIELD, STORE_FORMAT_FIELD, STORE_OPTIONS_FIELD, STATUS_FIELD, NAME_FIELD, VERSION_NAME_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("reference", REFERENCE_FIELD);
            this.put("storeFormat", STORE_FORMAT_FIELD);
            this.put("storeOptions", STORE_OPTIONS_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("versionName", VERSION_NAME_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
        }
    });
    private final String id;
    private final ReferenceItem reference;
    private final String storeFormat;
    private final StoreOptions storeOptions;
    private final String status;
    private final String name;
    private final String versionName;
    private final Instant creationTime;

    private CreateAnnotationStoreResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.reference = builder.reference;
        this.storeFormat = builder.storeFormat;
        this.storeOptions = builder.storeOptions;
        this.status = builder.status;
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.creationTime = builder.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final ReferenceItem reference() {
        return this.reference;
    }

    public final StoreFormat storeFormat() {
        return StoreFormat.fromValue(this.storeFormat);
    }

    public final String storeFormatAsString() {
        return this.storeFormat;
    }

    public final StoreOptions storeOptions() {
        return this.storeOptions;
    }

    public final StoreStatus status() {
        return StoreStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnnotationStoreResponse)) {
            return false;
        }
        CreateAnnotationStoreResponse other = (CreateAnnotationStoreResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.reference(), other.reference()) && Objects.equals(this.storeFormatAsString(), other.storeFormatAsString()) && Objects.equals(this.storeOptions(), other.storeOptions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnnotationStoreResponse").add("Id", (Object)this.id()).add("Reference", (Object)this.reference()).add("StoreFormat", (Object)this.storeFormatAsString()).add("StoreOptions", (Object)this.storeOptions()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("VersionName", (Object)this.versionName()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
            case "storeFormat": {
                return Optional.ofNullable(clazz.cast(this.storeFormatAsString()));
            }
            case "storeOptions": {
                return Optional.ofNullable(clazz.cast(this.storeOptions()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnnotationStoreResponse, T> g) {
        return obj -> g.apply((CreateAnnotationStoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String id;
        private ReferenceItem reference;
        private String storeFormat;
        private StoreOptions storeOptions;
        private String status;
        private String name;
        private String versionName;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnnotationStoreResponse model) {
            super(model);
            this.id(model.id);
            this.reference(model.reference);
            this.storeFormat(model.storeFormat);
            this.storeOptions(model.storeOptions);
            this.status(model.status);
            this.name(model.name);
            this.versionName(model.versionName);
            this.creationTime(model.creationTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ReferenceItem.Builder getReference() {
            return this.reference != null ? this.reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final String getStoreFormat() {
            return this.storeFormat;
        }

        public final void setStoreFormat(String storeFormat) {
            this.storeFormat = storeFormat;
        }

        @Override
        public final Builder storeFormat(String storeFormat) {
            this.storeFormat = storeFormat;
            return this;
        }

        @Override
        public final Builder storeFormat(StoreFormat storeFormat) {
            this.storeFormat(storeFormat == null ? null : storeFormat.toString());
            return this;
        }

        public final StoreOptions.Builder getStoreOptions() {
            return this.storeOptions != null ? this.storeOptions.toBuilder() : null;
        }

        public final void setStoreOptions(StoreOptions.BuilderImpl storeOptions) {
            this.storeOptions = storeOptions != null ? storeOptions.build() : null;
        }

        @Override
        public final Builder storeOptions(StoreOptions storeOptions) {
            this.storeOptions = storeOptions;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateAnnotationStoreResponse build() {
            return new CreateAnnotationStoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnnotationStoreResponse> {
        public Builder id(String var1);

        public Builder reference(ReferenceItem var1);

        default public Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return this.reference((ReferenceItem)((ReferenceItem.Builder)ReferenceItem.builder().applyMutation(reference)).build());
        }

        public Builder storeFormat(String var1);

        public Builder storeFormat(StoreFormat var1);

        public Builder storeOptions(StoreOptions var1);

        default public Builder storeOptions(Consumer<StoreOptions.Builder> storeOptions) {
            return this.storeOptions((StoreOptions)((StoreOptions.Builder)StoreOptions.builder().applyMutation(storeOptions)).build());
        }

        public Builder status(String var1);

        public Builder status(StoreStatus var1);

        public Builder name(String var1);

        public Builder versionName(String var1);

        public Builder creationTime(Instant var1);
    }
}

