/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.VersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnnotationStoreVersionResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, UpdateAnnotationStoreVersionResponse> {
    private static final SdkField<String> STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeId").getter(UpdateAnnotationStoreVersionResponse.getter(UpdateAnnotationStoreVersionResponse::storeId)).setter(UpdateAnnotationStoreVersionResponse.setter(Builder::storeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateAnnotationStoreVersionResponse.getter(UpdateAnnotationStoreVersionResponse::id)).setter(UpdateAnnotationStoreVersionResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateAnnotationStoreVersionResponse.getter(UpdateAnnotationStoreVersionResponse::statusAsString)).setter(UpdateAnnotationStoreVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateAnnotationStoreVersionResponse.getter(UpdateAnnotationStoreVersionResponse::name)).setter(UpdateAnnotationStoreVersionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(UpdateAnnotationStoreVersionResponse.getter(UpdateAnnotationStoreVersionResponse::versionName)).setter(UpdateAnnotationStoreVersionResponse.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAnnotationStoreVersionResponse.getter(UpdateAnnotationStoreVersionResponse::description)).setter(UpdateAnnotationStoreVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(UpdateAnnotationStoreVersionResponse.getter(UpdateAnnotationStoreVersionResponse::creationTime)).setter(UpdateAnnotationStoreVersionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(UpdateAnnotationStoreVersionResponse.getter(UpdateAnnotationStoreVersionResponse::updateTime)).setter(UpdateAnnotationStoreVersionResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORE_ID_FIELD, ID_FIELD, STATUS_FIELD, NAME_FIELD, VERSION_NAME_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("storeId", STORE_ID_FIELD);
            this.put("id", ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("versionName", VERSION_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
        }
    });
    private final String storeId;
    private final String id;
    private final String status;
    private final String name;
    private final String versionName;
    private final String description;
    private final Instant creationTime;
    private final Instant updateTime;

    private UpdateAnnotationStoreVersionResponse(BuilderImpl builder) {
        super(builder);
        this.storeId = builder.storeId;
        this.id = builder.id;
        this.status = builder.status;
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
    }

    public final String storeId() {
        return this.storeId;
    }

    public final String id() {
        return this.id;
    }

    public final VersionStatus status() {
        return VersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.storeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnnotationStoreVersionResponse)) {
            return false;
        }
        UpdateAnnotationStoreVersionResponse other = (UpdateAnnotationStoreVersionResponse)((Object)obj);
        return Objects.equals(this.storeId(), other.storeId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAnnotationStoreVersionResponse").add("StoreId", (Object)this.storeId()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("VersionName", (Object)this.versionName()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storeId": {
                return Optional.ofNullable(clazz.cast(this.storeId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnnotationStoreVersionResponse, T> g) {
        return obj -> g.apply((UpdateAnnotationStoreVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String storeId;
        private String id;
        private String status;
        private String name;
        private String versionName;
        private String description;
        private Instant creationTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnnotationStoreVersionResponse model) {
            super(model);
            this.storeId(model.storeId);
            this.id(model.id);
            this.status(model.status);
            this.name(model.name);
            this.versionName(model.versionName);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.updateTime(model.updateTime);
        }

        public final String getStoreId() {
            return this.storeId;
        }

        public final void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        @Override
        public final Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public UpdateAnnotationStoreVersionResponse build() {
            return new UpdateAnnotationStoreVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnnotationStoreVersionResponse> {
        public Builder storeId(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(VersionStatus var1);

        public Builder name(String var1);

        public Builder versionName(String var1);

        public Builder description(String var1);

        public Builder creationTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

