/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.FileType;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultipartReadSetUploadListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultipartReadSetUploadListItem> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::sequenceStoreId)).setter(MultipartReadSetUploadListItem.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::uploadId)).setter(MultipartReadSetUploadListItem.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final SdkField<String> SOURCE_FILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceFileType").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::sourceFileTypeAsString)).setter(MultipartReadSetUploadListItem.setter(Builder::sourceFileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFileType").build()}).build();
    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subjectId").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::subjectId)).setter(MultipartReadSetUploadListItem.setter(Builder::subjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()}).build();
    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleId").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::sampleId)).setter(MultipartReadSetUploadListItem.setter(Builder::sampleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()}).build();
    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generatedFrom").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::generatedFrom)).setter(MultipartReadSetUploadListItem.setter(Builder::generatedFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()}).build();
    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceArn").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::referenceArn)).setter(MultipartReadSetUploadListItem.setter(Builder::referenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::name)).setter(MultipartReadSetUploadListItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::description)).setter(MultipartReadSetUploadListItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::tags)).setter(MultipartReadSetUploadListItem.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(MultipartReadSetUploadListItem.getter(MultipartReadSetUploadListItem::creationTime)).setter(MultipartReadSetUploadListItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD, UPLOAD_ID_FIELD, SOURCE_FILE_TYPE_FIELD, SUBJECT_ID_FIELD, SAMPLE_ID_FIELD, GENERATED_FROM_FIELD, REFERENCE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, CREATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
            this.put("uploadId", UPLOAD_ID_FIELD);
            this.put("sourceFileType", SOURCE_FILE_TYPE_FIELD);
            this.put("subjectId", SUBJECT_ID_FIELD);
            this.put("sampleId", SAMPLE_ID_FIELD);
            this.put("generatedFrom", GENERATED_FROM_FIELD);
            this.put("referenceArn", REFERENCE_ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sequenceStoreId;
    private final String uploadId;
    private final String sourceFileType;
    private final String subjectId;
    private final String sampleId;
    private final String generatedFrom;
    private final String referenceArn;
    private final String name;
    private final String description;
    private final Map<String, String> tags;
    private final Instant creationTime;

    private MultipartReadSetUploadListItem(BuilderImpl builder) {
        this.sequenceStoreId = builder.sequenceStoreId;
        this.uploadId = builder.uploadId;
        this.sourceFileType = builder.sourceFileType;
        this.subjectId = builder.subjectId;
        this.sampleId = builder.sampleId;
        this.generatedFrom = builder.generatedFrom;
        this.referenceArn = builder.referenceArn;
        this.name = builder.name;
        this.description = builder.description;
        this.tags = builder.tags;
        this.creationTime = builder.creationTime;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final FileType sourceFileType() {
        return FileType.fromValue(this.sourceFileType);
    }

    public final String sourceFileTypeAsString() {
        return this.sourceFileType;
    }

    public final String subjectId() {
        return this.subjectId;
    }

    public final String sampleId() {
        return this.sampleId;
    }

    public final String generatedFrom() {
        return this.generatedFrom;
    }

    public final String referenceArn() {
        return this.referenceArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultipartReadSetUploadListItem)) {
            return false;
        }
        MultipartReadSetUploadListItem other = (MultipartReadSetUploadListItem)obj;
        return Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.sourceFileTypeAsString(), other.sourceFileTypeAsString()) && Objects.equals(this.subjectId(), other.subjectId()) && Objects.equals(this.sampleId(), other.sampleId()) && Objects.equals(this.generatedFrom(), other.generatedFrom()) && Objects.equals(this.referenceArn(), other.referenceArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"MultipartReadSetUploadListItem").add("SequenceStoreId", (Object)this.sequenceStoreId()).add("UploadId", (Object)this.uploadId()).add("SourceFileType", (Object)this.sourceFileTypeAsString()).add("SubjectId", (Object)this.subjectId()).add("SampleId", (Object)this.sampleId()).add("GeneratedFrom", (Object)this.generatedFrom()).add("ReferenceArn", (Object)this.referenceArn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "sourceFileType": {
                return Optional.ofNullable(clazz.cast(this.sourceFileTypeAsString()));
            }
            case "subjectId": {
                return Optional.ofNullable(clazz.cast(this.subjectId()));
            }
            case "sampleId": {
                return Optional.ofNullable(clazz.cast(this.sampleId()));
            }
            case "generatedFrom": {
                return Optional.ofNullable(clazz.cast(this.generatedFrom()));
            }
            case "referenceArn": {
                return Optional.ofNullable(clazz.cast(this.referenceArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MultipartReadSetUploadListItem, T> g) {
        return obj -> g.apply((MultipartReadSetUploadListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sequenceStoreId;
        private String uploadId;
        private String sourceFileType;
        private String subjectId;
        private String sampleId;
        private String generatedFrom;
        private String referenceArn;
        private String name;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MultipartReadSetUploadListItem model) {
            this.sequenceStoreId(model.sequenceStoreId);
            this.uploadId(model.uploadId);
            this.sourceFileType(model.sourceFileType);
            this.subjectId(model.subjectId);
            this.sampleId(model.sampleId);
            this.generatedFrom(model.generatedFrom);
            this.referenceArn(model.referenceArn);
            this.name(model.name);
            this.description(model.description);
            this.tags(model.tags);
            this.creationTime(model.creationTime);
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getSourceFileType() {
            return this.sourceFileType;
        }

        public final void setSourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
        }

        @Override
        public final Builder sourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
            return this;
        }

        @Override
        public final Builder sourceFileType(FileType sourceFileType) {
            this.sourceFileType(sourceFileType == null ? null : sourceFileType.toString());
            return this;
        }

        public final String getSubjectId() {
            return this.subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final String getSampleId() {
            return this.sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getGeneratedFrom() {
            return this.generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getReferenceArn() {
            return this.referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public MultipartReadSetUploadListItem build() {
            return new MultipartReadSetUploadListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultipartReadSetUploadListItem> {
        public Builder sequenceStoreId(String var1);

        public Builder uploadId(String var1);

        public Builder sourceFileType(String var1);

        public Builder sourceFileType(FileType var1);

        public Builder subjectId(String var1);

        public Builder sampleId(String var1);

        public Builder generatedFrom(String var1);

        public Builder referenceArn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder creationTime(Instant var1);
    }
}

