/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.AnnotationFieldMapCopier;
import software.amazon.awssdk.services.omics.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnnotationImportJobItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnnotationImportJobItem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::id)).setter(AnnotationImportJobItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationName").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::destinationName)).setter(AnnotationImportJobItem.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::versionName)).setter(AnnotationImportJobItem.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::roleArn)).setter(AnnotationImportJobItem.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::statusAsString)).setter(AnnotationImportJobItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::creationTime)).setter(AnnotationImportJobItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::updateTime)).setter(AnnotationImportJobItem.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::completionTime)).setter(AnnotationImportJobItem.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Boolean> RUN_LEFT_NORMALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("runLeftNormalization").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::runLeftNormalization)).setter(AnnotationImportJobItem.setter(Builder::runLeftNormalization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runLeftNormalization").build()}).build();
    private static final SdkField<Map<String, String>> ANNOTATION_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("annotationFields").getter(AnnotationImportJobItem.getter(AnnotationImportJobItem::annotationFields)).setter(AnnotationImportJobItem.setter(Builder::annotationFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESTINATION_NAME_FIELD, VERSION_NAME_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, UPDATE_TIME_FIELD, COMPLETION_TIME_FIELD, RUN_LEFT_NORMALIZATION_FIELD, ANNOTATION_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("destinationName", DESTINATION_NAME_FIELD);
            this.put("versionName", VERSION_NAME_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
            this.put("completionTime", COMPLETION_TIME_FIELD);
            this.put("runLeftNormalization", RUN_LEFT_NORMALIZATION_FIELD);
            this.put("annotationFields", ANNOTATION_FIELDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String destinationName;
    private final String versionName;
    private final String roleArn;
    private final String status;
    private final Instant creationTime;
    private final Instant updateTime;
    private final Instant completionTime;
    private final Boolean runLeftNormalization;
    private final Map<String, String> annotationFields;

    private AnnotationImportJobItem(BuilderImpl builder) {
        this.id = builder.id;
        this.destinationName = builder.destinationName;
        this.versionName = builder.versionName;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
        this.completionTime = builder.completionTime;
        this.runLeftNormalization = builder.runLeftNormalization;
        this.annotationFields = builder.annotationFields;
    }

    public final String id() {
        return this.id;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Boolean runLeftNormalization() {
        return this.runLeftNormalization;
    }

    public final boolean hasAnnotationFields() {
        return this.annotationFields != null && !(this.annotationFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> annotationFields() {
        return this.annotationFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.runLeftNormalization());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotationFields() ? this.annotationFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationImportJobItem)) {
            return false;
        }
        AnnotationImportJobItem other = (AnnotationImportJobItem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.runLeftNormalization(), other.runLeftNormalization()) && this.hasAnnotationFields() == other.hasAnnotationFields() && Objects.equals(this.annotationFields(), other.annotationFields());
    }

    public final String toString() {
        return ToString.builder((String)"AnnotationImportJobItem").add("Id", (Object)this.id()).add("DestinationName", (Object)this.destinationName()).add("VersionName", (Object)this.versionName()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("UpdateTime", (Object)this.updateTime()).add("CompletionTime", (Object)this.completionTime()).add("RunLeftNormalization", (Object)this.runLeftNormalization()).add("AnnotationFields", this.hasAnnotationFields() ? this.annotationFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "destinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "runLeftNormalization": {
                return Optional.ofNullable(clazz.cast(this.runLeftNormalization()));
            }
            case "annotationFields": {
                return Optional.ofNullable(clazz.cast(this.annotationFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnnotationImportJobItem, T> g) {
        return obj -> g.apply((AnnotationImportJobItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String destinationName;
        private String versionName;
        private String roleArn;
        private String status;
        private Instant creationTime;
        private Instant updateTime;
        private Instant completionTime;
        private Boolean runLeftNormalization;
        private Map<String, String> annotationFields = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationImportJobItem model) {
            this.id(model.id);
            this.destinationName(model.destinationName);
            this.versionName(model.versionName);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.updateTime(model.updateTime);
            this.completionTime(model.completionTime);
            this.runLeftNormalization(model.runLeftNormalization);
            this.annotationFields(model.annotationFields);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Boolean getRunLeftNormalization() {
            return this.runLeftNormalization;
        }

        public final void setRunLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
        }

        @Override
        public final Builder runLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
            return this;
        }

        public final Map<String, String> getAnnotationFields() {
            if (this.annotationFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.annotationFields;
        }

        public final void setAnnotationFields(Map<String, String> annotationFields) {
            this.annotationFields = AnnotationFieldMapCopier.copy(annotationFields);
        }

        @Override
        public final Builder annotationFields(Map<String, String> annotationFields) {
            this.annotationFields = AnnotationFieldMapCopier.copy(annotationFields);
            return this;
        }

        public AnnotationImportJobItem build() {
            return new AnnotationImportJobItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnnotationImportJobItem> {
        public Builder id(String var1);

        public Builder destinationName(String var1);

        public Builder versionName(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder creationTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder runLeftNormalization(Boolean var1);

        public Builder annotationFields(Map<String, String> var1);
    }
}

