/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ShareStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ShareDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ShareDetails> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareId").getter(ShareDetails.getter(ShareDetails::shareId)).setter(ShareDetails.setter(Builder::shareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(ShareDetails.getter(ShareDetails::resourceArn)).setter(ShareDetails.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(ShareDetails.getter(ShareDetails::resourceId)).setter(ShareDetails.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<String> PRINCIPAL_SUBSCRIBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalSubscriber").getter(ShareDetails.getter(ShareDetails::principalSubscriber)).setter(ShareDetails.setter(Builder::principalSubscriber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalSubscriber").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerId").getter(ShareDetails.getter(ShareDetails::ownerId)).setter(ShareDetails.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ShareDetails.getter(ShareDetails::statusAsString)).setter(ShareDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(ShareDetails.getter(ShareDetails::statusMessage)).setter(ShareDetails.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> SHARE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shareName").getter(ShareDetails.getter(ShareDetails::shareName)).setter(ShareDetails.setter(Builder::shareName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ShareDetails.getter(ShareDetails::creationTime)).setter(ShareDetails.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(ShareDetails.getter(ShareDetails::updateTime)).setter(ShareDetails.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD, RESOURCE_ARN_FIELD, RESOURCE_ID_FIELD, PRINCIPAL_SUBSCRIBER_FIELD, OWNER_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, SHARE_NAME_FIELD, CREATION_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("shareId", SHARE_ID_FIELD);
            this.put("resourceArn", RESOURCE_ARN_FIELD);
            this.put("resourceId", RESOURCE_ID_FIELD);
            this.put("principalSubscriber", PRINCIPAL_SUBSCRIBER_FIELD);
            this.put("ownerId", OWNER_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("statusMessage", STATUS_MESSAGE_FIELD);
            this.put("shareName", SHARE_NAME_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String shareId;
    private final String resourceArn;
    private final String resourceId;
    private final String principalSubscriber;
    private final String ownerId;
    private final String status;
    private final String statusMessage;
    private final String shareName;
    private final Instant creationTime;
    private final Instant updateTime;

    private ShareDetails(BuilderImpl builder) {
        this.shareId = builder.shareId;
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.principalSubscriber = builder.principalSubscriber;
        this.ownerId = builder.ownerId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.shareName = builder.shareName;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
    }

    public final String shareId() {
        return this.shareId;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final String principalSubscriber() {
        return this.principalSubscriber;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final ShareStatus status() {
        return ShareStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String shareName() {
        return this.shareName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalSubscriber());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.shareName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareDetails)) {
            return false;
        }
        ShareDetails other = (ShareDetails)obj;
        return Objects.equals(this.shareId(), other.shareId()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.principalSubscriber(), other.principalSubscriber()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.shareName(), other.shareName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ShareDetails").add("ShareId", (Object)this.shareId()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceId", (Object)this.resourceId()).add("PrincipalSubscriber", (Object)this.principalSubscriber()).add("OwnerId", (Object)this.ownerId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ShareName", (Object)this.shareName()).add("CreationTime", (Object)this.creationTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "shareId": {
                return Optional.ofNullable(clazz.cast(this.shareId()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "principalSubscriber": {
                return Optional.ofNullable(clazz.cast(this.principalSubscriber()));
            }
            case "ownerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "shareName": {
                return Optional.ofNullable(clazz.cast(this.shareName()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ShareDetails, T> g) {
        return obj -> g.apply((ShareDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shareId;
        private String resourceArn;
        private String resourceId;
        private String principalSubscriber;
        private String ownerId;
        private String status;
        private String statusMessage;
        private String shareName;
        private Instant creationTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareDetails model) {
            this.shareId(model.shareId);
            this.resourceArn(model.resourceArn);
            this.resourceId(model.resourceId);
            this.principalSubscriber(model.principalSubscriber);
            this.ownerId(model.ownerId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.shareName(model.shareName);
            this.creationTime(model.creationTime);
            this.updateTime(model.updateTime);
        }

        public final String getShareId() {
            return this.shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getPrincipalSubscriber() {
            return this.principalSubscriber;
        }

        public final void setPrincipalSubscriber(String principalSubscriber) {
            this.principalSubscriber = principalSubscriber;
        }

        @Override
        public final Builder principalSubscriber(String principalSubscriber) {
            this.principalSubscriber = principalSubscriber;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getShareName() {
            return this.shareName;
        }

        public final void setShareName(String shareName) {
            this.shareName = shareName;
        }

        @Override
        public final Builder shareName(String shareName) {
            this.shareName = shareName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ShareDetails build() {
            return new ShareDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ShareDetails> {
        public Builder shareId(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceId(String var1);

        public Builder principalSubscriber(String var1);

        public Builder ownerId(String var1);

        public Builder status(String var1);

        public Builder status(ShareStatus var1);

        public Builder statusMessage(String var1);

        public Builder shareName(String var1);

        public Builder creationTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

