/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.ActivateReadSetJobItem;
import software.amazon.awssdk.services.omics.model.ActivateReadSetJobListCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReadSetActivationJobsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListReadSetActivationJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReadSetActivationJobsResponse.getter(ListReadSetActivationJobsResponse::nextToken)).setter(ListReadSetActivationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ActivateReadSetJobItem>> ACTIVATION_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("activationJobs").getter(ListReadSetActivationJobsResponse.getter(ListReadSetActivationJobsResponse::activationJobs)).setter(ListReadSetActivationJobsResponse.setter(Builder::activationJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActivateReadSetJobItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ACTIVATION_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("activationJobs", ACTIVATION_JOBS_FIELD);
        }
    });
    private final String nextToken;
    private final List<ActivateReadSetJobItem> activationJobs;

    private ListReadSetActivationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.activationJobs = builder.activationJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasActivationJobs() {
        return this.activationJobs != null && !(this.activationJobs instanceof SdkAutoConstructList);
    }

    public final List<ActivateReadSetJobItem> activationJobs() {
        return this.activationJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActivationJobs() ? this.activationJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetActivationJobsResponse)) {
            return false;
        }
        ListReadSetActivationJobsResponse other = (ListReadSetActivationJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasActivationJobs() == other.hasActivationJobs() && Objects.equals(this.activationJobs(), other.activationJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListReadSetActivationJobsResponse").add("NextToken", (Object)this.nextToken()).add("ActivationJobs", this.hasActivationJobs() ? this.activationJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "activationJobs": {
                return Optional.ofNullable(clazz.cast(this.activationJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetActivationJobsResponse, T> g) {
        return obj -> g.apply((ListReadSetActivationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ActivateReadSetJobItem> activationJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetActivationJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.activationJobs(model.activationJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ActivateReadSetJobItem.Builder> getActivationJobs() {
            List<ActivateReadSetJobItem.Builder> result = ActivateReadSetJobListCopier.copyToBuilder(this.activationJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActivationJobs(Collection<ActivateReadSetJobItem.BuilderImpl> activationJobs) {
            this.activationJobs = ActivateReadSetJobListCopier.copyFromBuilder(activationJobs);
        }

        @Override
        public final Builder activationJobs(Collection<ActivateReadSetJobItem> activationJobs) {
            this.activationJobs = ActivateReadSetJobListCopier.copy(activationJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationJobs(ActivateReadSetJobItem ... activationJobs) {
            this.activationJobs(Arrays.asList(activationJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activationJobs(Consumer<ActivateReadSetJobItem.Builder> ... activationJobs) {
            this.activationJobs(Stream.of(activationJobs).map(c -> (ActivateReadSetJobItem)((ActivateReadSetJobItem.Builder)ActivateReadSetJobItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReadSetActivationJobsResponse build() {
            return new ListReadSetActivationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReadSetActivationJobsResponse> {
        public Builder nextToken(String var1);

        public Builder activationJobs(Collection<ActivateReadSetJobItem> var1);

        public Builder activationJobs(ActivateReadSetJobItem ... var1);

        public Builder activationJobs(Consumer<ActivateReadSetJobItem.Builder> ... var1);
    }
}

