/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.Accelerators;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.RunLogLevel;
import software.amazon.awssdk.services.omics.model.RunLogLocation;
import software.amazon.awssdk.services.omics.model.RunResourceDigestsCopier;
import software.amazon.awssdk.services.omics.model.RunRetentionMode;
import software.amazon.awssdk.services.omics.model.RunStatus;
import software.amazon.awssdk.services.omics.model.StorageType;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.services.omics.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRunResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetRunResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetRunResponse.getter(GetRunResponse::arn)).setter(GetRunResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetRunResponse.getter(GetRunResponse::id)).setter(GetRunResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetRunResponse.getter(GetRunResponse::statusAsString)).setter(GetRunResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(GetRunResponse.getter(GetRunResponse::workflowId)).setter(GetRunResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowType").getter(GetRunResponse.getter(GetRunResponse::workflowTypeAsString)).setter(GetRunResponse.setter(Builder::workflowType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runId").getter(GetRunResponse.getter(GetRunResponse::runId)).setter(GetRunResponse.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetRunResponse.getter(GetRunResponse::roleArn)).setter(GetRunResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetRunResponse.getter(GetRunResponse::name)).setter(GetRunResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RUN_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runGroupId").getter(GetRunResponse.getter(GetRunResponse::runGroupId)).setter(GetRunResponse.setter(Builder::runGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runGroupId").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(GetRunResponse.getter(GetRunResponse::priority)).setter(GetRunResponse.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(GetRunResponse.getter(GetRunResponse::definition)).setter(GetRunResponse.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("digest").getter(GetRunResponse.getter(GetRunResponse::digest)).setter(GetRunResponse.setter(Builder::digest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()}).build();
    private static final SdkField<Document> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("parameters").getter(GetRunResponse.getter(GetRunResponse::parameters)).setter(GetRunResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCapacity").getter(GetRunResponse.getter(GetRunResponse::storageCapacity)).setter(GetRunResponse.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()}).build();
    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputUri").getter(GetRunResponse.getter(GetRunResponse::outputUri)).setter(GetRunResponse.setter(Builder::outputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputUri").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logLevel").getter(GetRunResponse.getter(GetRunResponse::logLevelAsString)).setter(GetRunResponse.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_DIGESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("resourceDigests").getter(GetRunResponse.getter(GetRunResponse::resourceDigests)).setter(GetRunResponse.setter(Builder::resourceDigests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDigests").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STARTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startedBy").getter(GetRunResponse.getter(GetRunResponse::startedBy)).setter(GetRunResponse.setter(Builder::startedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedBy").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetRunResponse.getter(GetRunResponse::creationTime)).setter(GetRunResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetRunResponse.getter(GetRunResponse::startTime)).setter(GetRunResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("stopTime").getter(GetRunResponse.getter(GetRunResponse::stopTime)).setter(GetRunResponse.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetRunResponse.getter(GetRunResponse::statusMessage)).setter(GetRunResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetRunResponse.getter(GetRunResponse::tags)).setter(GetRunResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accelerators").getter(GetRunResponse.getter(GetRunResponse::acceleratorsAsString)).setter(GetRunResponse.setter(Builder::accelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerators").build()}).build();
    private static final SdkField<String> RETENTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retentionMode").getter(GetRunResponse.getter(GetRunResponse::retentionModeAsString)).setter(GetRunResponse.setter(Builder::retentionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionMode").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(GetRunResponse.getter(GetRunResponse::failureReason)).setter(GetRunResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<RunLogLocation> LOG_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logLocation").getter(GetRunResponse.getter(GetRunResponse::logLocation)).setter(GetRunResponse.setter(Builder::logLocation)).constructor(RunLogLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLocation").build()}).build();
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uuid").getter(GetRunResponse.getter(GetRunResponse::uuid)).setter(GetRunResponse.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()}).build();
    private static final SdkField<String> RUN_OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runOutputUri").getter(GetRunResponse.getter(GetRunResponse::runOutputUri)).setter(GetRunResponse.setter(Builder::runOutputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runOutputUri").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(GetRunResponse.getter(GetRunResponse::storageTypeAsString)).setter(GetRunResponse.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<String> WORKFLOW_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowOwnerId").getter(GetRunResponse.getter(GetRunResponse::workflowOwnerId)).setter(GetRunResponse.setter(Builder::workflowOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowOwnerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, STATUS_FIELD, WORKFLOW_ID_FIELD, WORKFLOW_TYPE_FIELD, RUN_ID_FIELD, ROLE_ARN_FIELD, NAME_FIELD, RUN_GROUP_ID_FIELD, PRIORITY_FIELD, DEFINITION_FIELD, DIGEST_FIELD, PARAMETERS_FIELD, STORAGE_CAPACITY_FIELD, OUTPUT_URI_FIELD, LOG_LEVEL_FIELD, RESOURCE_DIGESTS_FIELD, STARTED_BY_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, STOP_TIME_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD, ACCELERATORS_FIELD, RETENTION_MODE_FIELD, FAILURE_REASON_FIELD, LOG_LOCATION_FIELD, UUID_FIELD, RUN_OUTPUT_URI_FIELD, STORAGE_TYPE_FIELD, WORKFLOW_OWNER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("id", ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("workflowId", WORKFLOW_ID_FIELD);
            this.put("workflowType", WORKFLOW_TYPE_FIELD);
            this.put("runId", RUN_ID_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("name", NAME_FIELD);
            this.put("runGroupId", RUN_GROUP_ID_FIELD);
            this.put("priority", PRIORITY_FIELD);
            this.put("definition", DEFINITION_FIELD);
            this.put("digest", DIGEST_FIELD);
            this.put("parameters", PARAMETERS_FIELD);
            this.put("storageCapacity", STORAGE_CAPACITY_FIELD);
            this.put("outputUri", OUTPUT_URI_FIELD);
            this.put("logLevel", LOG_LEVEL_FIELD);
            this.put("resourceDigests", RESOURCE_DIGESTS_FIELD);
            this.put("startedBy", STARTED_BY_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("stopTime", STOP_TIME_FIELD);
            this.put("statusMessage", STATUS_MESSAGE_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("accelerators", ACCELERATORS_FIELD);
            this.put("retentionMode", RETENTION_MODE_FIELD);
            this.put("failureReason", FAILURE_REASON_FIELD);
            this.put("logLocation", LOG_LOCATION_FIELD);
            this.put("uuid", UUID_FIELD);
            this.put("runOutputUri", RUN_OUTPUT_URI_FIELD);
            this.put("storageType", STORAGE_TYPE_FIELD);
            this.put("workflowOwnerId", WORKFLOW_OWNER_ID_FIELD);
        }
    });
    private final String arn;
    private final String id;
    private final String status;
    private final String workflowId;
    private final String workflowType;
    private final String runId;
    private final String roleArn;
    private final String name;
    private final String runGroupId;
    private final Integer priority;
    private final String definition;
    private final String digest;
    private final Document parameters;
    private final Integer storageCapacity;
    private final String outputUri;
    private final String logLevel;
    private final Map<String, String> resourceDigests;
    private final String startedBy;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant stopTime;
    private final String statusMessage;
    private final Map<String, String> tags;
    private final String accelerators;
    private final String retentionMode;
    private final String failureReason;
    private final RunLogLocation logLocation;
    private final String uuid;
    private final String runOutputUri;
    private final String storageType;
    private final String workflowOwnerId;

    private GetRunResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.status = builder.status;
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.runId = builder.runId;
        this.roleArn = builder.roleArn;
        this.name = builder.name;
        this.runGroupId = builder.runGroupId;
        this.priority = builder.priority;
        this.definition = builder.definition;
        this.digest = builder.digest;
        this.parameters = builder.parameters;
        this.storageCapacity = builder.storageCapacity;
        this.outputUri = builder.outputUri;
        this.logLevel = builder.logLevel;
        this.resourceDigests = builder.resourceDigests;
        this.startedBy = builder.startedBy;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.accelerators = builder.accelerators;
        this.retentionMode = builder.retentionMode;
        this.failureReason = builder.failureReason;
        this.logLocation = builder.logLocation;
        this.uuid = builder.uuid;
        this.runOutputUri = builder.runOutputUri;
        this.storageType = builder.storageType;
        this.workflowOwnerId = builder.workflowOwnerId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final RunStatus status() {
        return RunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(this.workflowType);
    }

    public final String workflowTypeAsString() {
        return this.workflowType;
    }

    public final String runId() {
        return this.runId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String name() {
        return this.name;
    }

    public final String runGroupId() {
        return this.runGroupId;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String definition() {
        return this.definition;
    }

    public final String digest() {
        return this.digest;
    }

    public final Document parameters() {
        return this.parameters;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final String outputUri() {
        return this.outputUri;
    }

    public final RunLogLevel logLevel() {
        return RunLogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final boolean hasResourceDigests() {
        return this.resourceDigests != null && !(this.resourceDigests instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceDigests() {
        return this.resourceDigests;
    }

    public final String startedBy() {
        return this.startedBy;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant stopTime() {
        return this.stopTime;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Accelerators accelerators() {
        return Accelerators.fromValue(this.accelerators);
    }

    public final String acceleratorsAsString() {
        return this.accelerators;
    }

    public final RunRetentionMode retentionMode() {
        return RunRetentionMode.fromValue(this.retentionMode);
    }

    public final String retentionModeAsString() {
        return this.retentionMode;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final RunLogLocation logLocation() {
        return this.logLocation;
    }

    public final String uuid() {
        return this.uuid;
    }

    public final String runOutputUri() {
        return this.runOutputUri;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final String workflowOwnerId() {
        return this.workflowOwnerId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.runGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.digest());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceDigests() ? this.resourceDigests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.runOutputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowOwnerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRunResponse)) {
            return false;
        }
        GetRunResponse other = (GetRunResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.workflowTypeAsString(), other.workflowTypeAsString()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.runGroupId(), other.runGroupId()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.digest(), other.digest()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && Objects.equals(this.outputUri(), other.outputUri()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && this.hasResourceDigests() == other.hasResourceDigests() && Objects.equals(this.resourceDigests(), other.resourceDigests()) && Objects.equals(this.startedBy(), other.startedBy()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stopTime(), other.stopTime()) && Objects.equals(this.statusMessage(), other.statusMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.acceleratorsAsString(), other.acceleratorsAsString()) && Objects.equals(this.retentionModeAsString(), other.retentionModeAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.logLocation(), other.logLocation()) && Objects.equals(this.uuid(), other.uuid()) && Objects.equals(this.runOutputUri(), other.runOutputUri()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.workflowOwnerId(), other.workflowOwnerId());
    }

    public final String toString() {
        return ToString.builder((String)"GetRunResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("WorkflowId", (Object)this.workflowId()).add("WorkflowType", (Object)this.workflowTypeAsString()).add("RunId", (Object)this.runId()).add("RoleArn", (Object)this.roleArn()).add("Name", (Object)this.name()).add("RunGroupId", (Object)this.runGroupId()).add("Priority", (Object)this.priority()).add("Definition", (Object)this.definition()).add("Digest", (Object)this.digest()).add("Parameters", (Object)this.parameters()).add("StorageCapacity", (Object)this.storageCapacity()).add("OutputUri", (Object)this.outputUri()).add("LogLevel", (Object)this.logLevelAsString()).add("ResourceDigests", this.hasResourceDigests() ? this.resourceDigests() : null).add("StartedBy", (Object)this.startedBy()).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("StopTime", (Object)this.stopTime()).add("StatusMessage", (Object)this.statusMessage()).add("Tags", this.hasTags() ? this.tags() : null).add("Accelerators", (Object)this.acceleratorsAsString()).add("RetentionMode", (Object)this.retentionModeAsString()).add("FailureReason", (Object)this.failureReason()).add("LogLocation", (Object)this.logLocation()).add("Uuid", (Object)this.uuid()).add("RunOutputUri", (Object)this.runOutputUri()).add("StorageType", (Object)this.storageTypeAsString()).add("WorkflowOwnerId", (Object)this.workflowOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowTypeAsString()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "runGroupId": {
                return Optional.ofNullable(clazz.cast(this.runGroupId()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "digest": {
                return Optional.ofNullable(clazz.cast(this.digest()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "storageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "outputUri": {
                return Optional.ofNullable(clazz.cast(this.outputUri()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "resourceDigests": {
                return Optional.ofNullable(clazz.cast(this.resourceDigests()));
            }
            case "startedBy": {
                return Optional.ofNullable(clazz.cast(this.startedBy()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "stopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "accelerators": {
                return Optional.ofNullable(clazz.cast(this.acceleratorsAsString()));
            }
            case "retentionMode": {
                return Optional.ofNullable(clazz.cast(this.retentionModeAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "logLocation": {
                return Optional.ofNullable(clazz.cast(this.logLocation()));
            }
            case "uuid": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
            case "runOutputUri": {
                return Optional.ofNullable(clazz.cast(this.runOutputUri()));
            }
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "workflowOwnerId": {
                return Optional.ofNullable(clazz.cast(this.workflowOwnerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetRunResponse, T> g) {
        return obj -> g.apply((GetRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String status;
        private String workflowId;
        private String workflowType;
        private String runId;
        private String roleArn;
        private String name;
        private String runGroupId;
        private Integer priority;
        private String definition;
        private String digest;
        private Document parameters;
        private Integer storageCapacity;
        private String outputUri;
        private String logLevel;
        private Map<String, String> resourceDigests = DefaultSdkAutoConstructMap.getInstance();
        private String startedBy;
        private Instant creationTime;
        private Instant startTime;
        private Instant stopTime;
        private String statusMessage;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String accelerators;
        private String retentionMode;
        private String failureReason;
        private RunLogLocation logLocation;
        private String uuid;
        private String runOutputUri;
        private String storageType;
        private String workflowOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRunResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.status(model.status);
            this.workflowId(model.workflowId);
            this.workflowType(model.workflowType);
            this.runId(model.runId);
            this.roleArn(model.roleArn);
            this.name(model.name);
            this.runGroupId(model.runGroupId);
            this.priority(model.priority);
            this.definition(model.definition);
            this.digest(model.digest);
            this.parameters(model.parameters);
            this.storageCapacity(model.storageCapacity);
            this.outputUri(model.outputUri);
            this.logLevel(model.logLevel);
            this.resourceDigests(model.resourceDigests);
            this.startedBy(model.startedBy);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.stopTime(model.stopTime);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
            this.accelerators(model.accelerators);
            this.retentionMode(model.retentionMode);
            this.failureReason(model.failureReason);
            this.logLocation(model.logLocation);
            this.uuid(model.uuid);
            this.runOutputUri(model.runOutputUri);
            this.storageType(model.storageType);
            this.workflowOwnerId(model.workflowOwnerId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getWorkflowType() {
            return this.workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRunGroupId() {
            return this.runGroupId;
        }

        public final void setRunGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
        }

        @Override
        public final Builder runGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getDigest() {
            return this.digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final Document getParameters() {
            return this.parameters;
        }

        public final void setParameters(Document parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(Document parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getOutputUri() {
            return this.outputUri;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(RunLogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final Map<String, String> getResourceDigests() {
            if (this.resourceDigests instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceDigests;
        }

        public final void setResourceDigests(Map<String, String> resourceDigests) {
            this.resourceDigests = RunResourceDigestsCopier.copy(resourceDigests);
        }

        @Override
        public final Builder resourceDigests(Map<String, String> resourceDigests) {
            this.resourceDigests = RunResourceDigestsCopier.copy(resourceDigests);
            return this;
        }

        public final String getStartedBy() {
            return this.startedBy;
        }

        public final void setStartedBy(String startedBy) {
            this.startedBy = startedBy;
        }

        @Override
        public final Builder startedBy(String startedBy) {
            this.startedBy = startedBy;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getAccelerators() {
            return this.accelerators;
        }

        public final void setAccelerators(String accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        @Override
        public final Builder accelerators(Accelerators accelerators) {
            this.accelerators(accelerators == null ? null : accelerators.toString());
            return this;
        }

        public final String getRetentionMode() {
            return this.retentionMode;
        }

        public final void setRetentionMode(String retentionMode) {
            this.retentionMode = retentionMode;
        }

        @Override
        public final Builder retentionMode(String retentionMode) {
            this.retentionMode = retentionMode;
            return this;
        }

        @Override
        public final Builder retentionMode(RunRetentionMode retentionMode) {
            this.retentionMode(retentionMode == null ? null : retentionMode.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final RunLogLocation.Builder getLogLocation() {
            return this.logLocation != null ? this.logLocation.toBuilder() : null;
        }

        public final void setLogLocation(RunLogLocation.BuilderImpl logLocation) {
            this.logLocation = logLocation != null ? logLocation.build() : null;
        }

        @Override
        public final Builder logLocation(RunLogLocation logLocation) {
            this.logLocation = logLocation;
            return this;
        }

        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getRunOutputUri() {
            return this.runOutputUri;
        }

        public final void setRunOutputUri(String runOutputUri) {
            this.runOutputUri = runOutputUri;
        }

        @Override
        public final Builder runOutputUri(String runOutputUri) {
            this.runOutputUri = runOutputUri;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final String getWorkflowOwnerId() {
            return this.workflowOwnerId;
        }

        public final void setWorkflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
        }

        @Override
        public final Builder workflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
            return this;
        }

        @Override
        public GetRunResponse build() {
            return new GetRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRunResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(RunStatus var1);

        public Builder workflowId(String var1);

        public Builder workflowType(String var1);

        public Builder workflowType(WorkflowType var1);

        public Builder runId(String var1);

        public Builder roleArn(String var1);

        public Builder name(String var1);

        public Builder runGroupId(String var1);

        public Builder priority(Integer var1);

        public Builder definition(String var1);

        public Builder digest(String var1);

        public Builder parameters(Document var1);

        public Builder storageCapacity(Integer var1);

        public Builder outputUri(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(RunLogLevel var1);

        public Builder resourceDigests(Map<String, String> var1);

        public Builder startedBy(String var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder stopTime(Instant var1);

        public Builder statusMessage(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder accelerators(String var1);

        public Builder accelerators(Accelerators var1);

        public Builder retentionMode(String var1);

        public Builder retentionMode(RunRetentionMode var1);

        public Builder failureReason(String var1);

        public Builder logLocation(RunLogLocation var1);

        default public Builder logLocation(Consumer<RunLogLocation.Builder> logLocation) {
            return this.logLocation((RunLogLocation)((RunLogLocation.Builder)RunLogLocation.builder().applyMutation(logLocation)).build());
        }

        public Builder uuid(String var1);

        public Builder runOutputUri(String var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder workflowOwnerId(String var1);
    }
}

