/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ETagAlgorithm {
    FASTQ_MD5_UP("FASTQ_MD5up"),
    BAM_MD5_UP("BAM_MD5up"),
    CRAM_MD5_UP("CRAM_MD5up"),
    FASTQ_SHA256_UP("FASTQ_SHA256up"),
    BAM_SHA256_UP("BAM_SHA256up"),
    CRAM_SHA256_UP("CRAM_SHA256up"),
    FASTQ_SHA512_UP("FASTQ_SHA512up"),
    BAM_SHA512_UP("BAM_SHA512up"),
    CRAM_SHA512_UP("CRAM_SHA512up"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ETagAlgorithm> VALUE_MAP;
    private final String value;

    private ETagAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ETagAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ETagAlgorithm> knownValues() {
        EnumSet<ETagAlgorithm> knownValues = EnumSet.allOf(ETagAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ETagAlgorithm.class, ETagAlgorithm::toString);
    }
}

