/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.jmespath.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.utils.ToString;

@SdkInternalApi
public final class JmesPathRuntime {
    private JmesPathRuntime() {
    }

    public static final class Value {
        private static final Value NULL_VALUE = new Value(null);
        private final Type type;
        private final boolean isProjection;
        private SdkPojo pojoValue;
        private Integer integerValue;
        private String stringValue;
        private List<Object> listValue;
        private Map<Object, Object> mapValue;
        private Boolean booleanValue;

        private Value(Collection<?> value, boolean projection) {
            this.type = Type.LIST;
            this.listValue = new ArrayList(value);
            this.isProjection = projection;
        }

        private Value(Map<?, ?> value, boolean projection) {
            this.type = Type.MAP;
            this.mapValue = new HashMap(value);
            this.isProjection = projection;
        }

        public Value(Object value) {
            this.isProjection = false;
            if (value == null) {
                this.type = Type.NULL;
            } else if (value instanceof SdkPojo) {
                this.type = Type.POJO;
                this.pojoValue = (SdkPojo)value;
            } else if (value instanceof String) {
                this.type = Type.STRING;
                this.stringValue = (String)value;
            } else if (value instanceof Integer) {
                this.type = Type.INTEGER;
                this.integerValue = (Integer)value;
            } else if (value instanceof Collection) {
                this.type = Type.LIST;
                this.listValue = new ArrayList<Object>((Collection)value);
            } else if (value instanceof Map) {
                this.type = Type.MAP;
                this.mapValue = new HashMap<Object, Object>((Map)value);
            } else if (value instanceof Boolean) {
                this.type = Type.BOOLEAN;
                this.booleanValue = (Boolean)value;
            } else {
                throw new IllegalArgumentException("Unsupported value type: " + value.getClass());
            }
        }

        private static Value newProjection(Collection<?> values) {
            return new Value(values, true);
        }

        private static Value newProjection(Map<?, ?> values) {
            return new Value(values, true);
        }

        public Object value() {
            switch (this.type) {
                case NULL: {
                    return null;
                }
                case POJO: {
                    return this.pojoValue;
                }
                case INTEGER: {
                    return this.integerValue;
                }
                case STRING: {
                    return this.stringValue;
                }
                case BOOLEAN: {
                    return this.booleanValue;
                }
                case LIST: {
                    return this.listValue;
                }
                case MAP: {
                    return this.mapValue;
                }
            }
            throw new IllegalStateException();
        }

        public List<Object> values() {
            if (this.type == Type.NULL) {
                return Collections.emptyList();
            }
            if (this.type == Type.LIST) {
                return this.listValue;
            }
            return Collections.singletonList(this.value());
        }

        private Map<Object, Object> mapValues() {
            if (this.type == Type.NULL) {
                return Collections.emptyMap();
            }
            if (this.type == Type.MAP) {
                return this.mapValue;
            }
            throw new IllegalStateException("Must be MAP type to get map values");
        }

        public Boolean booleanValue() {
            switch (this.type) {
                case NULL: {
                    return null;
                }
                case STRING: {
                    return Boolean.parseBoolean(this.stringValue);
                }
                case BOOLEAN: {
                    return this.booleanValue;
                }
            }
            throw new IllegalStateException(String.format("Cannot convert type %s to Boolean.", new Object[]{this.type}));
        }

        public String stringValue() {
            switch (this.type) {
                case NULL: {
                    return null;
                }
                case INTEGER: {
                    return this.integerValue.toString();
                }
                case STRING: {
                    return this.stringValue;
                }
                case BOOLEAN: {
                    return this.booleanValue.toString();
                }
            }
            throw new IllegalStateException(String.format("Cannot convert type %s to String.", new Object[]{this.type}));
        }

        public List<String> stringValues() {
            if (this.type == Type.NULL) {
                return Collections.emptyList();
            }
            if (this.type == Type.LIST) {
                ArrayList<String> result = new ArrayList<String>();
                for (Object listEntry : this.listValue) {
                    Value entryAsValue = new Value(listEntry);
                    if (entryAsValue.type == Type.NULL) continue;
                    if (entryAsValue.type != Type.STRING) {
                        throw new IllegalStateException("Expected list elements to be of type String, but were " + (Object)((Object)entryAsValue.type));
                    }
                    result.add(entryAsValue.stringValue);
                }
                return result;
            }
            return Collections.singletonList(this.stringValue());
        }

        public Map<String, String> stringValuesMap() {
            if (this.type == Type.NULL) {
                return Collections.emptyMap();
            }
            if (this.type == Type.MAP) {
                HashMap<String, String> result = new HashMap<String, String>();
                this.mapValue.forEach((key, value) -> {
                    Value keyAsValue = new Value(key);
                    Value entryAsValue = new Value(value);
                    if (keyAsValue.type != Type.NULL) {
                        if (!this.isStringType(keyAsValue) || !this.isStringType(entryAsValue)) {
                            throw new IllegalStateException("Keys and values must be String type");
                        }
                        result.put(keyAsValue.stringValue, entryAsValue.stringValue);
                    }
                });
                return result;
            }
            throw new IllegalArgumentException("Not of type MAP");
        }

        private boolean isStringType(Value value) {
            return value.type == Type.STRING;
        }

        public Value constant(Value value) {
            return value;
        }

        public Value constant(Object constant) {
            return new Value(constant);
        }

        public Value wildcard() {
            if (this.type == Type.NULL) {
                return NULL_VALUE;
            }
            if (this.type == Type.LIST) {
                return Value.newProjection(this.listValue);
            }
            if (this.type == Type.MAP) {
                return Value.newProjection(this.mapValue);
            }
            if (this.type == Type.POJO) {
                return Value.newProjection(this.pojoValue.sdkFields().stream().map(f -> f.getValueOrDefault((Object)this.pojoValue)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            throw new IllegalArgumentException("Cannot use a wildcard expression on a " + (Object)((Object)this.type));
        }

        public Value flatten() {
            if (this.type == Type.NULL) {
                return NULL_VALUE;
            }
            if (this.type != Type.LIST) {
                throw new IllegalArgumentException("Cannot flatten a " + (Object)((Object)this.type));
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object listEntry : this.listValue) {
                Value listValue = new Value(listEntry);
                if (listValue.type != Type.LIST) {
                    result.add(listEntry);
                    continue;
                }
                result.addAll(listValue.listValue);
            }
            return Value.newProjection(result);
        }

        public Value field(String fieldName) {
            if (this.isProjection) {
                return this.project(v -> v.field(fieldName));
            }
            if (this.type == Type.NULL) {
                return NULL_VALUE;
            }
            if (this.type == Type.POJO) {
                return this.pojoValue.sdkFields().stream().filter((? super T f) -> f.memberName().equals(fieldName)).map(f -> f.getValueOrDefault((Object)this.pojoValue)).map(Value::new).findAny().orElseThrow(() -> new IllegalArgumentException("No such field: " + fieldName));
            }
            throw new IllegalArgumentException("Cannot get a field from a " + (Object)((Object)this.type));
        }

        public Value filter(Function<Value, Value> predicate) {
            if (this.isProjection) {
                return this.project(f -> f.filter(predicate));
            }
            if (this.type == Type.NULL) {
                return NULL_VALUE;
            }
            if (this.type == Type.LIST) {
                ArrayList results = new ArrayList();
                this.listValue.forEach(entry -> {
                    Value entryValue = new Value(entry);
                    Value predicateResult = (Value)predicate.apply(entryValue);
                    if (predicateResult.isTrue()) {
                        results.add(entry);
                    }
                });
                return new Value(results);
            }
            if (this.type == Type.MAP) {
                HashMap results = new HashMap();
                this.mapValue.forEach((key, entry) -> {
                    Value entryValue = new Value(entry);
                    Value predicateResult = (Value)predicate.apply(entryValue);
                    if (predicateResult.isTrue()) {
                        results.put(key, entry);
                    }
                });
                return new Value(results);
            }
            throw new IllegalArgumentException("Unsupported type for filter function: " + (Object)((Object)this.type));
        }

        public Value length() {
            if (this.type == Type.NULL) {
                return NULL_VALUE;
            }
            if (this.type == Type.STRING) {
                return new Value(this.stringValue.length());
            }
            if (this.type == Type.POJO) {
                return new Value(this.pojoValue.sdkFields().size());
            }
            if (this.type == Type.LIST) {
                return new Value(Math.toIntExact(this.listValue.size()));
            }
            if (this.type == Type.MAP) {
                return new Value(Math.toIntExact(this.mapValue.size()));
            }
            throw new IllegalArgumentException("Unsupported type for length function: " + (Object)((Object)this.type));
        }

        public Value keys() {
            if (this.type == Type.NULL) {
                return new Value(Collections.emptyList(), false);
            }
            if (this.type == Type.POJO) {
                return new Value(this.pojoValue.sdkFields().stream().map(SdkField::memberName).collect(Collectors.toList()));
            }
            if (this.type == Type.MAP) {
                return new Value(this.mapValue.keySet());
            }
            throw new IllegalArgumentException("Unsupported type for keys function: " + (Object)((Object)this.type));
        }

        public Value contains(Value rhs) {
            if (this.type == Type.NULL) {
                return NULL_VALUE;
            }
            if (this.type == Type.STRING) {
                if (rhs.type != Type.STRING) {
                    return new Value(false);
                }
                return new Value(this.stringValue.contains(rhs.stringValue));
            }
            Object value = rhs.value();
            if (this.type == Type.LIST) {
                return new Value(this.listValue.stream().anyMatch(v -> Objects.equals(v, value)));
            }
            if (this.type == Type.MAP) {
                return new Value(this.mapValue.containsValue(value));
            }
            throw new IllegalArgumentException("Unsupported type for contains function: " + (Object)((Object)this.type));
        }

        public Value compare(String comparison, Value rhs) {
            if (this.type != rhs.type) {
                return new Value(false);
            }
            if (this.type == Type.INTEGER) {
                switch (comparison) {
                    case "<": {
                        return new Value(this.integerValue < rhs.integerValue);
                    }
                    case "<=": {
                        return new Value(this.integerValue <= rhs.integerValue);
                    }
                    case ">": {
                        return new Value(this.integerValue > rhs.integerValue);
                    }
                    case ">=": {
                        return new Value(this.integerValue >= rhs.integerValue);
                    }
                    case "==": {
                        return new Value(Objects.equals(this.integerValue, rhs.integerValue));
                    }
                    case "!=": {
                        return new Value(!Objects.equals(this.integerValue, rhs.integerValue));
                    }
                }
                throw new IllegalArgumentException("Unsupported comparison: " + comparison);
            }
            if (this.type == Type.NULL || this.type == Type.STRING || this.type == Type.BOOLEAN) {
                switch (comparison) {
                    case "<": 
                    case "<=": 
                    case ">": 
                    case ">=": {
                        return NULL_VALUE;
                    }
                    case "==": {
                        return new Value(Objects.equals(this.value(), rhs.value()));
                    }
                    case "!=": {
                        return new Value(!Objects.equals(this.value(), rhs.value()));
                    }
                }
                throw new IllegalArgumentException("Unsupported comparison: " + comparison);
            }
            throw new IllegalArgumentException("Unsupported type in comparison: " + (Object)((Object)this.type));
        }

        @SafeVarargs
        public final Value multiSelectList(Function<Value, Value> ... functions) {
            if (this.isProjection) {
                return this.project(v -> v.multiSelectList(functions));
            }
            if (this.type == Type.NULL) {
                return NULL_VALUE;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (Function<Value, Value> function : functions) {
                result.add(function.apply(this).value());
            }
            return new Value(result);
        }

        public final Value multiSelectHash(Map<String, Function<Value, Value>> selections) {
            if (this.isProjection) {
                return this.project(v -> v.multiSelectHash(selections));
            }
            if (this.type == Type.NULL) {
                return NULL_VALUE;
            }
            if (this.type != Type.MAP) {
                throw new IllegalArgumentException("Multi-select map operation is only supported for maps");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry<String, Function<Value, Value>> entry : selections.entrySet()) {
                String key = entry.getKey();
                Function<Value, Value> function = entry.getValue();
                Value selectedValue = function.apply(new Value(this.mapValue.get(key)));
                result.put(key, selectedValue.value());
            }
            return new Value(result);
        }

        public Value or(Value rhs) {
            if (this.isTrue()) {
                return this;
            }
            return rhs.isTrue() ? rhs : NULL_VALUE;
        }

        public Value and(Value rhs) {
            return this.isTrue() ? rhs : this;
        }

        public Value not() {
            return new Value(!this.isTrue());
        }

        private boolean isTrue() {
            switch (this.type) {
                case POJO: {
                    return !this.pojoValue.sdkFields().isEmpty();
                }
                case LIST: {
                    return !this.listValue.isEmpty();
                }
                case MAP: {
                    return !this.mapValue.isEmpty();
                }
                case STRING: {
                    return !this.stringValue.isEmpty();
                }
                case BOOLEAN: {
                    return this.booleanValue;
                }
            }
            return false;
        }

        private Value project(Function<Value, Value> functionToApply) {
            if (this.type == Type.LIST) {
                return new Value(this.listValue.stream().map(Value::new).map(functionToApply).map(Value::value).filter(Objects::nonNull).collect(Collectors.toList()), true);
            }
            if (this.type == Type.MAP) {
                return new Value(this.mapValue.values().stream().map(Value::new).map(functionToApply).map(Value::value).filter(Objects::nonNull).collect(Collectors.toList()), true);
            }
            throw new IllegalArgumentException("Can only project on List or Map types");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value = (Value)o;
            return this.type == value.type && Objects.equals(this.value(), value.value());
        }

        public int hashCode() {
            Object value = this.value();
            int result = this.type.hashCode();
            result = 31 * result + (value != null ? value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return ToString.builder((String)"Value").add("type", (Object)this.type).add("value", this.value()).build();
        }

        private static enum Type {
            POJO,
            LIST,
            MAP,
            BOOLEAN,
            STRING,
            INTEGER,
            NULL;

        }
    }
}

