/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.RunLogLevel;
import software.amazon.awssdk.services.omics.model.RunRetentionMode;
import software.amazon.awssdk.services.omics.model.StorageType;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.services.omics.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartRunRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, StartRunRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(StartRunRequest.getter(StartRunRequest::workflowId)).setter(StartRunRequest.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowType").getter(StartRunRequest.getter(StartRunRequest::workflowTypeAsString)).setter(StartRunRequest.setter(Builder::workflowType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runId").getter(StartRunRequest.getter(StartRunRequest::runId)).setter(StartRunRequest.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartRunRequest.getter(StartRunRequest::roleArn)).setter(StartRunRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartRunRequest.getter(StartRunRequest::name)).setter(StartRunRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RUN_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runGroupId").getter(StartRunRequest.getter(StartRunRequest::runGroupId)).setter(StartRunRequest.setter(Builder::runGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runGroupId").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(StartRunRequest.getter(StartRunRequest::priority)).setter(StartRunRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<Document> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("parameters").getter(StartRunRequest.getter(StartRunRequest::parameters)).setter(StartRunRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCapacity").getter(StartRunRequest.getter(StartRunRequest::storageCapacity)).setter(StartRunRequest.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()}).build();
    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputUri").getter(StartRunRequest.getter(StartRunRequest::outputUri)).setter(StartRunRequest.setter(Builder::outputUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputUri").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logLevel").getter(StartRunRequest.getter(StartRunRequest::logLevelAsString)).setter(StartRunRequest.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartRunRequest.getter(StartRunRequest::tags)).setter(StartRunRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(StartRunRequest.getter(StartRunRequest::requestId)).setter(StartRunRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> RETENTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retentionMode").getter(StartRunRequest.getter(StartRunRequest::retentionModeAsString)).setter(StartRunRequest.setter(Builder::retentionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionMode").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(StartRunRequest.getter(StartRunRequest::storageTypeAsString)).setter(StartRunRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<String> WORKFLOW_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowOwnerId").getter(StartRunRequest.getter(StartRunRequest::workflowOwnerId)).setter(StartRunRequest.setter(Builder::workflowOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowOwnerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, WORKFLOW_TYPE_FIELD, RUN_ID_FIELD, ROLE_ARN_FIELD, NAME_FIELD, RUN_GROUP_ID_FIELD, PRIORITY_FIELD, PARAMETERS_FIELD, STORAGE_CAPACITY_FIELD, OUTPUT_URI_FIELD, LOG_LEVEL_FIELD, TAGS_FIELD, REQUEST_ID_FIELD, RETENTION_MODE_FIELD, STORAGE_TYPE_FIELD, WORKFLOW_OWNER_ID_FIELD));
    private final String workflowId;
    private final String workflowType;
    private final String runId;
    private final String roleArn;
    private final String name;
    private final String runGroupId;
    private final Integer priority;
    private final Document parameters;
    private final Integer storageCapacity;
    private final String outputUri;
    private final String logLevel;
    private final Map<String, String> tags;
    private final String requestIdValue;
    private final String retentionMode;
    private final String storageType;
    private final String workflowOwnerId;

    private StartRunRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.runId = builder.runId;
        this.roleArn = builder.roleArn;
        this.name = builder.name;
        this.runGroupId = builder.runGroupId;
        this.priority = builder.priority;
        this.parameters = builder.parameters;
        this.storageCapacity = builder.storageCapacity;
        this.outputUri = builder.outputUri;
        this.logLevel = builder.logLevel;
        this.tags = builder.tags;
        this.requestIdValue = builder.requestIdValue;
        this.retentionMode = builder.retentionMode;
        this.storageType = builder.storageType;
        this.workflowOwnerId = builder.workflowOwnerId;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(this.workflowType);
    }

    public final String workflowTypeAsString() {
        return this.workflowType;
    }

    public final String runId() {
        return this.runId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String name() {
        return this.name;
    }

    public final String runGroupId() {
        return this.runGroupId;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Document parameters() {
        return this.parameters;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final String outputUri() {
        return this.outputUri;
    }

    public final RunLogLevel logLevel() {
        return RunLogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final RunRetentionMode retentionMode() {
        return RunRetentionMode.fromValue(this.retentionMode);
    }

    public final String retentionModeAsString() {
        return this.retentionMode;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final String workflowOwnerId() {
        return this.workflowOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.runGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowOwnerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRunRequest)) {
            return false;
        }
        StartRunRequest other = (StartRunRequest)((Object)obj);
        return Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.workflowTypeAsString(), other.workflowTypeAsString()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.runGroupId(), other.runGroupId()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && Objects.equals(this.outputUri(), other.outputUri()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.retentionModeAsString(), other.retentionModeAsString()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.workflowOwnerId(), other.workflowOwnerId());
    }

    public final String toString() {
        return ToString.builder((String)"StartRunRequest").add("WorkflowId", (Object)this.workflowId()).add("WorkflowType", (Object)this.workflowTypeAsString()).add("RunId", (Object)this.runId()).add("RoleArn", (Object)this.roleArn()).add("Name", (Object)this.name()).add("RunGroupId", (Object)this.runGroupId()).add("Priority", (Object)this.priority()).add("Parameters", (Object)this.parameters()).add("StorageCapacity", (Object)this.storageCapacity()).add("OutputUri", (Object)this.outputUri()).add("LogLevel", (Object)this.logLevelAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("RequestId", (Object)this.requestId()).add("RetentionMode", (Object)this.retentionModeAsString()).add("StorageType", (Object)this.storageTypeAsString()).add("WorkflowOwnerId", (Object)this.workflowOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "workflowType": {
                return Optional.ofNullable(clazz.cast(this.workflowTypeAsString()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "runGroupId": {
                return Optional.ofNullable(clazz.cast(this.runGroupId()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "storageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "outputUri": {
                return Optional.ofNullable(clazz.cast(this.outputUri()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "retentionMode": {
                return Optional.ofNullable(clazz.cast(this.retentionModeAsString()));
            }
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "workflowOwnerId": {
                return Optional.ofNullable(clazz.cast(this.workflowOwnerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartRunRequest, T> g) {
        return obj -> g.apply((StartRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String workflowId;
        private String workflowType;
        private String runId;
        private String roleArn;
        private String name;
        private String runGroupId;
        private Integer priority;
        private Document parameters;
        private Integer storageCapacity;
        private String outputUri;
        private String logLevel;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String requestIdValue;
        private String retentionMode;
        private String storageType;
        private String workflowOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRunRequest model) {
            super(model);
            this.workflowId(model.workflowId);
            this.workflowType(model.workflowType);
            this.runId(model.runId);
            this.roleArn(model.roleArn);
            this.name(model.name);
            this.runGroupId(model.runGroupId);
            this.priority(model.priority);
            this.parameters(model.parameters);
            this.storageCapacity(model.storageCapacity);
            this.outputUri(model.outputUri);
            this.logLevel(model.logLevel);
            this.tags(model.tags);
            this.requestId(model.requestIdValue);
            this.retentionMode(model.retentionMode);
            this.storageType(model.storageType);
            this.workflowOwnerId(model.workflowOwnerId);
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getWorkflowType() {
            return this.workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRunGroupId() {
            return this.runGroupId;
        }

        public final void setRunGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
        }

        @Override
        public final Builder runGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Document getParameters() {
            return this.parameters;
        }

        public final void setParameters(Document parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(Document parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getOutputUri() {
            return this.outputUri;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(RunLogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getRetentionMode() {
            return this.retentionMode;
        }

        public final void setRetentionMode(String retentionMode) {
            this.retentionMode = retentionMode;
        }

        @Override
        public final Builder retentionMode(String retentionMode) {
            this.retentionMode = retentionMode;
            return this;
        }

        @Override
        public final Builder retentionMode(RunRetentionMode retentionMode) {
            this.retentionMode(retentionMode == null ? null : retentionMode.toString());
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final String getWorkflowOwnerId() {
            return this.workflowOwnerId;
        }

        public final void setWorkflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
        }

        @Override
        public final Builder workflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRunRequest build() {
            return new StartRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartRunRequest> {
        public Builder workflowId(String var1);

        public Builder workflowType(String var1);

        public Builder workflowType(WorkflowType var1);

        public Builder runId(String var1);

        public Builder roleArn(String var1);

        public Builder name(String var1);

        public Builder runGroupId(String var1);

        public Builder priority(Integer var1);

        public Builder parameters(Document var1);

        public Builder storageCapacity(Integer var1);

        public Builder outputUri(String var1);

        public Builder logLevel(String var1);

        public Builder logLevel(RunLogLevel var1);

        public Builder tags(Map<String, String> var1);

        public Builder requestId(String var1);

        public Builder retentionMode(String var1);

        public Builder retentionMode(RunRetentionMode var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder workflowOwnerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

