/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReferenceItem;
import software.amazon.awssdk.services.omics.model.StoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVariantStoreResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, CreateVariantStoreResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateVariantStoreResponse.getter(CreateVariantStoreResponse::id)).setter(CreateVariantStoreResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reference").getter(CreateVariantStoreResponse.getter(CreateVariantStoreResponse::reference)).setter(CreateVariantStoreResponse.setter(Builder::reference)).constructor(ReferenceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateVariantStoreResponse.getter(CreateVariantStoreResponse::statusAsString)).setter(CreateVariantStoreResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateVariantStoreResponse.getter(CreateVariantStoreResponse::name)).setter(CreateVariantStoreResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(CreateVariantStoreResponse.getter(CreateVariantStoreResponse::creationTime)).setter(CreateVariantStoreResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, REFERENCE_FIELD, STATUS_FIELD, NAME_FIELD, CREATION_TIME_FIELD));
    private final String id;
    private final ReferenceItem reference;
    private final String status;
    private final String name;
    private final Instant creationTime;

    private CreateVariantStoreResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.reference = builder.reference;
        this.status = builder.status;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final ReferenceItem reference() {
        return this.reference;
    }

    public final StoreStatus status() {
        return StoreStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVariantStoreResponse)) {
            return false;
        }
        CreateVariantStoreResponse other = (CreateVariantStoreResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.reference(), other.reference()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVariantStoreResponse").add("Id", (Object)this.id()).add("Reference", (Object)this.reference()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVariantStoreResponse, T> g) {
        return obj -> g.apply((CreateVariantStoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String id;
        private ReferenceItem reference;
        private String status;
        private String name;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVariantStoreResponse model) {
            super(model);
            this.id(model.id);
            this.reference(model.reference);
            this.status(model.status);
            this.name(model.name);
            this.creationTime(model.creationTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final ReferenceItem.Builder getReference() {
            return this.reference != null ? this.reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public CreateVariantStoreResponse build() {
            return new CreateVariantStoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVariantStoreResponse> {
        public Builder id(String var1);

        public Builder reference(ReferenceItem var1);

        default public Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return this.reference((ReferenceItem)((ReferenceItem.Builder)ReferenceItem.builder().applyMutation(reference)).build());
        }

        public Builder status(String var1);

        public Builder status(StoreStatus var1);

        public Builder name(String var1);

        public Builder creationTime(Instant var1);
    }
}

