/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.model.ExportReadSetJobDetail;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse;

public class ListReadSetExportJobsPublisher
implements SdkPublisher<ListReadSetExportJobsResponse> {
    private final OmicsAsyncClient client;
    private final ListReadSetExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReadSetExportJobsPublisher(OmicsAsyncClient client, ListReadSetExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReadSetExportJobsPublisher(OmicsAsyncClient client, ListReadSetExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReadSetExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReadSetExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExportReadSetJobDetail> exportJobs() {
        Function<ListReadSetExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exportJobs() != null) {
                return response.exportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReadSetExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReadSetExportJobsResponseFetcher
    implements AsyncPageFetcher<ListReadSetExportJobsResponse> {
        private ListReadSetExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReadSetExportJobsResponse> nextPage(ListReadSetExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetExportJobsPublisher.this.client.listReadSetExportJobs(ListReadSetExportJobsPublisher.this.firstRequest);
            }
            return ListReadSetExportJobsPublisher.this.client.listReadSetExportJobs((ListReadSetExportJobsRequest)((Object)ListReadSetExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

