/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.FileType;
import software.amazon.awssdk.services.omics.model.SourceFiles;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartReadSetImportJobSourceItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StartReadSetImportJobSourceItem> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StartReadSetImportJobSourceItem.getter(StartReadSetImportJobSourceItem::description)).setter(StartReadSetImportJobSourceItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generatedFrom").getter(StartReadSetImportJobSourceItem.getter(StartReadSetImportJobSourceItem::generatedFrom)).setter(StartReadSetImportJobSourceItem.setter(Builder::generatedFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(StartReadSetImportJobSourceItem.getter(StartReadSetImportJobSourceItem::name)).setter(StartReadSetImportJobSourceItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceArn").getter(StartReadSetImportJobSourceItem.getter(StartReadSetImportJobSourceItem::referenceArn)).setter(StartReadSetImportJobSourceItem.setter(Builder::referenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()}).build();
    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleId").getter(StartReadSetImportJobSourceItem.getter(StartReadSetImportJobSourceItem::sampleId)).setter(StartReadSetImportJobSourceItem.setter(Builder::sampleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()}).build();
    private static final SdkField<String> SOURCE_FILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceFileType").getter(StartReadSetImportJobSourceItem.getter(StartReadSetImportJobSourceItem::sourceFileTypeAsString)).setter(StartReadSetImportJobSourceItem.setter(Builder::sourceFileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFileType").build()}).build();
    private static final SdkField<SourceFiles> SOURCE_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceFiles").getter(StartReadSetImportJobSourceItem.getter(StartReadSetImportJobSourceItem::sourceFiles)).setter(StartReadSetImportJobSourceItem.setter(Builder::sourceFiles)).constructor(SourceFiles::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFiles").build()}).build();
    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subjectId").getter(StartReadSetImportJobSourceItem.getter(StartReadSetImportJobSourceItem::subjectId)).setter(StartReadSetImportJobSourceItem.setter(Builder::subjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartReadSetImportJobSourceItem.getter(StartReadSetImportJobSourceItem::tags)).setter(StartReadSetImportJobSourceItem.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, GENERATED_FROM_FIELD, NAME_FIELD, REFERENCE_ARN_FIELD, SAMPLE_ID_FIELD, SOURCE_FILE_TYPE_FIELD, SOURCE_FILES_FIELD, SUBJECT_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String generatedFrom;
    private final String name;
    private final String referenceArn;
    private final String sampleId;
    private final String sourceFileType;
    private final SourceFiles sourceFiles;
    private final String subjectId;
    private final Map<String, String> tags;

    private StartReadSetImportJobSourceItem(BuilderImpl builder) {
        this.description = builder.description;
        this.generatedFrom = builder.generatedFrom;
        this.name = builder.name;
        this.referenceArn = builder.referenceArn;
        this.sampleId = builder.sampleId;
        this.sourceFileType = builder.sourceFileType;
        this.sourceFiles = builder.sourceFiles;
        this.subjectId = builder.subjectId;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String generatedFrom() {
        return this.generatedFrom;
    }

    public final String name() {
        return this.name;
    }

    public final String referenceArn() {
        return this.referenceArn;
    }

    public final String sampleId() {
        return this.sampleId;
    }

    public final FileType sourceFileType() {
        return FileType.fromValue(this.sourceFileType);
    }

    public final String sourceFileTypeAsString() {
        return this.sourceFileType;
    }

    public final SourceFiles sourceFiles() {
        return this.sourceFiles;
    }

    public final String subjectId() {
        return this.subjectId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReadSetImportJobSourceItem)) {
            return false;
        }
        StartReadSetImportJobSourceItem other = (StartReadSetImportJobSourceItem)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.generatedFrom(), other.generatedFrom()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.referenceArn(), other.referenceArn()) && Objects.equals(this.sampleId(), other.sampleId()) && Objects.equals(this.sourceFileTypeAsString(), other.sourceFileTypeAsString()) && Objects.equals(this.sourceFiles(), other.sourceFiles()) && Objects.equals(this.subjectId(), other.subjectId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartReadSetImportJobSourceItem").add("Description", (Object)this.description()).add("GeneratedFrom", (Object)this.generatedFrom()).add("Name", (Object)this.name()).add("ReferenceArn", (Object)this.referenceArn()).add("SampleId", (Object)this.sampleId()).add("SourceFileType", (Object)this.sourceFileTypeAsString()).add("SourceFiles", (Object)this.sourceFiles()).add("SubjectId", (Object)this.subjectId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "generatedFrom": {
                return Optional.ofNullable(clazz.cast(this.generatedFrom()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "referenceArn": {
                return Optional.ofNullable(clazz.cast(this.referenceArn()));
            }
            case "sampleId": {
                return Optional.ofNullable(clazz.cast(this.sampleId()));
            }
            case "sourceFileType": {
                return Optional.ofNullable(clazz.cast(this.sourceFileTypeAsString()));
            }
            case "sourceFiles": {
                return Optional.ofNullable(clazz.cast(this.sourceFiles()));
            }
            case "subjectId": {
                return Optional.ofNullable(clazz.cast(this.subjectId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartReadSetImportJobSourceItem, T> g) {
        return obj -> g.apply((StartReadSetImportJobSourceItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String generatedFrom;
        private String name;
        private String referenceArn;
        private String sampleId;
        private String sourceFileType;
        private SourceFiles sourceFiles;
        private String subjectId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartReadSetImportJobSourceItem model) {
            this.description(model.description);
            this.generatedFrom(model.generatedFrom);
            this.name(model.name);
            this.referenceArn(model.referenceArn);
            this.sampleId(model.sampleId);
            this.sourceFileType(model.sourceFileType);
            this.sourceFiles(model.sourceFiles);
            this.subjectId(model.subjectId);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGeneratedFrom() {
            return this.generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReferenceArn() {
            return this.referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final String getSampleId() {
            return this.sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getSourceFileType() {
            return this.sourceFileType;
        }

        public final void setSourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
        }

        @Override
        public final Builder sourceFileType(String sourceFileType) {
            this.sourceFileType = sourceFileType;
            return this;
        }

        @Override
        public final Builder sourceFileType(FileType sourceFileType) {
            this.sourceFileType(sourceFileType == null ? null : sourceFileType.toString());
            return this;
        }

        public final SourceFiles.Builder getSourceFiles() {
            return this.sourceFiles != null ? this.sourceFiles.toBuilder() : null;
        }

        public final void setSourceFiles(SourceFiles.BuilderImpl sourceFiles) {
            this.sourceFiles = sourceFiles != null ? sourceFiles.build() : null;
        }

        @Override
        public final Builder sourceFiles(SourceFiles sourceFiles) {
            this.sourceFiles = sourceFiles;
            return this;
        }

        public final String getSubjectId() {
            return this.subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public StartReadSetImportJobSourceItem build() {
            return new StartReadSetImportJobSourceItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StartReadSetImportJobSourceItem> {
        public Builder description(String var1);

        public Builder generatedFrom(String var1);

        public Builder name(String var1);

        public Builder referenceArn(String var1);

        public Builder sampleId(String var1);

        public Builder sourceFileType(String var1);

        public Builder sourceFileType(FileType var1);

        public Builder sourceFiles(SourceFiles var1);

        default public Builder sourceFiles(Consumer<SourceFiles.Builder> sourceFiles) {
            return this.sourceFiles((SourceFiles)((SourceFiles.Builder)SourceFiles.builder().applyMutation(sourceFiles)).build());
        }

        public Builder subjectId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

