/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReferenceItem;
import software.amazon.awssdk.services.omics.model.SseConfig;
import software.amazon.awssdk.services.omics.model.StoreFormat;
import software.amazon.awssdk.services.omics.model.StoreOptions;
import software.amazon.awssdk.services.omics.model.StoreStatus;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnnotationStoreResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetAnnotationStoreResponse> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::creationTime)).setter(GetAnnotationStoreResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::description)).setter(GetAnnotationStoreResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::id)).setter(GetAnnotationStoreResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::name)).setter(GetAnnotationStoreResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reference").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::reference)).setter(GetAnnotationStoreResponse.setter(Builder::reference)).constructor(ReferenceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sseConfig").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::sseConfig)).setter(GetAnnotationStoreResponse.setter(Builder::sseConfig)).constructor(SseConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::statusAsString)).setter(GetAnnotationStoreResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::statusMessage)).setter(GetAnnotationStoreResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeArn").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::storeArn)).setter(GetAnnotationStoreResponse.setter(Builder::storeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeArn").build()}).build();
    private static final SdkField<String> STORE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeFormat").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::storeFormatAsString)).setter(GetAnnotationStoreResponse.setter(Builder::storeFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeFormat").build()}).build();
    private static final SdkField<StoreOptions> STORE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storeOptions").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::storeOptions)).setter(GetAnnotationStoreResponse.setter(Builder::storeOptions)).constructor(StoreOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeOptions").build()}).build();
    private static final SdkField<Long> STORE_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("storeSizeBytes").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::storeSizeBytes)).setter(GetAnnotationStoreResponse.setter(Builder::storeSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeSizeBytes").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::tags)).setter(GetAnnotationStoreResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetAnnotationStoreResponse.getter(GetAnnotationStoreResponse::updateTime)).setter(GetAnnotationStoreResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD, DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, REFERENCE_FIELD, SSE_CONFIG_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, STORE_ARN_FIELD, STORE_FORMAT_FIELD, STORE_OPTIONS_FIELD, STORE_SIZE_BYTES_FIELD, TAGS_FIELD, UPDATE_TIME_FIELD));
    private final Instant creationTime;
    private final String description;
    private final String id;
    private final String name;
    private final ReferenceItem reference;
    private final SseConfig sseConfig;
    private final String status;
    private final String statusMessage;
    private final String storeArn;
    private final String storeFormat;
    private final StoreOptions storeOptions;
    private final Long storeSizeBytes;
    private final Map<String, String> tags;
    private final Instant updateTime;

    private GetAnnotationStoreResponse(BuilderImpl builder) {
        super(builder);
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.reference = builder.reference;
        this.sseConfig = builder.sseConfig;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.storeArn = builder.storeArn;
        this.storeFormat = builder.storeFormat;
        this.storeOptions = builder.storeOptions;
        this.storeSizeBytes = builder.storeSizeBytes;
        this.tags = builder.tags;
        this.updateTime = builder.updateTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final ReferenceItem reference() {
        return this.reference;
    }

    public final SseConfig sseConfig() {
        return this.sseConfig;
    }

    public final StoreStatus status() {
        return StoreStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String storeArn() {
        return this.storeArn;
    }

    public final StoreFormat storeFormat() {
        return StoreFormat.fromValue(this.storeFormat);
    }

    public final String storeFormatAsString() {
        return this.storeFormat;
    }

    public final StoreOptions storeOptions() {
        return this.storeOptions;
    }

    public final Long storeSizeBytes() {
        return this.storeSizeBytes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnnotationStoreResponse)) {
            return false;
        }
        GetAnnotationStoreResponse other = (GetAnnotationStoreResponse)((Object)obj);
        return Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.reference(), other.reference()) && Objects.equals(this.sseConfig(), other.sseConfig()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.storeArn(), other.storeArn()) && Objects.equals(this.storeFormatAsString(), other.storeFormatAsString()) && Objects.equals(this.storeOptions(), other.storeOptions()) && Objects.equals(this.storeSizeBytes(), other.storeSizeBytes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetAnnotationStoreResponse").add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Reference", (Object)this.reference()).add("SseConfig", (Object)this.sseConfig()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StoreArn", (Object)this.storeArn()).add("StoreFormat", (Object)this.storeFormatAsString()).add("StoreOptions", (Object)this.storeOptions()).add("StoreSizeBytes", (Object)this.storeSizeBytes()).add("Tags", this.hasTags() ? this.tags() : null).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
            case "sseConfig": {
                return Optional.ofNullable(clazz.cast(this.sseConfig()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "storeArn": {
                return Optional.ofNullable(clazz.cast(this.storeArn()));
            }
            case "storeFormat": {
                return Optional.ofNullable(clazz.cast(this.storeFormatAsString()));
            }
            case "storeOptions": {
                return Optional.ofNullable(clazz.cast(this.storeOptions()));
            }
            case "storeSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.storeSizeBytes()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnnotationStoreResponse, T> g) {
        return obj -> g.apply((GetAnnotationStoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private Instant creationTime;
        private String description;
        private String id;
        private String name;
        private ReferenceItem reference;
        private SseConfig sseConfig;
        private String status;
        private String statusMessage;
        private String storeArn;
        private String storeFormat;
        private StoreOptions storeOptions;
        private Long storeSizeBytes;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnnotationStoreResponse model) {
            super(model);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.id(model.id);
            this.name(model.name);
            this.reference(model.reference);
            this.sseConfig(model.sseConfig);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.storeArn(model.storeArn);
            this.storeFormat(model.storeFormat);
            this.storeOptions(model.storeOptions);
            this.storeSizeBytes(model.storeSizeBytes);
            this.tags(model.tags);
            this.updateTime(model.updateTime);
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ReferenceItem.Builder getReference() {
            return this.reference != null ? this.reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return this.sseConfig != null ? this.sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStoreArn() {
            return this.storeArn;
        }

        public final void setStoreArn(String storeArn) {
            this.storeArn = storeArn;
        }

        @Override
        public final Builder storeArn(String storeArn) {
            this.storeArn = storeArn;
            return this;
        }

        public final String getStoreFormat() {
            return this.storeFormat;
        }

        public final void setStoreFormat(String storeFormat) {
            this.storeFormat = storeFormat;
        }

        @Override
        public final Builder storeFormat(String storeFormat) {
            this.storeFormat = storeFormat;
            return this;
        }

        @Override
        public final Builder storeFormat(StoreFormat storeFormat) {
            this.storeFormat(storeFormat == null ? null : storeFormat.toString());
            return this;
        }

        public final StoreOptions.Builder getStoreOptions() {
            return this.storeOptions != null ? this.storeOptions.toBuilder() : null;
        }

        public final void setStoreOptions(StoreOptions.BuilderImpl storeOptions) {
            this.storeOptions = storeOptions != null ? storeOptions.build() : null;
        }

        @Override
        public final Builder storeOptions(StoreOptions storeOptions) {
            this.storeOptions = storeOptions;
            return this;
        }

        public final Long getStoreSizeBytes() {
            return this.storeSizeBytes;
        }

        public final void setStoreSizeBytes(Long storeSizeBytes) {
            this.storeSizeBytes = storeSizeBytes;
        }

        @Override
        public final Builder storeSizeBytes(Long storeSizeBytes) {
            this.storeSizeBytes = storeSizeBytes;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetAnnotationStoreResponse build() {
            return new GetAnnotationStoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnnotationStoreResponse> {
        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder reference(ReferenceItem var1);

        default public Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return this.reference((ReferenceItem)((ReferenceItem.Builder)ReferenceItem.builder().applyMutation(reference)).build());
        }

        public Builder sseConfig(SseConfig var1);

        default public Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return this.sseConfig((SseConfig)((SseConfig.Builder)SseConfig.builder().applyMutation(sseConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(StoreStatus var1);

        public Builder statusMessage(String var1);

        public Builder storeArn(String var1);

        public Builder storeFormat(String var1);

        public Builder storeFormat(StoreFormat var1);

        public Builder storeOptions(StoreOptions var1);

        default public Builder storeOptions(Consumer<StoreOptions.Builder> storeOptions) {
            return this.storeOptions((StoreOptions)((StoreOptions.Builder)StoreOptions.builder().applyMutation(storeOptions)).build());
        }

        public Builder storeSizeBytes(Long var1);

        public Builder tags(Map<String, String> var1);

        public Builder updateTime(Instant var1);
    }
}

