/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.AnnotationImportJobItem;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse;

public class ListAnnotationImportJobsIterable
implements SdkIterable<ListAnnotationImportJobsResponse> {
    private final OmicsClient client;
    private final ListAnnotationImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnnotationImportJobsIterable(OmicsClient client, ListAnnotationImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAnnotationImportJobsResponseFetcher();
    }

    public Iterator<ListAnnotationImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnnotationImportJobItem> annotationImportJobs() {
        Function<ListAnnotationImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.annotationImportJobs() != null) {
                return response.annotationImportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnnotationImportJobsResponseFetcher
    implements SyncPageFetcher<ListAnnotationImportJobsResponse> {
        private ListAnnotationImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnnotationImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnnotationImportJobsResponse nextPage(ListAnnotationImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListAnnotationImportJobsIterable.this.client.listAnnotationImportJobs(ListAnnotationImportJobsIterable.this.firstRequest);
            }
            return ListAnnotationImportJobsIterable.this.client.listAnnotationImportJobs((ListAnnotationImportJobsRequest)((Object)ListAnnotationImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

