/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.ListReferencesRequest;
import software.amazon.awssdk.services.omics.model.ListReferencesResponse;
import software.amazon.awssdk.services.omics.model.ReferenceListItem;

public class ListReferencesIterable
implements SdkIterable<ListReferencesResponse> {
    private final OmicsClient client;
    private final ListReferencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReferencesIterable(OmicsClient client, ListReferencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReferencesResponseFetcher();
    }

    public Iterator<ListReferencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReferenceListItem> references() {
        Function<ListReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.references() != null) {
                return response.references().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReferencesResponseFetcher
    implements SyncPageFetcher<ListReferencesResponse> {
        private ListReferencesResponseFetcher() {
        }

        public boolean hasNextPage(ListReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReferencesResponse nextPage(ListReferencesResponse previousPage) {
            if (previousPage == null) {
                return ListReferencesIterable.this.client.listReferences(ListReferencesIterable.this.firstRequest);
            }
            return ListReferencesIterable.this.client.listReferences((ListReferencesRequest)((Object)ListReferencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

