/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.CreationType;
import software.amazon.awssdk.services.omics.model.ReadSetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadSetFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReadSetFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ReadSetFilter.getter(ReadSetFilter::name)).setter(ReadSetFilter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ReadSetFilter.getter(ReadSetFilter::statusAsString)).setter(ReadSetFilter.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceArn").getter(ReadSetFilter.getter(ReadSetFilter::referenceArn)).setter(ReadSetFilter.setter(Builder::referenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAfter").getter(ReadSetFilter.getter(ReadSetFilter::createdAfter)).setter(ReadSetFilter.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAfter").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdBefore").getter(ReadSetFilter.getter(ReadSetFilter::createdBefore)).setter(ReadSetFilter.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBefore").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleId").getter(ReadSetFilter.getter(ReadSetFilter::sampleId)).setter(ReadSetFilter.setter(Builder::sampleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()}).build();
    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subjectId").getter(ReadSetFilter.getter(ReadSetFilter::subjectId)).setter(ReadSetFilter.setter(Builder::subjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()}).build();
    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generatedFrom").getter(ReadSetFilter.getter(ReadSetFilter::generatedFrom)).setter(ReadSetFilter.setter(Builder::generatedFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()}).build();
    private static final SdkField<String> CREATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationType").getter(ReadSetFilter.getter(ReadSetFilter::creationTypeAsString)).setter(ReadSetFilter.setter(Builder::creationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, REFERENCE_ARN_FIELD, CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, SAMPLE_ID_FIELD, SUBJECT_ID_FIELD, GENERATED_FROM_FIELD, CREATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final String referenceArn;
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final String sampleId;
    private final String subjectId;
    private final String generatedFrom;
    private final String creationType;

    private ReadSetFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.referenceArn = builder.referenceArn;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.sampleId = builder.sampleId;
        this.subjectId = builder.subjectId;
        this.generatedFrom = builder.generatedFrom;
        this.creationType = builder.creationType;
    }

    public final String name() {
        return this.name;
    }

    public final ReadSetStatus status() {
        return ReadSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String referenceArn() {
        return this.referenceArn;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final String sampleId() {
        return this.sampleId;
    }

    public final String subjectId() {
        return this.subjectId;
    }

    public final String generatedFrom() {
        return this.generatedFrom;
    }

    public final CreationType creationType() {
        return CreationType.fromValue(this.creationType);
    }

    public final String creationTypeAsString() {
        return this.creationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadSetFilter)) {
            return false;
        }
        ReadSetFilter other = (ReadSetFilter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.referenceArn(), other.referenceArn()) && Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.sampleId(), other.sampleId()) && Objects.equals(this.subjectId(), other.subjectId()) && Objects.equals(this.generatedFrom(), other.generatedFrom()) && Objects.equals(this.creationTypeAsString(), other.creationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReadSetFilter").add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("ReferenceArn", (Object)this.referenceArn()).add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("SampleId", (Object)this.sampleId()).add("SubjectId", (Object)this.subjectId()).add("GeneratedFrom", (Object)this.generatedFrom()).add("CreationType", (Object)this.creationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "referenceArn": {
                return Optional.ofNullable(clazz.cast(this.referenceArn()));
            }
            case "createdAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "createdBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "sampleId": {
                return Optional.ofNullable(clazz.cast(this.sampleId()));
            }
            case "subjectId": {
                return Optional.ofNullable(clazz.cast(this.subjectId()));
            }
            case "generatedFrom": {
                return Optional.ofNullable(clazz.cast(this.generatedFrom()));
            }
            case "creationType": {
                return Optional.ofNullable(clazz.cast(this.creationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReadSetFilter, T> g) {
        return obj -> g.apply((ReadSetFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String referenceArn;
        private Instant createdAfter;
        private Instant createdBefore;
        private String sampleId;
        private String subjectId;
        private String generatedFrom;
        private String creationType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadSetFilter model) {
            this.name(model.name);
            this.status(model.status);
            this.referenceArn(model.referenceArn);
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.sampleId(model.sampleId);
            this.subjectId(model.subjectId);
            this.generatedFrom(model.generatedFrom);
            this.creationType(model.creationType);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getReferenceArn() {
            return this.referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final String getSampleId() {
            return this.sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getSubjectId() {
            return this.subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final String getGeneratedFrom() {
            return this.generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getCreationType() {
            return this.creationType;
        }

        public final void setCreationType(String creationType) {
            this.creationType = creationType;
        }

        @Override
        public final Builder creationType(String creationType) {
            this.creationType = creationType;
            return this;
        }

        @Override
        public final Builder creationType(CreationType creationType) {
            this.creationType(creationType == null ? null : creationType.toString());
            return this;
        }

        public ReadSetFilter build() {
            return new ReadSetFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReadSetFilter> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ReadSetStatus var1);

        public Builder referenceArn(String var1);

        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder sampleId(String var1);

        public Builder subjectId(String var1);

        public Builder generatedFrom(String var1);

        public Builder creationType(String var1);

        public Builder creationType(CreationType var1);
    }
}

