/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListSharesRequest;
import software.amazon.awssdk.services.omics.model.ListSharesResponse;
import software.amazon.awssdk.services.omics.model.ShareDetails;

public class ListSharesPublisher
implements SdkPublisher<ListSharesResponse> {
    private final OmicsAsyncClient client;
    private final ListSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSharesPublisher(OmicsAsyncClient client, ListSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSharesPublisher(OmicsAsyncClient client, ListSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ShareDetails> shares() {
        Function<ListSharesResponse, Iterator> getIterator = response -> {
            if (response != null && response.shares() != null) {
                return response.shares().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSharesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSharesResponseFetcher
    implements AsyncPageFetcher<ListSharesResponse> {
        private ListSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSharesResponse> nextPage(ListSharesResponse previousPage) {
            if (previousPage == null) {
                return ListSharesPublisher.this.client.listShares(ListSharesPublisher.this.firstRequest);
            }
            return ListSharesPublisher.this.client.listShares((ListSharesRequest)((Object)ListSharesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

