/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnnotationType {
    GENERIC("GENERIC"),
    CHR_POS("CHR_POS"),
    CHR_POS_REF_ALT("CHR_POS_REF_ALT"),
    CHR_START_END_ONE_BASE("CHR_START_END_ONE_BASE"),
    CHR_START_END_REF_ALT_ONE_BASE("CHR_START_END_REF_ALT_ONE_BASE"),
    CHR_START_END_ZERO_BASE("CHR_START_END_ZERO_BASE"),
    CHR_START_END_REF_ALT_ZERO_BASE("CHR_START_END_REF_ALT_ZERO_BASE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnnotationType> VALUE_MAP;
    private final String value;

    private AnnotationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnnotationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnnotationType> knownValues() {
        EnumSet<AnnotationType> knownValues = EnumSet.allOf(AnnotationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnnotationType.class, AnnotationType::toString);
    }
}

