/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.ReferenceFile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReferenceRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, GetReferenceRequest> {
    private static final SdkField<String> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("file").getter(GetReferenceRequest.getter(GetReferenceRequest::fileAsString)).setter(GetReferenceRequest.setter(Builder::file)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("file").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetReferenceRequest.getter(GetReferenceRequest::id)).setter(GetReferenceRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final SdkField<Integer> PART_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("partNumber").getter(GetReferenceRequest.getter(GetReferenceRequest::partNumber)).setter(GetReferenceRequest.setter(Builder::partNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partNumber").build()}).build();
    private static final SdkField<String> RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("range").getter(GetReferenceRequest.getter(GetReferenceRequest::range)).setter(GetReferenceRequest.setter(Builder::range)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Range").build()}).build();
    private static final SdkField<String> REFERENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceStoreId").getter(GetReferenceRequest.getter(GetReferenceRequest::referenceStoreId)).setter(GetReferenceRequest.setter(Builder::referenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("referenceStoreId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD, ID_FIELD, PART_NUMBER_FIELD, RANGE_FIELD, REFERENCE_STORE_ID_FIELD));
    private final String file;
    private final String id;
    private final Integer partNumber;
    private final String range;
    private final String referenceStoreId;

    private GetReferenceRequest(BuilderImpl builder) {
        super(builder);
        this.file = builder.file;
        this.id = builder.id;
        this.partNumber = builder.partNumber;
        this.range = builder.range;
        this.referenceStoreId = builder.referenceStoreId;
    }

    public final ReferenceFile file() {
        return ReferenceFile.fromValue(this.file);
    }

    public final String fileAsString() {
        return this.file;
    }

    public final String id() {
        return this.id;
    }

    public final Integer partNumber() {
        return this.partNumber;
    }

    public final String range() {
        return this.range;
    }

    public final String referenceStoreId() {
        return this.referenceStoreId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.partNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.range());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceStoreId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReferenceRequest)) {
            return false;
        }
        GetReferenceRequest other = (GetReferenceRequest)((Object)obj);
        return Objects.equals(this.fileAsString(), other.fileAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.partNumber(), other.partNumber()) && Objects.equals(this.range(), other.range()) && Objects.equals(this.referenceStoreId(), other.referenceStoreId());
    }

    public final String toString() {
        return ToString.builder((String)"GetReferenceRequest").add("File", (Object)this.fileAsString()).add("Id", (Object)this.id()).add("PartNumber", (Object)this.partNumber()).add("Range", (Object)this.range()).add("ReferenceStoreId", (Object)this.referenceStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "file": {
                return Optional.ofNullable(clazz.cast(this.fileAsString()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "partNumber": {
                return Optional.ofNullable(clazz.cast(this.partNumber()));
            }
            case "range": {
                return Optional.ofNullable(clazz.cast(this.range()));
            }
            case "referenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.referenceStoreId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReferenceRequest, T> g) {
        return obj -> g.apply((GetReferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String file;
        private String id;
        private Integer partNumber;
        private String range;
        private String referenceStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReferenceRequest model) {
            super(model);
            this.file(model.file);
            this.id(model.id);
            this.partNumber(model.partNumber);
            this.range(model.range);
            this.referenceStoreId(model.referenceStoreId);
        }

        public final String getFile() {
            return this.file;
        }

        public final void setFile(String file) {
            this.file = file;
        }

        @Override
        public final Builder file(String file) {
            this.file = file;
            return this;
        }

        @Override
        public final Builder file(ReferenceFile file) {
            this.file(file == null ? null : file.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final String getRange() {
            return this.range;
        }

        public final void setRange(String range) {
            this.range = range;
        }

        @Override
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        public final String getReferenceStoreId() {
            return this.referenceStoreId;
        }

        public final void setReferenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
        }

        @Override
        public final Builder referenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReferenceRequest build() {
            return new GetReferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReferenceRequest> {
        public Builder file(String var1);

        public Builder file(ReferenceFile var1);

        public Builder id(String var1);

        public Builder partNumber(Integer var1);

        public Builder range(String var1);

        public Builder referenceStoreId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

