/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRunGroupRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateRunGroupRequest> {
    private static final SdkField<Integer> MAX_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCpus").getter(CreateRunGroupRequest.getter(CreateRunGroupRequest::maxCpus)).setter(CreateRunGroupRequest.setter(Builder::maxCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpus").build()}).build();
    private static final SdkField<Integer> MAX_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxDuration").getter(CreateRunGroupRequest.getter(CreateRunGroupRequest::maxDuration)).setter(CreateRunGroupRequest.setter(Builder::maxDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDuration").build()}).build();
    private static final SdkField<Integer> MAX_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxRuns").getter(CreateRunGroupRequest.getter(CreateRunGroupRequest::maxRuns)).setter(CreateRunGroupRequest.setter(Builder::maxRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRuns").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateRunGroupRequest.getter(CreateRunGroupRequest::name)).setter(CreateRunGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(CreateRunGroupRequest.getter(CreateRunGroupRequest::requestId)).setter(CreateRunGroupRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateRunGroupRequest.getter(CreateRunGroupRequest::tags)).setter(CreateRunGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CPUS_FIELD, MAX_DURATION_FIELD, MAX_RUNS_FIELD, NAME_FIELD, REQUEST_ID_FIELD, TAGS_FIELD));
    private final Integer maxCpus;
    private final Integer maxDuration;
    private final Integer maxRuns;
    private final String name;
    private final String requestIdValue;
    private final Map<String, String> tags;

    private CreateRunGroupRequest(BuilderImpl builder) {
        super(builder);
        this.maxCpus = builder.maxCpus;
        this.maxDuration = builder.maxDuration;
        this.maxRuns = builder.maxRuns;
        this.name = builder.name;
        this.requestIdValue = builder.requestIdValue;
        this.tags = builder.tags;
    }

    public final Integer maxCpus() {
        return this.maxCpus;
    }

    public final Integer maxDuration() {
        return this.maxDuration;
    }

    public final Integer maxRuns() {
        return this.maxRuns;
    }

    public final String name() {
        return this.name;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRuns());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRunGroupRequest)) {
            return false;
        }
        CreateRunGroupRequest other = (CreateRunGroupRequest)((Object)obj);
        return Objects.equals(this.maxCpus(), other.maxCpus()) && Objects.equals(this.maxDuration(), other.maxDuration()) && Objects.equals(this.maxRuns(), other.maxRuns()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requestId(), other.requestId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRunGroupRequest").add("MaxCpus", (Object)this.maxCpus()).add("MaxDuration", (Object)this.maxDuration()).add("MaxRuns", (Object)this.maxRuns()).add("Name", (Object)this.name()).add("RequestId", (Object)this.requestId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxCpus": {
                return Optional.ofNullable(clazz.cast(this.maxCpus()));
            }
            case "maxDuration": {
                return Optional.ofNullable(clazz.cast(this.maxDuration()));
            }
            case "maxRuns": {
                return Optional.ofNullable(clazz.cast(this.maxRuns()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRunGroupRequest, T> g) {
        return obj -> g.apply((CreateRunGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private Integer maxCpus;
        private Integer maxDuration;
        private Integer maxRuns;
        private String name;
        private String requestIdValue;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRunGroupRequest model) {
            super(model);
            this.maxCpus(model.maxCpus);
            this.maxDuration(model.maxDuration);
            this.maxRuns(model.maxRuns);
            this.name(model.name);
            this.requestId(model.requestIdValue);
            this.tags(model.tags);
        }

        public final Integer getMaxCpus() {
            return this.maxCpus;
        }

        public final void setMaxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
        }

        @Override
        public final Builder maxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
            return this;
        }

        public final Integer getMaxDuration() {
            return this.maxDuration;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final Integer getMaxRuns() {
            return this.maxRuns;
        }

        public final void setMaxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
        }

        @Override
        public final Builder maxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRunGroupRequest build() {
            return new CreateRunGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRunGroupRequest> {
        public Builder maxCpus(Integer var1);

        public Builder maxDuration(Integer var1);

        public Builder maxRuns(Integer var1);

        public Builder name(String var1);

        public Builder requestId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

