/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.endpoints.internal;

import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.omics.endpoints.OmicsEndpointParams;
import software.amazon.awssdk.services.omics.endpoints.OmicsEndpointProvider;
import software.amazon.awssdk.services.omics.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class OmicsResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        OmicsEndpointProvider provider = (OmicsEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            Endpoint result = provider.resolveEndpoint(OmicsResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = OmicsResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), context.request())).isPresent()) {
                result = AwsEndpointProviderUtils.addHostPrefix(result, hostPrefix.get());
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    private static OmicsEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        OmicsEndpointParams.Builder builder = OmicsEndpointParams.builder();
        OmicsResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        OmicsResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        return builder.build();
    }

    private static void setContextParams(OmicsEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            default: 
        }
    }

    private static void setStaticContextParams(OmicsEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            default: 
        }
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        switch (operationName) {
            case "BatchDeleteReadSet": {
                return Optional.of("control-storage-");
            }
            case "CancelAnnotationImportJob": {
                return Optional.of("analytics-");
            }
            case "CancelRun": {
                return Optional.of("workflows-");
            }
            case "CancelVariantImportJob": {
                return Optional.of("analytics-");
            }
            case "CreateAnnotationStore": {
                return Optional.of("analytics-");
            }
            case "CreateReferenceStore": {
                return Optional.of("control-storage-");
            }
            case "CreateRunGroup": {
                return Optional.of("workflows-");
            }
            case "CreateSequenceStore": {
                return Optional.of("control-storage-");
            }
            case "CreateVariantStore": {
                return Optional.of("analytics-");
            }
            case "CreateWorkflow": {
                return Optional.of("workflows-");
            }
            case "DeleteAnnotationStore": {
                return Optional.of("analytics-");
            }
            case "DeleteReference": {
                return Optional.of("control-storage-");
            }
            case "DeleteReferenceStore": {
                return Optional.of("control-storage-");
            }
            case "DeleteRun": {
                return Optional.of("workflows-");
            }
            case "DeleteRunGroup": {
                return Optional.of("workflows-");
            }
            case "DeleteSequenceStore": {
                return Optional.of("control-storage-");
            }
            case "DeleteVariantStore": {
                return Optional.of("analytics-");
            }
            case "DeleteWorkflow": {
                return Optional.of("workflows-");
            }
            case "GetAnnotationImportJob": {
                return Optional.of("analytics-");
            }
            case "GetAnnotationStore": {
                return Optional.of("analytics-");
            }
            case "GetReadSet": {
                return Optional.of("storage-");
            }
            case "GetReadSetActivationJob": {
                return Optional.of("control-storage-");
            }
            case "GetReadSetExportJob": {
                return Optional.of("control-storage-");
            }
            case "GetReadSetImportJob": {
                return Optional.of("control-storage-");
            }
            case "GetReadSetMetadata": {
                return Optional.of("control-storage-");
            }
            case "GetReference": {
                return Optional.of("storage-");
            }
            case "GetReferenceImportJob": {
                return Optional.of("control-storage-");
            }
            case "GetReferenceMetadata": {
                return Optional.of("control-storage-");
            }
            case "GetReferenceStore": {
                return Optional.of("control-storage-");
            }
            case "GetRun": {
                return Optional.of("workflows-");
            }
            case "GetRunGroup": {
                return Optional.of("workflows-");
            }
            case "GetRunTask": {
                return Optional.of("workflows-");
            }
            case "GetSequenceStore": {
                return Optional.of("control-storage-");
            }
            case "GetVariantImportJob": {
                return Optional.of("analytics-");
            }
            case "GetVariantStore": {
                return Optional.of("analytics-");
            }
            case "GetWorkflow": {
                return Optional.of("workflows-");
            }
            case "ListAnnotationImportJobs": {
                return Optional.of("analytics-");
            }
            case "ListAnnotationStores": {
                return Optional.of("analytics-");
            }
            case "ListReadSetActivationJobs": {
                return Optional.of("control-storage-");
            }
            case "ListReadSetExportJobs": {
                return Optional.of("control-storage-");
            }
            case "ListReadSetImportJobs": {
                return Optional.of("control-storage-");
            }
            case "ListReadSets": {
                return Optional.of("control-storage-");
            }
            case "ListReferenceImportJobs": {
                return Optional.of("control-storage-");
            }
            case "ListReferenceStores": {
                return Optional.of("control-storage-");
            }
            case "ListReferences": {
                return Optional.of("control-storage-");
            }
            case "ListRunGroups": {
                return Optional.of("workflows-");
            }
            case "ListRunTasks": {
                return Optional.of("workflows-");
            }
            case "ListRuns": {
                return Optional.of("workflows-");
            }
            case "ListSequenceStores": {
                return Optional.of("control-storage-");
            }
            case "ListTagsForResource": {
                return Optional.of("tags-");
            }
            case "ListVariantImportJobs": {
                return Optional.of("analytics-");
            }
            case "ListVariantStores": {
                return Optional.of("analytics-");
            }
            case "ListWorkflows": {
                return Optional.of("workflows-");
            }
            case "StartAnnotationImportJob": {
                return Optional.of("analytics-");
            }
            case "StartReadSetActivationJob": {
                return Optional.of("control-storage-");
            }
            case "StartReadSetExportJob": {
                return Optional.of("control-storage-");
            }
            case "StartReadSetImportJob": {
                return Optional.of("control-storage-");
            }
            case "StartReferenceImportJob": {
                return Optional.of("control-storage-");
            }
            case "StartRun": {
                return Optional.of("workflows-");
            }
            case "StartVariantImportJob": {
                return Optional.of("analytics-");
            }
            case "TagResource": {
                return Optional.of("tags-");
            }
            case "UntagResource": {
                return Optional.of("tags-");
            }
            case "UpdateAnnotationStore": {
                return Optional.of("analytics-");
            }
            case "UpdateRunGroup": {
                return Optional.of("workflows-");
            }
            case "UpdateVariantStore": {
                return Optional.of("analytics-");
            }
            case "UpdateWorkflow": {
                return Optional.of("workflows-");
            }
        }
        return Optional.empty();
    }
}

