/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SystemVersionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SystemVersionSummary> {
    private static final SdkField<String> GI_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("giVersion").getter(SystemVersionSummary.getter(SystemVersionSummary::giVersion)).setter(SystemVersionSummary.setter(Builder::giVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("giVersion").build()}).build();
    private static final SdkField<String> SHAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shape").getter(SystemVersionSummary.getter(SystemVersionSummary::shape)).setter(SystemVersionSummary.setter(Builder::shape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()}).build();
    private static final SdkField<List<String>> SYSTEM_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("systemVersions").getter(SystemVersionSummary.getter(SystemVersionSummary::systemVersions)).setter(SystemVersionSummary.setter(Builder::systemVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GI_VERSION_FIELD, SHAPE_FIELD, SYSTEM_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SystemVersionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String giVersion;
    private final String shape;
    private final List<String> systemVersions;

    private SystemVersionSummary(BuilderImpl builder) {
        this.giVersion = builder.giVersion;
        this.shape = builder.shape;
        this.systemVersions = builder.systemVersions;
    }

    public final String giVersion() {
        return this.giVersion;
    }

    public final String shape() {
        return this.shape;
    }

    public final boolean hasSystemVersions() {
        return this.systemVersions != null && !(this.systemVersions instanceof SdkAutoConstructList);
    }

    public final List<String> systemVersions() {
        return this.systemVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.giVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.shape());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystemVersions() ? this.systemVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemVersionSummary)) {
            return false;
        }
        SystemVersionSummary other = (SystemVersionSummary)obj;
        return Objects.equals(this.giVersion(), other.giVersion()) && Objects.equals(this.shape(), other.shape()) && this.hasSystemVersions() == other.hasSystemVersions() && Objects.equals(this.systemVersions(), other.systemVersions());
    }

    public final String toString() {
        return ToString.builder((String)"SystemVersionSummary").add("GiVersion", (Object)this.giVersion()).add("Shape", (Object)this.shape()).add("SystemVersions", this.hasSystemVersions() ? this.systemVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "giVersion": {
                return Optional.ofNullable(clazz.cast(this.giVersion()));
            }
            case "shape": {
                return Optional.ofNullable(clazz.cast(this.shape()));
            }
            case "systemVersions": {
                return Optional.ofNullable(clazz.cast(this.systemVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giVersion", GI_VERSION_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("systemVersions", SYSTEM_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SystemVersionSummary, T> g) {
        return obj -> g.apply((SystemVersionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String giVersion;
        private String shape;
        private List<String> systemVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SystemVersionSummary model) {
            this.giVersion(model.giVersion);
            this.shape(model.shape);
            this.systemVersions(model.systemVersions);
        }

        public final String getGiVersion() {
            return this.giVersion;
        }

        public final void setGiVersion(String giVersion) {
            this.giVersion = giVersion;
        }

        @Override
        public final Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            return this;
        }

        public final String getShape() {
            return this.shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final Collection<String> getSystemVersions() {
            if (this.systemVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.systemVersions;
        }

        public final void setSystemVersions(Collection<String> systemVersions) {
            this.systemVersions = StringListCopier.copy(systemVersions);
        }

        @Override
        public final Builder systemVersions(Collection<String> systemVersions) {
            this.systemVersions = StringListCopier.copy(systemVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemVersions(String ... systemVersions) {
            this.systemVersions(Arrays.asList(systemVersions));
            return this;
        }

        public SystemVersionSummary build() {
            return new SystemVersionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SystemVersionSummary> {
        public Builder giVersion(String var1);

        public Builder shape(String var1);

        public Builder systemVersions(Collection<String> var1);

        public Builder systemVersions(String ... var1);
    }
}

