/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOdbNetworkRequest extends OdbRequest implements
        ToCopyableBuilder<UpdateOdbNetworkRequest.Builder, UpdateOdbNetworkRequest> {
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("odbNetworkId").getter(getter(UpdateOdbNetworkRequest::odbNetworkId))
            .setter(setter(Builder::odbNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateOdbNetworkRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<List<String>> PEERED_CIDRS_TO_BE_ADDED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("peeredCidrsToBeAdded")
            .getter(getter(UpdateOdbNetworkRequest::peeredCidrsToBeAdded))
            .setter(setter(Builder::peeredCidrsToBeAdded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peeredCidrsToBeAdded").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PEERED_CIDRS_TO_BE_REMOVED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("peeredCidrsToBeRemoved")
            .getter(getter(UpdateOdbNetworkRequest::peeredCidrsToBeRemoved))
            .setter(setter(Builder::peeredCidrsToBeRemoved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peeredCidrsToBeRemoved").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> S3_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Access").getter(getter(UpdateOdbNetworkRequest::s3AccessAsString)).setter(setter(Builder::s3Access))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Access").build()).build();

    private static final SdkField<String> ZERO_ETL_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("zeroEtlAccess").getter(getter(UpdateOdbNetworkRequest::zeroEtlAccessAsString))
            .setter(setter(Builder::zeroEtlAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zeroEtlAccess").build()).build();

    private static final SdkField<String> STS_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stsAccess").getter(getter(UpdateOdbNetworkRequest::stsAccessAsString))
            .setter(setter(Builder::stsAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stsAccess").build()).build();

    private static final SdkField<String> KMS_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsAccess").getter(getter(UpdateOdbNetworkRequest::kmsAccessAsString))
            .setter(setter(Builder::kmsAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAccess").build()).build();

    private static final SdkField<String> S3_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3PolicyDocument").getter(getter(UpdateOdbNetworkRequest::s3PolicyDocument))
            .setter(setter(Builder::s3PolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3PolicyDocument").build()).build();

    private static final SdkField<String> STS_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stsPolicyDocument").getter(getter(UpdateOdbNetworkRequest::stsPolicyDocument))
            .setter(setter(Builder::stsPolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stsPolicyDocument").build()).build();

    private static final SdkField<String> KMS_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsPolicyDocument").getter(getter(UpdateOdbNetworkRequest::kmsPolicyDocument))
            .setter(setter(Builder::kmsPolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsPolicyDocument").build()).build();

    private static final SdkField<List<String>> CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("crossRegionS3RestoreSourcesToEnable")
            .getter(getter(UpdateOdbNetworkRequest::crossRegionS3RestoreSourcesToEnable))
            .setter(setter(Builder::crossRegionS3RestoreSourcesToEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("crossRegionS3RestoreSourcesToEnable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CROSS_REGION_S3_RESTORE_SOURCES_TO_DISABLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("crossRegionS3RestoreSourcesToDisable")
            .getter(getter(UpdateOdbNetworkRequest::crossRegionS3RestoreSourcesToDisable))
            .setter(setter(Builder::crossRegionS3RestoreSourcesToDisable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("crossRegionS3RestoreSourcesToDisable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_NETWORK_ID_FIELD,
            DISPLAY_NAME_FIELD, PEERED_CIDRS_TO_BE_ADDED_FIELD, PEERED_CIDRS_TO_BE_REMOVED_FIELD, S3_ACCESS_FIELD,
            ZERO_ETL_ACCESS_FIELD, STS_ACCESS_FIELD, KMS_ACCESS_FIELD, S3_POLICY_DOCUMENT_FIELD, STS_POLICY_DOCUMENT_FIELD,
            KMS_POLICY_DOCUMENT_FIELD, CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD,
            CROSS_REGION_S3_RESTORE_SOURCES_TO_DISABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String odbNetworkId;

    private final String displayName;

    private final List<String> peeredCidrsToBeAdded;

    private final List<String> peeredCidrsToBeRemoved;

    private final String s3Access;

    private final String zeroEtlAccess;

    private final String stsAccess;

    private final String kmsAccess;

    private final String s3PolicyDocument;

    private final String stsPolicyDocument;

    private final String kmsPolicyDocument;

    private final List<String> crossRegionS3RestoreSourcesToEnable;

    private final List<String> crossRegionS3RestoreSourcesToDisable;

    private UpdateOdbNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.odbNetworkId = builder.odbNetworkId;
        this.displayName = builder.displayName;
        this.peeredCidrsToBeAdded = builder.peeredCidrsToBeAdded;
        this.peeredCidrsToBeRemoved = builder.peeredCidrsToBeRemoved;
        this.s3Access = builder.s3Access;
        this.zeroEtlAccess = builder.zeroEtlAccess;
        this.stsAccess = builder.stsAccess;
        this.kmsAccess = builder.kmsAccess;
        this.s3PolicyDocument = builder.s3PolicyDocument;
        this.stsPolicyDocument = builder.stsPolicyDocument;
        this.kmsPolicyDocument = builder.kmsPolicyDocument;
        this.crossRegionS3RestoreSourcesToEnable = builder.crossRegionS3RestoreSourcesToEnable;
        this.crossRegionS3RestoreSourcesToDisable = builder.crossRegionS3RestoreSourcesToDisable;
    }

    /**
     * <p>
     * The unique identifier of the ODB network to update.
     * </p>
     * 
     * @return The unique identifier of the ODB network to update.
     */
    public final String odbNetworkId() {
        return odbNetworkId;
    }

    /**
     * <p>
     * The new user-friendly name of the ODB network.
     * </p>
     * 
     * @return The new user-friendly name of the ODB network.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the PeeredCidrsToBeAdded property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPeeredCidrsToBeAdded() {
        return peeredCidrsToBeAdded != null && !(peeredCidrsToBeAdded instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of CIDR ranges from the peered VPC that allow access to the ODB network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPeeredCidrsToBeAdded} method.
     * </p>
     * 
     * @return The list of CIDR ranges from the peered VPC that allow access to the ODB network.
     */
    public final List<String> peeredCidrsToBeAdded() {
        return peeredCidrsToBeAdded;
    }

    /**
     * For responses, this returns true if the service returned a value for the PeeredCidrsToBeRemoved property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPeeredCidrsToBeRemoved() {
        return peeredCidrsToBeRemoved != null && !(peeredCidrsToBeRemoved instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of CIDR ranges from the peered VPC to remove from the ODB network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPeeredCidrsToBeRemoved} method.
     * </p>
     * 
     * @return The list of CIDR ranges from the peered VPC to remove from the ODB network.
     */
    public final List<String> peeredCidrsToBeRemoved() {
        return peeredCidrsToBeRemoved;
    }

    /**
     * <p>
     * Specifies the updated configuration for Amazon S3 access from the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3Access} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AccessAsString}.
     * </p>
     * 
     * @return Specifies the updated configuration for Amazon S3 access from the ODB network.
     * @see Access
     */
    public final Access s3Access() {
        return Access.fromValue(s3Access);
    }

    /**
     * <p>
     * Specifies the updated configuration for Amazon S3 access from the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3Access} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AccessAsString}.
     * </p>
     * 
     * @return Specifies the updated configuration for Amazon S3 access from the ODB network.
     * @see Access
     */
    public final String s3AccessAsString() {
        return s3Access;
    }

    /**
     * <p>
     * Specifies the updated configuration for Zero-ETL access from the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #zeroEtlAccess}
     * will return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #zeroEtlAccessAsString}.
     * </p>
     * 
     * @return Specifies the updated configuration for Zero-ETL access from the ODB network.
     * @see Access
     */
    public final Access zeroEtlAccess() {
        return Access.fromValue(zeroEtlAccess);
    }

    /**
     * <p>
     * Specifies the updated configuration for Zero-ETL access from the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #zeroEtlAccess}
     * will return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #zeroEtlAccessAsString}.
     * </p>
     * 
     * @return Specifies the updated configuration for Zero-ETL access from the ODB network.
     * @see Access
     */
    public final String zeroEtlAccessAsString() {
        return zeroEtlAccess;
    }

    /**
     * <p>
     * The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stsAccess} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stsAccessAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
     * @see Access
     */
    public final Access stsAccess() {
        return Access.fromValue(stsAccess);
    }

    /**
     * <p>
     * The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stsAccess} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stsAccessAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
     * @see Access
     */
    public final String stsAccessAsString() {
        return stsAccess;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kmsAccess} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kmsAccessAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
     * @see Access
     */
    public final Access kmsAccess() {
        return Access.fromValue(kmsAccess);
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kmsAccess} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kmsAccessAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
     * @see Access
     */
    public final String kmsAccessAsString() {
        return kmsAccess;
    }

    /**
     * <p>
     * Specifies the updated endpoint policy for Amazon S3 access from the ODB network.
     * </p>
     * 
     * @return Specifies the updated endpoint policy for Amazon S3 access from the ODB network.
     */
    public final String s3PolicyDocument() {
        return s3PolicyDocument;
    }

    /**
     * <p>
     * The STS policy document that defines permissions for token service usage within the ODB network.
     * </p>
     * 
     * @return The STS policy document that defines permissions for token service usage within the ODB network.
     */
    public final String stsPolicyDocument() {
        return stsPolicyDocument;
    }

    /**
     * <p>
     * The KMS policy document that defines permissions for key usage within the ODB network.
     * </p>
     * 
     * @return The KMS policy document that defines permissions for key usage within the ODB network.
     */
    public final String kmsPolicyDocument() {
        return kmsPolicyDocument;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossRegionS3RestoreSourcesToEnable
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCrossRegionS3RestoreSourcesToEnable() {
        return crossRegionS3RestoreSourcesToEnable != null
                && !(crossRegionS3RestoreSourcesToEnable instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cross-Region Amazon S3 restore sources to enable for the ODB network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossRegionS3RestoreSourcesToEnable}
     * method.
     * </p>
     * 
     * @return The cross-Region Amazon S3 restore sources to enable for the ODB network.
     */
    public final List<String> crossRegionS3RestoreSourcesToEnable() {
        return crossRegionS3RestoreSourcesToEnable;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossRegionS3RestoreSourcesToDisable
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCrossRegionS3RestoreSourcesToDisable() {
        return crossRegionS3RestoreSourcesToDisable != null
                && !(crossRegionS3RestoreSourcesToDisable instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cross-Region Amazon S3 restore sources to disable for the ODB network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossRegionS3RestoreSourcesToDisable}
     * method.
     * </p>
     * 
     * @return The cross-Region Amazon S3 restore sources to disable for the ODB network.
     */
    public final List<String> crossRegionS3RestoreSourcesToDisable() {
        return crossRegionS3RestoreSourcesToDisable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPeeredCidrsToBeAdded() ? peeredCidrsToBeAdded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPeeredCidrsToBeRemoved() ? peeredCidrsToBeRemoved() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(zeroEtlAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stsAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3PolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(stsPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(kmsPolicyDocument());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCrossRegionS3RestoreSourcesToEnable() ? crossRegionS3RestoreSourcesToEnable() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCrossRegionS3RestoreSourcesToDisable() ? crossRegionS3RestoreSourcesToDisable() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOdbNetworkRequest)) {
            return false;
        }
        UpdateOdbNetworkRequest other = (UpdateOdbNetworkRequest) obj;
        return Objects.equals(odbNetworkId(), other.odbNetworkId()) && Objects.equals(displayName(), other.displayName())
                && hasPeeredCidrsToBeAdded() == other.hasPeeredCidrsToBeAdded()
                && Objects.equals(peeredCidrsToBeAdded(), other.peeredCidrsToBeAdded())
                && hasPeeredCidrsToBeRemoved() == other.hasPeeredCidrsToBeRemoved()
                && Objects.equals(peeredCidrsToBeRemoved(), other.peeredCidrsToBeRemoved())
                && Objects.equals(s3AccessAsString(), other.s3AccessAsString())
                && Objects.equals(zeroEtlAccessAsString(), other.zeroEtlAccessAsString())
                && Objects.equals(stsAccessAsString(), other.stsAccessAsString())
                && Objects.equals(kmsAccessAsString(), other.kmsAccessAsString())
                && Objects.equals(s3PolicyDocument(), other.s3PolicyDocument())
                && Objects.equals(stsPolicyDocument(), other.stsPolicyDocument())
                && Objects.equals(kmsPolicyDocument(), other.kmsPolicyDocument())
                && hasCrossRegionS3RestoreSourcesToEnable() == other.hasCrossRegionS3RestoreSourcesToEnable()
                && Objects.equals(crossRegionS3RestoreSourcesToEnable(), other.crossRegionS3RestoreSourcesToEnable())
                && hasCrossRegionS3RestoreSourcesToDisable() == other.hasCrossRegionS3RestoreSourcesToDisable()
                && Objects.equals(crossRegionS3RestoreSourcesToDisable(), other.crossRegionS3RestoreSourcesToDisable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateOdbNetworkRequest")
                .add("OdbNetworkId", odbNetworkId())
                .add("DisplayName", displayName())
                .add("PeeredCidrsToBeAdded", hasPeeredCidrsToBeAdded() ? peeredCidrsToBeAdded() : null)
                .add("PeeredCidrsToBeRemoved", hasPeeredCidrsToBeRemoved() ? peeredCidrsToBeRemoved() : null)
                .add("S3Access", s3AccessAsString())
                .add("ZeroEtlAccess", zeroEtlAccessAsString())
                .add("StsAccess", stsAccessAsString())
                .add("KmsAccess", kmsAccessAsString())
                .add("S3PolicyDocument", s3PolicyDocument())
                .add("StsPolicyDocument", stsPolicyDocument())
                .add("KmsPolicyDocument", kmsPolicyDocument())
                .add("CrossRegionS3RestoreSourcesToEnable",
                        hasCrossRegionS3RestoreSourcesToEnable() ? crossRegionS3RestoreSourcesToEnable() : null)
                .add("CrossRegionS3RestoreSourcesToDisable",
                        hasCrossRegionS3RestoreSourcesToDisable() ? crossRegionS3RestoreSourcesToDisable() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "odbNetworkId":
            return Optional.ofNullable(clazz.cast(odbNetworkId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "peeredCidrsToBeAdded":
            return Optional.ofNullable(clazz.cast(peeredCidrsToBeAdded()));
        case "peeredCidrsToBeRemoved":
            return Optional.ofNullable(clazz.cast(peeredCidrsToBeRemoved()));
        case "s3Access":
            return Optional.ofNullable(clazz.cast(s3AccessAsString()));
        case "zeroEtlAccess":
            return Optional.ofNullable(clazz.cast(zeroEtlAccessAsString()));
        case "stsAccess":
            return Optional.ofNullable(clazz.cast(stsAccessAsString()));
        case "kmsAccess":
            return Optional.ofNullable(clazz.cast(kmsAccessAsString()));
        case "s3PolicyDocument":
            return Optional.ofNullable(clazz.cast(s3PolicyDocument()));
        case "stsPolicyDocument":
            return Optional.ofNullable(clazz.cast(stsPolicyDocument()));
        case "kmsPolicyDocument":
            return Optional.ofNullable(clazz.cast(kmsPolicyDocument()));
        case "crossRegionS3RestoreSourcesToEnable":
            return Optional.ofNullable(clazz.cast(crossRegionS3RestoreSourcesToEnable()));
        case "crossRegionS3RestoreSourcesToDisable":
            return Optional.ofNullable(clazz.cast(crossRegionS3RestoreSourcesToDisable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("peeredCidrsToBeAdded", PEERED_CIDRS_TO_BE_ADDED_FIELD);
        map.put("peeredCidrsToBeRemoved", PEERED_CIDRS_TO_BE_REMOVED_FIELD);
        map.put("s3Access", S3_ACCESS_FIELD);
        map.put("zeroEtlAccess", ZERO_ETL_ACCESS_FIELD);
        map.put("stsAccess", STS_ACCESS_FIELD);
        map.put("kmsAccess", KMS_ACCESS_FIELD);
        map.put("s3PolicyDocument", S3_POLICY_DOCUMENT_FIELD);
        map.put("stsPolicyDocument", STS_POLICY_DOCUMENT_FIELD);
        map.put("kmsPolicyDocument", KMS_POLICY_DOCUMENT_FIELD);
        map.put("crossRegionS3RestoreSourcesToEnable", CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD);
        map.put("crossRegionS3RestoreSourcesToDisable", CROSS_REGION_S3_RESTORE_SOURCES_TO_DISABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOdbNetworkRequest, T> g) {
        return obj -> g.apply((UpdateOdbNetworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateOdbNetworkRequest> {
        /**
         * <p>
         * The unique identifier of the ODB network to update.
         * </p>
         * 
         * @param odbNetworkId
         *        The unique identifier of the ODB network to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworkId(String odbNetworkId);

        /**
         * <p>
         * The new user-friendly name of the ODB network.
         * </p>
         * 
         * @param displayName
         *        The new user-friendly name of the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The list of CIDR ranges from the peered VPC that allow access to the ODB network.
         * </p>
         * 
         * @param peeredCidrsToBeAdded
         *        The list of CIDR ranges from the peered VPC that allow access to the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeredCidrsToBeAdded(Collection<String> peeredCidrsToBeAdded);

        /**
         * <p>
         * The list of CIDR ranges from the peered VPC that allow access to the ODB network.
         * </p>
         * 
         * @param peeredCidrsToBeAdded
         *        The list of CIDR ranges from the peered VPC that allow access to the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeredCidrsToBeAdded(String... peeredCidrsToBeAdded);

        /**
         * <p>
         * The list of CIDR ranges from the peered VPC to remove from the ODB network.
         * </p>
         * 
         * @param peeredCidrsToBeRemoved
         *        The list of CIDR ranges from the peered VPC to remove from the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeredCidrsToBeRemoved(Collection<String> peeredCidrsToBeRemoved);

        /**
         * <p>
         * The list of CIDR ranges from the peered VPC to remove from the ODB network.
         * </p>
         * 
         * @param peeredCidrsToBeRemoved
         *        The list of CIDR ranges from the peered VPC to remove from the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeredCidrsToBeRemoved(String... peeredCidrsToBeRemoved);

        /**
         * <p>
         * Specifies the updated configuration for Amazon S3 access from the ODB network.
         * </p>
         * 
         * @param s3Access
         *        Specifies the updated configuration for Amazon S3 access from the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder s3Access(String s3Access);

        /**
         * <p>
         * Specifies the updated configuration for Amazon S3 access from the ODB network.
         * </p>
         * 
         * @param s3Access
         *        Specifies the updated configuration for Amazon S3 access from the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder s3Access(Access s3Access);

        /**
         * <p>
         * Specifies the updated configuration for Zero-ETL access from the ODB network.
         * </p>
         * 
         * @param zeroEtlAccess
         *        Specifies the updated configuration for Zero-ETL access from the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder zeroEtlAccess(String zeroEtlAccess);

        /**
         * <p>
         * Specifies the updated configuration for Zero-ETL access from the ODB network.
         * </p>
         * 
         * @param zeroEtlAccess
         *        Specifies the updated configuration for Zero-ETL access from the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder zeroEtlAccess(Access zeroEtlAccess);

        /**
         * <p>
         * The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
         * </p>
         * 
         * @param stsAccess
         *        The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder stsAccess(String stsAccess);

        /**
         * <p>
         * The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
         * </p>
         * 
         * @param stsAccess
         *        The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder stsAccess(Access stsAccess);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
         * </p>
         * 
         * @param kmsAccess
         *        The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder kmsAccess(String kmsAccess);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
         * </p>
         * 
         * @param kmsAccess
         *        The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder kmsAccess(Access kmsAccess);

        /**
         * <p>
         * Specifies the updated endpoint policy for Amazon S3 access from the ODB network.
         * </p>
         * 
         * @param s3PolicyDocument
         *        Specifies the updated endpoint policy for Amazon S3 access from the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3PolicyDocument(String s3PolicyDocument);

        /**
         * <p>
         * The STS policy document that defines permissions for token service usage within the ODB network.
         * </p>
         * 
         * @param stsPolicyDocument
         *        The STS policy document that defines permissions for token service usage within the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stsPolicyDocument(String stsPolicyDocument);

        /**
         * <p>
         * The KMS policy document that defines permissions for key usage within the ODB network.
         * </p>
         * 
         * @param kmsPolicyDocument
         *        The KMS policy document that defines permissions for key usage within the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsPolicyDocument(String kmsPolicyDocument);

        /**
         * <p>
         * The cross-Region Amazon S3 restore sources to enable for the ODB network.
         * </p>
         * 
         * @param crossRegionS3RestoreSourcesToEnable
         *        The cross-Region Amazon S3 restore sources to enable for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable);

        /**
         * <p>
         * The cross-Region Amazon S3 restore sources to enable for the ODB network.
         * </p>
         * 
         * @param crossRegionS3RestoreSourcesToEnable
         *        The cross-Region Amazon S3 restore sources to enable for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionS3RestoreSourcesToEnable(String... crossRegionS3RestoreSourcesToEnable);

        /**
         * <p>
         * The cross-Region Amazon S3 restore sources to disable for the ODB network.
         * </p>
         * 
         * @param crossRegionS3RestoreSourcesToDisable
         *        The cross-Region Amazon S3 restore sources to disable for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionS3RestoreSourcesToDisable(Collection<String> crossRegionS3RestoreSourcesToDisable);

        /**
         * <p>
         * The cross-Region Amazon S3 restore sources to disable for the ODB network.
         * </p>
         * 
         * @param crossRegionS3RestoreSourcesToDisable
         *        The cross-Region Amazon S3 restore sources to disable for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionS3RestoreSourcesToDisable(String... crossRegionS3RestoreSourcesToDisable);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private String odbNetworkId;

        private String displayName;

        private List<String> peeredCidrsToBeAdded = DefaultSdkAutoConstructList.getInstance();

        private List<String> peeredCidrsToBeRemoved = DefaultSdkAutoConstructList.getInstance();

        private String s3Access;

        private String zeroEtlAccess;

        private String stsAccess;

        private String kmsAccess;

        private String s3PolicyDocument;

        private String stsPolicyDocument;

        private String kmsPolicyDocument;

        private List<String> crossRegionS3RestoreSourcesToEnable = DefaultSdkAutoConstructList.getInstance();

        private List<String> crossRegionS3RestoreSourcesToDisable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOdbNetworkRequest model) {
            super(model);
            odbNetworkId(model.odbNetworkId);
            displayName(model.displayName);
            peeredCidrsToBeAdded(model.peeredCidrsToBeAdded);
            peeredCidrsToBeRemoved(model.peeredCidrsToBeRemoved);
            s3Access(model.s3Access);
            zeroEtlAccess(model.zeroEtlAccess);
            stsAccess(model.stsAccess);
            kmsAccess(model.kmsAccess);
            s3PolicyDocument(model.s3PolicyDocument);
            stsPolicyDocument(model.stsPolicyDocument);
            kmsPolicyDocument(model.kmsPolicyDocument);
            crossRegionS3RestoreSourcesToEnable(model.crossRegionS3RestoreSourcesToEnable);
            crossRegionS3RestoreSourcesToDisable(model.crossRegionS3RestoreSourcesToDisable);
        }

        public final String getOdbNetworkId() {
            return odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getPeeredCidrsToBeAdded() {
            if (peeredCidrsToBeAdded instanceof SdkAutoConstructList) {
                return null;
            }
            return peeredCidrsToBeAdded;
        }

        public final void setPeeredCidrsToBeAdded(Collection<String> peeredCidrsToBeAdded) {
            this.peeredCidrsToBeAdded = StringListCopier.copy(peeredCidrsToBeAdded);
        }

        @Override
        public final Builder peeredCidrsToBeAdded(Collection<String> peeredCidrsToBeAdded) {
            this.peeredCidrsToBeAdded = StringListCopier.copy(peeredCidrsToBeAdded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peeredCidrsToBeAdded(String... peeredCidrsToBeAdded) {
            peeredCidrsToBeAdded(Arrays.asList(peeredCidrsToBeAdded));
            return this;
        }

        public final Collection<String> getPeeredCidrsToBeRemoved() {
            if (peeredCidrsToBeRemoved instanceof SdkAutoConstructList) {
                return null;
            }
            return peeredCidrsToBeRemoved;
        }

        public final void setPeeredCidrsToBeRemoved(Collection<String> peeredCidrsToBeRemoved) {
            this.peeredCidrsToBeRemoved = StringListCopier.copy(peeredCidrsToBeRemoved);
        }

        @Override
        public final Builder peeredCidrsToBeRemoved(Collection<String> peeredCidrsToBeRemoved) {
            this.peeredCidrsToBeRemoved = StringListCopier.copy(peeredCidrsToBeRemoved);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peeredCidrsToBeRemoved(String... peeredCidrsToBeRemoved) {
            peeredCidrsToBeRemoved(Arrays.asList(peeredCidrsToBeRemoved));
            return this;
        }

        public final String getS3Access() {
            return s3Access;
        }

        public final void setS3Access(String s3Access) {
            this.s3Access = s3Access;
        }

        @Override
        public final Builder s3Access(String s3Access) {
            this.s3Access = s3Access;
            return this;
        }

        @Override
        public final Builder s3Access(Access s3Access) {
            this.s3Access(s3Access == null ? null : s3Access.toString());
            return this;
        }

        public final String getZeroEtlAccess() {
            return zeroEtlAccess;
        }

        public final void setZeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
        }

        @Override
        public final Builder zeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
            return this;
        }

        @Override
        public final Builder zeroEtlAccess(Access zeroEtlAccess) {
            this.zeroEtlAccess(zeroEtlAccess == null ? null : zeroEtlAccess.toString());
            return this;
        }

        public final String getStsAccess() {
            return stsAccess;
        }

        public final void setStsAccess(String stsAccess) {
            this.stsAccess = stsAccess;
        }

        @Override
        public final Builder stsAccess(String stsAccess) {
            this.stsAccess = stsAccess;
            return this;
        }

        @Override
        public final Builder stsAccess(Access stsAccess) {
            this.stsAccess(stsAccess == null ? null : stsAccess.toString());
            return this;
        }

        public final String getKmsAccess() {
            return kmsAccess;
        }

        public final void setKmsAccess(String kmsAccess) {
            this.kmsAccess = kmsAccess;
        }

        @Override
        public final Builder kmsAccess(String kmsAccess) {
            this.kmsAccess = kmsAccess;
            return this;
        }

        @Override
        public final Builder kmsAccess(Access kmsAccess) {
            this.kmsAccess(kmsAccess == null ? null : kmsAccess.toString());
            return this;
        }

        public final String getS3PolicyDocument() {
            return s3PolicyDocument;
        }

        public final void setS3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
        }

        @Override
        public final Builder s3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
            return this;
        }

        public final String getStsPolicyDocument() {
            return stsPolicyDocument;
        }

        public final void setStsPolicyDocument(String stsPolicyDocument) {
            this.stsPolicyDocument = stsPolicyDocument;
        }

        @Override
        public final Builder stsPolicyDocument(String stsPolicyDocument) {
            this.stsPolicyDocument = stsPolicyDocument;
            return this;
        }

        public final String getKmsPolicyDocument() {
            return kmsPolicyDocument;
        }

        public final void setKmsPolicyDocument(String kmsPolicyDocument) {
            this.kmsPolicyDocument = kmsPolicyDocument;
        }

        @Override
        public final Builder kmsPolicyDocument(String kmsPolicyDocument) {
            this.kmsPolicyDocument = kmsPolicyDocument;
            return this;
        }

        public final Collection<String> getCrossRegionS3RestoreSourcesToEnable() {
            if (crossRegionS3RestoreSourcesToEnable instanceof SdkAutoConstructList) {
                return null;
            }
            return crossRegionS3RestoreSourcesToEnable;
        }

        public final void setCrossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable = StringListCopier.copy(crossRegionS3RestoreSourcesToEnable);
        }

        @Override
        public final Builder crossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable = StringListCopier.copy(crossRegionS3RestoreSourcesToEnable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionS3RestoreSourcesToEnable(String... crossRegionS3RestoreSourcesToEnable) {
            crossRegionS3RestoreSourcesToEnable(Arrays.asList(crossRegionS3RestoreSourcesToEnable));
            return this;
        }

        public final Collection<String> getCrossRegionS3RestoreSourcesToDisable() {
            if (crossRegionS3RestoreSourcesToDisable instanceof SdkAutoConstructList) {
                return null;
            }
            return crossRegionS3RestoreSourcesToDisable;
        }

        public final void setCrossRegionS3RestoreSourcesToDisable(Collection<String> crossRegionS3RestoreSourcesToDisable) {
            this.crossRegionS3RestoreSourcesToDisable = StringListCopier.copy(crossRegionS3RestoreSourcesToDisable);
        }

        @Override
        public final Builder crossRegionS3RestoreSourcesToDisable(Collection<String> crossRegionS3RestoreSourcesToDisable) {
            this.crossRegionS3RestoreSourcesToDisable = StringListCopier.copy(crossRegionS3RestoreSourcesToDisable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionS3RestoreSourcesToDisable(String... crossRegionS3RestoreSourcesToDisable) {
            crossRegionS3RestoreSourcesToDisable(Arrays.asList(crossRegionS3RestoreSourcesToDisable));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOdbNetworkRequest build() {
            return new UpdateOdbNetworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
