/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon Web Services Identity and Access Management (IAM) service role associated with a
 * resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamRole implements SdkPojo, Serializable, ToCopyableBuilder<IamRole.Builder, IamRole> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRoleArn").getter(getter(IamRole::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(IamRole::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(IamRole::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> AWS_INTEGRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsIntegration").getter(getter(IamRole::awsIntegrationAsString)).setter(setter(Builder::awsIntegration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIntegration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD,
            STATUS_FIELD, STATUS_REASON_FIELD, AWS_INTEGRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String iamRoleArn;

    private final String status;

    private final String statusReason;

    private final String awsIntegration;

    private IamRole(BuilderImpl builder) {
        this.iamRoleArn = builder.iamRoleArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.awsIntegration = builder.awsIntegration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The current status of the IAM service role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IamRoleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the IAM service role.
     * @see IamRoleStatus
     */
    public final IamRoleStatus status() {
        return IamRoleStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the IAM service role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IamRoleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the IAM service role.
     * @see IamRoleStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the current status of the IAM service role, if applicable.
     * </p>
     * 
     * @return Additional information about the current status of the IAM service role, if applicable.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Amazon Web Services integration configuration settings for the IAM service role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsIntegration}
     * will return {@link SupportedAwsIntegration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #awsIntegrationAsString}.
     * </p>
     * 
     * @return The Amazon Web Services integration configuration settings for the IAM service role.
     * @see SupportedAwsIntegration
     */
    public final SupportedAwsIntegration awsIntegration() {
        return SupportedAwsIntegration.fromValue(awsIntegration);
    }

    /**
     * <p>
     * The Amazon Web Services integration configuration settings for the IAM service role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsIntegration}
     * will return {@link SupportedAwsIntegration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #awsIntegrationAsString}.
     * </p>
     * 
     * @return The Amazon Web Services integration configuration settings for the IAM service role.
     * @see SupportedAwsIntegration
     */
    public final String awsIntegrationAsString() {
        return awsIntegration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(awsIntegrationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamRole)) {
            return false;
        }
        IamRole other = (IamRole) obj;
        return Objects.equals(iamRoleArn(), other.iamRoleArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(awsIntegrationAsString(), other.awsIntegrationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamRole").add("IamRoleArn", iamRoleArn()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("AwsIntegration", awsIntegrationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "awsIntegration":
            return Optional.ofNullable(clazz.cast(awsIntegrationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("iamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("awsIntegration", AWS_INTEGRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamRole, T> g) {
        return obj -> g.apply((IamRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamRole> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The current status of the IAM service role.
         * </p>
         * 
         * @param status
         *        The current status of the IAM service role.
         * @see IamRoleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamRoleStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the IAM service role.
         * </p>
         * 
         * @param status
         *        The current status of the IAM service role.
         * @see IamRoleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamRoleStatus
         */
        Builder status(IamRoleStatus status);

        /**
         * <p>
         * Additional information about the current status of the IAM service role, if applicable.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the current status of the IAM service role, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Amazon Web Services integration configuration settings for the IAM service role.
         * </p>
         * 
         * @param awsIntegration
         *        The Amazon Web Services integration configuration settings for the IAM service role.
         * @see SupportedAwsIntegration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedAwsIntegration
         */
        Builder awsIntegration(String awsIntegration);

        /**
         * <p>
         * The Amazon Web Services integration configuration settings for the IAM service role.
         * </p>
         * 
         * @param awsIntegration
         *        The Amazon Web Services integration configuration settings for the IAM service role.
         * @see SupportedAwsIntegration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedAwsIntegration
         */
        Builder awsIntegration(SupportedAwsIntegration awsIntegration);
    }

    static final class BuilderImpl implements Builder {
        private String iamRoleArn;

        private String status;

        private String statusReason;

        private String awsIntegration;

        private BuilderImpl() {
        }

        private BuilderImpl(IamRole model) {
            iamRoleArn(model.iamRoleArn);
            status(model.status);
            statusReason(model.statusReason);
            awsIntegration(model.awsIntegration);
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IamRoleStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getAwsIntegration() {
            return awsIntegration;
        }

        public final void setAwsIntegration(String awsIntegration) {
            this.awsIntegration = awsIntegration;
        }

        @Override
        public final Builder awsIntegration(String awsIntegration) {
            this.awsIntegration = awsIntegration;
            return this;
        }

        @Override
        public final Builder awsIntegration(SupportedAwsIntegration awsIntegration) {
            this.awsIntegration(awsIntegration == null ? null : awsIntegration.toString());
            return this;
        }

        @Override
        public IamRole build() {
            return new IamRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
