/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the data collection options enabled for a VM cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCollectionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DataCollectionOptions.Builder, DataCollectionOptions> {
    private static final SdkField<Boolean> IS_DIAGNOSTICS_EVENTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isDiagnosticsEventsEnabled")
            .getter(getter(DataCollectionOptions::isDiagnosticsEventsEnabled))
            .setter(setter(Builder::isDiagnosticsEventsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDiagnosticsEventsEnabled").build())
            .build();

    private static final SdkField<Boolean> IS_HEALTH_MONITORING_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("isHealthMonitoringEnabled")
            .getter(getter(DataCollectionOptions::isHealthMonitoringEnabled)).setter(setter(Builder::isHealthMonitoringEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isHealthMonitoringEnabled").build())
            .build();

    private static final SdkField<Boolean> IS_INCIDENT_LOGS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isIncidentLogsEnabled").getter(getter(DataCollectionOptions::isIncidentLogsEnabled))
            .setter(setter(Builder::isIncidentLogsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isIncidentLogsEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IS_DIAGNOSTICS_EVENTS_ENABLED_FIELD, IS_HEALTH_MONITORING_ENABLED_FIELD, IS_INCIDENT_LOGS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean isDiagnosticsEventsEnabled;

    private final Boolean isHealthMonitoringEnabled;

    private final Boolean isIncidentLogsEnabled;

    private DataCollectionOptions(BuilderImpl builder) {
        this.isDiagnosticsEventsEnabled = builder.isDiagnosticsEventsEnabled;
        this.isHealthMonitoringEnabled = builder.isHealthMonitoringEnabled;
        this.isIncidentLogsEnabled = builder.isIncidentLogsEnabled;
    }

    /**
     * <p>
     * Indicates whether diagnostic collection is enabled for the VM cluster.
     * </p>
     * 
     * @return Indicates whether diagnostic collection is enabled for the VM cluster.
     */
    public final Boolean isDiagnosticsEventsEnabled() {
        return isDiagnosticsEventsEnabled;
    }

    /**
     * <p>
     * Indicates whether health monitoring is enabled for the VM cluster.
     * </p>
     * 
     * @return Indicates whether health monitoring is enabled for the VM cluster.
     */
    public final Boolean isHealthMonitoringEnabled() {
        return isHealthMonitoringEnabled;
    }

    /**
     * <p>
     * Indicates whether incident logs are enabled for the cloud VM cluster.
     * </p>
     * 
     * @return Indicates whether incident logs are enabled for the cloud VM cluster.
     */
    public final Boolean isIncidentLogsEnabled() {
        return isIncidentLogsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isDiagnosticsEventsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(isHealthMonitoringEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(isIncidentLogsEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCollectionOptions)) {
            return false;
        }
        DataCollectionOptions other = (DataCollectionOptions) obj;
        return Objects.equals(isDiagnosticsEventsEnabled(), other.isDiagnosticsEventsEnabled())
                && Objects.equals(isHealthMonitoringEnabled(), other.isHealthMonitoringEnabled())
                && Objects.equals(isIncidentLogsEnabled(), other.isIncidentLogsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataCollectionOptions").add("IsDiagnosticsEventsEnabled", isDiagnosticsEventsEnabled())
                .add("IsHealthMonitoringEnabled", isHealthMonitoringEnabled())
                .add("IsIncidentLogsEnabled", isIncidentLogsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isDiagnosticsEventsEnabled":
            return Optional.ofNullable(clazz.cast(isDiagnosticsEventsEnabled()));
        case "isHealthMonitoringEnabled":
            return Optional.ofNullable(clazz.cast(isHealthMonitoringEnabled()));
        case "isIncidentLogsEnabled":
            return Optional.ofNullable(clazz.cast(isIncidentLogsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("isDiagnosticsEventsEnabled", IS_DIAGNOSTICS_EVENTS_ENABLED_FIELD);
        map.put("isHealthMonitoringEnabled", IS_HEALTH_MONITORING_ENABLED_FIELD);
        map.put("isIncidentLogsEnabled", IS_INCIDENT_LOGS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataCollectionOptions, T> g) {
        return obj -> g.apply((DataCollectionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCollectionOptions> {
        /**
         * <p>
         * Indicates whether diagnostic collection is enabled for the VM cluster.
         * </p>
         * 
         * @param isDiagnosticsEventsEnabled
         *        Indicates whether diagnostic collection is enabled for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDiagnosticsEventsEnabled(Boolean isDiagnosticsEventsEnabled);

        /**
         * <p>
         * Indicates whether health monitoring is enabled for the VM cluster.
         * </p>
         * 
         * @param isHealthMonitoringEnabled
         *        Indicates whether health monitoring is enabled for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isHealthMonitoringEnabled(Boolean isHealthMonitoringEnabled);

        /**
         * <p>
         * Indicates whether incident logs are enabled for the cloud VM cluster.
         * </p>
         * 
         * @param isIncidentLogsEnabled
         *        Indicates whether incident logs are enabled for the cloud VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isIncidentLogsEnabled(Boolean isIncidentLogsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean isDiagnosticsEventsEnabled;

        private Boolean isHealthMonitoringEnabled;

        private Boolean isIncidentLogsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCollectionOptions model) {
            isDiagnosticsEventsEnabled(model.isDiagnosticsEventsEnabled);
            isHealthMonitoringEnabled(model.isHealthMonitoringEnabled);
            isIncidentLogsEnabled(model.isIncidentLogsEnabled);
        }

        public final Boolean getIsDiagnosticsEventsEnabled() {
            return isDiagnosticsEventsEnabled;
        }

        public final void setIsDiagnosticsEventsEnabled(Boolean isDiagnosticsEventsEnabled) {
            this.isDiagnosticsEventsEnabled = isDiagnosticsEventsEnabled;
        }

        @Override
        public final Builder isDiagnosticsEventsEnabled(Boolean isDiagnosticsEventsEnabled) {
            this.isDiagnosticsEventsEnabled = isDiagnosticsEventsEnabled;
            return this;
        }

        public final Boolean getIsHealthMonitoringEnabled() {
            return isHealthMonitoringEnabled;
        }

        public final void setIsHealthMonitoringEnabled(Boolean isHealthMonitoringEnabled) {
            this.isHealthMonitoringEnabled = isHealthMonitoringEnabled;
        }

        @Override
        public final Builder isHealthMonitoringEnabled(Boolean isHealthMonitoringEnabled) {
            this.isHealthMonitoringEnabled = isHealthMonitoringEnabled;
            return this;
        }

        public final Boolean getIsIncidentLogsEnabled() {
            return isIncidentLogsEnabled;
        }

        public final void setIsIncidentLogsEnabled(Boolean isIncidentLogsEnabled) {
            this.isIncidentLogsEnabled = isIncidentLogsEnabled;
        }

        @Override
        public final Builder isIncidentLogsEnabled(Boolean isIncidentLogsEnabled) {
            this.isIncidentLogsEnabled = isIncidentLogsEnabled;
            return this;
        }

        @Override
        public DataCollectionOptions build() {
            return new DataCollectionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
