/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateOdbNetworkRequest extends OdbRequest implements
        ToCopyableBuilder<CreateOdbNetworkRequest.Builder, CreateOdbNetworkRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateOdbNetworkRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CreateOdbNetworkRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(CreateOdbNetworkRequest::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<String> CLIENT_SUBNET_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientSubnetCidr").getter(getter(CreateOdbNetworkRequest::clientSubnetCidr))
            .setter(setter(Builder::clientSubnetCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnetCidr").build()).build();

    private static final SdkField<String> BACKUP_SUBNET_CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backupSubnetCidr").getter(getter(CreateOdbNetworkRequest::backupSubnetCidr))
            .setter(setter(Builder::backupSubnetCidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupSubnetCidr").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(CreateOdbNetworkRequest::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<String> DEFAULT_DNS_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultDnsPrefix").getter(getter(CreateOdbNetworkRequest::defaultDnsPrefix))
            .setter(setter(Builder::defaultDnsPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDnsPrefix").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateOdbNetworkRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> S3_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Access").getter(getter(CreateOdbNetworkRequest::s3AccessAsString)).setter(setter(Builder::s3Access))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Access").build()).build();

    private static final SdkField<String> ZERO_ETL_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("zeroEtlAccess").getter(getter(CreateOdbNetworkRequest::zeroEtlAccessAsString))
            .setter(setter(Builder::zeroEtlAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zeroEtlAccess").build()).build();

    private static final SdkField<String> STS_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stsAccess").getter(getter(CreateOdbNetworkRequest::stsAccessAsString))
            .setter(setter(Builder::stsAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stsAccess").build()).build();

    private static final SdkField<String> KMS_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsAccess").getter(getter(CreateOdbNetworkRequest::kmsAccessAsString))
            .setter(setter(Builder::kmsAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsAccess").build()).build();

    private static final SdkField<String> S3_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3PolicyDocument").getter(getter(CreateOdbNetworkRequest::s3PolicyDocument))
            .setter(setter(Builder::s3PolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3PolicyDocument").build()).build();

    private static final SdkField<String> STS_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stsPolicyDocument").getter(getter(CreateOdbNetworkRequest::stsPolicyDocument))
            .setter(setter(Builder::stsPolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stsPolicyDocument").build()).build();

    private static final SdkField<String> KMS_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsPolicyDocument").getter(getter(CreateOdbNetworkRequest::kmsPolicyDocument))
            .setter(setter(Builder::kmsPolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsPolicyDocument").build()).build();

    private static final SdkField<List<String>> CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("crossRegionS3RestoreSourcesToEnable")
            .getter(getter(CreateOdbNetworkRequest::crossRegionS3RestoreSourcesToEnable))
            .setter(setter(Builder::crossRegionS3RestoreSourcesToEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("crossRegionS3RestoreSourcesToEnable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateOdbNetworkRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CLIENT_SUBNET_CIDR_FIELD, BACKUP_SUBNET_CIDR_FIELD,
            CUSTOM_DOMAIN_NAME_FIELD, DEFAULT_DNS_PREFIX_FIELD, CLIENT_TOKEN_FIELD, S3_ACCESS_FIELD, ZERO_ETL_ACCESS_FIELD,
            STS_ACCESS_FIELD, KMS_ACCESS_FIELD, S3_POLICY_DOCUMENT_FIELD, STS_POLICY_DOCUMENT_FIELD, KMS_POLICY_DOCUMENT_FIELD,
            CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String displayName;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final String clientSubnetCidr;

    private final String backupSubnetCidr;

    private final String customDomainName;

    private final String defaultDnsPrefix;

    private final String clientToken;

    private final String s3Access;

    private final String zeroEtlAccess;

    private final String stsAccess;

    private final String kmsAccess;

    private final String s3PolicyDocument;

    private final String stsPolicyDocument;

    private final String kmsPolicyDocument;

    private final List<String> crossRegionS3RestoreSourcesToEnable;

    private final Map<String, String> tags;

    private CreateOdbNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.clientSubnetCidr = builder.clientSubnetCidr;
        this.backupSubnetCidr = builder.backupSubnetCidr;
        this.customDomainName = builder.customDomainName;
        this.defaultDnsPrefix = builder.defaultDnsPrefix;
        this.clientToken = builder.clientToken;
        this.s3Access = builder.s3Access;
        this.zeroEtlAccess = builder.zeroEtlAccess;
        this.stsAccess = builder.stsAccess;
        this.kmsAccess = builder.kmsAccess;
        this.s3PolicyDocument = builder.s3PolicyDocument;
        this.stsPolicyDocument = builder.stsPolicyDocument;
        this.kmsPolicyDocument = builder.kmsPolicyDocument;
        this.crossRegionS3RestoreSourcesToEnable = builder.crossRegionS3RestoreSourcesToEnable;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A user-friendly name for the ODB network.
     * </p>
     * 
     * @return A user-friendly name for the ODB network.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The Amazon Web Services Availability Zone (AZ) where the ODB network is located.
     * </p>
     * <p>
     * This operation requires that you specify a value for either <code>availabilityZone</code> or
     * <code>availabilityZoneId</code>.
     * </p>
     * 
     * @return The Amazon Web Services Availability Zone (AZ) where the ODB network is located.</p>
     *         <p>
     *         This operation requires that you specify a value for either <code>availabilityZone</code> or
     *         <code>availabilityZoneId</code>.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The AZ ID of the AZ where the ODB network is located.
     * </p>
     * <p>
     * This operation requires that you specify a value for either <code>availabilityZone</code> or
     * <code>availabilityZoneId</code>.
     * </p>
     * 
     * @return The AZ ID of the AZ where the ODB network is located.</p>
     *         <p>
     *         This operation requires that you specify a value for either <code>availabilityZone</code> or
     *         <code>availabilityZoneId</code>.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The CIDR range of the client subnet for the ODB network.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must not overlap with the CIDR range of the backup subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not overlap with the CIDR ranges of the VPCs that are connected to the ODB network.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not use the following CIDR ranges that are reserved by OCI:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>100.106.0.0/16</code> and <code>100.107.0.0/16</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.0.0/16</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>224.0.0.0 - 239.255.255.255</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>240.0.0.0 - 255.255.255.255</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The CIDR range of the client subnet for the ODB network.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must not overlap with the CIDR range of the backup subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not overlap with the CIDR ranges of the VPCs that are connected to the ODB network.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not use the following CIDR ranges that are reserved by OCI:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>100.106.0.0/16</code> and <code>100.107.0.0/16</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.0.0/16</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>224.0.0.0 - 239.255.255.255</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>240.0.0.0 - 255.255.255.255</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String clientSubnetCidr() {
        return clientSubnetCidr;
    }

    /**
     * <p>
     * The CIDR range of the backup subnet for the ODB network.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must not overlap with the CIDR range of the client subnet.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not overlap with the CIDR ranges of the VPCs that are connected to the ODB network.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must not use the following CIDR ranges that are reserved by OCI:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>100.106.0.0/16</code> and <code>100.107.0.0/16</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>169.254.0.0/16</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>224.0.0.0 - 239.255.255.255</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>240.0.0.0 - 255.255.255.255</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The CIDR range of the backup subnet for the ODB network.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must not overlap with the CIDR range of the client subnet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not overlap with the CIDR ranges of the VPCs that are connected to the ODB network.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must not use the following CIDR ranges that are reserved by OCI:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>100.106.0.0/16</code> and <code>100.107.0.0/16</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>169.254.0.0/16</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>224.0.0.0 - 239.255.255.255</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>240.0.0.0 - 255.255.255.255</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String backupSubnetCidr() {
        return backupSubnetCidr;
    }

    /**
     * <p>
     * The domain name to use for the resources in the ODB network.
     * </p>
     * 
     * @return The domain name to use for the resources in the ODB network.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The DNS prefix to the default DNS domain name. The default DNS domain name is oraclevcn.com.
     * </p>
     * 
     * @return The DNS prefix to the default DNS domain name. The default DNS domain name is oraclevcn.com.
     */
    public final String defaultDnsPrefix() {
        return defaultDnsPrefix;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
     * specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for the
     * request to ensure idempotency. The client token is valid for up to 24 hours after it's first used.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
     *         don't specify a client token, the Amazon Web Services SDK automatically generates a client token and uses
     *         it for the request to ensure idempotency. The client token is valid for up to 24 hours after it's first
     *         used.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the configuration for Amazon S3 access from the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3Access} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AccessAsString}.
     * </p>
     * 
     * @return Specifies the configuration for Amazon S3 access from the ODB network.
     * @see Access
     */
    public final Access s3Access() {
        return Access.fromValue(s3Access);
    }

    /**
     * <p>
     * Specifies the configuration for Amazon S3 access from the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3Access} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3AccessAsString}.
     * </p>
     * 
     * @return Specifies the configuration for Amazon S3 access from the ODB network.
     * @see Access
     */
    public final String s3AccessAsString() {
        return s3Access;
    }

    /**
     * <p>
     * Specifies the configuration for Zero-ETL access from the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #zeroEtlAccess}
     * will return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #zeroEtlAccessAsString}.
     * </p>
     * 
     * @return Specifies the configuration for Zero-ETL access from the ODB network.
     * @see Access
     */
    public final Access zeroEtlAccess() {
        return Access.fromValue(zeroEtlAccess);
    }

    /**
     * <p>
     * Specifies the configuration for Zero-ETL access from the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #zeroEtlAccess}
     * will return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #zeroEtlAccessAsString}.
     * </p>
     * 
     * @return Specifies the configuration for Zero-ETL access from the ODB network.
     * @see Access
     */
    public final String zeroEtlAccessAsString() {
        return zeroEtlAccess;
    }

    /**
     * <p>
     * The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stsAccess} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stsAccessAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
     * @see Access
     */
    public final Access stsAccess() {
        return Access.fromValue(stsAccess);
    }

    /**
     * <p>
     * The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stsAccess} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stsAccessAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
     * @see Access
     */
    public final String stsAccessAsString() {
        return stsAccess;
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kmsAccess} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kmsAccessAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
     * @see Access
     */
    public final Access kmsAccess() {
        return Access.fromValue(kmsAccess);
    }

    /**
     * <p>
     * The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kmsAccess} will
     * return {@link Access#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kmsAccessAsString}.
     * </p>
     * 
     * @return The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
     * @see Access
     */
    public final String kmsAccessAsString() {
        return kmsAccess;
    }

    /**
     * <p>
     * Specifies the endpoint policy for Amazon S3 access from the ODB network.
     * </p>
     * 
     * @return Specifies the endpoint policy for Amazon S3 access from the ODB network.
     */
    public final String s3PolicyDocument() {
        return s3PolicyDocument;
    }

    /**
     * <p>
     * The STS policy document that defines permissions for token service usage within the ODB network.
     * </p>
     * 
     * @return The STS policy document that defines permissions for token service usage within the ODB network.
     */
    public final String stsPolicyDocument() {
        return stsPolicyDocument;
    }

    /**
     * <p>
     * The KMS policy document that defines permissions for key usage within the ODB network.
     * </p>
     * 
     * @return The KMS policy document that defines permissions for key usage within the ODB network.
     */
    public final String kmsPolicyDocument() {
        return kmsPolicyDocument;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrossRegionS3RestoreSourcesToEnable
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCrossRegionS3RestoreSourcesToEnable() {
        return crossRegionS3RestoreSourcesToEnable != null
                && !(crossRegionS3RestoreSourcesToEnable instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The cross-Region Amazon S3 restore sources to enable for the ODB network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrossRegionS3RestoreSourcesToEnable}
     * method.
     * </p>
     * 
     * @return The cross-Region Amazon S3 restore sources to enable for the ODB network.
     */
    public final List<String> crossRegionS3RestoreSourcesToEnable() {
        return crossRegionS3RestoreSourcesToEnable;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of resource tags to apply to the ODB network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The list of resource tags to apply to the ODB network.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(clientSubnetCidr());
        hashCode = 31 * hashCode + Objects.hashCode(backupSubnetCidr());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultDnsPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(zeroEtlAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stsAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3PolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(stsPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(kmsPolicyDocument());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCrossRegionS3RestoreSourcesToEnable() ? crossRegionS3RestoreSourcesToEnable() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOdbNetworkRequest)) {
            return false;
        }
        CreateOdbNetworkRequest other = (CreateOdbNetworkRequest) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(clientSubnetCidr(), other.clientSubnetCidr())
                && Objects.equals(backupSubnetCidr(), other.backupSubnetCidr())
                && Objects.equals(customDomainName(), other.customDomainName())
                && Objects.equals(defaultDnsPrefix(), other.defaultDnsPrefix())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(s3AccessAsString(), other.s3AccessAsString())
                && Objects.equals(zeroEtlAccessAsString(), other.zeroEtlAccessAsString())
                && Objects.equals(stsAccessAsString(), other.stsAccessAsString())
                && Objects.equals(kmsAccessAsString(), other.kmsAccessAsString())
                && Objects.equals(s3PolicyDocument(), other.s3PolicyDocument())
                && Objects.equals(stsPolicyDocument(), other.stsPolicyDocument())
                && Objects.equals(kmsPolicyDocument(), other.kmsPolicyDocument())
                && hasCrossRegionS3RestoreSourcesToEnable() == other.hasCrossRegionS3RestoreSourcesToEnable()
                && Objects.equals(crossRegionS3RestoreSourcesToEnable(), other.crossRegionS3RestoreSourcesToEnable())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateOdbNetworkRequest")
                .add("DisplayName", displayName())
                .add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId())
                .add("ClientSubnetCidr", clientSubnetCidr())
                .add("BackupSubnetCidr", backupSubnetCidr())
                .add("CustomDomainName", customDomainName())
                .add("DefaultDnsPrefix", defaultDnsPrefix())
                .add("ClientToken", clientToken())
                .add("S3Access", s3AccessAsString())
                .add("ZeroEtlAccess", zeroEtlAccessAsString())
                .add("StsAccess", stsAccessAsString())
                .add("KmsAccess", kmsAccessAsString())
                .add("S3PolicyDocument", s3PolicyDocument())
                .add("StsPolicyDocument", stsPolicyDocument())
                .add("KmsPolicyDocument", kmsPolicyDocument())
                .add("CrossRegionS3RestoreSourcesToEnable",
                        hasCrossRegionS3RestoreSourcesToEnable() ? crossRegionS3RestoreSourcesToEnable() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "clientSubnetCidr":
            return Optional.ofNullable(clazz.cast(clientSubnetCidr()));
        case "backupSubnetCidr":
            return Optional.ofNullable(clazz.cast(backupSubnetCidr()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "defaultDnsPrefix":
            return Optional.ofNullable(clazz.cast(defaultDnsPrefix()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "s3Access":
            return Optional.ofNullable(clazz.cast(s3AccessAsString()));
        case "zeroEtlAccess":
            return Optional.ofNullable(clazz.cast(zeroEtlAccessAsString()));
        case "stsAccess":
            return Optional.ofNullable(clazz.cast(stsAccessAsString()));
        case "kmsAccess":
            return Optional.ofNullable(clazz.cast(kmsAccessAsString()));
        case "s3PolicyDocument":
            return Optional.ofNullable(clazz.cast(s3PolicyDocument()));
        case "stsPolicyDocument":
            return Optional.ofNullable(clazz.cast(stsPolicyDocument()));
        case "kmsPolicyDocument":
            return Optional.ofNullable(clazz.cast(kmsPolicyDocument()));
        case "crossRegionS3RestoreSourcesToEnable":
            return Optional.ofNullable(clazz.cast(crossRegionS3RestoreSourcesToEnable()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("clientSubnetCidr", CLIENT_SUBNET_CIDR_FIELD);
        map.put("backupSubnetCidr", BACKUP_SUBNET_CIDR_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("defaultDnsPrefix", DEFAULT_DNS_PREFIX_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("s3Access", S3_ACCESS_FIELD);
        map.put("zeroEtlAccess", ZERO_ETL_ACCESS_FIELD);
        map.put("stsAccess", STS_ACCESS_FIELD);
        map.put("kmsAccess", KMS_ACCESS_FIELD);
        map.put("s3PolicyDocument", S3_POLICY_DOCUMENT_FIELD);
        map.put("stsPolicyDocument", STS_POLICY_DOCUMENT_FIELD);
        map.put("kmsPolicyDocument", KMS_POLICY_DOCUMENT_FIELD);
        map.put("crossRegionS3RestoreSourcesToEnable", CROSS_REGION_S3_RESTORE_SOURCES_TO_ENABLE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOdbNetworkRequest, T> g) {
        return obj -> g.apply((CreateOdbNetworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateOdbNetworkRequest> {
        /**
         * <p>
         * A user-friendly name for the ODB network.
         * </p>
         * 
         * @param displayName
         *        A user-friendly name for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The Amazon Web Services Availability Zone (AZ) where the ODB network is located.
         * </p>
         * <p>
         * This operation requires that you specify a value for either <code>availabilityZone</code> or
         * <code>availabilityZoneId</code>.
         * </p>
         * 
         * @param availabilityZone
         *        The Amazon Web Services Availability Zone (AZ) where the ODB network is located.</p>
         *        <p>
         *        This operation requires that you specify a value for either <code>availabilityZone</code> or
         *        <code>availabilityZoneId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The AZ ID of the AZ where the ODB network is located.
         * </p>
         * <p>
         * This operation requires that you specify a value for either <code>availabilityZone</code> or
         * <code>availabilityZoneId</code>.
         * </p>
         * 
         * @param availabilityZoneId
         *        The AZ ID of the AZ where the ODB network is located.</p>
         *        <p>
         *        This operation requires that you specify a value for either <code>availabilityZone</code> or
         *        <code>availabilityZoneId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The CIDR range of the client subnet for the ODB network.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must not overlap with the CIDR range of the backup subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not overlap with the CIDR ranges of the VPCs that are connected to the ODB network.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not use the following CIDR ranges that are reserved by OCI:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>100.106.0.0/16</code> and <code>100.107.0.0/16</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.0.0/16</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>224.0.0.0 - 239.255.255.255</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>240.0.0.0 - 255.255.255.255</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param clientSubnetCidr
         *        The CIDR range of the client subnet for the ODB network.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must not overlap with the CIDR range of the backup subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not overlap with the CIDR ranges of the VPCs that are connected to the ODB network.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not use the following CIDR ranges that are reserved by OCI:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>100.106.0.0/16</code> and <code>100.107.0.0/16</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.0.0/16</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>224.0.0.0 - 239.255.255.255</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>240.0.0.0 - 255.255.255.255</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientSubnetCidr(String clientSubnetCidr);

        /**
         * <p>
         * The CIDR range of the backup subnet for the ODB network.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must not overlap with the CIDR range of the client subnet.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not overlap with the CIDR ranges of the VPCs that are connected to the ODB network.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must not use the following CIDR ranges that are reserved by OCI:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>100.106.0.0/16</code> and <code>100.107.0.0/16</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>169.254.0.0/16</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>224.0.0.0 - 239.255.255.255</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>240.0.0.0 - 255.255.255.255</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param backupSubnetCidr
         *        The CIDR range of the backup subnet for the ODB network.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must not overlap with the CIDR range of the client subnet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not overlap with the CIDR ranges of the VPCs that are connected to the ODB network.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must not use the following CIDR ranges that are reserved by OCI:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>100.106.0.0/16</code> and <code>100.107.0.0/16</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>169.254.0.0/16</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>224.0.0.0 - 239.255.255.255</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>240.0.0.0 - 255.255.255.255</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupSubnetCidr(String backupSubnetCidr);

        /**
         * <p>
         * The domain name to use for the resources in the ODB network.
         * </p>
         * 
         * @param customDomainName
         *        The domain name to use for the resources in the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The DNS prefix to the default DNS domain name. The default DNS domain name is oraclevcn.com.
         * </p>
         * 
         * @param defaultDnsPrefix
         *        The DNS prefix to the default DNS domain name. The default DNS domain name is oraclevcn.com.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultDnsPrefix(String defaultDnsPrefix);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you don't
         * specify a client token, the Amazon Web Services SDK automatically generates a client token and uses it for
         * the request to ensure idempotency. The client token is valid for up to 24 hours after it's first used.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        don't specify a client token, the Amazon Web Services SDK automatically generates a client token and
         *        uses it for the request to ensure idempotency. The client token is valid for up to 24 hours after it's
         *        first used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the configuration for Amazon S3 access from the ODB network.
         * </p>
         * 
         * @param s3Access
         *        Specifies the configuration for Amazon S3 access from the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder s3Access(String s3Access);

        /**
         * <p>
         * Specifies the configuration for Amazon S3 access from the ODB network.
         * </p>
         * 
         * @param s3Access
         *        Specifies the configuration for Amazon S3 access from the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder s3Access(Access s3Access);

        /**
         * <p>
         * Specifies the configuration for Zero-ETL access from the ODB network.
         * </p>
         * 
         * @param zeroEtlAccess
         *        Specifies the configuration for Zero-ETL access from the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder zeroEtlAccess(String zeroEtlAccess);

        /**
         * <p>
         * Specifies the configuration for Zero-ETL access from the ODB network.
         * </p>
         * 
         * @param zeroEtlAccess
         *        Specifies the configuration for Zero-ETL access from the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder zeroEtlAccess(Access zeroEtlAccess);

        /**
         * <p>
         * The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
         * </p>
         * 
         * @param stsAccess
         *        The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder stsAccess(String stsAccess);

        /**
         * <p>
         * The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
         * </p>
         * 
         * @param stsAccess
         *        The Amazon Web Services Security Token Service (STS) access configuration for the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder stsAccess(Access stsAccess);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
         * </p>
         * 
         * @param kmsAccess
         *        The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder kmsAccess(String kmsAccess);

        /**
         * <p>
         * The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
         * </p>
         * 
         * @param kmsAccess
         *        The Amazon Web Services Key Management Service (KMS) access configuration for the ODB network.
         * @see Access
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Access
         */
        Builder kmsAccess(Access kmsAccess);

        /**
         * <p>
         * Specifies the endpoint policy for Amazon S3 access from the ODB network.
         * </p>
         * 
         * @param s3PolicyDocument
         *        Specifies the endpoint policy for Amazon S3 access from the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3PolicyDocument(String s3PolicyDocument);

        /**
         * <p>
         * The STS policy document that defines permissions for token service usage within the ODB network.
         * </p>
         * 
         * @param stsPolicyDocument
         *        The STS policy document that defines permissions for token service usage within the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stsPolicyDocument(String stsPolicyDocument);

        /**
         * <p>
         * The KMS policy document that defines permissions for key usage within the ODB network.
         * </p>
         * 
         * @param kmsPolicyDocument
         *        The KMS policy document that defines permissions for key usage within the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsPolicyDocument(String kmsPolicyDocument);

        /**
         * <p>
         * The cross-Region Amazon S3 restore sources to enable for the ODB network.
         * </p>
         * 
         * @param crossRegionS3RestoreSourcesToEnable
         *        The cross-Region Amazon S3 restore sources to enable for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable);

        /**
         * <p>
         * The cross-Region Amazon S3 restore sources to enable for the ODB network.
         * </p>
         * 
         * @param crossRegionS3RestoreSourcesToEnable
         *        The cross-Region Amazon S3 restore sources to enable for the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossRegionS3RestoreSourcesToEnable(String... crossRegionS3RestoreSourcesToEnable);

        /**
         * <p>
         * The list of resource tags to apply to the ODB network.
         * </p>
         * 
         * @param tags
         *        The list of resource tags to apply to the ODB network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private String displayName;

        private String availabilityZone;

        private String availabilityZoneId;

        private String clientSubnetCidr;

        private String backupSubnetCidr;

        private String customDomainName;

        private String defaultDnsPrefix;

        private String clientToken;

        private String s3Access;

        private String zeroEtlAccess;

        private String stsAccess;

        private String kmsAccess;

        private String s3PolicyDocument;

        private String stsPolicyDocument;

        private String kmsPolicyDocument;

        private List<String> crossRegionS3RestoreSourcesToEnable = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOdbNetworkRequest model) {
            super(model);
            displayName(model.displayName);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            clientSubnetCidr(model.clientSubnetCidr);
            backupSubnetCidr(model.backupSubnetCidr);
            customDomainName(model.customDomainName);
            defaultDnsPrefix(model.defaultDnsPrefix);
            clientToken(model.clientToken);
            s3Access(model.s3Access);
            zeroEtlAccess(model.zeroEtlAccess);
            stsAccess(model.stsAccess);
            kmsAccess(model.kmsAccess);
            s3PolicyDocument(model.s3PolicyDocument);
            stsPolicyDocument(model.stsPolicyDocument);
            kmsPolicyDocument(model.kmsPolicyDocument);
            crossRegionS3RestoreSourcesToEnable(model.crossRegionS3RestoreSourcesToEnable);
            tags(model.tags);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getClientSubnetCidr() {
            return clientSubnetCidr;
        }

        public final void setClientSubnetCidr(String clientSubnetCidr) {
            this.clientSubnetCidr = clientSubnetCidr;
        }

        @Override
        public final Builder clientSubnetCidr(String clientSubnetCidr) {
            this.clientSubnetCidr = clientSubnetCidr;
            return this;
        }

        public final String getBackupSubnetCidr() {
            return backupSubnetCidr;
        }

        public final void setBackupSubnetCidr(String backupSubnetCidr) {
            this.backupSubnetCidr = backupSubnetCidr;
        }

        @Override
        public final Builder backupSubnetCidr(String backupSubnetCidr) {
            this.backupSubnetCidr = backupSubnetCidr;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getDefaultDnsPrefix() {
            return defaultDnsPrefix;
        }

        public final void setDefaultDnsPrefix(String defaultDnsPrefix) {
            this.defaultDnsPrefix = defaultDnsPrefix;
        }

        @Override
        public final Builder defaultDnsPrefix(String defaultDnsPrefix) {
            this.defaultDnsPrefix = defaultDnsPrefix;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getS3Access() {
            return s3Access;
        }

        public final void setS3Access(String s3Access) {
            this.s3Access = s3Access;
        }

        @Override
        public final Builder s3Access(String s3Access) {
            this.s3Access = s3Access;
            return this;
        }

        @Override
        public final Builder s3Access(Access s3Access) {
            this.s3Access(s3Access == null ? null : s3Access.toString());
            return this;
        }

        public final String getZeroEtlAccess() {
            return zeroEtlAccess;
        }

        public final void setZeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
        }

        @Override
        public final Builder zeroEtlAccess(String zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
            return this;
        }

        @Override
        public final Builder zeroEtlAccess(Access zeroEtlAccess) {
            this.zeroEtlAccess(zeroEtlAccess == null ? null : zeroEtlAccess.toString());
            return this;
        }

        public final String getStsAccess() {
            return stsAccess;
        }

        public final void setStsAccess(String stsAccess) {
            this.stsAccess = stsAccess;
        }

        @Override
        public final Builder stsAccess(String stsAccess) {
            this.stsAccess = stsAccess;
            return this;
        }

        @Override
        public final Builder stsAccess(Access stsAccess) {
            this.stsAccess(stsAccess == null ? null : stsAccess.toString());
            return this;
        }

        public final String getKmsAccess() {
            return kmsAccess;
        }

        public final void setKmsAccess(String kmsAccess) {
            this.kmsAccess = kmsAccess;
        }

        @Override
        public final Builder kmsAccess(String kmsAccess) {
            this.kmsAccess = kmsAccess;
            return this;
        }

        @Override
        public final Builder kmsAccess(Access kmsAccess) {
            this.kmsAccess(kmsAccess == null ? null : kmsAccess.toString());
            return this;
        }

        public final String getS3PolicyDocument() {
            return s3PolicyDocument;
        }

        public final void setS3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
        }

        @Override
        public final Builder s3PolicyDocument(String s3PolicyDocument) {
            this.s3PolicyDocument = s3PolicyDocument;
            return this;
        }

        public final String getStsPolicyDocument() {
            return stsPolicyDocument;
        }

        public final void setStsPolicyDocument(String stsPolicyDocument) {
            this.stsPolicyDocument = stsPolicyDocument;
        }

        @Override
        public final Builder stsPolicyDocument(String stsPolicyDocument) {
            this.stsPolicyDocument = stsPolicyDocument;
            return this;
        }

        public final String getKmsPolicyDocument() {
            return kmsPolicyDocument;
        }

        public final void setKmsPolicyDocument(String kmsPolicyDocument) {
            this.kmsPolicyDocument = kmsPolicyDocument;
        }

        @Override
        public final Builder kmsPolicyDocument(String kmsPolicyDocument) {
            this.kmsPolicyDocument = kmsPolicyDocument;
            return this;
        }

        public final Collection<String> getCrossRegionS3RestoreSourcesToEnable() {
            if (crossRegionS3RestoreSourcesToEnable instanceof SdkAutoConstructList) {
                return null;
            }
            return crossRegionS3RestoreSourcesToEnable;
        }

        public final void setCrossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable = StringListCopier.copy(crossRegionS3RestoreSourcesToEnable);
        }

        @Override
        public final Builder crossRegionS3RestoreSourcesToEnable(Collection<String> crossRegionS3RestoreSourcesToEnable) {
            this.crossRegionS3RestoreSourcesToEnable = StringListCopier.copy(crossRegionS3RestoreSourcesToEnable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crossRegionS3RestoreSourcesToEnable(String... crossRegionS3RestoreSourcesToEnable) {
            crossRegionS3RestoreSourcesToEnable(Arrays.asList(crossRegionS3RestoreSourcesToEnable));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOdbNetworkRequest build() {
            return new CreateOdbNetworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
