/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a VM cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudVmClusterSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudVmClusterSummary.Builder, CloudVmClusterSummary> {
    private static final SdkField<String> CLOUD_VM_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudVmClusterId").getter(getter(CloudVmClusterSummary::cloudVmClusterId))
            .setter(setter(Builder::cloudVmClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudVmClusterId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CloudVmClusterSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CloudVmClusterSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(CloudVmClusterSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> CLOUD_VM_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cloudVmClusterArn").getter(getter(CloudVmClusterSummary::cloudVmClusterArn))
            .setter(setter(Builder::cloudVmClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudVmClusterArn").build()).build();

    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudExadataInfrastructureId")
            .getter(getter(CloudVmClusterSummary::cloudExadataInfrastructureId))
            .setter(setter(Builder::cloudExadataInfrastructureId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId")
                    .build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(CloudVmClusterSummary::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()).build();

    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cpuCoreCount").getter(getter(CloudVmClusterSummary::cpuCoreCount)).setter(setter(Builder::cpuCoreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()).build();

    private static final SdkField<DataCollectionOptions> DATA_COLLECTION_OPTIONS_FIELD = SdkField
            .<DataCollectionOptions> builder(MarshallingType.SDK_POJO).memberName("dataCollectionOptions")
            .getter(getter(CloudVmClusterSummary::dataCollectionOptions)).setter(setter(Builder::dataCollectionOptions))
            .constructor(DataCollectionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollectionOptions").build())
            .build();

    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("dataStorageSizeInTBs").getter(getter(CloudVmClusterSummary::dataStorageSizeInTBs))
            .setter(setter(Builder::dataStorageSizeInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInTBs").build())
            .build();

    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs")
            .getter(getter(CloudVmClusterSummary::dbNodeStorageSizeInGBs)).setter(setter(Builder::dbNodeStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build())
            .build();

    private static final SdkField<List<String>> DB_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dbServers")
            .getter(getter(CloudVmClusterSummary::dbServers))
            .setter(setter(Builder::dbServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DISK_REDUNDANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("diskRedundancy").getter(getter(CloudVmClusterSummary::diskRedundancyAsString))
            .setter(setter(Builder::diskRedundancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diskRedundancy").build()).build();

    private static final SdkField<String> GI_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("giVersion").getter(getter(CloudVmClusterSummary::giVersion)).setter(setter(Builder::giVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("giVersion").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(CloudVmClusterSummary::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<ExadataIormConfig> IORM_CONFIG_CACHE_FIELD = SdkField
            .<ExadataIormConfig> builder(MarshallingType.SDK_POJO).memberName("iormConfigCache")
            .getter(getter(CloudVmClusterSummary::iormConfigCache)).setter(setter(Builder::iormConfigCache))
            .constructor(ExadataIormConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iormConfigCache").build()).build();

    private static final SdkField<Boolean> IS_LOCAL_BACKUP_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isLocalBackupEnabled").getter(getter(CloudVmClusterSummary::isLocalBackupEnabled))
            .setter(setter(Builder::isLocalBackupEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLocalBackupEnabled").build())
            .build();

    private static final SdkField<Boolean> IS_SPARSE_DISKGROUP_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("isSparseDiskgroupEnabled")
            .getter(getter(CloudVmClusterSummary::isSparseDiskgroupEnabled)).setter(setter(Builder::isSparseDiskgroupEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSparseDiskgroupEnabled").build())
            .build();

    private static final SdkField<String> LAST_UPDATE_HISTORY_ENTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdateHistoryEntryId").getter(getter(CloudVmClusterSummary::lastUpdateHistoryEntryId))
            .setter(setter(Builder::lastUpdateHistoryEntryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateHistoryEntryId").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseModel").getter(getter(CloudVmClusterSummary::licenseModelAsString))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()).build();

    private static final SdkField<Integer> LISTENER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("listenerPort").getter(getter(CloudVmClusterSummary::listenerPort)).setter(setter(Builder::listenerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memorySizeInGBs").getter(getter(CloudVmClusterSummary::memorySizeInGBs))
            .setter(setter(Builder::memorySizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()).build();

    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nodeCount").getter(getter(CloudVmClusterSummary::nodeCount)).setter(setter(Builder::nodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeCount").build()).build();

    private static final SdkField<String> OCID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ocid")
            .getter(getter(CloudVmClusterSummary::ocid)).setter(setter(Builder::ocid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()).build();

    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociResourceAnchorName").getter(getter(CloudVmClusterSummary::ociResourceAnchorName))
            .setter(setter(Builder::ociResourceAnchorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build())
            .build();

    private static final SdkField<String> OCI_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ociUrl")
            .getter(getter(CloudVmClusterSummary::ociUrl)).setter(setter(Builder::ociUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociUrl").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(CloudVmClusterSummary::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<String> SCAN_DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanDnsName").getter(getter(CloudVmClusterSummary::scanDnsName)).setter(setter(Builder::scanDnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanDnsName").build()).build();

    private static final SdkField<String> SCAN_DNS_RECORD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanDnsRecordId").getter(getter(CloudVmClusterSummary::scanDnsRecordId))
            .setter(setter(Builder::scanDnsRecordId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanDnsRecordId").build()).build();

    private static final SdkField<List<String>> SCAN_IP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("scanIpIds")
            .getter(getter(CloudVmClusterSummary::scanIpIds))
            .setter(setter(Builder::scanIpIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanIpIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SHAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("shape")
            .getter(getter(CloudVmClusterSummary::shape)).setter(setter(Builder::shape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()).build();

    private static final SdkField<List<String>> SSH_PUBLIC_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sshPublicKeys")
            .getter(getter(CloudVmClusterSummary::sshPublicKeys))
            .setter(setter(Builder::sshPublicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> STORAGE_SIZE_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageSizeInGBs").getter(getter(CloudVmClusterSummary::storageSizeInGBs))
            .setter(setter(Builder::storageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageSizeInGBs").build()).build();

    private static final SdkField<String> SYSTEM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemVersion").getter(getter(CloudVmClusterSummary::systemVersion))
            .setter(setter(Builder::systemVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemVersion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CloudVmClusterSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeZone").getter(getter(CloudVmClusterSummary::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()).build();

    private static final SdkField<List<String>> VIP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("vipIds")
            .getter(getter(CloudVmClusterSummary::vipIds))
            .setter(setter(Builder::vipIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vipIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("odbNetworkId").getter(getter(CloudVmClusterSummary::odbNetworkId)).setter(setter(Builder::odbNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()).build();

    private static final SdkField<Float> PERCENT_PROGRESS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("percentProgress").getter(getter(CloudVmClusterSummary::percentProgress))
            .setter(setter(Builder::percentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentProgress").build()).build();

    private static final SdkField<String> COMPUTE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeModel").getter(getter(CloudVmClusterSummary::computeModelAsString))
            .setter(setter(Builder::computeModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeModel").build()).build();

    private static final SdkField<List<IamRole>> IAM_ROLES_FIELD = SdkField
            .<List<IamRole>> builder(MarshallingType.LIST)
            .memberName("iamRoles")
            .getter(getter(CloudVmClusterSummary::iamRoles))
            .setter(setter(Builder::iamRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IamRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(IamRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_VM_CLUSTER_ID_FIELD,
            DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CLOUD_VM_CLUSTER_ARN_FIELD,
            CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, CLUSTER_NAME_FIELD, CPU_CORE_COUNT_FIELD, DATA_COLLECTION_OPTIONS_FIELD,
            DATA_STORAGE_SIZE_IN_T_BS_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVERS_FIELD, DISK_REDUNDANCY_FIELD,
            GI_VERSION_FIELD, HOSTNAME_FIELD, IORM_CONFIG_CACHE_FIELD, IS_LOCAL_BACKUP_ENABLED_FIELD,
            IS_SPARSE_DISKGROUP_ENABLED_FIELD, LAST_UPDATE_HISTORY_ENTRY_ID_FIELD, LICENSE_MODEL_FIELD, LISTENER_PORT_FIELD,
            MEMORY_SIZE_IN_G_BS_FIELD, NODE_COUNT_FIELD, OCID_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD, OCI_URL_FIELD, DOMAIN_FIELD,
            SCAN_DNS_NAME_FIELD, SCAN_DNS_RECORD_ID_FIELD, SCAN_IP_IDS_FIELD, SHAPE_FIELD, SSH_PUBLIC_KEYS_FIELD,
            STORAGE_SIZE_IN_G_BS_FIELD, SYSTEM_VERSION_FIELD, CREATED_AT_FIELD, TIME_ZONE_FIELD, VIP_IDS_FIELD,
            ODB_NETWORK_ID_FIELD, PERCENT_PROGRESS_FIELD, COMPUTE_MODEL_FIELD, IAM_ROLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cloudVmClusterId;

    private final String displayName;

    private final String status;

    private final String statusReason;

    private final String cloudVmClusterArn;

    private final String cloudExadataInfrastructureId;

    private final String clusterName;

    private final Integer cpuCoreCount;

    private final DataCollectionOptions dataCollectionOptions;

    private final Double dataStorageSizeInTBs;

    private final Integer dbNodeStorageSizeInGBs;

    private final List<String> dbServers;

    private final String diskRedundancy;

    private final String giVersion;

    private final String hostname;

    private final ExadataIormConfig iormConfigCache;

    private final Boolean isLocalBackupEnabled;

    private final Boolean isSparseDiskgroupEnabled;

    private final String lastUpdateHistoryEntryId;

    private final String licenseModel;

    private final Integer listenerPort;

    private final Integer memorySizeInGBs;

    private final Integer nodeCount;

    private final String ocid;

    private final String ociResourceAnchorName;

    private final String ociUrl;

    private final String domain;

    private final String scanDnsName;

    private final String scanDnsRecordId;

    private final List<String> scanIpIds;

    private final String shape;

    private final List<String> sshPublicKeys;

    private final Integer storageSizeInGBs;

    private final String systemVersion;

    private final Instant createdAt;

    private final String timeZone;

    private final List<String> vipIds;

    private final String odbNetworkId;

    private final Float percentProgress;

    private final String computeModel;

    private final List<IamRole> iamRoles;

    private CloudVmClusterSummary(BuilderImpl builder) {
        this.cloudVmClusterId = builder.cloudVmClusterId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.cloudVmClusterArn = builder.cloudVmClusterArn;
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.clusterName = builder.clusterName;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.dataCollectionOptions = builder.dataCollectionOptions;
        this.dataStorageSizeInTBs = builder.dataStorageSizeInTBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServers = builder.dbServers;
        this.diskRedundancy = builder.diskRedundancy;
        this.giVersion = builder.giVersion;
        this.hostname = builder.hostname;
        this.iormConfigCache = builder.iormConfigCache;
        this.isLocalBackupEnabled = builder.isLocalBackupEnabled;
        this.isSparseDiskgroupEnabled = builder.isSparseDiskgroupEnabled;
        this.lastUpdateHistoryEntryId = builder.lastUpdateHistoryEntryId;
        this.licenseModel = builder.licenseModel;
        this.listenerPort = builder.listenerPort;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.nodeCount = builder.nodeCount;
        this.ocid = builder.ocid;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.ociUrl = builder.ociUrl;
        this.domain = builder.domain;
        this.scanDnsName = builder.scanDnsName;
        this.scanDnsRecordId = builder.scanDnsRecordId;
        this.scanIpIds = builder.scanIpIds;
        this.shape = builder.shape;
        this.sshPublicKeys = builder.sshPublicKeys;
        this.storageSizeInGBs = builder.storageSizeInGBs;
        this.systemVersion = builder.systemVersion;
        this.createdAt = builder.createdAt;
        this.timeZone = builder.timeZone;
        this.vipIds = builder.vipIds;
        this.odbNetworkId = builder.odbNetworkId;
        this.percentProgress = builder.percentProgress;
        this.computeModel = builder.computeModel;
        this.iamRoles = builder.iamRoles;
    }

    /**
     * <p>
     * The unique identifier of the VM cluster.
     * </p>
     * 
     * @return The unique identifier of the VM cluster.
     */
    public final String cloudVmClusterId() {
        return cloudVmClusterId;
    }

    /**
     * <p>
     * The user-friendly name for the VM cluster.
     * </p>
     * 
     * @return The user-friendly name for the VM cluster.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The current status of the VM cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the VM cluster.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the VM cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the VM cluster.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the status of the VM cluster.
     * </p>
     * 
     * @return Additional information about the status of the VM cluster.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the VM cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the VM cluster.
     */
    public final String cloudVmClusterArn() {
        return cloudVmClusterArn;
    }

    /**
     * <p>
     * The unique identifier of the Exadata infrastructure that this VM cluster belongs to.
     * </p>
     * 
     * @return The unique identifier of the Exadata infrastructure that this VM cluster belongs to.
     */
    public final String cloudExadataInfrastructureId() {
        return cloudExadataInfrastructureId;
    }

    /**
     * <p>
     * The name of the Grid Infrastructure (GI) cluster.
     * </p>
     * 
     * @return The name of the Grid Infrastructure (GI) cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The number of CPU cores enabled on the VM cluster.
     * </p>
     * 
     * @return The number of CPU cores enabled on the VM cluster.
     */
    public final Integer cpuCoreCount() {
        return cpuCoreCount;
    }

    /**
     * Returns the value of the DataCollectionOptions property for this object.
     * 
     * @return The value of the DataCollectionOptions property for this object.
     */
    public final DataCollectionOptions dataCollectionOptions() {
        return dataCollectionOptions;
    }

    /**
     * <p>
     * The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
     * </p>
     * 
     * @return The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
     */
    public final Double dataStorageSizeInTBs() {
        return dataStorageSizeInTBs;
    }

    /**
     * <p>
     * The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
     * </p>
     * 
     * @return The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
     */
    public final Integer dbNodeStorageSizeInGBs() {
        return dbNodeStorageSizeInGBs;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbServers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDbServers() {
        return dbServers != null && !(dbServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of database servers for the VM cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbServers} method.
     * </p>
     * 
     * @return The list of database servers for the VM cluster.
     */
    public final List<String> dbServers() {
        return dbServers;
    }

    /**
     * <p>
     * The type of redundancy configured for the VM cluster. <code>NORMAL</code> is 2-way redundancy. <code>HIGH</code>
     * is 3-way redundancy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskRedundancy}
     * will return {@link DiskRedundancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskRedundancyAsString}.
     * </p>
     * 
     * @return The type of redundancy configured for the VM cluster. <code>NORMAL</code> is 2-way redundancy.
     *         <code>HIGH</code> is 3-way redundancy.
     * @see DiskRedundancy
     */
    public final DiskRedundancy diskRedundancy() {
        return DiskRedundancy.fromValue(diskRedundancy);
    }

    /**
     * <p>
     * The type of redundancy configured for the VM cluster. <code>NORMAL</code> is 2-way redundancy. <code>HIGH</code>
     * is 3-way redundancy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskRedundancy}
     * will return {@link DiskRedundancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskRedundancyAsString}.
     * </p>
     * 
     * @return The type of redundancy configured for the VM cluster. <code>NORMAL</code> is 2-way redundancy.
     *         <code>HIGH</code> is 3-way redundancy.
     * @see DiskRedundancy
     */
    public final String diskRedundancyAsString() {
        return diskRedundancy;
    }

    /**
     * <p>
     * The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
     * </p>
     * 
     * @return The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
     */
    public final String giVersion() {
        return giVersion;
    }

    /**
     * <p>
     * The host name for the VM cluster.
     * </p>
     * 
     * @return The host name for the VM cluster.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * Returns the value of the IormConfigCache property for this object.
     * 
     * @return The value of the IormConfigCache property for this object.
     */
    public final ExadataIormConfig iormConfigCache() {
        return iormConfigCache;
    }

    /**
     * <p>
     * Indicates whether database backups to local Exadata storage is enabled for the VM cluster.
     * </p>
     * 
     * @return Indicates whether database backups to local Exadata storage is enabled for the VM cluster.
     */
    public final Boolean isLocalBackupEnabled() {
        return isLocalBackupEnabled;
    }

    /**
     * <p>
     * Indicates whether the VM cluster is configured with a sparse disk group.
     * </p>
     * 
     * @return Indicates whether the VM cluster is configured with a sparse disk group.
     */
    public final Boolean isSparseDiskgroupEnabled() {
        return isSparseDiskgroupEnabled;
    }

    /**
     * <p>
     * The Oracle Cloud ID (OCID) of the last maintenance update history entry.
     * </p>
     * 
     * @return The Oracle Cloud ID (OCID) of the last maintenance update history entry.
     */
    public final String lastUpdateHistoryEntryId() {
        return lastUpdateHistoryEntryId;
    }

    /**
     * <p>
     * The Oracle license model applied to the VM cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The Oracle license model applied to the VM cluster.
     * @see LicenseModel
     */
    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(licenseModel);
    }

    /**
     * <p>
     * The Oracle license model applied to the VM cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The Oracle license model applied to the VM cluster.
     * @see LicenseModel
     */
    public final String licenseModelAsString() {
        return licenseModel;
    }

    /**
     * <p>
     * The port number configured for the listener on the VM cluster.
     * </p>
     * 
     * @return The port number configured for the listener on the VM cluster.
     */
    public final Integer listenerPort() {
        return listenerPort;
    }

    /**
     * <p>
     * The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
     * </p>
     * 
     * @return The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
     */
    public final Integer memorySizeInGBs() {
        return memorySizeInGBs;
    }

    /**
     * <p>
     * The number of nodes in the VM cluster.
     * </p>
     * 
     * @return The number of nodes in the VM cluster.
     */
    public final Integer nodeCount() {
        return nodeCount;
    }

    /**
     * <p>
     * The OCID of the VM cluster.
     * </p>
     * 
     * @return The OCID of the VM cluster.
     */
    public final String ocid() {
        return ocid;
    }

    /**
     * <p>
     * The name of the OCI resource anchor for the VM cluster.
     * </p>
     * 
     * @return The name of the OCI resource anchor for the VM cluster.
     */
    public final String ociResourceAnchorName() {
        return ociResourceAnchorName;
    }

    /**
     * <p>
     * The HTTPS link to the VM cluster in OCI.
     * </p>
     * 
     * @return The HTTPS link to the VM cluster in OCI.
     */
    public final String ociUrl() {
        return ociUrl;
    }

    /**
     * <p>
     * The domain of the VM cluster.
     * </p>
     * 
     * @return The domain of the VM cluster.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The FQDN of the DNS record for the Single Client Access Name (SCAN) IP addresses that are associated with the VM
     * cluster.
     * </p>
     * 
     * @return The FQDN of the DNS record for the Single Client Access Name (SCAN) IP addresses that are associated with
     *         the VM cluster.
     */
    public final String scanDnsName() {
        return scanDnsName;
    }

    /**
     * <p>
     * The OCID of the DNS record for the SCAN IP addresses that are associated with the VM cluster.
     * </p>
     * 
     * @return The OCID of the DNS record for the SCAN IP addresses that are associated with the VM cluster.
     */
    public final String scanDnsRecordId() {
        return scanDnsRecordId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScanIpIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScanIpIds() {
        return scanIpIds != null && !(scanIpIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OCID of the SCAN IP addresses that are associated with the VM cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScanIpIds} method.
     * </p>
     * 
     * @return The OCID of the SCAN IP addresses that are associated with the VM cluster.
     */
    public final List<String> scanIpIds() {
        return scanIpIds;
    }

    /**
     * <p>
     * The hardware model name of the Exadata infrastructure that's running the VM cluster.
     * </p>
     * 
     * @return The hardware model name of the Exadata infrastructure that's running the VM cluster.
     */
    public final String shape() {
        return shape;
    }

    /**
     * For responses, this returns true if the service returned a value for the SshPublicKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSshPublicKeys() {
        return sshPublicKeys != null && !(sshPublicKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The public key portion of one or more key pairs used for SSH access to the VM cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSshPublicKeys} method.
     * </p>
     * 
     * @return The public key portion of one or more key pairs used for SSH access to the VM cluster.
     */
    public final List<String> sshPublicKeys() {
        return sshPublicKeys;
    }

    /**
     * <p>
     * The amount of local node storage, in gigabytes (GB), that's allocated to the VM cluster.
     * </p>
     * 
     * @return The amount of local node storage, in gigabytes (GB), that's allocated to the VM cluster.
     */
    public final Integer storageSizeInGBs() {
        return storageSizeInGBs;
    }

    /**
     * <p>
     * The operating system version of the image chosen for the VM cluster.
     * </p>
     * 
     * @return The operating system version of the image chosen for the VM cluster.
     */
    public final String systemVersion() {
        return systemVersion;
    }

    /**
     * <p>
     * The date and time when the VM cluster was created.
     * </p>
     * 
     * @return The date and time when the VM cluster was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time zone of the VM cluster.
     * </p>
     * 
     * @return The time zone of the VM cluster.
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the VipIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVipIds() {
        return vipIds != null && !(vipIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The virtual IP (VIP) addresses that are associated with the VM cluster. Oracle's Cluster Ready Services (CRS)
     * creates and maintains one VIP address for each node in the VM cluster to enable failover. If one node fails, the
     * VIP is reassigned to another active node in the cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVipIds} method.
     * </p>
     * 
     * @return The virtual IP (VIP) addresses that are associated with the VM cluster. Oracle's Cluster Ready Services
     *         (CRS) creates and maintains one VIP address for each node in the VM cluster to enable failover. If one
     *         node fails, the VIP is reassigned to another active node in the cluster.
     */
    public final List<String> vipIds() {
        return vipIds;
    }

    /**
     * <p>
     * The unique identifier of the ODB network for the VM cluster.
     * </p>
     * 
     * @return The unique identifier of the ODB network for the VM cluster.
     */
    public final String odbNetworkId() {
        return odbNetworkId;
    }

    /**
     * <p>
     * The amount of progress made on the current operation on the VM cluster, expressed as a percentage.
     * </p>
     * 
     * @return The amount of progress made on the current operation on the VM cluster, expressed as a percentage.
     */
    public final Float percentProgress() {
        return percentProgress;
    }

    /**
     * <p>
     * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
     * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute
     * and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical
     * core of a processor with hyper-threading enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeModel} will
     * return {@link ComputeModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModelAsString}.
     * </p>
     * 
     * @return The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
     *         abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
     *         from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
     *         OCPUs are based on the physical core of a processor with hyper-threading enabled.
     * @see ComputeModel
     */
    public final ComputeModel computeModel() {
        return ComputeModel.fromValue(computeModel);
    }

    /**
     * <p>
     * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
     * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute
     * and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical
     * core of a processor with hyper-threading enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeModel} will
     * return {@link ComputeModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModelAsString}.
     * </p>
     * 
     * @return The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
     *         abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
     *         from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
     *         OCPUs are based on the physical core of a processor with hyper-threading enabled.
     * @see ComputeModel
     */
    public final String computeModelAsString() {
        return computeModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the IamRoles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIamRoles() {
        return iamRoles != null && !(iamRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Identity and Access Management (IAM) service roles associated with the VM cluster in the
     * summary information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIamRoles} method.
     * </p>
     * 
     * @return The Amazon Web Services Identity and Access Management (IAM) service roles associated with the VM cluster
     *         in the summary information.
     */
    public final List<IamRole> iamRoles() {
        return iamRoles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudVmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(cloudVmClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(dataCollectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbServers() ? dbServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(diskRedundancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(giVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(iormConfigCache());
        hashCode = 31 * hashCode + Objects.hashCode(isLocalBackupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(isSparseDiskgroupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateHistoryEntryId());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(listenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(ocid());
        hashCode = 31 * hashCode + Objects.hashCode(ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(ociUrl());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(scanDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(scanDnsRecordId());
        hashCode = 31 * hashCode + Objects.hashCode(hasScanIpIds() ? scanIpIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(shape());
        hashCode = 31 * hashCode + Objects.hashCode(hasSshPublicKeys() ? sshPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(systemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasVipIds() ? vipIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(computeModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIamRoles() ? iamRoles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudVmClusterSummary)) {
            return false;
        }
        CloudVmClusterSummary other = (CloudVmClusterSummary) obj;
        return Objects.equals(cloudVmClusterId(), other.cloudVmClusterId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(cloudVmClusterArn(), other.cloudVmClusterArn())
                && Objects.equals(cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId())
                && Objects.equals(clusterName(), other.clusterName()) && Objects.equals(cpuCoreCount(), other.cpuCoreCount())
                && Objects.equals(dataCollectionOptions(), other.dataCollectionOptions())
                && Objects.equals(dataStorageSizeInTBs(), other.dataStorageSizeInTBs())
                && Objects.equals(dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs())
                && hasDbServers() == other.hasDbServers() && Objects.equals(dbServers(), other.dbServers())
                && Objects.equals(diskRedundancyAsString(), other.diskRedundancyAsString())
                && Objects.equals(giVersion(), other.giVersion()) && Objects.equals(hostname(), other.hostname())
                && Objects.equals(iormConfigCache(), other.iormConfigCache())
                && Objects.equals(isLocalBackupEnabled(), other.isLocalBackupEnabled())
                && Objects.equals(isSparseDiskgroupEnabled(), other.isSparseDiskgroupEnabled())
                && Objects.equals(lastUpdateHistoryEntryId(), other.lastUpdateHistoryEntryId())
                && Objects.equals(licenseModelAsString(), other.licenseModelAsString())
                && Objects.equals(listenerPort(), other.listenerPort())
                && Objects.equals(memorySizeInGBs(), other.memorySizeInGBs()) && Objects.equals(nodeCount(), other.nodeCount())
                && Objects.equals(ocid(), other.ocid()) && Objects.equals(ociResourceAnchorName(), other.ociResourceAnchorName())
                && Objects.equals(ociUrl(), other.ociUrl()) && Objects.equals(domain(), other.domain())
                && Objects.equals(scanDnsName(), other.scanDnsName())
                && Objects.equals(scanDnsRecordId(), other.scanDnsRecordId()) && hasScanIpIds() == other.hasScanIpIds()
                && Objects.equals(scanIpIds(), other.scanIpIds()) && Objects.equals(shape(), other.shape())
                && hasSshPublicKeys() == other.hasSshPublicKeys() && Objects.equals(sshPublicKeys(), other.sshPublicKeys())
                && Objects.equals(storageSizeInGBs(), other.storageSizeInGBs())
                && Objects.equals(systemVersion(), other.systemVersion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(timeZone(), other.timeZone()) && hasVipIds() == other.hasVipIds()
                && Objects.equals(vipIds(), other.vipIds()) && Objects.equals(odbNetworkId(), other.odbNetworkId())
                && Objects.equals(percentProgress(), other.percentProgress())
                && Objects.equals(computeModelAsString(), other.computeModelAsString()) && hasIamRoles() == other.hasIamRoles()
                && Objects.equals(iamRoles(), other.iamRoles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudVmClusterSummary").add("CloudVmClusterId", cloudVmClusterId())
                .add("DisplayName", displayName()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("CloudVmClusterArn", cloudVmClusterArn())
                .add("CloudExadataInfrastructureId", cloudExadataInfrastructureId()).add("ClusterName", clusterName())
                .add("CpuCoreCount", cpuCoreCount()).add("DataCollectionOptions", dataCollectionOptions())
                .add("DataStorageSizeInTBs", dataStorageSizeInTBs()).add("DbNodeStorageSizeInGBs", dbNodeStorageSizeInGBs())
                .add("DbServers", hasDbServers() ? dbServers() : null).add("DiskRedundancy", diskRedundancyAsString())
                .add("GiVersion", giVersion()).add("Hostname", hostname()).add("IormConfigCache", iormConfigCache())
                .add("IsLocalBackupEnabled", isLocalBackupEnabled()).add("IsSparseDiskgroupEnabled", isSparseDiskgroupEnabled())
                .add("LastUpdateHistoryEntryId", lastUpdateHistoryEntryId()).add("LicenseModel", licenseModelAsString())
                .add("ListenerPort", listenerPort()).add("MemorySizeInGBs", memorySizeInGBs()).add("NodeCount", nodeCount())
                .add("Ocid", ocid()).add("OciResourceAnchorName", ociResourceAnchorName()).add("OciUrl", ociUrl())
                .add("Domain", domain()).add("ScanDnsName", scanDnsName()).add("ScanDnsRecordId", scanDnsRecordId())
                .add("ScanIpIds", hasScanIpIds() ? scanIpIds() : null).add("Shape", shape())
                .add("SshPublicKeys", sshPublicKeys() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StorageSizeInGBs", storageSizeInGBs()).add("SystemVersion", systemVersion()).add("CreatedAt", createdAt())
                .add("TimeZone", timeZone()).add("VipIds", hasVipIds() ? vipIds() : null).add("OdbNetworkId", odbNetworkId())
                .add("PercentProgress", percentProgress()).add("ComputeModel", computeModelAsString())
                .add("IamRoles", hasIamRoles() ? iamRoles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudVmClusterId":
            return Optional.ofNullable(clazz.cast(cloudVmClusterId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "cloudVmClusterArn":
            return Optional.ofNullable(clazz.cast(cloudVmClusterArn()));
        case "cloudExadataInfrastructureId":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructureId()));
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "cpuCoreCount":
            return Optional.ofNullable(clazz.cast(cpuCoreCount()));
        case "dataCollectionOptions":
            return Optional.ofNullable(clazz.cast(dataCollectionOptions()));
        case "dataStorageSizeInTBs":
            return Optional.ofNullable(clazz.cast(dataStorageSizeInTBs()));
        case "dbNodeStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(dbNodeStorageSizeInGBs()));
        case "dbServers":
            return Optional.ofNullable(clazz.cast(dbServers()));
        case "diskRedundancy":
            return Optional.ofNullable(clazz.cast(diskRedundancyAsString()));
        case "giVersion":
            return Optional.ofNullable(clazz.cast(giVersion()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "iormConfigCache":
            return Optional.ofNullable(clazz.cast(iormConfigCache()));
        case "isLocalBackupEnabled":
            return Optional.ofNullable(clazz.cast(isLocalBackupEnabled()));
        case "isSparseDiskgroupEnabled":
            return Optional.ofNullable(clazz.cast(isSparseDiskgroupEnabled()));
        case "lastUpdateHistoryEntryId":
            return Optional.ofNullable(clazz.cast(lastUpdateHistoryEntryId()));
        case "licenseModel":
            return Optional.ofNullable(clazz.cast(licenseModelAsString()));
        case "listenerPort":
            return Optional.ofNullable(clazz.cast(listenerPort()));
        case "memorySizeInGBs":
            return Optional.ofNullable(clazz.cast(memorySizeInGBs()));
        case "nodeCount":
            return Optional.ofNullable(clazz.cast(nodeCount()));
        case "ocid":
            return Optional.ofNullable(clazz.cast(ocid()));
        case "ociResourceAnchorName":
            return Optional.ofNullable(clazz.cast(ociResourceAnchorName()));
        case "ociUrl":
            return Optional.ofNullable(clazz.cast(ociUrl()));
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "scanDnsName":
            return Optional.ofNullable(clazz.cast(scanDnsName()));
        case "scanDnsRecordId":
            return Optional.ofNullable(clazz.cast(scanDnsRecordId()));
        case "scanIpIds":
            return Optional.ofNullable(clazz.cast(scanIpIds()));
        case "shape":
            return Optional.ofNullable(clazz.cast(shape()));
        case "sshPublicKeys":
            return Optional.ofNullable(clazz.cast(sshPublicKeys()));
        case "storageSizeInGBs":
            return Optional.ofNullable(clazz.cast(storageSizeInGBs()));
        case "systemVersion":
            return Optional.ofNullable(clazz.cast(systemVersion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "timeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "vipIds":
            return Optional.ofNullable(clazz.cast(vipIds()));
        case "odbNetworkId":
            return Optional.ofNullable(clazz.cast(odbNetworkId()));
        case "percentProgress":
            return Optional.ofNullable(clazz.cast(percentProgress()));
        case "computeModel":
            return Optional.ofNullable(clazz.cast(computeModelAsString()));
        case "iamRoles":
            return Optional.ofNullable(clazz.cast(iamRoles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudVmClusterId", CLOUD_VM_CLUSTER_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("cloudVmClusterArn", CLOUD_VM_CLUSTER_ARN_FIELD);
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("dataCollectionOptions", DATA_COLLECTION_OPTIONS_FIELD);
        map.put("dataStorageSizeInTBs", DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        map.put("diskRedundancy", DISK_REDUNDANCY_FIELD);
        map.put("giVersion", GI_VERSION_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("iormConfigCache", IORM_CONFIG_CACHE_FIELD);
        map.put("isLocalBackupEnabled", IS_LOCAL_BACKUP_ENABLED_FIELD);
        map.put("isSparseDiskgroupEnabled", IS_SPARSE_DISKGROUP_ENABLED_FIELD);
        map.put("lastUpdateHistoryEntryId", LAST_UPDATE_HISTORY_ENTRY_ID_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("listenerPort", LISTENER_PORT_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("nodeCount", NODE_COUNT_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("ociUrl", OCI_URL_FIELD);
        map.put("domain", DOMAIN_FIELD);
        map.put("scanDnsName", SCAN_DNS_NAME_FIELD);
        map.put("scanDnsRecordId", SCAN_DNS_RECORD_ID_FIELD);
        map.put("scanIpIds", SCAN_IP_IDS_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("sshPublicKeys", SSH_PUBLIC_KEYS_FIELD);
        map.put("storageSizeInGBs", STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("systemVersion", SYSTEM_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("timeZone", TIME_ZONE_FIELD);
        map.put("vipIds", VIP_IDS_FIELD);
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("percentProgress", PERCENT_PROGRESS_FIELD);
        map.put("computeModel", COMPUTE_MODEL_FIELD);
        map.put("iamRoles", IAM_ROLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudVmClusterSummary, T> g) {
        return obj -> g.apply((CloudVmClusterSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudVmClusterSummary> {
        /**
         * <p>
         * The unique identifier of the VM cluster.
         * </p>
         * 
         * @param cloudVmClusterId
         *        The unique identifier of the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudVmClusterId(String cloudVmClusterId);

        /**
         * <p>
         * The user-friendly name for the VM cluster.
         * </p>
         * 
         * @param displayName
         *        The user-friendly name for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The current status of the VM cluster.
         * </p>
         * 
         * @param status
         *        The current status of the VM cluster.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the VM cluster.
         * </p>
         * 
         * @param status
         *        The current status of the VM cluster.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Additional information about the status of the VM cluster.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the status of the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the VM cluster.
         * </p>
         * 
         * @param cloudVmClusterArn
         *        The Amazon Resource Name (ARN) of the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudVmClusterArn(String cloudVmClusterArn);

        /**
         * <p>
         * The unique identifier of the Exadata infrastructure that this VM cluster belongs to.
         * </p>
         * 
         * @param cloudExadataInfrastructureId
         *        The unique identifier of the Exadata infrastructure that this VM cluster belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId);

        /**
         * <p>
         * The name of the Grid Infrastructure (GI) cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the Grid Infrastructure (GI) cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The number of CPU cores enabled on the VM cluster.
         * </p>
         * 
         * @param cpuCoreCount
         *        The number of CPU cores enabled on the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCoreCount(Integer cpuCoreCount);

        /**
         * Sets the value of the DataCollectionOptions property for this object.
         *
         * @param dataCollectionOptions
         *        The new value for the DataCollectionOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions);

        /**
         * Sets the value of the DataCollectionOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataCollectionOptions.Builder} avoiding
         * the need to create one manually via {@link DataCollectionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataCollectionOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #dataCollectionOptions(DataCollectionOptions)}.
         * 
         * @param dataCollectionOptions
         *        a consumer that will call methods on {@link DataCollectionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCollectionOptions(DataCollectionOptions)
         */
        default Builder dataCollectionOptions(Consumer<DataCollectionOptions.Builder> dataCollectionOptions) {
            return dataCollectionOptions(DataCollectionOptions.builder().applyMutation(dataCollectionOptions).build());
        }

        /**
         * <p>
         * The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
         * </p>
         * 
         * @param dataStorageSizeInTBs
         *        The size of the data disk group, in terabytes (TB), that's allocated for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs);

        /**
         * <p>
         * The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
         * </p>
         * 
         * @param dbNodeStorageSizeInGBs
         *        The amount of local node storage, in gigabytes (GB), that's allocated for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs);

        /**
         * <p>
         * The list of database servers for the VM cluster.
         * </p>
         * 
         * @param dbServers
         *        The list of database servers for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServers(Collection<String> dbServers);

        /**
         * <p>
         * The list of database servers for the VM cluster.
         * </p>
         * 
         * @param dbServers
         *        The list of database servers for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServers(String... dbServers);

        /**
         * <p>
         * The type of redundancy configured for the VM cluster. <code>NORMAL</code> is 2-way redundancy.
         * <code>HIGH</code> is 3-way redundancy.
         * </p>
         * 
         * @param diskRedundancy
         *        The type of redundancy configured for the VM cluster. <code>NORMAL</code> is 2-way redundancy.
         *        <code>HIGH</code> is 3-way redundancy.
         * @see DiskRedundancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskRedundancy
         */
        Builder diskRedundancy(String diskRedundancy);

        /**
         * <p>
         * The type of redundancy configured for the VM cluster. <code>NORMAL</code> is 2-way redundancy.
         * <code>HIGH</code> is 3-way redundancy.
         * </p>
         * 
         * @param diskRedundancy
         *        The type of redundancy configured for the VM cluster. <code>NORMAL</code> is 2-way redundancy.
         *        <code>HIGH</code> is 3-way redundancy.
         * @see DiskRedundancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskRedundancy
         */
        Builder diskRedundancy(DiskRedundancy diskRedundancy);

        /**
         * <p>
         * The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
         * </p>
         * 
         * @param giVersion
         *        The software version of the Oracle Grid Infrastructure (GI) for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder giVersion(String giVersion);

        /**
         * <p>
         * The host name for the VM cluster.
         * </p>
         * 
         * @param hostname
         *        The host name for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * Sets the value of the IormConfigCache property for this object.
         *
         * @param iormConfigCache
         *        The new value for the IormConfigCache property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iormConfigCache(ExadataIormConfig iormConfigCache);

        /**
         * Sets the value of the IormConfigCache property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExadataIormConfig.Builder} avoiding the
         * need to create one manually via {@link ExadataIormConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExadataIormConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #iormConfigCache(ExadataIormConfig)}.
         * 
         * @param iormConfigCache
         *        a consumer that will call methods on {@link ExadataIormConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iormConfigCache(ExadataIormConfig)
         */
        default Builder iormConfigCache(Consumer<ExadataIormConfig.Builder> iormConfigCache) {
            return iormConfigCache(ExadataIormConfig.builder().applyMutation(iormConfigCache).build());
        }

        /**
         * <p>
         * Indicates whether database backups to local Exadata storage is enabled for the VM cluster.
         * </p>
         * 
         * @param isLocalBackupEnabled
         *        Indicates whether database backups to local Exadata storage is enabled for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isLocalBackupEnabled(Boolean isLocalBackupEnabled);

        /**
         * <p>
         * Indicates whether the VM cluster is configured with a sparse disk group.
         * </p>
         * 
         * @param isSparseDiskgroupEnabled
         *        Indicates whether the VM cluster is configured with a sparse disk group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled);

        /**
         * <p>
         * The Oracle Cloud ID (OCID) of the last maintenance update history entry.
         * </p>
         * 
         * @param lastUpdateHistoryEntryId
         *        The Oracle Cloud ID (OCID) of the last maintenance update history entry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateHistoryEntryId(String lastUpdateHistoryEntryId);

        /**
         * <p>
         * The Oracle license model applied to the VM cluster.
         * </p>
         * 
         * @param licenseModel
         *        The Oracle license model applied to the VM cluster.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The Oracle license model applied to the VM cluster.
         * </p>
         * 
         * @param licenseModel
         *        The Oracle license model applied to the VM cluster.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(LicenseModel licenseModel);

        /**
         * <p>
         * The port number configured for the listener on the VM cluster.
         * </p>
         * 
         * @param listenerPort
         *        The port number configured for the listener on the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPort(Integer listenerPort);

        /**
         * <p>
         * The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
         * </p>
         * 
         * @param memorySizeInGBs
         *        The amount of memory, in gigabytes (GB), that's allocated for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeInGBs(Integer memorySizeInGBs);

        /**
         * <p>
         * The number of nodes in the VM cluster.
         * </p>
         * 
         * @param nodeCount
         *        The number of nodes in the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeCount(Integer nodeCount);

        /**
         * <p>
         * The OCID of the VM cluster.
         * </p>
         * 
         * @param ocid
         *        The OCID of the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocid(String ocid);

        /**
         * <p>
         * The name of the OCI resource anchor for the VM cluster.
         * </p>
         * 
         * @param ociResourceAnchorName
         *        The name of the OCI resource anchor for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociResourceAnchorName(String ociResourceAnchorName);

        /**
         * <p>
         * The HTTPS link to the VM cluster in OCI.
         * </p>
         * 
         * @param ociUrl
         *        The HTTPS link to the VM cluster in OCI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociUrl(String ociUrl);

        /**
         * <p>
         * The domain of the VM cluster.
         * </p>
         * 
         * @param domain
         *        The domain of the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The FQDN of the DNS record for the Single Client Access Name (SCAN) IP addresses that are associated with the
         * VM cluster.
         * </p>
         * 
         * @param scanDnsName
         *        The FQDN of the DNS record for the Single Client Access Name (SCAN) IP addresses that are associated
         *        with the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanDnsName(String scanDnsName);

        /**
         * <p>
         * The OCID of the DNS record for the SCAN IP addresses that are associated with the VM cluster.
         * </p>
         * 
         * @param scanDnsRecordId
         *        The OCID of the DNS record for the SCAN IP addresses that are associated with the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanDnsRecordId(String scanDnsRecordId);

        /**
         * <p>
         * The OCID of the SCAN IP addresses that are associated with the VM cluster.
         * </p>
         * 
         * @param scanIpIds
         *        The OCID of the SCAN IP addresses that are associated with the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanIpIds(Collection<String> scanIpIds);

        /**
         * <p>
         * The OCID of the SCAN IP addresses that are associated with the VM cluster.
         * </p>
         * 
         * @param scanIpIds
         *        The OCID of the SCAN IP addresses that are associated with the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanIpIds(String... scanIpIds);

        /**
         * <p>
         * The hardware model name of the Exadata infrastructure that's running the VM cluster.
         * </p>
         * 
         * @param shape
         *        The hardware model name of the Exadata infrastructure that's running the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shape(String shape);

        /**
         * <p>
         * The public key portion of one or more key pairs used for SSH access to the VM cluster.
         * </p>
         * 
         * @param sshPublicKeys
         *        The public key portion of one or more key pairs used for SSH access to the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeys(Collection<String> sshPublicKeys);

        /**
         * <p>
         * The public key portion of one or more key pairs used for SSH access to the VM cluster.
         * </p>
         * 
         * @param sshPublicKeys
         *        The public key portion of one or more key pairs used for SSH access to the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeys(String... sshPublicKeys);

        /**
         * <p>
         * The amount of local node storage, in gigabytes (GB), that's allocated to the VM cluster.
         * </p>
         * 
         * @param storageSizeInGBs
         *        The amount of local node storage, in gigabytes (GB), that's allocated to the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSizeInGBs(Integer storageSizeInGBs);

        /**
         * <p>
         * The operating system version of the image chosen for the VM cluster.
         * </p>
         * 
         * @param systemVersion
         *        The operating system version of the image chosen for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemVersion(String systemVersion);

        /**
         * <p>
         * The date and time when the VM cluster was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the VM cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time zone of the VM cluster.
         * </p>
         * 
         * @param timeZone
         *        The time zone of the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * The virtual IP (VIP) addresses that are associated with the VM cluster. Oracle's Cluster Ready Services (CRS)
         * creates and maintains one VIP address for each node in the VM cluster to enable failover. If one node fails,
         * the VIP is reassigned to another active node in the cluster.
         * </p>
         * 
         * @param vipIds
         *        The virtual IP (VIP) addresses that are associated with the VM cluster. Oracle's Cluster Ready
         *        Services (CRS) creates and maintains one VIP address for each node in the VM cluster to enable
         *        failover. If one node fails, the VIP is reassigned to another active node in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vipIds(Collection<String> vipIds);

        /**
         * <p>
         * The virtual IP (VIP) addresses that are associated with the VM cluster. Oracle's Cluster Ready Services (CRS)
         * creates and maintains one VIP address for each node in the VM cluster to enable failover. If one node fails,
         * the VIP is reassigned to another active node in the cluster.
         * </p>
         * 
         * @param vipIds
         *        The virtual IP (VIP) addresses that are associated with the VM cluster. Oracle's Cluster Ready
         *        Services (CRS) creates and maintains one VIP address for each node in the VM cluster to enable
         *        failover. If one node fails, the VIP is reassigned to another active node in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vipIds(String... vipIds);

        /**
         * <p>
         * The unique identifier of the ODB network for the VM cluster.
         * </p>
         * 
         * @param odbNetworkId
         *        The unique identifier of the ODB network for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworkId(String odbNetworkId);

        /**
         * <p>
         * The amount of progress made on the current operation on the VM cluster, expressed as a percentage.
         * </p>
         * 
         * @param percentProgress
         *        The amount of progress made on the current operation on the VM cluster, expressed as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentProgress(Float percentProgress);

        /**
         * <p>
         * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
         * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of
         * compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on
         * the physical core of a processor with hyper-threading enabled.
         * </p>
         * 
         * @param computeModel
         *        The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
         *        abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
         *        from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
         *        OCPUs are based on the physical core of a processor with hyper-threading enabled.
         * @see ComputeModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeModel
         */
        Builder computeModel(String computeModel);

        /**
         * <p>
         * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
         * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of
         * compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on
         * the physical core of a processor with hyper-threading enabled.
         * </p>
         * 
         * @param computeModel
         *        The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
         *        abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
         *        from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
         *        OCPUs are based on the physical core of a processor with hyper-threading enabled.
         * @see ComputeModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeModel
         */
        Builder computeModel(ComputeModel computeModel);

        /**
         * <p>
         * The Amazon Web Services Identity and Access Management (IAM) service roles associated with the VM cluster in
         * the summary information.
         * </p>
         * 
         * @param iamRoles
         *        The Amazon Web Services Identity and Access Management (IAM) service roles associated with the VM
         *        cluster in the summary information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(Collection<IamRole> iamRoles);

        /**
         * <p>
         * The Amazon Web Services Identity and Access Management (IAM) service roles associated with the VM cluster in
         * the summary information.
         * </p>
         * 
         * @param iamRoles
         *        The Amazon Web Services Identity and Access Management (IAM) service roles associated with the VM
         *        cluster in the summary information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(IamRole... iamRoles);

        /**
         * <p>
         * The Amazon Web Services Identity and Access Management (IAM) service roles associated with the VM cluster in
         * the summary information.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.IamRole.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.odb.model.IamRole#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.IamRole.Builder#build()} is called immediately and its
         * result is passed to {@link #iamRoles(List<IamRole>)}.
         * 
         * @param iamRoles
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.odb.model.IamRole.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamRoles(java.util.Collection<IamRole>)
         */
        Builder iamRoles(Consumer<IamRole.Builder>... iamRoles);
    }

    static final class BuilderImpl implements Builder {
        private String cloudVmClusterId;

        private String displayName;

        private String status;

        private String statusReason;

        private String cloudVmClusterArn;

        private String cloudExadataInfrastructureId;

        private String clusterName;

        private Integer cpuCoreCount;

        private DataCollectionOptions dataCollectionOptions;

        private Double dataStorageSizeInTBs;

        private Integer dbNodeStorageSizeInGBs;

        private List<String> dbServers = DefaultSdkAutoConstructList.getInstance();

        private String diskRedundancy;

        private String giVersion;

        private String hostname;

        private ExadataIormConfig iormConfigCache;

        private Boolean isLocalBackupEnabled;

        private Boolean isSparseDiskgroupEnabled;

        private String lastUpdateHistoryEntryId;

        private String licenseModel;

        private Integer listenerPort;

        private Integer memorySizeInGBs;

        private Integer nodeCount;

        private String ocid;

        private String ociResourceAnchorName;

        private String ociUrl;

        private String domain;

        private String scanDnsName;

        private String scanDnsRecordId;

        private List<String> scanIpIds = DefaultSdkAutoConstructList.getInstance();

        private String shape;

        private List<String> sshPublicKeys = DefaultSdkAutoConstructList.getInstance();

        private Integer storageSizeInGBs;

        private String systemVersion;

        private Instant createdAt;

        private String timeZone;

        private List<String> vipIds = DefaultSdkAutoConstructList.getInstance();

        private String odbNetworkId;

        private Float percentProgress;

        private String computeModel;

        private List<IamRole> iamRoles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudVmClusterSummary model) {
            cloudVmClusterId(model.cloudVmClusterId);
            displayName(model.displayName);
            status(model.status);
            statusReason(model.statusReason);
            cloudVmClusterArn(model.cloudVmClusterArn);
            cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            clusterName(model.clusterName);
            cpuCoreCount(model.cpuCoreCount);
            dataCollectionOptions(model.dataCollectionOptions);
            dataStorageSizeInTBs(model.dataStorageSizeInTBs);
            dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            dbServers(model.dbServers);
            diskRedundancy(model.diskRedundancy);
            giVersion(model.giVersion);
            hostname(model.hostname);
            iormConfigCache(model.iormConfigCache);
            isLocalBackupEnabled(model.isLocalBackupEnabled);
            isSparseDiskgroupEnabled(model.isSparseDiskgroupEnabled);
            lastUpdateHistoryEntryId(model.lastUpdateHistoryEntryId);
            licenseModel(model.licenseModel);
            listenerPort(model.listenerPort);
            memorySizeInGBs(model.memorySizeInGBs);
            nodeCount(model.nodeCount);
            ocid(model.ocid);
            ociResourceAnchorName(model.ociResourceAnchorName);
            ociUrl(model.ociUrl);
            domain(model.domain);
            scanDnsName(model.scanDnsName);
            scanDnsRecordId(model.scanDnsRecordId);
            scanIpIds(model.scanIpIds);
            shape(model.shape);
            sshPublicKeys(model.sshPublicKeys);
            storageSizeInGBs(model.storageSizeInGBs);
            systemVersion(model.systemVersion);
            createdAt(model.createdAt);
            timeZone(model.timeZone);
            vipIds(model.vipIds);
            odbNetworkId(model.odbNetworkId);
            percentProgress(model.percentProgress);
            computeModel(model.computeModel);
            iamRoles(model.iamRoles);
        }

        public final String getCloudVmClusterId() {
            return cloudVmClusterId;
        }

        public final void setCloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
        }

        @Override
        public final Builder cloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getCloudVmClusterArn() {
            return cloudVmClusterArn;
        }

        public final void setCloudVmClusterArn(String cloudVmClusterArn) {
            this.cloudVmClusterArn = cloudVmClusterArn;
        }

        @Override
        public final Builder cloudVmClusterArn(String cloudVmClusterArn) {
            this.cloudVmClusterArn = cloudVmClusterArn;
            return this;
        }

        public final String getCloudExadataInfrastructureId() {
            return cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Integer getCpuCoreCount() {
            return cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final DataCollectionOptions.Builder getDataCollectionOptions() {
            return dataCollectionOptions != null ? dataCollectionOptions.toBuilder() : null;
        }

        public final void setDataCollectionOptions(DataCollectionOptions.BuilderImpl dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions != null ? dataCollectionOptions.build() : null;
        }

        @Override
        public final Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            return this;
        }

        public final Double getDataStorageSizeInTBs() {
            return dataStorageSizeInTBs;
        }

        public final void setDataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        }

        @Override
        public final Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final Collection<String> getDbServers() {
            if (dbServers instanceof SdkAutoConstructList) {
                return null;
            }
            return dbServers;
        }

        public final void setDbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(String... dbServers) {
            dbServers(Arrays.asList(dbServers));
            return this;
        }

        public final String getDiskRedundancy() {
            return diskRedundancy;
        }

        public final void setDiskRedundancy(String diskRedundancy) {
            this.diskRedundancy = diskRedundancy;
        }

        @Override
        public final Builder diskRedundancy(String diskRedundancy) {
            this.diskRedundancy = diskRedundancy;
            return this;
        }

        @Override
        public final Builder diskRedundancy(DiskRedundancy diskRedundancy) {
            this.diskRedundancy(diskRedundancy == null ? null : diskRedundancy.toString());
            return this;
        }

        public final String getGiVersion() {
            return giVersion;
        }

        public final void setGiVersion(String giVersion) {
            this.giVersion = giVersion;
        }

        @Override
        public final Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final ExadataIormConfig.Builder getIormConfigCache() {
            return iormConfigCache != null ? iormConfigCache.toBuilder() : null;
        }

        public final void setIormConfigCache(ExadataIormConfig.BuilderImpl iormConfigCache) {
            this.iormConfigCache = iormConfigCache != null ? iormConfigCache.build() : null;
        }

        @Override
        public final Builder iormConfigCache(ExadataIormConfig iormConfigCache) {
            this.iormConfigCache = iormConfigCache;
            return this;
        }

        public final Boolean getIsLocalBackupEnabled() {
            return isLocalBackupEnabled;
        }

        public final void setIsLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
        }

        @Override
        public final Builder isLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
            return this;
        }

        public final Boolean getIsSparseDiskgroupEnabled() {
            return isSparseDiskgroupEnabled;
        }

        public final void setIsSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
        }

        @Override
        public final Builder isSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
            return this;
        }

        public final String getLastUpdateHistoryEntryId() {
            return lastUpdateHistoryEntryId;
        }

        public final void setLastUpdateHistoryEntryId(String lastUpdateHistoryEntryId) {
            this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
        }

        @Override
        public final Builder lastUpdateHistoryEntryId(String lastUpdateHistoryEntryId) {
            this.lastUpdateHistoryEntryId = lastUpdateHistoryEntryId;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final Integer getListenerPort() {
            return listenerPort;
        }

        public final void setListenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(Integer listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final Integer getNodeCount() {
            return nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final String getOcid() {
            return ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final String getOciUrl() {
            return ociUrl;
        }

        public final void setOciUrl(String ociUrl) {
            this.ociUrl = ociUrl;
        }

        @Override
        public final Builder ociUrl(String ociUrl) {
            this.ociUrl = ociUrl;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getScanDnsName() {
            return scanDnsName;
        }

        public final void setScanDnsName(String scanDnsName) {
            this.scanDnsName = scanDnsName;
        }

        @Override
        public final Builder scanDnsName(String scanDnsName) {
            this.scanDnsName = scanDnsName;
            return this;
        }

        public final String getScanDnsRecordId() {
            return scanDnsRecordId;
        }

        public final void setScanDnsRecordId(String scanDnsRecordId) {
            this.scanDnsRecordId = scanDnsRecordId;
        }

        @Override
        public final Builder scanDnsRecordId(String scanDnsRecordId) {
            this.scanDnsRecordId = scanDnsRecordId;
            return this;
        }

        public final Collection<String> getScanIpIds() {
            if (scanIpIds instanceof SdkAutoConstructList) {
                return null;
            }
            return scanIpIds;
        }

        public final void setScanIpIds(Collection<String> scanIpIds) {
            this.scanIpIds = StringListCopier.copy(scanIpIds);
        }

        @Override
        public final Builder scanIpIds(Collection<String> scanIpIds) {
            this.scanIpIds = StringListCopier.copy(scanIpIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanIpIds(String... scanIpIds) {
            scanIpIds(Arrays.asList(scanIpIds));
            return this;
        }

        public final String getShape() {
            return shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final Collection<String> getSshPublicKeys() {
            if (sshPublicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return sshPublicKeys;
        }

        public final void setSshPublicKeys(Collection<String> sshPublicKeys) {
            this.sshPublicKeys = SensitiveStringListCopier.copy(sshPublicKeys);
        }

        @Override
        public final Builder sshPublicKeys(Collection<String> sshPublicKeys) {
            this.sshPublicKeys = SensitiveStringListCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(String... sshPublicKeys) {
            sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        public final Integer getStorageSizeInGBs() {
            return storageSizeInGBs;
        }

        public final void setStorageSizeInGBs(Integer storageSizeInGBs) {
            this.storageSizeInGBs = storageSizeInGBs;
        }

        @Override
        public final Builder storageSizeInGBs(Integer storageSizeInGBs) {
            this.storageSizeInGBs = storageSizeInGBs;
            return this;
        }

        public final String getSystemVersion() {
            return systemVersion;
        }

        public final void setSystemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
        }

        @Override
        public final Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final Collection<String> getVipIds() {
            if (vipIds instanceof SdkAutoConstructList) {
                return null;
            }
            return vipIds;
        }

        public final void setVipIds(Collection<String> vipIds) {
            this.vipIds = StringListCopier.copy(vipIds);
        }

        @Override
        public final Builder vipIds(Collection<String> vipIds) {
            this.vipIds = StringListCopier.copy(vipIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vipIds(String... vipIds) {
            vipIds(Arrays.asList(vipIds));
            return this;
        }

        public final String getOdbNetworkId() {
            return odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final Float getPercentProgress() {
            return percentProgress;
        }

        public final void setPercentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final String getComputeModel() {
            return computeModel;
        }

        public final void setComputeModel(String computeModel) {
            this.computeModel = computeModel;
        }

        @Override
        public final Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            return this;
        }

        @Override
        public final Builder computeModel(ComputeModel computeModel) {
            this.computeModel(computeModel == null ? null : computeModel.toString());
            return this;
        }

        public final List<IamRole.Builder> getIamRoles() {
            List<IamRole.Builder> result = IamRoleListCopier.copyToBuilder(this.iamRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIamRoles(Collection<IamRole.BuilderImpl> iamRoles) {
            this.iamRoles = IamRoleListCopier.copyFromBuilder(iamRoles);
        }

        @Override
        public final Builder iamRoles(Collection<IamRole> iamRoles) {
            this.iamRoles = IamRoleListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(IamRole... iamRoles) {
            iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(Consumer<IamRole.Builder>... iamRoles) {
            iamRoles(Stream.of(iamRoles).map(c -> IamRole.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CloudVmClusterSummary build() {
            return new CloudVmClusterSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
