/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Autonomous VM cluster resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudAutonomousVmCluster implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudAutonomousVmCluster.Builder, CloudAutonomousVmCluster> {
    private static final SdkField<String> CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudAutonomousVmClusterId")
            .getter(getter(CloudAutonomousVmCluster::cloudAutonomousVmClusterId))
            .setter(setter(Builder::cloudAutonomousVmClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusterId").build())
            .build();

    private static final SdkField<String> CLOUD_AUTONOMOUS_VM_CLUSTER_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudAutonomousVmClusterArn")
            .getter(getter(CloudAutonomousVmCluster::cloudAutonomousVmClusterArn))
            .setter(setter(Builder::cloudAutonomousVmClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusterArn")
                    .build()).build();

    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("odbNetworkId").getter(getter(CloudAutonomousVmCluster::odbNetworkId))
            .setter(setter(Builder::odbNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()).build();

    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociResourceAnchorName").getter(getter(CloudAutonomousVmCluster::ociResourceAnchorName))
            .setter(setter(Builder::ociResourceAnchorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build())
            .build();

    private static final SdkField<Float> PERCENT_PROGRESS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("percentProgress").getter(getter(CloudAutonomousVmCluster::percentProgress))
            .setter(setter(Builder::percentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentProgress").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CloudAutonomousVmCluster::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CloudAutonomousVmCluster::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(CloudAutonomousVmCluster::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudExadataInfrastructureId")
            .getter(getter(CloudAutonomousVmCluster::cloudExadataInfrastructureId))
            .setter(setter(Builder::cloudExadataInfrastructureId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId")
                    .build()).build();

    private static final SdkField<Float> AUTONOMOUS_DATA_STORAGE_PERCENTAGE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("autonomousDataStoragePercentage")
            .getter(getter(CloudAutonomousVmCluster::autonomousDataStoragePercentage))
            .setter(setter(Builder::autonomousDataStoragePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousDataStoragePercentage")
                    .build()).build();

    private static final SdkField<Double> AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("autonomousDataStorageSizeInTBs")
            .getter(getter(CloudAutonomousVmCluster::autonomousDataStorageSizeInTBs))
            .setter(setter(Builder::autonomousDataStorageSizeInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousDataStorageSizeInTBs")
                    .build()).build();

    private static final SdkField<Double> AVAILABLE_AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("availableAutonomousDataStorageSizeInTBs")
            .getter(getter(CloudAutonomousVmCluster::availableAutonomousDataStorageSizeInTBs))
            .setter(setter(Builder::availableAutonomousDataStorageSizeInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("availableAutonomousDataStorageSizeInTBs").build()).build();

    private static final SdkField<Integer> AVAILABLE_CONTAINER_DATABASES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("availableContainerDatabases")
            .getter(getter(CloudAutonomousVmCluster::availableContainerDatabases))
            .setter(setter(Builder::availableContainerDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableContainerDatabases")
                    .build()).build();

    private static final SdkField<Float> AVAILABLE_CPUS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("availableCpus").getter(getter(CloudAutonomousVmCluster::availableCpus))
            .setter(setter(Builder::availableCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableCpus").build()).build();

    private static final SdkField<String> COMPUTE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeModel").getter(getter(CloudAutonomousVmCluster::computeModelAsString))
            .setter(setter(Builder::computeModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeModel").build()).build();

    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cpuCoreCount").getter(getter(CloudAutonomousVmCluster::cpuCoreCount))
            .setter(setter(Builder::cpuCoreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()).build();

    private static final SdkField<Integer> CPU_CORE_COUNT_PER_NODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cpuCoreCountPerNode").getter(getter(CloudAutonomousVmCluster::cpuCoreCountPerNode))
            .setter(setter(Builder::cpuCoreCountPerNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCountPerNode").build())
            .build();

    private static final SdkField<Float> CPU_PERCENTAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("cpuPercentage").getter(getter(CloudAutonomousVmCluster::cpuPercentage))
            .setter(setter(Builder::cpuPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuPercentage").build()).build();

    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("dataStorageSizeInGBs").getter(getter(CloudAutonomousVmCluster::dataStorageSizeInGBs))
            .setter(setter(Builder::dataStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInGBs").build())
            .build();

    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("dataStorageSizeInTBs").getter(getter(CloudAutonomousVmCluster::dataStorageSizeInTBs))
            .setter(setter(Builder::dataStorageSizeInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInTBs").build())
            .build();

    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs")
            .getter(getter(CloudAutonomousVmCluster::dbNodeStorageSizeInGBs)).setter(setter(Builder::dbNodeStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build())
            .build();

    private static final SdkField<List<String>> DB_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dbServers")
            .getter(getter(CloudAutonomousVmCluster::dbServers))
            .setter(setter(Builder::dbServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CloudAutonomousVmCluster::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("domain")
            .getter(getter(CloudAutonomousVmCluster::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()).build();

    private static final SdkField<Double> EXADATA_STORAGE_IN_T_BS_LOWEST_SCALED_VALUE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("exadataStorageInTBsLowestScaledValue")
            .getter(getter(CloudAutonomousVmCluster::exadataStorageInTBsLowestScaledValue))
            .setter(setter(Builder::exadataStorageInTBsLowestScaledValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("exadataStorageInTBsLowestScaledValue").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostname").getter(getter(CloudAutonomousVmCluster::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final SdkField<String> OCID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ocid")
            .getter(getter(CloudAutonomousVmCluster::ocid)).setter(setter(Builder::ocid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()).build();

    private static final SdkField<String> OCI_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ociUrl")
            .getter(getter(CloudAutonomousVmCluster::ociUrl)).setter(setter(Builder::ociUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociUrl").build()).build();

    private static final SdkField<Boolean> IS_MTLS_ENABLED_VM_CLUSTER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isMtlsEnabledVmCluster").getter(getter(CloudAutonomousVmCluster::isMtlsEnabledVmCluster))
            .setter(setter(Builder::isMtlsEnabledVmCluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMtlsEnabledVmCluster").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseModel").getter(getter(CloudAutonomousVmCluster::licenseModelAsString))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()).build();

    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField
            .<MaintenanceWindow> builder(MarshallingType.SDK_POJO).memberName("maintenanceWindow")
            .getter(getter(CloudAutonomousVmCluster::maintenanceWindow)).setter(setter(Builder::maintenanceWindow))
            .constructor(MaintenanceWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()).build();

    private static final SdkField<Integer> MAX_ACDS_LOWEST_SCALED_VALUE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("maxAcdsLowestScaledValue")
            .getter(getter(CloudAutonomousVmCluster::maxAcdsLowestScaledValue)).setter(setter(Builder::maxAcdsLowestScaledValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAcdsLowestScaledValue").build())
            .build();

    private static final SdkField<Integer> MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("memoryPerOracleComputeUnitInGBs")
            .getter(getter(CloudAutonomousVmCluster::memoryPerOracleComputeUnitInGBs))
            .setter(setter(Builder::memoryPerOracleComputeUnitInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryPerOracleComputeUnitInGBs")
                    .build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memorySizeInGBs").getter(getter(CloudAutonomousVmCluster::memorySizeInGBs))
            .setter(setter(Builder::memorySizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()).build();

    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("nodeCount").getter(getter(CloudAutonomousVmCluster::nodeCount)).setter(setter(Builder::nodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeCount").build()).build();

    private static final SdkField<Integer> NON_PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("nonProvisionableAutonomousContainerDatabases")
            .getter(getter(CloudAutonomousVmCluster::nonProvisionableAutonomousContainerDatabases))
            .setter(setter(Builder::nonProvisionableAutonomousContainerDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("nonProvisionableAutonomousContainerDatabases").build()).build();

    private static final SdkField<Integer> PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("provisionableAutonomousContainerDatabases")
            .getter(getter(CloudAutonomousVmCluster::provisionableAutonomousContainerDatabases))
            .setter(setter(Builder::provisionableAutonomousContainerDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("provisionableAutonomousContainerDatabases").build()).build();

    private static final SdkField<Integer> PROVISIONED_AUTONOMOUS_CONTAINER_DATABASES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("provisionedAutonomousContainerDatabases")
            .getter(getter(CloudAutonomousVmCluster::provisionedAutonomousContainerDatabases))
            .setter(setter(Builder::provisionedAutonomousContainerDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("provisionedAutonomousContainerDatabases").build()).build();

    private static final SdkField<Float> PROVISIONED_CPUS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("provisionedCpus").getter(getter(CloudAutonomousVmCluster::provisionedCpus))
            .setter(setter(Builder::provisionedCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedCpus").build()).build();

    private static final SdkField<Float> RECLAIMABLE_CPUS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("reclaimableCpus").getter(getter(CloudAutonomousVmCluster::reclaimableCpus))
            .setter(setter(Builder::reclaimableCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reclaimableCpus").build()).build();

    private static final SdkField<Float> RESERVED_CPUS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("reservedCpus").getter(getter(CloudAutonomousVmCluster::reservedCpus))
            .setter(setter(Builder::reservedCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedCpus").build()).build();

    private static final SdkField<Integer> SCAN_LISTENER_PORT_NON_TLS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("scanListenerPortNonTls").getter(getter(CloudAutonomousVmCluster::scanListenerPortNonTls))
            .setter(setter(Builder::scanListenerPortNonTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortNonTls").build())
            .build();

    private static final SdkField<Integer> SCAN_LISTENER_PORT_TLS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("scanListenerPortTls").getter(getter(CloudAutonomousVmCluster::scanListenerPortTls))
            .setter(setter(Builder::scanListenerPortTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortTls").build())
            .build();

    private static final SdkField<String> SHAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("shape")
            .getter(getter(CloudAutonomousVmCluster::shape)).setter(setter(Builder::shape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CloudAutonomousVmCluster::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> TIME_DATABASE_SSL_CERTIFICATE_EXPIRES_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timeDatabaseSslCertificateExpires")
            .getter(getter(CloudAutonomousVmCluster::timeDatabaseSslCertificateExpires))
            .setter(setter(Builder::timeDatabaseSslCertificateExpires))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDatabaseSslCertificateExpires")
                    .build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> TIME_ORDS_CERTIFICATE_EXPIRES_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timeOrdsCertificateExpires")
            .getter(getter(CloudAutonomousVmCluster::timeOrdsCertificateExpires))
            .setter(setter(Builder::timeOrdsCertificateExpires))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOrdsCertificateExpires").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeZone").getter(getter(CloudAutonomousVmCluster::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()).build();

    private static final SdkField<Integer> TOTAL_CONTAINER_DATABASES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalContainerDatabases").getter(getter(CloudAutonomousVmCluster::totalContainerDatabases))
            .setter(setter(Builder::totalContainerDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalContainerDatabases").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD, CLOUD_AUTONOMOUS_VM_CLUSTER_ARN_FIELD, ODB_NETWORK_ID_FIELD,
            OCI_RESOURCE_ANCHOR_NAME_FIELD, PERCENT_PROGRESS_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, AUTONOMOUS_DATA_STORAGE_PERCENTAGE_FIELD,
            AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD, AVAILABLE_AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD,
            AVAILABLE_CONTAINER_DATABASES_FIELD, AVAILABLE_CPUS_FIELD, COMPUTE_MODEL_FIELD, CPU_CORE_COUNT_FIELD,
            CPU_CORE_COUNT_PER_NODE_FIELD, CPU_PERCENTAGE_FIELD, DATA_STORAGE_SIZE_IN_G_BS_FIELD,
            DATA_STORAGE_SIZE_IN_T_BS_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVERS_FIELD, DESCRIPTION_FIELD,
            DOMAIN_FIELD, EXADATA_STORAGE_IN_T_BS_LOWEST_SCALED_VALUE_FIELD, HOSTNAME_FIELD, OCID_FIELD, OCI_URL_FIELD,
            IS_MTLS_ENABLED_VM_CLUSTER_FIELD, LICENSE_MODEL_FIELD, MAINTENANCE_WINDOW_FIELD, MAX_ACDS_LOWEST_SCALED_VALUE_FIELD,
            MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, NODE_COUNT_FIELD,
            NON_PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD, PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD,
            PROVISIONED_AUTONOMOUS_CONTAINER_DATABASES_FIELD, PROVISIONED_CPUS_FIELD, RECLAIMABLE_CPUS_FIELD,
            RESERVED_CPUS_FIELD, SCAN_LISTENER_PORT_NON_TLS_FIELD, SCAN_LISTENER_PORT_TLS_FIELD, SHAPE_FIELD, CREATED_AT_FIELD,
            TIME_DATABASE_SSL_CERTIFICATE_EXPIRES_FIELD, TIME_ORDS_CERTIFICATE_EXPIRES_FIELD, TIME_ZONE_FIELD,
            TOTAL_CONTAINER_DATABASES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cloudAutonomousVmClusterId;

    private final String cloudAutonomousVmClusterArn;

    private final String odbNetworkId;

    private final String ociResourceAnchorName;

    private final Float percentProgress;

    private final String displayName;

    private final String status;

    private final String statusReason;

    private final String cloudExadataInfrastructureId;

    private final Float autonomousDataStoragePercentage;

    private final Double autonomousDataStorageSizeInTBs;

    private final Double availableAutonomousDataStorageSizeInTBs;

    private final Integer availableContainerDatabases;

    private final Float availableCpus;

    private final String computeModel;

    private final Integer cpuCoreCount;

    private final Integer cpuCoreCountPerNode;

    private final Float cpuPercentage;

    private final Double dataStorageSizeInGBs;

    private final Double dataStorageSizeInTBs;

    private final Integer dbNodeStorageSizeInGBs;

    private final List<String> dbServers;

    private final String description;

    private final String domain;

    private final Double exadataStorageInTBsLowestScaledValue;

    private final String hostname;

    private final String ocid;

    private final String ociUrl;

    private final Boolean isMtlsEnabledVmCluster;

    private final String licenseModel;

    private final MaintenanceWindow maintenanceWindow;

    private final Integer maxAcdsLowestScaledValue;

    private final Integer memoryPerOracleComputeUnitInGBs;

    private final Integer memorySizeInGBs;

    private final Integer nodeCount;

    private final Integer nonProvisionableAutonomousContainerDatabases;

    private final Integer provisionableAutonomousContainerDatabases;

    private final Integer provisionedAutonomousContainerDatabases;

    private final Float provisionedCpus;

    private final Float reclaimableCpus;

    private final Float reservedCpus;

    private final Integer scanListenerPortNonTls;

    private final Integer scanListenerPortTls;

    private final String shape;

    private final Instant createdAt;

    private final Instant timeDatabaseSslCertificateExpires;

    private final Instant timeOrdsCertificateExpires;

    private final String timeZone;

    private final Integer totalContainerDatabases;

    private CloudAutonomousVmCluster(BuilderImpl builder) {
        this.cloudAutonomousVmClusterId = builder.cloudAutonomousVmClusterId;
        this.cloudAutonomousVmClusterArn = builder.cloudAutonomousVmClusterArn;
        this.odbNetworkId = builder.odbNetworkId;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.percentProgress = builder.percentProgress;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.autonomousDataStoragePercentage = builder.autonomousDataStoragePercentage;
        this.autonomousDataStorageSizeInTBs = builder.autonomousDataStorageSizeInTBs;
        this.availableAutonomousDataStorageSizeInTBs = builder.availableAutonomousDataStorageSizeInTBs;
        this.availableContainerDatabases = builder.availableContainerDatabases;
        this.availableCpus = builder.availableCpus;
        this.computeModel = builder.computeModel;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.cpuCoreCountPerNode = builder.cpuCoreCountPerNode;
        this.cpuPercentage = builder.cpuPercentage;
        this.dataStorageSizeInGBs = builder.dataStorageSizeInGBs;
        this.dataStorageSizeInTBs = builder.dataStorageSizeInTBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServers = builder.dbServers;
        this.description = builder.description;
        this.domain = builder.domain;
        this.exadataStorageInTBsLowestScaledValue = builder.exadataStorageInTBsLowestScaledValue;
        this.hostname = builder.hostname;
        this.ocid = builder.ocid;
        this.ociUrl = builder.ociUrl;
        this.isMtlsEnabledVmCluster = builder.isMtlsEnabledVmCluster;
        this.licenseModel = builder.licenseModel;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.maxAcdsLowestScaledValue = builder.maxAcdsLowestScaledValue;
        this.memoryPerOracleComputeUnitInGBs = builder.memoryPerOracleComputeUnitInGBs;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.nodeCount = builder.nodeCount;
        this.nonProvisionableAutonomousContainerDatabases = builder.nonProvisionableAutonomousContainerDatabases;
        this.provisionableAutonomousContainerDatabases = builder.provisionableAutonomousContainerDatabases;
        this.provisionedAutonomousContainerDatabases = builder.provisionedAutonomousContainerDatabases;
        this.provisionedCpus = builder.provisionedCpus;
        this.reclaimableCpus = builder.reclaimableCpus;
        this.reservedCpus = builder.reservedCpus;
        this.scanListenerPortNonTls = builder.scanListenerPortNonTls;
        this.scanListenerPortTls = builder.scanListenerPortTls;
        this.shape = builder.shape;
        this.createdAt = builder.createdAt;
        this.timeDatabaseSslCertificateExpires = builder.timeDatabaseSslCertificateExpires;
        this.timeOrdsCertificateExpires = builder.timeOrdsCertificateExpires;
        this.timeZone = builder.timeZone;
        this.totalContainerDatabases = builder.totalContainerDatabases;
    }

    /**
     * <p>
     * The unique identifier of the Autonomous VM cluster.
     * </p>
     * 
     * @return The unique identifier of the Autonomous VM cluster.
     */
    public final String cloudAutonomousVmClusterId() {
        return cloudAutonomousVmClusterId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Autonomous VM cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Autonomous VM cluster.
     */
    public final String cloudAutonomousVmClusterArn() {
        return cloudAutonomousVmClusterArn;
    }

    /**
     * <p>
     * The unique identifier of the ODB network associated with this Autonomous VM cluster.
     * </p>
     * 
     * @return The unique identifier of the ODB network associated with this Autonomous VM cluster.
     */
    public final String odbNetworkId() {
        return odbNetworkId;
    }

    /**
     * <p>
     * The name of the OCI resource anchor associated with this Autonomous VM cluster.
     * </p>
     * 
     * @return The name of the OCI resource anchor associated with this Autonomous VM cluster.
     */
    public final String ociResourceAnchorName() {
        return ociResourceAnchorName;
    }

    /**
     * <p>
     * The progress of the current operation on the Autonomous VM cluster, as a percentage.
     * </p>
     * 
     * @return The progress of the current operation on the Autonomous VM cluster, as a percentage.
     */
    public final Float percentProgress() {
        return percentProgress;
    }

    /**
     * <p>
     * The display name of the Autonomous VM cluster.
     * </p>
     * 
     * @return The display name of the Autonomous VM cluster.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The current state of the Autonomous VM cluster. Possible values include <code>CREATING</code>,
     * <code>AVAILABLE</code>, <code>UPDATING</code>, <code>DELETING</code>, <code>DELETED</code>, <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the Autonomous VM cluster. Possible values include <code>CREATING</code>,
     *         <code>AVAILABLE</code>, <code>UPDATING</code>, <code>DELETING</code>, <code>DELETED</code>,
     *         <code>FAILED</code>.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the Autonomous VM cluster. Possible values include <code>CREATING</code>,
     * <code>AVAILABLE</code>, <code>UPDATING</code>, <code>DELETING</code>, <code>DELETED</code>, <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the Autonomous VM cluster. Possible values include <code>CREATING</code>,
     *         <code>AVAILABLE</code>, <code>UPDATING</code>, <code>DELETING</code>, <code>DELETED</code>,
     *         <code>FAILED</code>.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the current status of the Autonomous VM cluster.
     * </p>
     * 
     * @return Additional information about the current status of the Autonomous VM cluster.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster.
     * </p>
     * 
     * @return The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster.
     */
    public final String cloudExadataInfrastructureId() {
        return cloudExadataInfrastructureId;
    }

    /**
     * <p>
     * The percentage of data storage currently in use for Autonomous Databases in the Autonomous VM cluster.
     * </p>
     * 
     * @return The percentage of data storage currently in use for Autonomous Databases in the Autonomous VM cluster.
     */
    public final Float autonomousDataStoragePercentage() {
        return autonomousDataStoragePercentage;
    }

    /**
     * <p>
     * The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB.
     * </p>
     * 
     * @return The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB.
     */
    public final Double autonomousDataStorageSizeInTBs() {
        return autonomousDataStorageSizeInTBs;
    }

    /**
     * <p>
     * The available data storage space for Autonomous Databases in the Autonomous VM cluster, in TB.
     * </p>
     * 
     * @return The available data storage space for Autonomous Databases in the Autonomous VM cluster, in TB.
     */
    public final Double availableAutonomousDataStorageSizeInTBs() {
        return availableAutonomousDataStorageSizeInTBs;
    }

    /**
     * <p>
     * The number of Autonomous CDBs that you can create with the currently available storage.
     * </p>
     * 
     * @return The number of Autonomous CDBs that you can create with the currently available storage.
     */
    public final Integer availableContainerDatabases() {
        return availableContainerDatabases;
    }

    /**
     * <p>
     * The number of CPU cores available for allocation to Autonomous Databases.
     * </p>
     * 
     * @return The number of CPU cores available for allocation to Autonomous Databases.
     */
    public final Float availableCpus() {
        return availableCpus;
    }

    /**
     * <p>
     * The compute model of the Autonomous VM cluster: ECPU or OCPU.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeModel} will
     * return {@link ComputeModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModelAsString}.
     * </p>
     * 
     * @return The compute model of the Autonomous VM cluster: ECPU or OCPU.
     * @see ComputeModel
     */
    public final ComputeModel computeModel() {
        return ComputeModel.fromValue(computeModel);
    }

    /**
     * <p>
     * The compute model of the Autonomous VM cluster: ECPU or OCPU.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeModel} will
     * return {@link ComputeModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModelAsString}.
     * </p>
     * 
     * @return The compute model of the Autonomous VM cluster: ECPU or OCPU.
     * @see ComputeModel
     */
    public final String computeModelAsString() {
        return computeModel;
    }

    /**
     * <p>
     * The total number of CPU cores in the Autonomous VM cluster.
     * </p>
     * 
     * @return The total number of CPU cores in the Autonomous VM cluster.
     */
    public final Integer cpuCoreCount() {
        return cpuCoreCount;
    }

    /**
     * <p>
     * The number of CPU cores enabled per node in the Autonomous VM cluster.
     * </p>
     * 
     * @return The number of CPU cores enabled per node in the Autonomous VM cluster.
     */
    public final Integer cpuCoreCountPerNode() {
        return cpuCoreCountPerNode;
    }

    /**
     * <p>
     * The percentage of total CPU cores currently in use in the Autonomous VM cluster.
     * </p>
     * 
     * @return The percentage of total CPU cores currently in use in the Autonomous VM cluster.
     */
    public final Float cpuPercentage() {
        return cpuPercentage;
    }

    /**
     * <p>
     * The total data storage allocated to the Autonomous VM cluster, in GB.
     * </p>
     * 
     * @return The total data storage allocated to the Autonomous VM cluster, in GB.
     */
    public final Double dataStorageSizeInGBs() {
        return dataStorageSizeInGBs;
    }

    /**
     * <p>
     * The total data storage allocated to the Autonomous VM cluster, in TB.
     * </p>
     * 
     * @return The total data storage allocated to the Autonomous VM cluster, in TB.
     */
    public final Double dataStorageSizeInTBs() {
        return dataStorageSizeInTBs;
    }

    /**
     * <p>
     * The local node storage allocated to the Autonomous VM cluster, in gigabytes (GB).
     * </p>
     * 
     * @return The local node storage allocated to the Autonomous VM cluster, in gigabytes (GB).
     */
    public final Integer dbNodeStorageSizeInGBs() {
        return dbNodeStorageSizeInGBs;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbServers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDbServers() {
        return dbServers != null && !(dbServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of database servers associated with the Autonomous VM cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbServers} method.
     * </p>
     * 
     * @return The list of database servers associated with the Autonomous VM cluster.
     */
    public final List<String> dbServers() {
        return dbServers;
    }

    /**
     * <p>
     * The user-provided description of the Autonomous VM cluster.
     * </p>
     * 
     * @return The user-provided description of the Autonomous VM cluster.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The domain name for the Autonomous VM cluster.
     * </p>
     * 
     * @return The domain name for the Autonomous VM cluster.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The minimum value to which you can scale down the Exadata storage, in TB.
     * </p>
     * 
     * @return The minimum value to which you can scale down the Exadata storage, in TB.
     */
    public final Double exadataStorageInTBsLowestScaledValue() {
        return exadataStorageInTBsLowestScaledValue;
    }

    /**
     * <p>
     * The hostname for the Autonomous VM cluster.
     * </p>
     * 
     * @return The hostname for the Autonomous VM cluster.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
     * </p>
     * 
     * @return The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
     */
    public final String ocid() {
        return ocid;
    }

    /**
     * <p>
     * The URL for accessing the OCI console page for this Autonomous VM cluster.
     * </p>
     * 
     * @return The URL for accessing the OCI console page for this Autonomous VM cluster.
     */
    public final String ociUrl() {
        return ociUrl;
    }

    /**
     * <p>
     * Indicates whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
     * </p>
     * 
     * @return Indicates whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
     */
    public final Boolean isMtlsEnabledVmCluster() {
        return isMtlsEnabledVmCluster;
    }

    /**
     * <p>
     * The Oracle license model that applies to the Autonomous VM cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The Oracle license model that applies to the Autonomous VM cluster.
     * @see LicenseModel
     */
    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(licenseModel);
    }

    /**
     * <p>
     * The Oracle license model that applies to the Autonomous VM cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The Oracle license model that applies to the Autonomous VM cluster.
     * @see LicenseModel
     */
    public final String licenseModelAsString() {
        return licenseModel;
    }

    /**
     * <p>
     * The scheduling details for the maintenance window. Patching and system updates take place during the maintenance
     * window.
     * </p>
     * 
     * @return The scheduling details for the maintenance window. Patching and system updates take place during the
     *         maintenance window.
     */
    public final MaintenanceWindow maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * The minimum value to which you can scale down the maximum number of Autonomous CDBs.
     * </p>
     * 
     * @return The minimum value to which you can scale down the maximum number of Autonomous CDBs.
     */
    public final Integer maxAcdsLowestScaledValue() {
        return maxAcdsLowestScaledValue;
    }

    /**
     * <p>
     * The amount of memory allocated per Oracle Compute Unit, in GB.
     * </p>
     * 
     * @return The amount of memory allocated per Oracle Compute Unit, in GB.
     */
    public final Integer memoryPerOracleComputeUnitInGBs() {
        return memoryPerOracleComputeUnitInGBs;
    }

    /**
     * <p>
     * The total amount of memory allocated to the Autonomous VM cluster, in gigabytes (GB).
     * </p>
     * 
     * @return The total amount of memory allocated to the Autonomous VM cluster, in gigabytes (GB).
     */
    public final Integer memorySizeInGBs() {
        return memorySizeInGBs;
    }

    /**
     * <p>
     * The number of database server nodes in the Autonomous VM cluster.
     * </p>
     * 
     * @return The number of database server nodes in the Autonomous VM cluster.
     */
    public final Integer nodeCount() {
        return nodeCount;
    }

    /**
     * <p>
     * The number of Autonomous CDBs that can't be provisioned because of resource constraints.
     * </p>
     * 
     * @return The number of Autonomous CDBs that can't be provisioned because of resource constraints.
     */
    public final Integer nonProvisionableAutonomousContainerDatabases() {
        return nonProvisionableAutonomousContainerDatabases;
    }

    /**
     * <p>
     * The number of Autonomous CDBs that can be provisioned in the Autonomous VM cluster.
     * </p>
     * 
     * @return The number of Autonomous CDBs that can be provisioned in the Autonomous VM cluster.
     */
    public final Integer provisionableAutonomousContainerDatabases() {
        return provisionableAutonomousContainerDatabases;
    }

    /**
     * <p>
     * The number of Autonomous CDBs currently provisioned in the Autonomous VM cluster.
     * </p>
     * 
     * @return The number of Autonomous CDBs currently provisioned in the Autonomous VM cluster.
     */
    public final Integer provisionedAutonomousContainerDatabases() {
        return provisionedAutonomousContainerDatabases;
    }

    /**
     * <p>
     * The number of CPU cores currently provisioned in the Autonomous VM cluster.
     * </p>
     * 
     * @return The number of CPU cores currently provisioned in the Autonomous VM cluster.
     */
    public final Float provisionedCpus() {
        return provisionedCpus;
    }

    /**
     * <p>
     * The number of CPU cores that can be reclaimed from terminated or scaled-down Autonomous Databases.
     * </p>
     * 
     * @return The number of CPU cores that can be reclaimed from terminated or scaled-down Autonomous Databases.
     */
    public final Float reclaimableCpus() {
        return reclaimableCpus;
    }

    /**
     * <p>
     * The number of CPU cores reserved for system operations and redundancy.
     * </p>
     * 
     * @return The number of CPU cores reserved for system operations and redundancy.
     */
    public final Float reservedCpus() {
        return reservedCpus;
    }

    /**
     * <p>
     * The SCAN listener port for non-TLS (TCP) protocol. The default is 1521.
     * </p>
     * 
     * @return The SCAN listener port for non-TLS (TCP) protocol. The default is 1521.
     */
    public final Integer scanListenerPortNonTls() {
        return scanListenerPortNonTls;
    }

    /**
     * <p>
     * The SCAN listener port for TLS (TCP) protocol. The default is 2484.
     * </p>
     * 
     * @return The SCAN listener port for TLS (TCP) protocol. The default is 2484.
     */
    public final Integer scanListenerPortTls() {
        return scanListenerPortTls;
    }

    /**
     * <p>
     * The shape of the Exadata infrastructure for the Autonomous VM cluster.
     * </p>
     * 
     * @return The shape of the Exadata infrastructure for the Autonomous VM cluster.
     */
    public final String shape() {
        return shape;
    }

    /**
     * <p>
     * The date and time when the Autonomous VM cluster was created.
     * </p>
     * 
     * @return The date and time when the Autonomous VM cluster was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The expiration date and time of the database SSL certificate.
     * </p>
     * 
     * @return The expiration date and time of the database SSL certificate.
     */
    public final Instant timeDatabaseSslCertificateExpires() {
        return timeDatabaseSslCertificateExpires;
    }

    /**
     * <p>
     * The expiration date and time of the Oracle REST Data Services (ORDS) certificate.
     * </p>
     * 
     * @return The expiration date and time of the Oracle REST Data Services (ORDS) certificate.
     */
    public final Instant timeOrdsCertificateExpires() {
        return timeOrdsCertificateExpires;
    }

    /**
     * <p>
     * The time zone of the Autonomous VM cluster.
     * </p>
     * 
     * @return The time zone of the Autonomous VM cluster.
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * The total number of Autonomous Container Databases that can be created with the allocated local storage.
     * </p>
     * 
     * @return The total number of Autonomous Container Databases that can be created with the allocated local storage.
     */
    public final Integer totalContainerDatabases() {
        return totalContainerDatabases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudAutonomousVmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(cloudAutonomousVmClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(autonomousDataStoragePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(autonomousDataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(availableAutonomousDataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(availableContainerDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(availableCpus());
        hashCode = 31 * hashCode + Objects.hashCode(computeModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCoreCountPerNode());
        hashCode = 31 * hashCode + Objects.hashCode(cpuPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(dataStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(dataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbServers() ? dbServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(exadataStorageInTBsLowestScaledValue());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(ocid());
        hashCode = 31 * hashCode + Objects.hashCode(ociUrl());
        hashCode = 31 * hashCode + Objects.hashCode(isMtlsEnabledVmCluster());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(maxAcdsLowestScaledValue());
        hashCode = 31 * hashCode + Objects.hashCode(memoryPerOracleComputeUnitInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonProvisionableAutonomousContainerDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(provisionableAutonomousContainerDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedAutonomousContainerDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedCpus());
        hashCode = 31 * hashCode + Objects.hashCode(reclaimableCpus());
        hashCode = 31 * hashCode + Objects.hashCode(reservedCpus());
        hashCode = 31 * hashCode + Objects.hashCode(scanListenerPortNonTls());
        hashCode = 31 * hashCode + Objects.hashCode(scanListenerPortTls());
        hashCode = 31 * hashCode + Objects.hashCode(shape());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(timeDatabaseSslCertificateExpires());
        hashCode = 31 * hashCode + Objects.hashCode(timeOrdsCertificateExpires());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(totalContainerDatabases());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudAutonomousVmCluster)) {
            return false;
        }
        CloudAutonomousVmCluster other = (CloudAutonomousVmCluster) obj;
        return Objects.equals(cloudAutonomousVmClusterId(), other.cloudAutonomousVmClusterId())
                && Objects.equals(cloudAutonomousVmClusterArn(), other.cloudAutonomousVmClusterArn())
                && Objects.equals(odbNetworkId(), other.odbNetworkId())
                && Objects.equals(ociResourceAnchorName(), other.ociResourceAnchorName())
                && Objects.equals(percentProgress(), other.percentProgress())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId())
                && Objects.equals(autonomousDataStoragePercentage(), other.autonomousDataStoragePercentage())
                && Objects.equals(autonomousDataStorageSizeInTBs(), other.autonomousDataStorageSizeInTBs())
                && Objects.equals(availableAutonomousDataStorageSizeInTBs(), other.availableAutonomousDataStorageSizeInTBs())
                && Objects.equals(availableContainerDatabases(), other.availableContainerDatabases())
                && Objects.equals(availableCpus(), other.availableCpus())
                && Objects.equals(computeModelAsString(), other.computeModelAsString())
                && Objects.equals(cpuCoreCount(), other.cpuCoreCount())
                && Objects.equals(cpuCoreCountPerNode(), other.cpuCoreCountPerNode())
                && Objects.equals(cpuPercentage(), other.cpuPercentage())
                && Objects.equals(dataStorageSizeInGBs(), other.dataStorageSizeInGBs())
                && Objects.equals(dataStorageSizeInTBs(), other.dataStorageSizeInTBs())
                && Objects.equals(dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs())
                && hasDbServers() == other.hasDbServers()
                && Objects.equals(dbServers(), other.dbServers())
                && Objects.equals(description(), other.description())
                && Objects.equals(domain(), other.domain())
                && Objects.equals(exadataStorageInTBsLowestScaledValue(), other.exadataStorageInTBsLowestScaledValue())
                && Objects.equals(hostname(), other.hostname())
                && Objects.equals(ocid(), other.ocid())
                && Objects.equals(ociUrl(), other.ociUrl())
                && Objects.equals(isMtlsEnabledVmCluster(), other.isMtlsEnabledVmCluster())
                && Objects.equals(licenseModelAsString(), other.licenseModelAsString())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow())
                && Objects.equals(maxAcdsLowestScaledValue(), other.maxAcdsLowestScaledValue())
                && Objects.equals(memoryPerOracleComputeUnitInGBs(), other.memoryPerOracleComputeUnitInGBs())
                && Objects.equals(memorySizeInGBs(), other.memorySizeInGBs())
                && Objects.equals(nodeCount(), other.nodeCount())
                && Objects.equals(nonProvisionableAutonomousContainerDatabases(),
                        other.nonProvisionableAutonomousContainerDatabases())
                && Objects.equals(provisionableAutonomousContainerDatabases(), other.provisionableAutonomousContainerDatabases())
                && Objects.equals(provisionedAutonomousContainerDatabases(), other.provisionedAutonomousContainerDatabases())
                && Objects.equals(provisionedCpus(), other.provisionedCpus())
                && Objects.equals(reclaimableCpus(), other.reclaimableCpus())
                && Objects.equals(reservedCpus(), other.reservedCpus())
                && Objects.equals(scanListenerPortNonTls(), other.scanListenerPortNonTls())
                && Objects.equals(scanListenerPortTls(), other.scanListenerPortTls()) && Objects.equals(shape(), other.shape())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(timeDatabaseSslCertificateExpires(), other.timeDatabaseSslCertificateExpires())
                && Objects.equals(timeOrdsCertificateExpires(), other.timeOrdsCertificateExpires())
                && Objects.equals(timeZone(), other.timeZone())
                && Objects.equals(totalContainerDatabases(), other.totalContainerDatabases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudAutonomousVmCluster").add("CloudAutonomousVmClusterId", cloudAutonomousVmClusterId())
                .add("CloudAutonomousVmClusterArn", cloudAutonomousVmClusterArn()).add("OdbNetworkId", odbNetworkId())
                .add("OciResourceAnchorName", ociResourceAnchorName()).add("PercentProgress", percentProgress())
                .add("DisplayName", displayName()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("CloudExadataInfrastructureId", cloudExadataInfrastructureId())
                .add("AutonomousDataStoragePercentage", autonomousDataStoragePercentage())
                .add("AutonomousDataStorageSizeInTBs", autonomousDataStorageSizeInTBs())
                .add("AvailableAutonomousDataStorageSizeInTBs", availableAutonomousDataStorageSizeInTBs())
                .add("AvailableContainerDatabases", availableContainerDatabases()).add("AvailableCpus", availableCpus())
                .add("ComputeModel", computeModelAsString()).add("CpuCoreCount", cpuCoreCount())
                .add("CpuCoreCountPerNode", cpuCoreCountPerNode()).add("CpuPercentage", cpuPercentage())
                .add("DataStorageSizeInGBs", dataStorageSizeInGBs()).add("DataStorageSizeInTBs", dataStorageSizeInTBs())
                .add("DbNodeStorageSizeInGBs", dbNodeStorageSizeInGBs()).add("DbServers", hasDbServers() ? dbServers() : null)
                .add("Description", description()).add("Domain", domain())
                .add("ExadataStorageInTBsLowestScaledValue", exadataStorageInTBsLowestScaledValue()).add("Hostname", hostname())
                .add("Ocid", ocid()).add("OciUrl", ociUrl()).add("IsMtlsEnabledVmCluster", isMtlsEnabledVmCluster())
                .add("LicenseModel", licenseModelAsString()).add("MaintenanceWindow", maintenanceWindow())
                .add("MaxAcdsLowestScaledValue", maxAcdsLowestScaledValue())
                .add("MemoryPerOracleComputeUnitInGBs", memoryPerOracleComputeUnitInGBs())
                .add("MemorySizeInGBs", memorySizeInGBs()).add("NodeCount", nodeCount())
                .add("NonProvisionableAutonomousContainerDatabases", nonProvisionableAutonomousContainerDatabases())
                .add("ProvisionableAutonomousContainerDatabases", provisionableAutonomousContainerDatabases())
                .add("ProvisionedAutonomousContainerDatabases", provisionedAutonomousContainerDatabases())
                .add("ProvisionedCpus", provisionedCpus()).add("ReclaimableCpus", reclaimableCpus())
                .add("ReservedCpus", reservedCpus()).add("ScanListenerPortNonTls", scanListenerPortNonTls())
                .add("ScanListenerPortTls", scanListenerPortTls()).add("Shape", shape()).add("CreatedAt", createdAt())
                .add("TimeDatabaseSslCertificateExpires", timeDatabaseSslCertificateExpires())
                .add("TimeOrdsCertificateExpires", timeOrdsCertificateExpires()).add("TimeZone", timeZone())
                .add("TotalContainerDatabases", totalContainerDatabases()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudAutonomousVmClusterId":
            return Optional.ofNullable(clazz.cast(cloudAutonomousVmClusterId()));
        case "cloudAutonomousVmClusterArn":
            return Optional.ofNullable(clazz.cast(cloudAutonomousVmClusterArn()));
        case "odbNetworkId":
            return Optional.ofNullable(clazz.cast(odbNetworkId()));
        case "ociResourceAnchorName":
            return Optional.ofNullable(clazz.cast(ociResourceAnchorName()));
        case "percentProgress":
            return Optional.ofNullable(clazz.cast(percentProgress()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "cloudExadataInfrastructureId":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructureId()));
        case "autonomousDataStoragePercentage":
            return Optional.ofNullable(clazz.cast(autonomousDataStoragePercentage()));
        case "autonomousDataStorageSizeInTBs":
            return Optional.ofNullable(clazz.cast(autonomousDataStorageSizeInTBs()));
        case "availableAutonomousDataStorageSizeInTBs":
            return Optional.ofNullable(clazz.cast(availableAutonomousDataStorageSizeInTBs()));
        case "availableContainerDatabases":
            return Optional.ofNullable(clazz.cast(availableContainerDatabases()));
        case "availableCpus":
            return Optional.ofNullable(clazz.cast(availableCpus()));
        case "computeModel":
            return Optional.ofNullable(clazz.cast(computeModelAsString()));
        case "cpuCoreCount":
            return Optional.ofNullable(clazz.cast(cpuCoreCount()));
        case "cpuCoreCountPerNode":
            return Optional.ofNullable(clazz.cast(cpuCoreCountPerNode()));
        case "cpuPercentage":
            return Optional.ofNullable(clazz.cast(cpuPercentage()));
        case "dataStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(dataStorageSizeInGBs()));
        case "dataStorageSizeInTBs":
            return Optional.ofNullable(clazz.cast(dataStorageSizeInTBs()));
        case "dbNodeStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(dbNodeStorageSizeInGBs()));
        case "dbServers":
            return Optional.ofNullable(clazz.cast(dbServers()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "exadataStorageInTBsLowestScaledValue":
            return Optional.ofNullable(clazz.cast(exadataStorageInTBsLowestScaledValue()));
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "ocid":
            return Optional.ofNullable(clazz.cast(ocid()));
        case "ociUrl":
            return Optional.ofNullable(clazz.cast(ociUrl()));
        case "isMtlsEnabledVmCluster":
            return Optional.ofNullable(clazz.cast(isMtlsEnabledVmCluster()));
        case "licenseModel":
            return Optional.ofNullable(clazz.cast(licenseModelAsString()));
        case "maintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "maxAcdsLowestScaledValue":
            return Optional.ofNullable(clazz.cast(maxAcdsLowestScaledValue()));
        case "memoryPerOracleComputeUnitInGBs":
            return Optional.ofNullable(clazz.cast(memoryPerOracleComputeUnitInGBs()));
        case "memorySizeInGBs":
            return Optional.ofNullable(clazz.cast(memorySizeInGBs()));
        case "nodeCount":
            return Optional.ofNullable(clazz.cast(nodeCount()));
        case "nonProvisionableAutonomousContainerDatabases":
            return Optional.ofNullable(clazz.cast(nonProvisionableAutonomousContainerDatabases()));
        case "provisionableAutonomousContainerDatabases":
            return Optional.ofNullable(clazz.cast(provisionableAutonomousContainerDatabases()));
        case "provisionedAutonomousContainerDatabases":
            return Optional.ofNullable(clazz.cast(provisionedAutonomousContainerDatabases()));
        case "provisionedCpus":
            return Optional.ofNullable(clazz.cast(provisionedCpus()));
        case "reclaimableCpus":
            return Optional.ofNullable(clazz.cast(reclaimableCpus()));
        case "reservedCpus":
            return Optional.ofNullable(clazz.cast(reservedCpus()));
        case "scanListenerPortNonTls":
            return Optional.ofNullable(clazz.cast(scanListenerPortNonTls()));
        case "scanListenerPortTls":
            return Optional.ofNullable(clazz.cast(scanListenerPortTls()));
        case "shape":
            return Optional.ofNullable(clazz.cast(shape()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "timeDatabaseSslCertificateExpires":
            return Optional.ofNullable(clazz.cast(timeDatabaseSslCertificateExpires()));
        case "timeOrdsCertificateExpires":
            return Optional.ofNullable(clazz.cast(timeOrdsCertificateExpires()));
        case "timeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "totalContainerDatabases":
            return Optional.ofNullable(clazz.cast(totalContainerDatabases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudAutonomousVmClusterId", CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD);
        map.put("cloudAutonomousVmClusterArn", CLOUD_AUTONOMOUS_VM_CLUSTER_ARN_FIELD);
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("percentProgress", PERCENT_PROGRESS_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("autonomousDataStoragePercentage", AUTONOMOUS_DATA_STORAGE_PERCENTAGE_FIELD);
        map.put("autonomousDataStorageSizeInTBs", AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("availableAutonomousDataStorageSizeInTBs", AVAILABLE_AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("availableContainerDatabases", AVAILABLE_CONTAINER_DATABASES_FIELD);
        map.put("availableCpus", AVAILABLE_CPUS_FIELD);
        map.put("computeModel", COMPUTE_MODEL_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("cpuCoreCountPerNode", CPU_CORE_COUNT_PER_NODE_FIELD);
        map.put("cpuPercentage", CPU_PERCENTAGE_FIELD);
        map.put("dataStorageSizeInGBs", DATA_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dataStorageSizeInTBs", DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domain", DOMAIN_FIELD);
        map.put("exadataStorageInTBsLowestScaledValue", EXADATA_STORAGE_IN_T_BS_LOWEST_SCALED_VALUE_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("ociUrl", OCI_URL_FIELD);
        map.put("isMtlsEnabledVmCluster", IS_MTLS_ENABLED_VM_CLUSTER_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("maintenanceWindow", MAINTENANCE_WINDOW_FIELD);
        map.put("maxAcdsLowestScaledValue", MAX_ACDS_LOWEST_SCALED_VALUE_FIELD);
        map.put("memoryPerOracleComputeUnitInGBs", MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("nodeCount", NODE_COUNT_FIELD);
        map.put("nonProvisionableAutonomousContainerDatabases", NON_PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD);
        map.put("provisionableAutonomousContainerDatabases", PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD);
        map.put("provisionedAutonomousContainerDatabases", PROVISIONED_AUTONOMOUS_CONTAINER_DATABASES_FIELD);
        map.put("provisionedCpus", PROVISIONED_CPUS_FIELD);
        map.put("reclaimableCpus", RECLAIMABLE_CPUS_FIELD);
        map.put("reservedCpus", RESERVED_CPUS_FIELD);
        map.put("scanListenerPortNonTls", SCAN_LISTENER_PORT_NON_TLS_FIELD);
        map.put("scanListenerPortTls", SCAN_LISTENER_PORT_TLS_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("timeDatabaseSslCertificateExpires", TIME_DATABASE_SSL_CERTIFICATE_EXPIRES_FIELD);
        map.put("timeOrdsCertificateExpires", TIME_ORDS_CERTIFICATE_EXPIRES_FIELD);
        map.put("timeZone", TIME_ZONE_FIELD);
        map.put("totalContainerDatabases", TOTAL_CONTAINER_DATABASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudAutonomousVmCluster, T> g) {
        return obj -> g.apply((CloudAutonomousVmCluster) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudAutonomousVmCluster> {
        /**
         * <p>
         * The unique identifier of the Autonomous VM cluster.
         * </p>
         * 
         * @param cloudAutonomousVmClusterId
         *        The unique identifier of the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Autonomous VM cluster.
         * </p>
         * 
         * @param cloudAutonomousVmClusterArn
         *        The Amazon Resource Name (ARN) for the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudAutonomousVmClusterArn(String cloudAutonomousVmClusterArn);

        /**
         * <p>
         * The unique identifier of the ODB network associated with this Autonomous VM cluster.
         * </p>
         * 
         * @param odbNetworkId
         *        The unique identifier of the ODB network associated with this Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworkId(String odbNetworkId);

        /**
         * <p>
         * The name of the OCI resource anchor associated with this Autonomous VM cluster.
         * </p>
         * 
         * @param ociResourceAnchorName
         *        The name of the OCI resource anchor associated with this Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociResourceAnchorName(String ociResourceAnchorName);

        /**
         * <p>
         * The progress of the current operation on the Autonomous VM cluster, as a percentage.
         * </p>
         * 
         * @param percentProgress
         *        The progress of the current operation on the Autonomous VM cluster, as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentProgress(Float percentProgress);

        /**
         * <p>
         * The display name of the Autonomous VM cluster.
         * </p>
         * 
         * @param displayName
         *        The display name of the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The current state of the Autonomous VM cluster. Possible values include <code>CREATING</code>,
         * <code>AVAILABLE</code>, <code>UPDATING</code>, <code>DELETING</code>, <code>DELETED</code>,
         * <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current state of the Autonomous VM cluster. Possible values include <code>CREATING</code>,
         *        <code>AVAILABLE</code>, <code>UPDATING</code>, <code>DELETING</code>, <code>DELETED</code>,
         *        <code>FAILED</code>.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the Autonomous VM cluster. Possible values include <code>CREATING</code>,
         * <code>AVAILABLE</code>, <code>UPDATING</code>, <code>DELETING</code>, <code>DELETED</code>,
         * <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current state of the Autonomous VM cluster. Possible values include <code>CREATING</code>,
         *        <code>AVAILABLE</code>, <code>UPDATING</code>, <code>DELETING</code>, <code>DELETED</code>,
         *        <code>FAILED</code>.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Additional information about the current status of the Autonomous VM cluster.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the current status of the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster.
         * </p>
         * 
         * @param cloudExadataInfrastructureId
         *        The unique identifier of the Cloud Exadata Infrastructure containing this Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId);

        /**
         * <p>
         * The percentage of data storage currently in use for Autonomous Databases in the Autonomous VM cluster.
         * </p>
         * 
         * @param autonomousDataStoragePercentage
         *        The percentage of data storage currently in use for Autonomous Databases in the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autonomousDataStoragePercentage(Float autonomousDataStoragePercentage);

        /**
         * <p>
         * The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB.
         * </p>
         * 
         * @param autonomousDataStorageSizeInTBs
         *        The data storage size allocated for Autonomous Databases in the Autonomous VM cluster, in TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs);

        /**
         * <p>
         * The available data storage space for Autonomous Databases in the Autonomous VM cluster, in TB.
         * </p>
         * 
         * @param availableAutonomousDataStorageSizeInTBs
         *        The available data storage space for Autonomous Databases in the Autonomous VM cluster, in TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableAutonomousDataStorageSizeInTBs(Double availableAutonomousDataStorageSizeInTBs);

        /**
         * <p>
         * The number of Autonomous CDBs that you can create with the currently available storage.
         * </p>
         * 
         * @param availableContainerDatabases
         *        The number of Autonomous CDBs that you can create with the currently available storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableContainerDatabases(Integer availableContainerDatabases);

        /**
         * <p>
         * The number of CPU cores available for allocation to Autonomous Databases.
         * </p>
         * 
         * @param availableCpus
         *        The number of CPU cores available for allocation to Autonomous Databases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableCpus(Float availableCpus);

        /**
         * <p>
         * The compute model of the Autonomous VM cluster: ECPU or OCPU.
         * </p>
         * 
         * @param computeModel
         *        The compute model of the Autonomous VM cluster: ECPU or OCPU.
         * @see ComputeModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeModel
         */
        Builder computeModel(String computeModel);

        /**
         * <p>
         * The compute model of the Autonomous VM cluster: ECPU or OCPU.
         * </p>
         * 
         * @param computeModel
         *        The compute model of the Autonomous VM cluster: ECPU or OCPU.
         * @see ComputeModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeModel
         */
        Builder computeModel(ComputeModel computeModel);

        /**
         * <p>
         * The total number of CPU cores in the Autonomous VM cluster.
         * </p>
         * 
         * @param cpuCoreCount
         *        The total number of CPU cores in the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCoreCount(Integer cpuCoreCount);

        /**
         * <p>
         * The number of CPU cores enabled per node in the Autonomous VM cluster.
         * </p>
         * 
         * @param cpuCoreCountPerNode
         *        The number of CPU cores enabled per node in the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode);

        /**
         * <p>
         * The percentage of total CPU cores currently in use in the Autonomous VM cluster.
         * </p>
         * 
         * @param cpuPercentage
         *        The percentage of total CPU cores currently in use in the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuPercentage(Float cpuPercentage);

        /**
         * <p>
         * The total data storage allocated to the Autonomous VM cluster, in GB.
         * </p>
         * 
         * @param dataStorageSizeInGBs
         *        The total data storage allocated to the Autonomous VM cluster, in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorageSizeInGBs(Double dataStorageSizeInGBs);

        /**
         * <p>
         * The total data storage allocated to the Autonomous VM cluster, in TB.
         * </p>
         * 
         * @param dataStorageSizeInTBs
         *        The total data storage allocated to the Autonomous VM cluster, in TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs);

        /**
         * <p>
         * The local node storage allocated to the Autonomous VM cluster, in gigabytes (GB).
         * </p>
         * 
         * @param dbNodeStorageSizeInGBs
         *        The local node storage allocated to the Autonomous VM cluster, in gigabytes (GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs);

        /**
         * <p>
         * The list of database servers associated with the Autonomous VM cluster.
         * </p>
         * 
         * @param dbServers
         *        The list of database servers associated with the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServers(Collection<String> dbServers);

        /**
         * <p>
         * The list of database servers associated with the Autonomous VM cluster.
         * </p>
         * 
         * @param dbServers
         *        The list of database servers associated with the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServers(String... dbServers);

        /**
         * <p>
         * The user-provided description of the Autonomous VM cluster.
         * </p>
         * 
         * @param description
         *        The user-provided description of the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The domain name for the Autonomous VM cluster.
         * </p>
         * 
         * @param domain
         *        The domain name for the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The minimum value to which you can scale down the Exadata storage, in TB.
         * </p>
         * 
         * @param exadataStorageInTBsLowestScaledValue
         *        The minimum value to which you can scale down the Exadata storage, in TB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exadataStorageInTBsLowestScaledValue(Double exadataStorageInTBsLowestScaledValue);

        /**
         * <p>
         * The hostname for the Autonomous VM cluster.
         * </p>
         * 
         * @param hostname
         *        The hostname for the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
         * </p>
         * 
         * @param ocid
         *        The Oracle Cloud Identifier (OCID) of the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocid(String ocid);

        /**
         * <p>
         * The URL for accessing the OCI console page for this Autonomous VM cluster.
         * </p>
         * 
         * @param ociUrl
         *        The URL for accessing the OCI console page for this Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociUrl(String ociUrl);

        /**
         * <p>
         * Indicates whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
         * </p>
         * 
         * @param isMtlsEnabledVmCluster
         *        Indicates whether mutual TLS (mTLS) authentication is enabled for the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster);

        /**
         * <p>
         * The Oracle license model that applies to the Autonomous VM cluster.
         * </p>
         * 
         * @param licenseModel
         *        The Oracle license model that applies to the Autonomous VM cluster.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The Oracle license model that applies to the Autonomous VM cluster.
         * </p>
         * 
         * @param licenseModel
         *        The Oracle license model that applies to the Autonomous VM cluster.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(LicenseModel licenseModel);

        /**
         * <p>
         * The scheduling details for the maintenance window. Patching and system updates take place during the
         * maintenance window.
         * </p>
         * 
         * @param maintenanceWindow
         *        The scheduling details for the maintenance window. Patching and system updates take place during the
         *        maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(MaintenanceWindow maintenanceWindow);

        /**
         * <p>
         * The scheduling details for the maintenance window. Patching and system updates take place during the
         * maintenance window.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceWindow.Builder} avoiding the
         * need to create one manually via {@link MaintenanceWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindow(MaintenanceWindow)}.
         * 
         * @param maintenanceWindow
         *        a consumer that will call methods on {@link MaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindow(MaintenanceWindow)
         */
        default Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return maintenanceWindow(MaintenanceWindow.builder().applyMutation(maintenanceWindow).build());
        }

        /**
         * <p>
         * The minimum value to which you can scale down the maximum number of Autonomous CDBs.
         * </p>
         * 
         * @param maxAcdsLowestScaledValue
         *        The minimum value to which you can scale down the maximum number of Autonomous CDBs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAcdsLowestScaledValue(Integer maxAcdsLowestScaledValue);

        /**
         * <p>
         * The amount of memory allocated per Oracle Compute Unit, in GB.
         * </p>
         * 
         * @param memoryPerOracleComputeUnitInGBs
         *        The amount of memory allocated per Oracle Compute Unit, in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs);

        /**
         * <p>
         * The total amount of memory allocated to the Autonomous VM cluster, in gigabytes (GB).
         * </p>
         * 
         * @param memorySizeInGBs
         *        The total amount of memory allocated to the Autonomous VM cluster, in gigabytes (GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeInGBs(Integer memorySizeInGBs);

        /**
         * <p>
         * The number of database server nodes in the Autonomous VM cluster.
         * </p>
         * 
         * @param nodeCount
         *        The number of database server nodes in the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeCount(Integer nodeCount);

        /**
         * <p>
         * The number of Autonomous CDBs that can't be provisioned because of resource constraints.
         * </p>
         * 
         * @param nonProvisionableAutonomousContainerDatabases
         *        The number of Autonomous CDBs that can't be provisioned because of resource constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonProvisionableAutonomousContainerDatabases(Integer nonProvisionableAutonomousContainerDatabases);

        /**
         * <p>
         * The number of Autonomous CDBs that can be provisioned in the Autonomous VM cluster.
         * </p>
         * 
         * @param provisionableAutonomousContainerDatabases
         *        The number of Autonomous CDBs that can be provisioned in the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionableAutonomousContainerDatabases(Integer provisionableAutonomousContainerDatabases);

        /**
         * <p>
         * The number of Autonomous CDBs currently provisioned in the Autonomous VM cluster.
         * </p>
         * 
         * @param provisionedAutonomousContainerDatabases
         *        The number of Autonomous CDBs currently provisioned in the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedAutonomousContainerDatabases(Integer provisionedAutonomousContainerDatabases);

        /**
         * <p>
         * The number of CPU cores currently provisioned in the Autonomous VM cluster.
         * </p>
         * 
         * @param provisionedCpus
         *        The number of CPU cores currently provisioned in the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedCpus(Float provisionedCpus);

        /**
         * <p>
         * The number of CPU cores that can be reclaimed from terminated or scaled-down Autonomous Databases.
         * </p>
         * 
         * @param reclaimableCpus
         *        The number of CPU cores that can be reclaimed from terminated or scaled-down Autonomous Databases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reclaimableCpus(Float reclaimableCpus);

        /**
         * <p>
         * The number of CPU cores reserved for system operations and redundancy.
         * </p>
         * 
         * @param reservedCpus
         *        The number of CPU cores reserved for system operations and redundancy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCpus(Float reservedCpus);

        /**
         * <p>
         * The SCAN listener port for non-TLS (TCP) protocol. The default is 1521.
         * </p>
         * 
         * @param scanListenerPortNonTls
         *        The SCAN listener port for non-TLS (TCP) protocol. The default is 1521.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanListenerPortNonTls(Integer scanListenerPortNonTls);

        /**
         * <p>
         * The SCAN listener port for TLS (TCP) protocol. The default is 2484.
         * </p>
         * 
         * @param scanListenerPortTls
         *        The SCAN listener port for TLS (TCP) protocol. The default is 2484.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanListenerPortTls(Integer scanListenerPortTls);

        /**
         * <p>
         * The shape of the Exadata infrastructure for the Autonomous VM cluster.
         * </p>
         * 
         * @param shape
         *        The shape of the Exadata infrastructure for the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shape(String shape);

        /**
         * <p>
         * The date and time when the Autonomous VM cluster was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the Autonomous VM cluster was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The expiration date and time of the database SSL certificate.
         * </p>
         * 
         * @param timeDatabaseSslCertificateExpires
         *        The expiration date and time of the database SSL certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeDatabaseSslCertificateExpires(Instant timeDatabaseSslCertificateExpires);

        /**
         * <p>
         * The expiration date and time of the Oracle REST Data Services (ORDS) certificate.
         * </p>
         * 
         * @param timeOrdsCertificateExpires
         *        The expiration date and time of the Oracle REST Data Services (ORDS) certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOrdsCertificateExpires(Instant timeOrdsCertificateExpires);

        /**
         * <p>
         * The time zone of the Autonomous VM cluster.
         * </p>
         * 
         * @param timeZone
         *        The time zone of the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * The total number of Autonomous Container Databases that can be created with the allocated local storage.
         * </p>
         * 
         * @param totalContainerDatabases
         *        The total number of Autonomous Container Databases that can be created with the allocated local
         *        storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalContainerDatabases(Integer totalContainerDatabases);
    }

    static final class BuilderImpl implements Builder {
        private String cloudAutonomousVmClusterId;

        private String cloudAutonomousVmClusterArn;

        private String odbNetworkId;

        private String ociResourceAnchorName;

        private Float percentProgress;

        private String displayName;

        private String status;

        private String statusReason;

        private String cloudExadataInfrastructureId;

        private Float autonomousDataStoragePercentage;

        private Double autonomousDataStorageSizeInTBs;

        private Double availableAutonomousDataStorageSizeInTBs;

        private Integer availableContainerDatabases;

        private Float availableCpus;

        private String computeModel;

        private Integer cpuCoreCount;

        private Integer cpuCoreCountPerNode;

        private Float cpuPercentage;

        private Double dataStorageSizeInGBs;

        private Double dataStorageSizeInTBs;

        private Integer dbNodeStorageSizeInGBs;

        private List<String> dbServers = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String domain;

        private Double exadataStorageInTBsLowestScaledValue;

        private String hostname;

        private String ocid;

        private String ociUrl;

        private Boolean isMtlsEnabledVmCluster;

        private String licenseModel;

        private MaintenanceWindow maintenanceWindow;

        private Integer maxAcdsLowestScaledValue;

        private Integer memoryPerOracleComputeUnitInGBs;

        private Integer memorySizeInGBs;

        private Integer nodeCount;

        private Integer nonProvisionableAutonomousContainerDatabases;

        private Integer provisionableAutonomousContainerDatabases;

        private Integer provisionedAutonomousContainerDatabases;

        private Float provisionedCpus;

        private Float reclaimableCpus;

        private Float reservedCpus;

        private Integer scanListenerPortNonTls;

        private Integer scanListenerPortTls;

        private String shape;

        private Instant createdAt;

        private Instant timeDatabaseSslCertificateExpires;

        private Instant timeOrdsCertificateExpires;

        private String timeZone;

        private Integer totalContainerDatabases;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudAutonomousVmCluster model) {
            cloudAutonomousVmClusterId(model.cloudAutonomousVmClusterId);
            cloudAutonomousVmClusterArn(model.cloudAutonomousVmClusterArn);
            odbNetworkId(model.odbNetworkId);
            ociResourceAnchorName(model.ociResourceAnchorName);
            percentProgress(model.percentProgress);
            displayName(model.displayName);
            status(model.status);
            statusReason(model.statusReason);
            cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            autonomousDataStoragePercentage(model.autonomousDataStoragePercentage);
            autonomousDataStorageSizeInTBs(model.autonomousDataStorageSizeInTBs);
            availableAutonomousDataStorageSizeInTBs(model.availableAutonomousDataStorageSizeInTBs);
            availableContainerDatabases(model.availableContainerDatabases);
            availableCpus(model.availableCpus);
            computeModel(model.computeModel);
            cpuCoreCount(model.cpuCoreCount);
            cpuCoreCountPerNode(model.cpuCoreCountPerNode);
            cpuPercentage(model.cpuPercentage);
            dataStorageSizeInGBs(model.dataStorageSizeInGBs);
            dataStorageSizeInTBs(model.dataStorageSizeInTBs);
            dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            dbServers(model.dbServers);
            description(model.description);
            domain(model.domain);
            exadataStorageInTBsLowestScaledValue(model.exadataStorageInTBsLowestScaledValue);
            hostname(model.hostname);
            ocid(model.ocid);
            ociUrl(model.ociUrl);
            isMtlsEnabledVmCluster(model.isMtlsEnabledVmCluster);
            licenseModel(model.licenseModel);
            maintenanceWindow(model.maintenanceWindow);
            maxAcdsLowestScaledValue(model.maxAcdsLowestScaledValue);
            memoryPerOracleComputeUnitInGBs(model.memoryPerOracleComputeUnitInGBs);
            memorySizeInGBs(model.memorySizeInGBs);
            nodeCount(model.nodeCount);
            nonProvisionableAutonomousContainerDatabases(model.nonProvisionableAutonomousContainerDatabases);
            provisionableAutonomousContainerDatabases(model.provisionableAutonomousContainerDatabases);
            provisionedAutonomousContainerDatabases(model.provisionedAutonomousContainerDatabases);
            provisionedCpus(model.provisionedCpus);
            reclaimableCpus(model.reclaimableCpus);
            reservedCpus(model.reservedCpus);
            scanListenerPortNonTls(model.scanListenerPortNonTls);
            scanListenerPortTls(model.scanListenerPortTls);
            shape(model.shape);
            createdAt(model.createdAt);
            timeDatabaseSslCertificateExpires(model.timeDatabaseSslCertificateExpires);
            timeOrdsCertificateExpires(model.timeOrdsCertificateExpires);
            timeZone(model.timeZone);
            totalContainerDatabases(model.totalContainerDatabases);
        }

        public final String getCloudAutonomousVmClusterId() {
            return cloudAutonomousVmClusterId;
        }

        public final void setCloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
        }

        @Override
        public final Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            return this;
        }

        public final String getCloudAutonomousVmClusterArn() {
            return cloudAutonomousVmClusterArn;
        }

        public final void setCloudAutonomousVmClusterArn(String cloudAutonomousVmClusterArn) {
            this.cloudAutonomousVmClusterArn = cloudAutonomousVmClusterArn;
        }

        @Override
        public final Builder cloudAutonomousVmClusterArn(String cloudAutonomousVmClusterArn) {
            this.cloudAutonomousVmClusterArn = cloudAutonomousVmClusterArn;
            return this;
        }

        public final String getOdbNetworkId() {
            return odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final Float getPercentProgress() {
            return percentProgress;
        }

        public final void setPercentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getCloudExadataInfrastructureId() {
            return cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final Float getAutonomousDataStoragePercentage() {
            return autonomousDataStoragePercentage;
        }

        public final void setAutonomousDataStoragePercentage(Float autonomousDataStoragePercentage) {
            this.autonomousDataStoragePercentage = autonomousDataStoragePercentage;
        }

        @Override
        public final Builder autonomousDataStoragePercentage(Float autonomousDataStoragePercentage) {
            this.autonomousDataStoragePercentage = autonomousDataStoragePercentage;
            return this;
        }

        public final Double getAutonomousDataStorageSizeInTBs() {
            return autonomousDataStorageSizeInTBs;
        }

        public final void setAutonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
        }

        @Override
        public final Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            return this;
        }

        public final Double getAvailableAutonomousDataStorageSizeInTBs() {
            return availableAutonomousDataStorageSizeInTBs;
        }

        public final void setAvailableAutonomousDataStorageSizeInTBs(Double availableAutonomousDataStorageSizeInTBs) {
            this.availableAutonomousDataStorageSizeInTBs = availableAutonomousDataStorageSizeInTBs;
        }

        @Override
        public final Builder availableAutonomousDataStorageSizeInTBs(Double availableAutonomousDataStorageSizeInTBs) {
            this.availableAutonomousDataStorageSizeInTBs = availableAutonomousDataStorageSizeInTBs;
            return this;
        }

        public final Integer getAvailableContainerDatabases() {
            return availableContainerDatabases;
        }

        public final void setAvailableContainerDatabases(Integer availableContainerDatabases) {
            this.availableContainerDatabases = availableContainerDatabases;
        }

        @Override
        public final Builder availableContainerDatabases(Integer availableContainerDatabases) {
            this.availableContainerDatabases = availableContainerDatabases;
            return this;
        }

        public final Float getAvailableCpus() {
            return availableCpus;
        }

        public final void setAvailableCpus(Float availableCpus) {
            this.availableCpus = availableCpus;
        }

        @Override
        public final Builder availableCpus(Float availableCpus) {
            this.availableCpus = availableCpus;
            return this;
        }

        public final String getComputeModel() {
            return computeModel;
        }

        public final void setComputeModel(String computeModel) {
            this.computeModel = computeModel;
        }

        @Override
        public final Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            return this;
        }

        @Override
        public final Builder computeModel(ComputeModel computeModel) {
            this.computeModel(computeModel == null ? null : computeModel.toString());
            return this;
        }

        public final Integer getCpuCoreCount() {
            return cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final Integer getCpuCoreCountPerNode() {
            return cpuCoreCountPerNode;
        }

        public final void setCpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
        }

        @Override
        public final Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
            return this;
        }

        public final Float getCpuPercentage() {
            return cpuPercentage;
        }

        public final void setCpuPercentage(Float cpuPercentage) {
            this.cpuPercentage = cpuPercentage;
        }

        @Override
        public final Builder cpuPercentage(Float cpuPercentage) {
            this.cpuPercentage = cpuPercentage;
            return this;
        }

        public final Double getDataStorageSizeInGBs() {
            return dataStorageSizeInGBs;
        }

        public final void setDataStorageSizeInGBs(Double dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
        }

        @Override
        public final Builder dataStorageSizeInGBs(Double dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
            return this;
        }

        public final Double getDataStorageSizeInTBs() {
            return dataStorageSizeInTBs;
        }

        public final void setDataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        }

        @Override
        public final Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final Collection<String> getDbServers() {
            if (dbServers instanceof SdkAutoConstructList) {
                return null;
            }
            return dbServers;
        }

        public final void setDbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(String... dbServers) {
            dbServers(Arrays.asList(dbServers));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Double getExadataStorageInTBsLowestScaledValue() {
            return exadataStorageInTBsLowestScaledValue;
        }

        public final void setExadataStorageInTBsLowestScaledValue(Double exadataStorageInTBsLowestScaledValue) {
            this.exadataStorageInTBsLowestScaledValue = exadataStorageInTBsLowestScaledValue;
        }

        @Override
        public final Builder exadataStorageInTBsLowestScaledValue(Double exadataStorageInTBsLowestScaledValue) {
            this.exadataStorageInTBsLowestScaledValue = exadataStorageInTBsLowestScaledValue;
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getOcid() {
            return ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getOciUrl() {
            return ociUrl;
        }

        public final void setOciUrl(String ociUrl) {
            this.ociUrl = ociUrl;
        }

        @Override
        public final Builder ociUrl(String ociUrl) {
            this.ociUrl = ociUrl;
            return this;
        }

        public final Boolean getIsMtlsEnabledVmCluster() {
            return isMtlsEnabledVmCluster;
        }

        public final void setIsMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
        }

        @Override
        public final Builder isMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return maintenanceWindow != null ? maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getMaxAcdsLowestScaledValue() {
            return maxAcdsLowestScaledValue;
        }

        public final void setMaxAcdsLowestScaledValue(Integer maxAcdsLowestScaledValue) {
            this.maxAcdsLowestScaledValue = maxAcdsLowestScaledValue;
        }

        @Override
        public final Builder maxAcdsLowestScaledValue(Integer maxAcdsLowestScaledValue) {
            this.maxAcdsLowestScaledValue = maxAcdsLowestScaledValue;
            return this;
        }

        public final Integer getMemoryPerOracleComputeUnitInGBs() {
            return memoryPerOracleComputeUnitInGBs;
        }

        public final void setMemoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
        }

        @Override
        public final Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final Integer getNodeCount() {
            return nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final Integer getNonProvisionableAutonomousContainerDatabases() {
            return nonProvisionableAutonomousContainerDatabases;
        }

        public final void setNonProvisionableAutonomousContainerDatabases(Integer nonProvisionableAutonomousContainerDatabases) {
            this.nonProvisionableAutonomousContainerDatabases = nonProvisionableAutonomousContainerDatabases;
        }

        @Override
        public final Builder nonProvisionableAutonomousContainerDatabases(Integer nonProvisionableAutonomousContainerDatabases) {
            this.nonProvisionableAutonomousContainerDatabases = nonProvisionableAutonomousContainerDatabases;
            return this;
        }

        public final Integer getProvisionableAutonomousContainerDatabases() {
            return provisionableAutonomousContainerDatabases;
        }

        public final void setProvisionableAutonomousContainerDatabases(Integer provisionableAutonomousContainerDatabases) {
            this.provisionableAutonomousContainerDatabases = provisionableAutonomousContainerDatabases;
        }

        @Override
        public final Builder provisionableAutonomousContainerDatabases(Integer provisionableAutonomousContainerDatabases) {
            this.provisionableAutonomousContainerDatabases = provisionableAutonomousContainerDatabases;
            return this;
        }

        public final Integer getProvisionedAutonomousContainerDatabases() {
            return provisionedAutonomousContainerDatabases;
        }

        public final void setProvisionedAutonomousContainerDatabases(Integer provisionedAutonomousContainerDatabases) {
            this.provisionedAutonomousContainerDatabases = provisionedAutonomousContainerDatabases;
        }

        @Override
        public final Builder provisionedAutonomousContainerDatabases(Integer provisionedAutonomousContainerDatabases) {
            this.provisionedAutonomousContainerDatabases = provisionedAutonomousContainerDatabases;
            return this;
        }

        public final Float getProvisionedCpus() {
            return provisionedCpus;
        }

        public final void setProvisionedCpus(Float provisionedCpus) {
            this.provisionedCpus = provisionedCpus;
        }

        @Override
        public final Builder provisionedCpus(Float provisionedCpus) {
            this.provisionedCpus = provisionedCpus;
            return this;
        }

        public final Float getReclaimableCpus() {
            return reclaimableCpus;
        }

        public final void setReclaimableCpus(Float reclaimableCpus) {
            this.reclaimableCpus = reclaimableCpus;
        }

        @Override
        public final Builder reclaimableCpus(Float reclaimableCpus) {
            this.reclaimableCpus = reclaimableCpus;
            return this;
        }

        public final Float getReservedCpus() {
            return reservedCpus;
        }

        public final void setReservedCpus(Float reservedCpus) {
            this.reservedCpus = reservedCpus;
        }

        @Override
        public final Builder reservedCpus(Float reservedCpus) {
            this.reservedCpus = reservedCpus;
            return this;
        }

        public final Integer getScanListenerPortNonTls() {
            return scanListenerPortNonTls;
        }

        public final void setScanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
        }

        @Override
        public final Builder scanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
            return this;
        }

        public final Integer getScanListenerPortTls() {
            return scanListenerPortTls;
        }

        public final void setScanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
        }

        @Override
        public final Builder scanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
            return this;
        }

        public final String getShape() {
            return shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getTimeDatabaseSslCertificateExpires() {
            return timeDatabaseSslCertificateExpires;
        }

        public final void setTimeDatabaseSslCertificateExpires(Instant timeDatabaseSslCertificateExpires) {
            this.timeDatabaseSslCertificateExpires = timeDatabaseSslCertificateExpires;
        }

        @Override
        public final Builder timeDatabaseSslCertificateExpires(Instant timeDatabaseSslCertificateExpires) {
            this.timeDatabaseSslCertificateExpires = timeDatabaseSslCertificateExpires;
            return this;
        }

        public final Instant getTimeOrdsCertificateExpires() {
            return timeOrdsCertificateExpires;
        }

        public final void setTimeOrdsCertificateExpires(Instant timeOrdsCertificateExpires) {
            this.timeOrdsCertificateExpires = timeOrdsCertificateExpires;
        }

        @Override
        public final Builder timeOrdsCertificateExpires(Instant timeOrdsCertificateExpires) {
            this.timeOrdsCertificateExpires = timeOrdsCertificateExpires;
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final Integer getTotalContainerDatabases() {
            return totalContainerDatabases;
        }

        public final void setTotalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
        }

        @Override
        public final Builder totalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            return this;
        }

        @Override
        public CloudAutonomousVmCluster build() {
            return new CloudAutonomousVmCluster(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
