/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateIamRoleToResourceRequest extends OdbRequest implements
        ToCopyableBuilder<AssociateIamRoleToResourceRequest.Builder, AssociateIamRoleToResourceRequest> {
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamRoleArn").getter(getter(AssociateIamRoleToResourceRequest::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoleArn").build()).build();

    private static final SdkField<String> AWS_INTEGRATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsIntegration").getter(getter(AssociateIamRoleToResourceRequest::awsIntegrationAsString))
            .setter(setter(Builder::awsIntegration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIntegration").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(AssociateIamRoleToResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_ROLE_ARN_FIELD,
            AWS_INTEGRATION_FIELD, RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String iamRoleArn;

    private final String awsIntegration;

    private final String resourceArn;

    private AssociateIamRoleToResourceRequest(BuilderImpl builder) {
        super(builder);
        this.iamRoleArn = builder.iamRoleArn;
        this.awsIntegration = builder.awsIntegration;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role to associate with the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role to associate with the resource.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The Amazon Web Services integration configuration settings for the IAM service role association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsIntegration}
     * will return {@link SupportedAwsIntegration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #awsIntegrationAsString}.
     * </p>
     * 
     * @return The Amazon Web Services integration configuration settings for the IAM service role association.
     * @see SupportedAwsIntegration
     */
    public final SupportedAwsIntegration awsIntegration() {
        return SupportedAwsIntegration.fromValue(awsIntegration);
    }

    /**
     * <p>
     * The Amazon Web Services integration configuration settings for the IAM service role association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsIntegration}
     * will return {@link SupportedAwsIntegration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #awsIntegrationAsString}.
     * </p>
     * 
     * @return The Amazon Web Services integration configuration settings for the IAM service role association.
     * @see SupportedAwsIntegration
     */
    public final String awsIntegrationAsString() {
        return awsIntegration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target resource to associate with the IAM service role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target resource to associate with the IAM service role.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(awsIntegrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateIamRoleToResourceRequest)) {
            return false;
        }
        AssociateIamRoleToResourceRequest other = (AssociateIamRoleToResourceRequest) obj;
        return Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(awsIntegrationAsString(), other.awsIntegrationAsString())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateIamRoleToResourceRequest").add("IamRoleArn", iamRoleArn())
                .add("AwsIntegration", awsIntegrationAsString()).add("ResourceArn", resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "awsIntegration":
            return Optional.ofNullable(clazz.cast(awsIntegrationAsString()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("iamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("awsIntegration", AWS_INTEGRATION_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateIamRoleToResourceRequest, T> g) {
        return obj -> g.apply((AssociateIamRoleToResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateIamRoleToResourceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role to associate with the resource.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role to associate with the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The Amazon Web Services integration configuration settings for the IAM service role association.
         * </p>
         * 
         * @param awsIntegration
         *        The Amazon Web Services integration configuration settings for the IAM service role association.
         * @see SupportedAwsIntegration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedAwsIntegration
         */
        Builder awsIntegration(String awsIntegration);

        /**
         * <p>
         * The Amazon Web Services integration configuration settings for the IAM service role association.
         * </p>
         * 
         * @param awsIntegration
         *        The Amazon Web Services integration configuration settings for the IAM service role association.
         * @see SupportedAwsIntegration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedAwsIntegration
         */
        Builder awsIntegration(SupportedAwsIntegration awsIntegration);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target resource to associate with the IAM service role.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the target resource to associate with the IAM service role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private String iamRoleArn;

        private String awsIntegration;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateIamRoleToResourceRequest model) {
            super(model);
            iamRoleArn(model.iamRoleArn);
            awsIntegration(model.awsIntegration);
            resourceArn(model.resourceArn);
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getAwsIntegration() {
            return awsIntegration;
        }

        public final void setAwsIntegration(String awsIntegration) {
            this.awsIntegration = awsIntegration;
        }

        @Override
        public final Builder awsIntegration(String awsIntegration) {
            this.awsIntegration = awsIntegration;
            return this;
        }

        @Override
        public final Builder awsIntegration(SupportedAwsIntegration awsIntegration) {
            this.awsIntegration(awsIntegration == null ? null : awsIntegration.toString());
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateIamRoleToResourceRequest build() {
            return new AssociateIamRoleToResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
