/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse;
import software.amazon.awssdk.services.odb.model.OdbNetworkSummary;

public class ListOdbNetworksIterable
implements SdkIterable<ListOdbNetworksResponse> {
    private final OdbClient client;
    private final ListOdbNetworksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOdbNetworksIterable(OdbClient client, ListOdbNetworksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOdbNetworksResponseFetcher();
    }

    public Iterator<ListOdbNetworksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OdbNetworkSummary> odbNetworks() {
        Function<ListOdbNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.odbNetworks() != null) {
                return response.odbNetworks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOdbNetworksResponseFetcher
    implements SyncPageFetcher<ListOdbNetworksResponse> {
        private ListOdbNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListOdbNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOdbNetworksResponse nextPage(ListOdbNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListOdbNetworksIterable.this.client.listOdbNetworks(ListOdbNetworksIterable.this.firstRequest);
            }
            return ListOdbNetworksIterable.this.client.listOdbNetworks((ListOdbNetworksRequest)((Object)ListOdbNetworksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

