/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.odb.auth.scheme.OdbAuthSchemeParams;
import software.amazon.awssdk.services.odb.auth.scheme.internal.DefaultOdbAuthSchemeProvider;
import software.amazon.awssdk.services.odb.auth.scheme.internal.PreferredOdbAuthSchemeProvider;

@SdkPublicApi
public interface OdbAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(OdbAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<OdbAuthSchemeParams.Builder> consumer) {
        OdbAuthSchemeParams.Builder builder = OdbAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static OdbAuthSchemeProvider defaultProvider() {
        return DefaultOdbAuthSchemeProvider.create();
    }

    public static OdbAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredOdbAuthSchemeProvider(OdbAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

