/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.DbServerSummary;
import software.amazon.awssdk.services.odb.model.ListDbServersRequest;
import software.amazon.awssdk.services.odb.model.ListDbServersResponse;

public class ListDbServersPublisher
implements SdkPublisher<ListDbServersResponse> {
    private final OdbAsyncClient client;
    private final ListDbServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDbServersPublisher(OdbAsyncClient client, ListDbServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDbServersPublisher(OdbAsyncClient client, ListDbServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDbServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDbServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DbServerSummary> dbServers() {
        Function<ListDbServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbServers() != null) {
                return response.dbServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDbServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDbServersResponseFetcher
    implements AsyncPageFetcher<ListDbServersResponse> {
        private ListDbServersResponseFetcher() {
        }

        public boolean hasNextPage(ListDbServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDbServersResponse> nextPage(ListDbServersResponse previousPage) {
            if (previousPage == null) {
                return ListDbServersPublisher.this.client.listDbServers(ListDbServersPublisher.this.firstRequest);
            }
            return ListDbServersPublisher.this.client.listDbServers((ListDbServersRequest)((Object)ListDbServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

