/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.DbNodeListCopier;
import software.amazon.awssdk.services.odb.model.DbNodeSummary;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDbNodesResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListDbNodesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDbNodesResponse.getter(ListDbNodesResponse::nextToken)).setter(ListDbNodesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<DbNodeSummary>> DB_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbNodes").getter(ListDbNodesResponse.getter(ListDbNodesResponse::dbNodes)).setter(ListDbNodesResponse.setter(Builder::dbNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DbNodeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DB_NODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDbNodesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<DbNodeSummary> dbNodes;

    private ListDbNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.dbNodes = builder.dbNodes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDbNodes() {
        return this.dbNodes != null && !(this.dbNodes instanceof SdkAutoConstructList);
    }

    public final List<DbNodeSummary> dbNodes() {
        return this.dbNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbNodes() ? this.dbNodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDbNodesResponse)) {
            return false;
        }
        ListDbNodesResponse other = (ListDbNodesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDbNodes() == other.hasDbNodes() && Objects.equals(this.dbNodes(), other.dbNodes());
    }

    public final String toString() {
        return ToString.builder((String)"ListDbNodesResponse").add("NextToken", (Object)this.nextToken()).add("DbNodes", this.hasDbNodes() ? this.dbNodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "dbNodes": {
                return Optional.ofNullable(clazz.cast(this.dbNodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("dbNodes", DB_NODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDbNodesResponse, T> g) {
        return obj -> g.apply((ListDbNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DbNodeSummary> dbNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDbNodesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.dbNodes(model.dbNodes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DbNodeSummary.Builder> getDbNodes() {
            List<DbNodeSummary.Builder> result = DbNodeListCopier.copyToBuilder(this.dbNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbNodes(Collection<DbNodeSummary.BuilderImpl> dbNodes) {
            this.dbNodes = DbNodeListCopier.copyFromBuilder(dbNodes);
        }

        @Override
        public final Builder dbNodes(Collection<DbNodeSummary> dbNodes) {
            this.dbNodes = DbNodeListCopier.copy(dbNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbNodes(DbNodeSummary ... dbNodes) {
            this.dbNodes(Arrays.asList(dbNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbNodes(Consumer<DbNodeSummary.Builder> ... dbNodes) {
            this.dbNodes(Stream.of(dbNodes).map(c -> (DbNodeSummary)((DbNodeSummary.Builder)DbNodeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDbNodesResponse build() {
            return new ListDbNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDbNodesResponse> {
        public Builder nextToken(String var1);

        public Builder dbNodes(Collection<DbNodeSummary> var1);

        public Builder dbNodes(DbNodeSummary ... var1);

        public Builder dbNodes(Consumer<DbNodeSummary.Builder> ... var1);
    }
}

