/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Exadata infrastructure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudExadataInfrastructure implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudExadataInfrastructure.Builder, CloudExadataInfrastructure> {
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudExadataInfrastructureId")
            .getter(getter(CloudExadataInfrastructure::cloudExadataInfrastructureId))
            .setter(setter(Builder::cloudExadataInfrastructureId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId")
                    .build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CloudExadataInfrastructure::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CloudExadataInfrastructure::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(CloudExadataInfrastructure::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudExadataInfrastructureArn")
            .getter(getter(CloudExadataInfrastructure::cloudExadataInfrastructureArn))
            .setter(setter(Builder::cloudExadataInfrastructureArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureArn")
                    .build()).build();

    private static final SdkField<Integer> ACTIVATED_STORAGE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("activatedStorageCount").getter(getter(CloudExadataInfrastructure::activatedStorageCount))
            .setter(setter(Builder::activatedStorageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activatedStorageCount").build())
            .build();

    private static final SdkField<Integer> ADDITIONAL_STORAGE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("additionalStorageCount").getter(getter(CloudExadataInfrastructure::additionalStorageCount))
            .setter(setter(Builder::additionalStorageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalStorageCount").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("availableStorageSizeInGBs")
            .getter(getter(CloudExadataInfrastructure::availableStorageSizeInGBs))
            .setter(setter(Builder::availableStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableStorageSizeInGBs").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(CloudExadataInfrastructure::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZoneId").getter(getter(CloudExadataInfrastructure::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build())
            .build();

    private static final SdkField<Integer> COMPUTE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("computeCount").getter(getter(CloudExadataInfrastructure::computeCount))
            .setter(setter(Builder::computeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeCount").build()).build();

    private static final SdkField<Integer> CPU_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cpuCount").getter(getter(CloudExadataInfrastructure::cpuCount)).setter(setter(Builder::cpuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCount").build()).build();

    private static final SdkField<List<CustomerContact>> CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD = SdkField
            .<List<CustomerContact>> builder(MarshallingType.LIST)
            .memberName("customerContactsToSendToOCI")
            .getter(getter(CloudExadataInfrastructure::customerContactsToSendToOCI))
            .setter(setter(Builder::customerContactsToSendToOCI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerContactsToSendToOCI")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomerContact> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomerContact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("dataStorageSizeInTBs").getter(getter(CloudExadataInfrastructure::dataStorageSizeInTBs))
            .setter(setter(Builder::dataStorageSizeInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInTBs").build())
            .build();

    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs")
            .getter(getter(CloudExadataInfrastructure::dbNodeStorageSizeInGBs)).setter(setter(Builder::dbNodeStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build())
            .build();

    private static final SdkField<String> DB_SERVER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbServerVersion").getter(getter(CloudExadataInfrastructure::dbServerVersion))
            .setter(setter(Builder::dbServerVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerVersion").build()).build();

    private static final SdkField<String> LAST_MAINTENANCE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastMaintenanceRunId").getter(getter(CloudExadataInfrastructure::lastMaintenanceRunId))
            .setter(setter(Builder::lastMaintenanceRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastMaintenanceRunId").build())
            .build();

    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField
            .<MaintenanceWindow> builder(MarshallingType.SDK_POJO).memberName("maintenanceWindow")
            .getter(getter(CloudExadataInfrastructure::maintenanceWindow)).setter(setter(Builder::maintenanceWindow))
            .constructor(MaintenanceWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()).build();

    private static final SdkField<Integer> MAX_CPU_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCpuCount").getter(getter(CloudExadataInfrastructure::maxCpuCount))
            .setter(setter(Builder::maxCpuCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpuCount").build()).build();

    private static final SdkField<Double> MAX_DATA_STORAGE_IN_T_BS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("maxDataStorageInTBs").getter(getter(CloudExadataInfrastructure::maxDataStorageInTBs))
            .setter(setter(Builder::maxDataStorageInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDataStorageInTBs").build())
            .build();

    private static final SdkField<Integer> MAX_DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("maxDbNodeStorageSizeInGBs")
            .getter(getter(CloudExadataInfrastructure::maxDbNodeStorageSizeInGBs))
            .setter(setter(Builder::maxDbNodeStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDbNodeStorageSizeInGBs").build())
            .build();

    private static final SdkField<Integer> MAX_MEMORY_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxMemoryInGBs").getter(getter(CloudExadataInfrastructure::maxMemoryInGBs))
            .setter(setter(Builder::maxMemoryInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxMemoryInGBs").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("memorySizeInGBs").getter(getter(CloudExadataInfrastructure::memorySizeInGBs))
            .setter(setter(Builder::memorySizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()).build();

    private static final SdkField<String> MONTHLY_DB_SERVER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monthlyDbServerVersion").getter(getter(CloudExadataInfrastructure::monthlyDbServerVersion))
            .setter(setter(Builder::monthlyDbServerVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyDbServerVersion").build())
            .build();

    private static final SdkField<String> MONTHLY_STORAGE_SERVER_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("monthlyStorageServerVersion")
            .getter(getter(CloudExadataInfrastructure::monthlyStorageServerVersion))
            .setter(setter(Builder::monthlyStorageServerVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyStorageServerVersion")
                    .build()).build();

    private static final SdkField<String> NEXT_MAINTENANCE_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextMaintenanceRunId").getter(getter(CloudExadataInfrastructure::nextMaintenanceRunId))
            .setter(setter(Builder::nextMaintenanceRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMaintenanceRunId").build())
            .build();

    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociResourceAnchorName").getter(getter(CloudExadataInfrastructure::ociResourceAnchorName))
            .setter(setter(Builder::ociResourceAnchorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build())
            .build();

    private static final SdkField<String> OCI_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ociUrl")
            .getter(getter(CloudExadataInfrastructure::ociUrl)).setter(setter(Builder::ociUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociUrl").build()).build();

    private static final SdkField<String> OCID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ocid")
            .getter(getter(CloudExadataInfrastructure::ocid)).setter(setter(Builder::ocid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()).build();

    private static final SdkField<String> SHAPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("shape")
            .getter(getter(CloudExadataInfrastructure::shape)).setter(setter(Builder::shape))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()).build();

    private static final SdkField<Integer> STORAGE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCount").getter(getter(CloudExadataInfrastructure::storageCount))
            .setter(setter(Builder::storageCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCount").build()).build();

    private static final SdkField<String> STORAGE_SERVER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageServerVersion").getter(getter(CloudExadataInfrastructure::storageServerVersion))
            .setter(setter(Builder::storageServerVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageServerVersion").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CloudExadataInfrastructure::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> TOTAL_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalStorageSizeInGBs").getter(getter(CloudExadataInfrastructure::totalStorageSizeInGBs))
            .setter(setter(Builder::totalStorageSizeInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalStorageSizeInGBs").build())
            .build();

    private static final SdkField<Float> PERCENT_PROGRESS_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("percentProgress").getter(getter(CloudExadataInfrastructure::percentProgress))
            .setter(setter(Builder::percentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentProgress").build()).build();

    private static final SdkField<String> DATABASE_SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseServerType").getter(getter(CloudExadataInfrastructure::databaseServerType))
            .setter(setter(Builder::databaseServerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseServerType").build())
            .build();

    private static final SdkField<String> STORAGE_SERVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageServerType").getter(getter(CloudExadataInfrastructure::storageServerType))
            .setter(setter(Builder::storageServerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageServerType").build()).build();

    private static final SdkField<String> COMPUTE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeModel").getter(getter(CloudExadataInfrastructure::computeModelAsString))
            .setter(setter(Builder::computeModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeModel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            CLOUD_EXADATA_INFRASTRUCTURE_ARN_FIELD, ACTIVATED_STORAGE_COUNT_FIELD, ADDITIONAL_STORAGE_COUNT_FIELD,
            AVAILABLE_STORAGE_SIZE_IN_G_BS_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, COMPUTE_COUNT_FIELD,
            CPU_COUNT_FIELD, CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD, DATA_STORAGE_SIZE_IN_T_BS_FIELD,
            DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVER_VERSION_FIELD, LAST_MAINTENANCE_RUN_ID_FIELD, MAINTENANCE_WINDOW_FIELD,
            MAX_CPU_COUNT_FIELD, MAX_DATA_STORAGE_IN_T_BS_FIELD, MAX_DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD,
            MAX_MEMORY_IN_G_BS_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, MONTHLY_DB_SERVER_VERSION_FIELD,
            MONTHLY_STORAGE_SERVER_VERSION_FIELD, NEXT_MAINTENANCE_RUN_ID_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD, OCI_URL_FIELD,
            OCID_FIELD, SHAPE_FIELD, STORAGE_COUNT_FIELD, STORAGE_SERVER_VERSION_FIELD, CREATED_AT_FIELD,
            TOTAL_STORAGE_SIZE_IN_G_BS_FIELD, PERCENT_PROGRESS_FIELD, DATABASE_SERVER_TYPE_FIELD, STORAGE_SERVER_TYPE_FIELD,
            COMPUTE_MODEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cloudExadataInfrastructureId;

    private final String displayName;

    private final String status;

    private final String statusReason;

    private final String cloudExadataInfrastructureArn;

    private final Integer activatedStorageCount;

    private final Integer additionalStorageCount;

    private final Integer availableStorageSizeInGBs;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Integer computeCount;

    private final Integer cpuCount;

    private final List<CustomerContact> customerContactsToSendToOCI;

    private final Double dataStorageSizeInTBs;

    private final Integer dbNodeStorageSizeInGBs;

    private final String dbServerVersion;

    private final String lastMaintenanceRunId;

    private final MaintenanceWindow maintenanceWindow;

    private final Integer maxCpuCount;

    private final Double maxDataStorageInTBs;

    private final Integer maxDbNodeStorageSizeInGBs;

    private final Integer maxMemoryInGBs;

    private final Integer memorySizeInGBs;

    private final String monthlyDbServerVersion;

    private final String monthlyStorageServerVersion;

    private final String nextMaintenanceRunId;

    private final String ociResourceAnchorName;

    private final String ociUrl;

    private final String ocid;

    private final String shape;

    private final Integer storageCount;

    private final String storageServerVersion;

    private final Instant createdAt;

    private final Integer totalStorageSizeInGBs;

    private final Float percentProgress;

    private final String databaseServerType;

    private final String storageServerType;

    private final String computeModel;

    private CloudExadataInfrastructure(BuilderImpl builder) {
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.cloudExadataInfrastructureArn = builder.cloudExadataInfrastructureArn;
        this.activatedStorageCount = builder.activatedStorageCount;
        this.additionalStorageCount = builder.additionalStorageCount;
        this.availableStorageSizeInGBs = builder.availableStorageSizeInGBs;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.computeCount = builder.computeCount;
        this.cpuCount = builder.cpuCount;
        this.customerContactsToSendToOCI = builder.customerContactsToSendToOCI;
        this.dataStorageSizeInTBs = builder.dataStorageSizeInTBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServerVersion = builder.dbServerVersion;
        this.lastMaintenanceRunId = builder.lastMaintenanceRunId;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.maxCpuCount = builder.maxCpuCount;
        this.maxDataStorageInTBs = builder.maxDataStorageInTBs;
        this.maxDbNodeStorageSizeInGBs = builder.maxDbNodeStorageSizeInGBs;
        this.maxMemoryInGBs = builder.maxMemoryInGBs;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.monthlyDbServerVersion = builder.monthlyDbServerVersion;
        this.monthlyStorageServerVersion = builder.monthlyStorageServerVersion;
        this.nextMaintenanceRunId = builder.nextMaintenanceRunId;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.ociUrl = builder.ociUrl;
        this.ocid = builder.ocid;
        this.shape = builder.shape;
        this.storageCount = builder.storageCount;
        this.storageServerVersion = builder.storageServerVersion;
        this.createdAt = builder.createdAt;
        this.totalStorageSizeInGBs = builder.totalStorageSizeInGBs;
        this.percentProgress = builder.percentProgress;
        this.databaseServerType = builder.databaseServerType;
        this.storageServerType = builder.storageServerType;
        this.computeModel = builder.computeModel;
    }

    /**
     * <p>
     * The unique identifier for the Exadata infrastructure.
     * </p>
     * 
     * @return The unique identifier for the Exadata infrastructure.
     */
    public final String cloudExadataInfrastructureId() {
        return cloudExadataInfrastructureId;
    }

    /**
     * <p>
     * The user-friendly name for the Exadata infrastructure.
     * </p>
     * 
     * @return The user-friendly name for the Exadata infrastructure.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The current status of the Exadata infrastructure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Exadata infrastructure.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Exadata infrastructure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Exadata infrastructure.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the status of the Exadata infrastructure.
     * </p>
     * 
     * @return Additional information about the status of the Exadata infrastructure.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Exadata infrastructure.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Exadata infrastructure.
     */
    public final String cloudExadataInfrastructureArn() {
        return cloudExadataInfrastructureArn;
    }

    /**
     * <p>
     * The number of storage servers requested for the Exadata infrastructure.
     * </p>
     * 
     * @return The number of storage servers requested for the Exadata infrastructure.
     */
    public final Integer activatedStorageCount() {
        return activatedStorageCount;
    }

    /**
     * <p>
     * The number of storage servers requested for the Exadata infrastructure.
     * </p>
     * 
     * @return The number of storage servers requested for the Exadata infrastructure.
     */
    public final Integer additionalStorageCount() {
        return additionalStorageCount;
    }

    /**
     * <p>
     * The amount of available storage, in gigabytes (GB), for the Exadata infrastructure.
     * </p>
     * 
     * @return The amount of available storage, in gigabytes (GB), for the Exadata infrastructure.
     */
    public final Integer availableStorageSizeInGBs() {
        return availableStorageSizeInGBs;
    }

    /**
     * <p>
     * The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
     * </p>
     * 
     * @return The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The AZ ID of the AZ where the Exadata infrastructure is located.
     * </p>
     * 
     * @return The AZ ID of the AZ where the Exadata infrastructure is located.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The number of database servers for the Exadata infrastructure.
     * </p>
     * 
     * @return The number of database servers for the Exadata infrastructure.
     */
    public final Integer computeCount() {
        return computeCount;
    }

    /**
     * <p>
     * The total number of CPU cores that are allocated to the Exadata infrastructure.
     * </p>
     * 
     * @return The total number of CPU cores that are allocated to the Exadata infrastructure.
     */
    public final Integer cpuCount() {
        return cpuCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerContactsToSendToOCI property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomerContactsToSendToOCI() {
        return customerContactsToSendToOCI != null && !(customerContactsToSendToOCI instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata
     * infrastructure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerContactsToSendToOCI} method.
     * </p>
     * 
     * @return The email addresses of contacts to receive notification from Oracle about maintenance updates for the
     *         Exadata infrastructure.
     */
    public final List<CustomerContact> customerContactsToSendToOCI() {
        return customerContactsToSendToOCI;
    }

    /**
     * <p>
     * The size of the Exadata infrastructure's data disk group, in terabytes (TB).
     * </p>
     * 
     * @return The size of the Exadata infrastructure's data disk group, in terabytes (TB).
     */
    public final Double dataStorageSizeInTBs() {
        return dataStorageSizeInTBs;
    }

    /**
     * <p>
     * The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
     * </p>
     * 
     * @return The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
     */
    public final Integer dbNodeStorageSizeInGBs() {
        return dbNodeStorageSizeInGBs;
    }

    /**
     * <p>
     * The software version of the database servers (dom0) in the Exadata infrastructure.
     * </p>
     * 
     * @return The software version of the database servers (dom0) in the Exadata infrastructure.
     */
    public final String dbServerVersion() {
        return dbServerVersion;
    }

    /**
     * <p>
     * The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata infrastructure.
     * </p>
     * 
     * @return The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata infrastructure.
     */
    public final String lastMaintenanceRunId() {
        return lastMaintenanceRunId;
    }

    /**
     * <p>
     * The scheduling details for the maintenance window. Patching and system updates take place during the maintenance
     * window.
     * </p>
     * 
     * @return The scheduling details for the maintenance window. Patching and system updates take place during the
     *         maintenance window.
     */
    public final MaintenanceWindow maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * The total number of CPU cores available on the Exadata infrastructure.
     * </p>
     * 
     * @return The total number of CPU cores available on the Exadata infrastructure.
     */
    public final Integer maxCpuCount() {
        return maxCpuCount;
    }

    /**
     * <p>
     * The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata infrastructure.
     * </p>
     * 
     * @return The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata
     *         infrastructure.
     */
    public final Double maxDataStorageInTBs() {
        return maxDataStorageInTBs;
    }

    /**
     * <p>
     * The total amount of local node storage, in gigabytes (GB), that's available on the Exadata infrastructure.
     * </p>
     * 
     * @return The total amount of local node storage, in gigabytes (GB), that's available on the Exadata
     *         infrastructure.
     */
    public final Integer maxDbNodeStorageSizeInGBs() {
        return maxDbNodeStorageSizeInGBs;
    }

    /**
     * <p>
     * The total amount of memory, in gigabytes (GB), that's available on the Exadata infrastructure.
     * </p>
     * 
     * @return The total amount of memory, in gigabytes (GB), that's available on the Exadata infrastructure.
     */
    public final Integer maxMemoryInGBs() {
        return maxMemoryInGBs;
    }

    /**
     * <p>
     * The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure.
     * </p>
     * 
     * @return The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure.
     */
    public final Integer memorySizeInGBs() {
        return memorySizeInGBs;
    }

    /**
     * <p>
     * The monthly software version of the database servers installed on the Exadata infrastructure.
     * </p>
     * 
     * @return The monthly software version of the database servers installed on the Exadata infrastructure.
     */
    public final String monthlyDbServerVersion() {
        return monthlyDbServerVersion;
    }

    /**
     * <p>
     * The monthly software version of the storage servers installed on the Exadata infrastructure.
     * </p>
     * 
     * @return The monthly software version of the storage servers installed on the Exadata infrastructure.
     */
    public final String monthlyStorageServerVersion() {
        return monthlyStorageServerVersion;
    }

    /**
     * <p>
     * The OCID of the next maintenance run for the Exadata infrastructure.
     * </p>
     * 
     * @return The OCID of the next maintenance run for the Exadata infrastructure.
     */
    public final String nextMaintenanceRunId() {
        return nextMaintenanceRunId;
    }

    /**
     * <p>
     * The name of the OCI resource anchor for the Exadata infrastructure.
     * </p>
     * 
     * @return The name of the OCI resource anchor for the Exadata infrastructure.
     */
    public final String ociResourceAnchorName() {
        return ociResourceAnchorName;
    }

    /**
     * <p>
     * The HTTPS link to the Exadata infrastructure in OCI.
     * </p>
     * 
     * @return The HTTPS link to the Exadata infrastructure in OCI.
     */
    public final String ociUrl() {
        return ociUrl;
    }

    /**
     * <p>
     * The OCID of the Exadata infrastructure.
     * </p>
     * 
     * @return The OCID of the Exadata infrastructure.
     */
    public final String ocid() {
        return ocid;
    }

    /**
     * <p>
     * The model name of the Exadata infrastructure.
     * </p>
     * 
     * @return The model name of the Exadata infrastructure.
     */
    public final String shape() {
        return shape;
    }

    /**
     * <p>
     * The number of storage servers that are activated for the Exadata infrastructure.
     * </p>
     * 
     * @return The number of storage servers that are activated for the Exadata infrastructure.
     */
    public final Integer storageCount() {
        return storageCount;
    }

    /**
     * <p>
     * The software version of the storage servers on the Exadata infrastructure.
     * </p>
     * 
     * @return The software version of the storage servers on the Exadata infrastructure.
     */
    public final String storageServerVersion() {
        return storageServerVersion;
    }

    /**
     * <p>
     * The date and time when the Exadata infrastructure was created.
     * </p>
     * 
     * @return The date and time when the Exadata infrastructure was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The total amount of storage, in gigabytes (GB), on the the Exadata infrastructure.
     * </p>
     * 
     * @return The total amount of storage, in gigabytes (GB), on the the Exadata infrastructure.
     */
    public final Integer totalStorageSizeInGBs() {
        return totalStorageSizeInGBs;
    }

    /**
     * <p>
     * The amount of progress made on the current operation on the Exadata infrastructure, expressed as a percentage.
     * </p>
     * 
     * @return The amount of progress made on the current operation on the Exadata infrastructure, expressed as a
     *         percentage.
     */
    public final Float percentProgress() {
        return percentProgress;
    }

    /**
     * <p>
     * The database server model type of the Exadata infrastructure. For the list of valid model names, use the
     * <code>ListDbSystemShapes</code> operation.
     * </p>
     * 
     * @return The database server model type of the Exadata infrastructure. For the list of valid model names, use the
     *         <code>ListDbSystemShapes</code> operation.
     */
    public final String databaseServerType() {
        return databaseServerType;
    }

    /**
     * <p>
     * The storage server model type of the Exadata infrastructure. For the list of valid model names, use the
     * <code>ListDbSystemShapes</code> operation.
     * </p>
     * 
     * @return The storage server model type of the Exadata infrastructure. For the list of valid model names, use the
     *         <code>ListDbSystemShapes</code> operation.
     */
    public final String storageServerType() {
        return storageServerType;
    }

    /**
     * <p>
     * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
     * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute
     * and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical
     * core of a processor with hyper-threading enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeModel} will
     * return {@link ComputeModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModelAsString}.
     * </p>
     * 
     * @return The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
     *         abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
     *         from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
     *         OCPUs are based on the physical core of a processor with hyper-threading enabled.
     * @see ComputeModel
     */
    public final ComputeModel computeModel() {
        return ComputeModel.fromValue(computeModel);
    }

    /**
     * <p>
     * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
     * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of compute
     * and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on the physical
     * core of a processor with hyper-threading enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeModel} will
     * return {@link ComputeModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModelAsString}.
     * </p>
     * 
     * @return The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
     *         abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
     *         from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
     *         OCPUs are based on the physical core of a processor with hyper-threading enabled.
     * @see ComputeModel
     */
    public final String computeModelAsString() {
        return computeModel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructureArn());
        hashCode = 31 * hashCode + Objects.hashCode(activatedStorageCount());
        hashCode = 31 * hashCode + Objects.hashCode(additionalStorageCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(computeCount());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerContactsToSendToOCI() ? customerContactsToSendToOCI() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(dbServerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(lastMaintenanceRunId());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(maxCpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(maxDataStorageInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(maxDbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(maxMemoryInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(monthlyDbServerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(monthlyStorageServerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(nextMaintenanceRunId());
        hashCode = 31 * hashCode + Objects.hashCode(ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(ociUrl());
        hashCode = 31 * hashCode + Objects.hashCode(ocid());
        hashCode = 31 * hashCode + Objects.hashCode(shape());
        hashCode = 31 * hashCode + Objects.hashCode(storageCount());
        hashCode = 31 * hashCode + Objects.hashCode(storageServerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(totalStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(databaseServerType());
        hashCode = 31 * hashCode + Objects.hashCode(storageServerType());
        hashCode = 31 * hashCode + Objects.hashCode(computeModelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudExadataInfrastructure)) {
            return false;
        }
        CloudExadataInfrastructure other = (CloudExadataInfrastructure) obj;
        return Objects.equals(cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(cloudExadataInfrastructureArn(), other.cloudExadataInfrastructureArn())
                && Objects.equals(activatedStorageCount(), other.activatedStorageCount())
                && Objects.equals(additionalStorageCount(), other.additionalStorageCount())
                && Objects.equals(availableStorageSizeInGBs(), other.availableStorageSizeInGBs())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(computeCount(), other.computeCount()) && Objects.equals(cpuCount(), other.cpuCount())
                && hasCustomerContactsToSendToOCI() == other.hasCustomerContactsToSendToOCI()
                && Objects.equals(customerContactsToSendToOCI(), other.customerContactsToSendToOCI())
                && Objects.equals(dataStorageSizeInTBs(), other.dataStorageSizeInTBs())
                && Objects.equals(dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs())
                && Objects.equals(dbServerVersion(), other.dbServerVersion())
                && Objects.equals(lastMaintenanceRunId(), other.lastMaintenanceRunId())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow())
                && Objects.equals(maxCpuCount(), other.maxCpuCount())
                && Objects.equals(maxDataStorageInTBs(), other.maxDataStorageInTBs())
                && Objects.equals(maxDbNodeStorageSizeInGBs(), other.maxDbNodeStorageSizeInGBs())
                && Objects.equals(maxMemoryInGBs(), other.maxMemoryInGBs())
                && Objects.equals(memorySizeInGBs(), other.memorySizeInGBs())
                && Objects.equals(monthlyDbServerVersion(), other.monthlyDbServerVersion())
                && Objects.equals(monthlyStorageServerVersion(), other.monthlyStorageServerVersion())
                && Objects.equals(nextMaintenanceRunId(), other.nextMaintenanceRunId())
                && Objects.equals(ociResourceAnchorName(), other.ociResourceAnchorName())
                && Objects.equals(ociUrl(), other.ociUrl()) && Objects.equals(ocid(), other.ocid())
                && Objects.equals(shape(), other.shape()) && Objects.equals(storageCount(), other.storageCount())
                && Objects.equals(storageServerVersion(), other.storageServerVersion())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(totalStorageSizeInGBs(), other.totalStorageSizeInGBs())
                && Objects.equals(percentProgress(), other.percentProgress())
                && Objects.equals(databaseServerType(), other.databaseServerType())
                && Objects.equals(storageServerType(), other.storageServerType())
                && Objects.equals(computeModelAsString(), other.computeModelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudExadataInfrastructure").add("CloudExadataInfrastructureId", cloudExadataInfrastructureId())
                .add("DisplayName", displayName()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("CloudExadataInfrastructureArn", cloudExadataInfrastructureArn())
                .add("ActivatedStorageCount", activatedStorageCount()).add("AdditionalStorageCount", additionalStorageCount())
                .add("AvailableStorageSizeInGBs", availableStorageSizeInGBs()).add("AvailabilityZone", availabilityZone())
                .add("AvailabilityZoneId", availabilityZoneId()).add("ComputeCount", computeCount()).add("CpuCount", cpuCount())
                .add("CustomerContactsToSendToOCI", hasCustomerContactsToSendToOCI() ? customerContactsToSendToOCI() : null)
                .add("DataStorageSizeInTBs", dataStorageSizeInTBs()).add("DbNodeStorageSizeInGBs", dbNodeStorageSizeInGBs())
                .add("DbServerVersion", dbServerVersion()).add("LastMaintenanceRunId", lastMaintenanceRunId())
                .add("MaintenanceWindow", maintenanceWindow()).add("MaxCpuCount", maxCpuCount())
                .add("MaxDataStorageInTBs", maxDataStorageInTBs()).add("MaxDbNodeStorageSizeInGBs", maxDbNodeStorageSizeInGBs())
                .add("MaxMemoryInGBs", maxMemoryInGBs()).add("MemorySizeInGBs", memorySizeInGBs())
                .add("MonthlyDbServerVersion", monthlyDbServerVersion())
                .add("MonthlyStorageServerVersion", monthlyStorageServerVersion())
                .add("NextMaintenanceRunId", nextMaintenanceRunId()).add("OciResourceAnchorName", ociResourceAnchorName())
                .add("OciUrl", ociUrl()).add("Ocid", ocid()).add("Shape", shape()).add("StorageCount", storageCount())
                .add("StorageServerVersion", storageServerVersion()).add("CreatedAt", createdAt())
                .add("TotalStorageSizeInGBs", totalStorageSizeInGBs()).add("PercentProgress", percentProgress())
                .add("DatabaseServerType", databaseServerType()).add("StorageServerType", storageServerType())
                .add("ComputeModel", computeModelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudExadataInfrastructureId":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructureId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "cloudExadataInfrastructureArn":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructureArn()));
        case "activatedStorageCount":
            return Optional.ofNullable(clazz.cast(activatedStorageCount()));
        case "additionalStorageCount":
            return Optional.ofNullable(clazz.cast(additionalStorageCount()));
        case "availableStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(availableStorageSizeInGBs()));
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "availabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "computeCount":
            return Optional.ofNullable(clazz.cast(computeCount()));
        case "cpuCount":
            return Optional.ofNullable(clazz.cast(cpuCount()));
        case "customerContactsToSendToOCI":
            return Optional.ofNullable(clazz.cast(customerContactsToSendToOCI()));
        case "dataStorageSizeInTBs":
            return Optional.ofNullable(clazz.cast(dataStorageSizeInTBs()));
        case "dbNodeStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(dbNodeStorageSizeInGBs()));
        case "dbServerVersion":
            return Optional.ofNullable(clazz.cast(dbServerVersion()));
        case "lastMaintenanceRunId":
            return Optional.ofNullable(clazz.cast(lastMaintenanceRunId()));
        case "maintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "maxCpuCount":
            return Optional.ofNullable(clazz.cast(maxCpuCount()));
        case "maxDataStorageInTBs":
            return Optional.ofNullable(clazz.cast(maxDataStorageInTBs()));
        case "maxDbNodeStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(maxDbNodeStorageSizeInGBs()));
        case "maxMemoryInGBs":
            return Optional.ofNullable(clazz.cast(maxMemoryInGBs()));
        case "memorySizeInGBs":
            return Optional.ofNullable(clazz.cast(memorySizeInGBs()));
        case "monthlyDbServerVersion":
            return Optional.ofNullable(clazz.cast(monthlyDbServerVersion()));
        case "monthlyStorageServerVersion":
            return Optional.ofNullable(clazz.cast(monthlyStorageServerVersion()));
        case "nextMaintenanceRunId":
            return Optional.ofNullable(clazz.cast(nextMaintenanceRunId()));
        case "ociResourceAnchorName":
            return Optional.ofNullable(clazz.cast(ociResourceAnchorName()));
        case "ociUrl":
            return Optional.ofNullable(clazz.cast(ociUrl()));
        case "ocid":
            return Optional.ofNullable(clazz.cast(ocid()));
        case "shape":
            return Optional.ofNullable(clazz.cast(shape()));
        case "storageCount":
            return Optional.ofNullable(clazz.cast(storageCount()));
        case "storageServerVersion":
            return Optional.ofNullable(clazz.cast(storageServerVersion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "totalStorageSizeInGBs":
            return Optional.ofNullable(clazz.cast(totalStorageSizeInGBs()));
        case "percentProgress":
            return Optional.ofNullable(clazz.cast(percentProgress()));
        case "databaseServerType":
            return Optional.ofNullable(clazz.cast(databaseServerType()));
        case "storageServerType":
            return Optional.ofNullable(clazz.cast(storageServerType()));
        case "computeModel":
            return Optional.ofNullable(clazz.cast(computeModelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("cloudExadataInfrastructureArn", CLOUD_EXADATA_INFRASTRUCTURE_ARN_FIELD);
        map.put("activatedStorageCount", ACTIVATED_STORAGE_COUNT_FIELD);
        map.put("additionalStorageCount", ADDITIONAL_STORAGE_COUNT_FIELD);
        map.put("availableStorageSizeInGBs", AVAILABLE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("computeCount", COMPUTE_COUNT_FIELD);
        map.put("cpuCount", CPU_COUNT_FIELD);
        map.put("customerContactsToSendToOCI", CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD);
        map.put("dataStorageSizeInTBs", DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServerVersion", DB_SERVER_VERSION_FIELD);
        map.put("lastMaintenanceRunId", LAST_MAINTENANCE_RUN_ID_FIELD);
        map.put("maintenanceWindow", MAINTENANCE_WINDOW_FIELD);
        map.put("maxCpuCount", MAX_CPU_COUNT_FIELD);
        map.put("maxDataStorageInTBs", MAX_DATA_STORAGE_IN_T_BS_FIELD);
        map.put("maxDbNodeStorageSizeInGBs", MAX_DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("maxMemoryInGBs", MAX_MEMORY_IN_G_BS_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("monthlyDbServerVersion", MONTHLY_DB_SERVER_VERSION_FIELD);
        map.put("monthlyStorageServerVersion", MONTHLY_STORAGE_SERVER_VERSION_FIELD);
        map.put("nextMaintenanceRunId", NEXT_MAINTENANCE_RUN_ID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("ociUrl", OCI_URL_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("storageCount", STORAGE_COUNT_FIELD);
        map.put("storageServerVersion", STORAGE_SERVER_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("totalStorageSizeInGBs", TOTAL_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("percentProgress", PERCENT_PROGRESS_FIELD);
        map.put("databaseServerType", DATABASE_SERVER_TYPE_FIELD);
        map.put("storageServerType", STORAGE_SERVER_TYPE_FIELD);
        map.put("computeModel", COMPUTE_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudExadataInfrastructure, T> g) {
        return obj -> g.apply((CloudExadataInfrastructure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudExadataInfrastructure> {
        /**
         * <p>
         * The unique identifier for the Exadata infrastructure.
         * </p>
         * 
         * @param cloudExadataInfrastructureId
         *        The unique identifier for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId);

        /**
         * <p>
         * The user-friendly name for the Exadata infrastructure.
         * </p>
         * 
         * @param displayName
         *        The user-friendly name for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The current status of the Exadata infrastructure.
         * </p>
         * 
         * @param status
         *        The current status of the Exadata infrastructure.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Exadata infrastructure.
         * </p>
         * 
         * @param status
         *        The current status of the Exadata infrastructure.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Additional information about the status of the Exadata infrastructure.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the status of the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Exadata infrastructure.
         * </p>
         * 
         * @param cloudExadataInfrastructureArn
         *        The Amazon Resource Name (ARN) for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructureArn(String cloudExadataInfrastructureArn);

        /**
         * <p>
         * The number of storage servers requested for the Exadata infrastructure.
         * </p>
         * 
         * @param activatedStorageCount
         *        The number of storage servers requested for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activatedStorageCount(Integer activatedStorageCount);

        /**
         * <p>
         * The number of storage servers requested for the Exadata infrastructure.
         * </p>
         * 
         * @param additionalStorageCount
         *        The number of storage servers requested for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalStorageCount(Integer additionalStorageCount);

        /**
         * <p>
         * The amount of available storage, in gigabytes (GB), for the Exadata infrastructure.
         * </p>
         * 
         * @param availableStorageSizeInGBs
         *        The amount of available storage, in gigabytes (GB), for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableStorageSizeInGBs(Integer availableStorageSizeInGBs);

        /**
         * <p>
         * The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
         * </p>
         * 
         * @param availabilityZone
         *        The name of the Availability Zone (AZ) where the Exadata infrastructure is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The AZ ID of the AZ where the Exadata infrastructure is located.
         * </p>
         * 
         * @param availabilityZoneId
         *        The AZ ID of the AZ where the Exadata infrastructure is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The number of database servers for the Exadata infrastructure.
         * </p>
         * 
         * @param computeCount
         *        The number of database servers for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeCount(Integer computeCount);

        /**
         * <p>
         * The total number of CPU cores that are allocated to the Exadata infrastructure.
         * </p>
         * 
         * @param cpuCount
         *        The total number of CPU cores that are allocated to the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCount(Integer cpuCount);

        /**
         * <p>
         * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata
         * infrastructure.
         * </p>
         * 
         * @param customerContactsToSendToOCI
         *        The email addresses of contacts to receive notification from Oracle about maintenance updates for the
         *        Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerContactsToSendToOCI(Collection<CustomerContact> customerContactsToSendToOCI);

        /**
         * <p>
         * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata
         * infrastructure.
         * </p>
         * 
         * @param customerContactsToSendToOCI
         *        The email addresses of contacts to receive notification from Oracle about maintenance updates for the
         *        Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerContactsToSendToOCI(CustomerContact... customerContactsToSendToOCI);

        /**
         * <p>
         * The email addresses of contacts to receive notification from Oracle about maintenance updates for the Exadata
         * infrastructure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.odb.model.CustomerContact.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.odb.model.CustomerContact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.odb.model.CustomerContact.Builder#build()} is called immediately and
         * its result is passed to {@link #customerContactsToSendToOCI(List<CustomerContact>)}.
         * 
         * @param customerContactsToSendToOCI
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.odb.model.CustomerContact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerContactsToSendToOCI(java.util.Collection<CustomerContact>)
         */
        Builder customerContactsToSendToOCI(Consumer<CustomerContact.Builder>... customerContactsToSendToOCI);

        /**
         * <p>
         * The size of the Exadata infrastructure's data disk group, in terabytes (TB).
         * </p>
         * 
         * @param dataStorageSizeInTBs
         *        The size of the Exadata infrastructure's data disk group, in terabytes (TB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs);

        /**
         * <p>
         * The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
         * </p>
         * 
         * @param dbNodeStorageSizeInGBs
         *        The size of the Exadata infrastructure's local node storage, in gigabytes (GB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs);

        /**
         * <p>
         * The software version of the database servers (dom0) in the Exadata infrastructure.
         * </p>
         * 
         * @param dbServerVersion
         *        The software version of the database servers (dom0) in the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServerVersion(String dbServerVersion);

        /**
         * <p>
         * The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata infrastructure.
         * </p>
         * 
         * @param lastMaintenanceRunId
         *        The Oracle Cloud Identifier (OCID) of the last maintenance run for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastMaintenanceRunId(String lastMaintenanceRunId);

        /**
         * <p>
         * The scheduling details for the maintenance window. Patching and system updates take place during the
         * maintenance window.
         * </p>
         * 
         * @param maintenanceWindow
         *        The scheduling details for the maintenance window. Patching and system updates take place during the
         *        maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(MaintenanceWindow maintenanceWindow);

        /**
         * <p>
         * The scheduling details for the maintenance window. Patching and system updates take place during the
         * maintenance window.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceWindow.Builder} avoiding the
         * need to create one manually via {@link MaintenanceWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindow(MaintenanceWindow)}.
         * 
         * @param maintenanceWindow
         *        a consumer that will call methods on {@link MaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindow(MaintenanceWindow)
         */
        default Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return maintenanceWindow(MaintenanceWindow.builder().applyMutation(maintenanceWindow).build());
        }

        /**
         * <p>
         * The total number of CPU cores available on the Exadata infrastructure.
         * </p>
         * 
         * @param maxCpuCount
         *        The total number of CPU cores available on the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCpuCount(Integer maxCpuCount);

        /**
         * <p>
         * The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata
         * infrastructure.
         * </p>
         * 
         * @param maxDataStorageInTBs
         *        The total amount of data disk group storage, in terabytes (TB), that's available on the Exadata
         *        infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDataStorageInTBs(Double maxDataStorageInTBs);

        /**
         * <p>
         * The total amount of local node storage, in gigabytes (GB), that's available on the Exadata infrastructure.
         * </p>
         * 
         * @param maxDbNodeStorageSizeInGBs
         *        The total amount of local node storage, in gigabytes (GB), that's available on the Exadata
         *        infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDbNodeStorageSizeInGBs(Integer maxDbNodeStorageSizeInGBs);

        /**
         * <p>
         * The total amount of memory, in gigabytes (GB), that's available on the Exadata infrastructure.
         * </p>
         * 
         * @param maxMemoryInGBs
         *        The total amount of memory, in gigabytes (GB), that's available on the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxMemoryInGBs(Integer maxMemoryInGBs);

        /**
         * <p>
         * The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure.
         * </p>
         * 
         * @param memorySizeInGBs
         *        The amount of memory, in gigabytes (GB), that's allocated on the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySizeInGBs(Integer memorySizeInGBs);

        /**
         * <p>
         * The monthly software version of the database servers installed on the Exadata infrastructure.
         * </p>
         * 
         * @param monthlyDbServerVersion
         *        The monthly software version of the database servers installed on the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyDbServerVersion(String monthlyDbServerVersion);

        /**
         * <p>
         * The monthly software version of the storage servers installed on the Exadata infrastructure.
         * </p>
         * 
         * @param monthlyStorageServerVersion
         *        The monthly software version of the storage servers installed on the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyStorageServerVersion(String monthlyStorageServerVersion);

        /**
         * <p>
         * The OCID of the next maintenance run for the Exadata infrastructure.
         * </p>
         * 
         * @param nextMaintenanceRunId
         *        The OCID of the next maintenance run for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMaintenanceRunId(String nextMaintenanceRunId);

        /**
         * <p>
         * The name of the OCI resource anchor for the Exadata infrastructure.
         * </p>
         * 
         * @param ociResourceAnchorName
         *        The name of the OCI resource anchor for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociResourceAnchorName(String ociResourceAnchorName);

        /**
         * <p>
         * The HTTPS link to the Exadata infrastructure in OCI.
         * </p>
         * 
         * @param ociUrl
         *        The HTTPS link to the Exadata infrastructure in OCI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociUrl(String ociUrl);

        /**
         * <p>
         * The OCID of the Exadata infrastructure.
         * </p>
         * 
         * @param ocid
         *        The OCID of the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ocid(String ocid);

        /**
         * <p>
         * The model name of the Exadata infrastructure.
         * </p>
         * 
         * @param shape
         *        The model name of the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shape(String shape);

        /**
         * <p>
         * The number of storage servers that are activated for the Exadata infrastructure.
         * </p>
         * 
         * @param storageCount
         *        The number of storage servers that are activated for the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCount(Integer storageCount);

        /**
         * <p>
         * The software version of the storage servers on the Exadata infrastructure.
         * </p>
         * 
         * @param storageServerVersion
         *        The software version of the storage servers on the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageServerVersion(String storageServerVersion);

        /**
         * <p>
         * The date and time when the Exadata infrastructure was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the Exadata infrastructure was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The total amount of storage, in gigabytes (GB), on the the Exadata infrastructure.
         * </p>
         * 
         * @param totalStorageSizeInGBs
         *        The total amount of storage, in gigabytes (GB), on the the Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalStorageSizeInGBs(Integer totalStorageSizeInGBs);

        /**
         * <p>
         * The amount of progress made on the current operation on the Exadata infrastructure, expressed as a
         * percentage.
         * </p>
         * 
         * @param percentProgress
         *        The amount of progress made on the current operation on the Exadata infrastructure, expressed as a
         *        percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentProgress(Float percentProgress);

        /**
         * <p>
         * The database server model type of the Exadata infrastructure. For the list of valid model names, use the
         * <code>ListDbSystemShapes</code> operation.
         * </p>
         * 
         * @param databaseServerType
         *        The database server model type of the Exadata infrastructure. For the list of valid model names, use
         *        the <code>ListDbSystemShapes</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseServerType(String databaseServerType);

        /**
         * <p>
         * The storage server model type of the Exadata infrastructure. For the list of valid model names, use the
         * <code>ListDbSystemShapes</code> operation.
         * </p>
         * 
         * @param storageServerType
         *        The storage server model type of the Exadata infrastructure. For the list of valid model names, use
         *        the <code>ListDbSystemShapes</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageServerType(String storageServerType);

        /**
         * <p>
         * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
         * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of
         * compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on
         * the physical core of a processor with hyper-threading enabled.
         * </p>
         * 
         * @param computeModel
         *        The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
         *        abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
         *        from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
         *        OCPUs are based on the physical core of a processor with hyper-threading enabled.
         * @see ComputeModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeModel
         */
        Builder computeModel(String computeModel);

        /**
         * <p>
         * The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an abstracted
         * measure of compute resources. ECPUs are based on the number of cores elastically allocated from a pool of
         * compute and storage servers. An OCPU is a legacy physical measure of compute resources. OCPUs are based on
         * the physical core of a processor with hyper-threading enabled.
         * </p>
         * 
         * @param computeModel
         *        The OCI model compute model used when you create or clone an instance: ECPU or OCPU. An ECPU is an
         *        abstracted measure of compute resources. ECPUs are based on the number of cores elastically allocated
         *        from a pool of compute and storage servers. An OCPU is a legacy physical measure of compute resources.
         *        OCPUs are based on the physical core of a processor with hyper-threading enabled.
         * @see ComputeModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeModel
         */
        Builder computeModel(ComputeModel computeModel);
    }

    static final class BuilderImpl implements Builder {
        private String cloudExadataInfrastructureId;

        private String displayName;

        private String status;

        private String statusReason;

        private String cloudExadataInfrastructureArn;

        private Integer activatedStorageCount;

        private Integer additionalStorageCount;

        private Integer availableStorageSizeInGBs;

        private String availabilityZone;

        private String availabilityZoneId;

        private Integer computeCount;

        private Integer cpuCount;

        private List<CustomerContact> customerContactsToSendToOCI = DefaultSdkAutoConstructList.getInstance();

        private Double dataStorageSizeInTBs;

        private Integer dbNodeStorageSizeInGBs;

        private String dbServerVersion;

        private String lastMaintenanceRunId;

        private MaintenanceWindow maintenanceWindow;

        private Integer maxCpuCount;

        private Double maxDataStorageInTBs;

        private Integer maxDbNodeStorageSizeInGBs;

        private Integer maxMemoryInGBs;

        private Integer memorySizeInGBs;

        private String monthlyDbServerVersion;

        private String monthlyStorageServerVersion;

        private String nextMaintenanceRunId;

        private String ociResourceAnchorName;

        private String ociUrl;

        private String ocid;

        private String shape;

        private Integer storageCount;

        private String storageServerVersion;

        private Instant createdAt;

        private Integer totalStorageSizeInGBs;

        private Float percentProgress;

        private String databaseServerType;

        private String storageServerType;

        private String computeModel;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudExadataInfrastructure model) {
            cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            displayName(model.displayName);
            status(model.status);
            statusReason(model.statusReason);
            cloudExadataInfrastructureArn(model.cloudExadataInfrastructureArn);
            activatedStorageCount(model.activatedStorageCount);
            additionalStorageCount(model.additionalStorageCount);
            availableStorageSizeInGBs(model.availableStorageSizeInGBs);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            computeCount(model.computeCount);
            cpuCount(model.cpuCount);
            customerContactsToSendToOCI(model.customerContactsToSendToOCI);
            dataStorageSizeInTBs(model.dataStorageSizeInTBs);
            dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            dbServerVersion(model.dbServerVersion);
            lastMaintenanceRunId(model.lastMaintenanceRunId);
            maintenanceWindow(model.maintenanceWindow);
            maxCpuCount(model.maxCpuCount);
            maxDataStorageInTBs(model.maxDataStorageInTBs);
            maxDbNodeStorageSizeInGBs(model.maxDbNodeStorageSizeInGBs);
            maxMemoryInGBs(model.maxMemoryInGBs);
            memorySizeInGBs(model.memorySizeInGBs);
            monthlyDbServerVersion(model.monthlyDbServerVersion);
            monthlyStorageServerVersion(model.monthlyStorageServerVersion);
            nextMaintenanceRunId(model.nextMaintenanceRunId);
            ociResourceAnchorName(model.ociResourceAnchorName);
            ociUrl(model.ociUrl);
            ocid(model.ocid);
            shape(model.shape);
            storageCount(model.storageCount);
            storageServerVersion(model.storageServerVersion);
            createdAt(model.createdAt);
            totalStorageSizeInGBs(model.totalStorageSizeInGBs);
            percentProgress(model.percentProgress);
            databaseServerType(model.databaseServerType);
            storageServerType(model.storageServerType);
            computeModel(model.computeModel);
        }

        public final String getCloudExadataInfrastructureId() {
            return cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getCloudExadataInfrastructureArn() {
            return cloudExadataInfrastructureArn;
        }

        public final void setCloudExadataInfrastructureArn(String cloudExadataInfrastructureArn) {
            this.cloudExadataInfrastructureArn = cloudExadataInfrastructureArn;
        }

        @Override
        public final Builder cloudExadataInfrastructureArn(String cloudExadataInfrastructureArn) {
            this.cloudExadataInfrastructureArn = cloudExadataInfrastructureArn;
            return this;
        }

        public final Integer getActivatedStorageCount() {
            return activatedStorageCount;
        }

        public final void setActivatedStorageCount(Integer activatedStorageCount) {
            this.activatedStorageCount = activatedStorageCount;
        }

        @Override
        public final Builder activatedStorageCount(Integer activatedStorageCount) {
            this.activatedStorageCount = activatedStorageCount;
            return this;
        }

        public final Integer getAdditionalStorageCount() {
            return additionalStorageCount;
        }

        public final void setAdditionalStorageCount(Integer additionalStorageCount) {
            this.additionalStorageCount = additionalStorageCount;
        }

        @Override
        public final Builder additionalStorageCount(Integer additionalStorageCount) {
            this.additionalStorageCount = additionalStorageCount;
            return this;
        }

        public final Integer getAvailableStorageSizeInGBs() {
            return availableStorageSizeInGBs;
        }

        public final void setAvailableStorageSizeInGBs(Integer availableStorageSizeInGBs) {
            this.availableStorageSizeInGBs = availableStorageSizeInGBs;
        }

        @Override
        public final Builder availableStorageSizeInGBs(Integer availableStorageSizeInGBs) {
            this.availableStorageSizeInGBs = availableStorageSizeInGBs;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Integer getComputeCount() {
            return computeCount;
        }

        public final void setComputeCount(Integer computeCount) {
            this.computeCount = computeCount;
        }

        @Override
        public final Builder computeCount(Integer computeCount) {
            this.computeCount = computeCount;
            return this;
        }

        public final Integer getCpuCount() {
            return cpuCount;
        }

        public final void setCpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
        }

        @Override
        public final Builder cpuCount(Integer cpuCount) {
            this.cpuCount = cpuCount;
            return this;
        }

        public final List<CustomerContact.Builder> getCustomerContactsToSendToOCI() {
            List<CustomerContact.Builder> result = CustomerContactsCopier.copyToBuilder(this.customerContactsToSendToOCI);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomerContactsToSendToOCI(Collection<CustomerContact.BuilderImpl> customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI = CustomerContactsCopier.copyFromBuilder(customerContactsToSendToOCI);
        }

        @Override
        public final Builder customerContactsToSendToOCI(Collection<CustomerContact> customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI = CustomerContactsCopier.copy(customerContactsToSendToOCI);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerContactsToSendToOCI(CustomerContact... customerContactsToSendToOCI) {
            customerContactsToSendToOCI(Arrays.asList(customerContactsToSendToOCI));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerContactsToSendToOCI(Consumer<CustomerContact.Builder>... customerContactsToSendToOCI) {
            customerContactsToSendToOCI(Stream.of(customerContactsToSendToOCI)
                    .map(c -> CustomerContact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getDataStorageSizeInTBs() {
            return dataStorageSizeInTBs;
        }

        public final void setDataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        }

        @Override
        public final Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final String getDbServerVersion() {
            return dbServerVersion;
        }

        public final void setDbServerVersion(String dbServerVersion) {
            this.dbServerVersion = dbServerVersion;
        }

        @Override
        public final Builder dbServerVersion(String dbServerVersion) {
            this.dbServerVersion = dbServerVersion;
            return this;
        }

        public final String getLastMaintenanceRunId() {
            return lastMaintenanceRunId;
        }

        public final void setLastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
        }

        @Override
        public final Builder lastMaintenanceRunId(String lastMaintenanceRunId) {
            this.lastMaintenanceRunId = lastMaintenanceRunId;
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return maintenanceWindow != null ? maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getMaxCpuCount() {
            return maxCpuCount;
        }

        public final void setMaxCpuCount(Integer maxCpuCount) {
            this.maxCpuCount = maxCpuCount;
        }

        @Override
        public final Builder maxCpuCount(Integer maxCpuCount) {
            this.maxCpuCount = maxCpuCount;
            return this;
        }

        public final Double getMaxDataStorageInTBs() {
            return maxDataStorageInTBs;
        }

        public final void setMaxDataStorageInTBs(Double maxDataStorageInTBs) {
            this.maxDataStorageInTBs = maxDataStorageInTBs;
        }

        @Override
        public final Builder maxDataStorageInTBs(Double maxDataStorageInTBs) {
            this.maxDataStorageInTBs = maxDataStorageInTBs;
            return this;
        }

        public final Integer getMaxDbNodeStorageSizeInGBs() {
            return maxDbNodeStorageSizeInGBs;
        }

        public final void setMaxDbNodeStorageSizeInGBs(Integer maxDbNodeStorageSizeInGBs) {
            this.maxDbNodeStorageSizeInGBs = maxDbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder maxDbNodeStorageSizeInGBs(Integer maxDbNodeStorageSizeInGBs) {
            this.maxDbNodeStorageSizeInGBs = maxDbNodeStorageSizeInGBs;
            return this;
        }

        public final Integer getMaxMemoryInGBs() {
            return maxMemoryInGBs;
        }

        public final void setMaxMemoryInGBs(Integer maxMemoryInGBs) {
            this.maxMemoryInGBs = maxMemoryInGBs;
        }

        @Override
        public final Builder maxMemoryInGBs(Integer maxMemoryInGBs) {
            this.maxMemoryInGBs = maxMemoryInGBs;
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final String getMonthlyDbServerVersion() {
            return monthlyDbServerVersion;
        }

        public final void setMonthlyDbServerVersion(String monthlyDbServerVersion) {
            this.monthlyDbServerVersion = monthlyDbServerVersion;
        }

        @Override
        public final Builder monthlyDbServerVersion(String monthlyDbServerVersion) {
            this.monthlyDbServerVersion = monthlyDbServerVersion;
            return this;
        }

        public final String getMonthlyStorageServerVersion() {
            return monthlyStorageServerVersion;
        }

        public final void setMonthlyStorageServerVersion(String monthlyStorageServerVersion) {
            this.monthlyStorageServerVersion = monthlyStorageServerVersion;
        }

        @Override
        public final Builder monthlyStorageServerVersion(String monthlyStorageServerVersion) {
            this.monthlyStorageServerVersion = monthlyStorageServerVersion;
            return this;
        }

        public final String getNextMaintenanceRunId() {
            return nextMaintenanceRunId;
        }

        public final void setNextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
        }

        @Override
        public final Builder nextMaintenanceRunId(String nextMaintenanceRunId) {
            this.nextMaintenanceRunId = nextMaintenanceRunId;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final String getOciUrl() {
            return ociUrl;
        }

        public final void setOciUrl(String ociUrl) {
            this.ociUrl = ociUrl;
        }

        @Override
        public final Builder ociUrl(String ociUrl) {
            this.ociUrl = ociUrl;
            return this;
        }

        public final String getOcid() {
            return ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getShape() {
            return shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final Integer getStorageCount() {
            return storageCount;
        }

        public final void setStorageCount(Integer storageCount) {
            this.storageCount = storageCount;
        }

        @Override
        public final Builder storageCount(Integer storageCount) {
            this.storageCount = storageCount;
            return this;
        }

        public final String getStorageServerVersion() {
            return storageServerVersion;
        }

        public final void setStorageServerVersion(String storageServerVersion) {
            this.storageServerVersion = storageServerVersion;
        }

        @Override
        public final Builder storageServerVersion(String storageServerVersion) {
            this.storageServerVersion = storageServerVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Integer getTotalStorageSizeInGBs() {
            return totalStorageSizeInGBs;
        }

        public final void setTotalStorageSizeInGBs(Integer totalStorageSizeInGBs) {
            this.totalStorageSizeInGBs = totalStorageSizeInGBs;
        }

        @Override
        public final Builder totalStorageSizeInGBs(Integer totalStorageSizeInGBs) {
            this.totalStorageSizeInGBs = totalStorageSizeInGBs;
            return this;
        }

        public final Float getPercentProgress() {
            return percentProgress;
        }

        public final void setPercentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final String getDatabaseServerType() {
            return databaseServerType;
        }

        public final void setDatabaseServerType(String databaseServerType) {
            this.databaseServerType = databaseServerType;
        }

        @Override
        public final Builder databaseServerType(String databaseServerType) {
            this.databaseServerType = databaseServerType;
            return this;
        }

        public final String getStorageServerType() {
            return storageServerType;
        }

        public final void setStorageServerType(String storageServerType) {
            this.storageServerType = storageServerType;
        }

        @Override
        public final Builder storageServerType(String storageServerType) {
            this.storageServerType = storageServerType;
            return this;
        }

        public final String getComputeModel() {
            return computeModel;
        }

        public final void setComputeModel(String computeModel) {
            this.computeModel = computeModel;
        }

        @Override
        public final Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            return this;
        }

        @Override
        public final Builder computeModel(ComputeModel computeModel) {
            this.computeModel(computeModel == null ? null : computeModel.toString());
            return this;
        }

        @Override
        public CloudExadataInfrastructure build() {
            return new CloudExadataInfrastructure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
