/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Objective {
    AUTO("AUTO"),
    BALANCED("BALANCED"),
    BASIC("BASIC"),
    HIGH_THROUGHPUT("HIGH_THROUGHPUT"),
    LOW_LATENCY("LOW_LATENCY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Objective> VALUE_MAP;
    private final String value;

    private Objective(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Objective fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Objective> knownValues() {
        EnumSet<Objective> knownValues = EnumSet.allOf(Objective.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Objective.class, Objective::toString);
    }
}

