/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.AutonomousVirtualMachineSummary;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse;

public class ListAutonomousVirtualMachinesIterable
implements SdkIterable<ListAutonomousVirtualMachinesResponse> {
    private final OdbClient client;
    private final ListAutonomousVirtualMachinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAutonomousVirtualMachinesIterable(OdbClient client, ListAutonomousVirtualMachinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAutonomousVirtualMachinesResponseFetcher();
    }

    public Iterator<ListAutonomousVirtualMachinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutonomousVirtualMachineSummary> autonomousVirtualMachines() {
        Function<ListAutonomousVirtualMachinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.autonomousVirtualMachines() != null) {
                return response.autonomousVirtualMachines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAutonomousVirtualMachinesResponseFetcher
    implements SyncPageFetcher<ListAutonomousVirtualMachinesResponse> {
        private ListAutonomousVirtualMachinesResponseFetcher() {
        }

        public boolean hasNextPage(ListAutonomousVirtualMachinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAutonomousVirtualMachinesResponse nextPage(ListAutonomousVirtualMachinesResponse previousPage) {
            if (previousPage == null) {
                return ListAutonomousVirtualMachinesIterable.this.client.listAutonomousVirtualMachines(ListAutonomousVirtualMachinesIterable.this.firstRequest);
            }
            return ListAutonomousVirtualMachinesIterable.this.client.listAutonomousVirtualMachines((ListAutonomousVirtualMachinesRequest)((Object)ListAutonomousVirtualMachinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

