/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.observabilityadmin.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidationError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidationError> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ValidationError.getter(ValidationError::message)).setter(ValidationError.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(ValidationError.getter(ValidationError::reason)).setter(ValidationError.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<Map<String, String>> FIELD_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("FieldMap").getter(ValidationError.getter(ValidationError::fieldMap)).setter(ValidationError.setter(Builder::fieldMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, REASON_FIELD, FIELD_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidationError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String message;
    private final String reason;
    private final Map<String, String> fieldMap;

    private ValidationError(BuilderImpl builder) {
        this.message = builder.message;
        this.reason = builder.reason;
        this.fieldMap = builder.fieldMap;
    }

    public final String message() {
        return this.message;
    }

    public final String reason() {
        return this.reason;
    }

    public final boolean hasFieldMap() {
        return this.fieldMap != null && !(this.fieldMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> fieldMap() {
        return this.fieldMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldMap() ? this.fieldMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError)obj;
        return Objects.equals(this.message(), other.message()) && Objects.equals(this.reason(), other.reason()) && this.hasFieldMap() == other.hasFieldMap() && Objects.equals(this.fieldMap(), other.fieldMap());
    }

    public final String toString() {
        return ToString.builder((String)"ValidationError").add("Message", (Object)this.message()).add("Reason", (Object)this.reason()).add("FieldMap", this.hasFieldMap() ? this.fieldMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "FieldMap": {
                return Optional.ofNullable(clazz.cast(this.fieldMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Message", MESSAGE_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("FieldMap", FIELD_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationError, T> g) {
        return obj -> g.apply((ValidationError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private String reason;
        private Map<String, String> fieldMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationError model) {
            this.message(model.message);
            this.reason(model.reason);
            this.fieldMap(model.fieldMap);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Map<String, String> getFieldMap() {
            if (this.fieldMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.fieldMap;
        }

        public final void setFieldMap(Map<String, String> fieldMap) {
            this.fieldMap = FieldMapCopier.copy(fieldMap);
        }

        @Override
        public final Builder fieldMap(Map<String, String> fieldMap) {
            this.fieldMap = FieldMapCopier.copy(fieldMap);
            return this;
        }

        public ValidationError build() {
            return new ValidationError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidationError> {
        public Builder message(String var1);

        public Builder reason(String var1);

        public Builder fieldMap(Map<String, String> var1);
    }
}

