/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.observabilityadmin.model.EncryptedLogGroupStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceLogsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceLogsConfiguration> {
    private static final SdkField<String> LOG_GROUP_SELECTION_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupSelectionCriteria").getter(SourceLogsConfiguration.getter(SourceLogsConfiguration::logGroupSelectionCriteria)).setter(SourceLogsConfiguration.setter(Builder::logGroupSelectionCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupSelectionCriteria").build()}).build();
    private static final SdkField<String> ENCRYPTED_LOG_GROUP_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptedLogGroupStrategy").getter(SourceLogsConfiguration.getter(SourceLogsConfiguration::encryptedLogGroupStrategyAsString)).setter(SourceLogsConfiguration.setter(Builder::encryptedLogGroupStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedLogGroupStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_SELECTION_CRITERIA_FIELD, ENCRYPTED_LOG_GROUP_STRATEGY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceLogsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logGroupSelectionCriteria;
    private final String encryptedLogGroupStrategy;

    private SourceLogsConfiguration(BuilderImpl builder) {
        this.logGroupSelectionCriteria = builder.logGroupSelectionCriteria;
        this.encryptedLogGroupStrategy = builder.encryptedLogGroupStrategy;
    }

    public final String logGroupSelectionCriteria() {
        return this.logGroupSelectionCriteria;
    }

    public final EncryptedLogGroupStrategy encryptedLogGroupStrategy() {
        return EncryptedLogGroupStrategy.fromValue(this.encryptedLogGroupStrategy);
    }

    public final String encryptedLogGroupStrategyAsString() {
        return this.encryptedLogGroupStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupSelectionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedLogGroupStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceLogsConfiguration)) {
            return false;
        }
        SourceLogsConfiguration other = (SourceLogsConfiguration)obj;
        return Objects.equals(this.logGroupSelectionCriteria(), other.logGroupSelectionCriteria()) && Objects.equals(this.encryptedLogGroupStrategyAsString(), other.encryptedLogGroupStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SourceLogsConfiguration").add("LogGroupSelectionCriteria", (Object)this.logGroupSelectionCriteria()).add("EncryptedLogGroupStrategy", (Object)this.encryptedLogGroupStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogGroupSelectionCriteria": {
                return Optional.ofNullable(clazz.cast(this.logGroupSelectionCriteria()));
            }
            case "EncryptedLogGroupStrategy": {
                return Optional.ofNullable(clazz.cast(this.encryptedLogGroupStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LogGroupSelectionCriteria", LOG_GROUP_SELECTION_CRITERIA_FIELD);
        map.put("EncryptedLogGroupStrategy", ENCRYPTED_LOG_GROUP_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceLogsConfiguration, T> g) {
        return obj -> g.apply((SourceLogsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logGroupSelectionCriteria;
        private String encryptedLogGroupStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceLogsConfiguration model) {
            this.logGroupSelectionCriteria(model.logGroupSelectionCriteria);
            this.encryptedLogGroupStrategy(model.encryptedLogGroupStrategy);
        }

        public final String getLogGroupSelectionCriteria() {
            return this.logGroupSelectionCriteria;
        }

        public final void setLogGroupSelectionCriteria(String logGroupSelectionCriteria) {
            this.logGroupSelectionCriteria = logGroupSelectionCriteria;
        }

        @Override
        public final Builder logGroupSelectionCriteria(String logGroupSelectionCriteria) {
            this.logGroupSelectionCriteria = logGroupSelectionCriteria;
            return this;
        }

        public final String getEncryptedLogGroupStrategy() {
            return this.encryptedLogGroupStrategy;
        }

        public final void setEncryptedLogGroupStrategy(String encryptedLogGroupStrategy) {
            this.encryptedLogGroupStrategy = encryptedLogGroupStrategy;
        }

        @Override
        public final Builder encryptedLogGroupStrategy(String encryptedLogGroupStrategy) {
            this.encryptedLogGroupStrategy = encryptedLogGroupStrategy;
            return this;
        }

        @Override
        public final Builder encryptedLogGroupStrategy(EncryptedLogGroupStrategy encryptedLogGroupStrategy) {
            this.encryptedLogGroupStrategy(encryptedLogGroupStrategy == null ? null : encryptedLogGroupStrategy.toString());
            return this;
        }

        public SourceLogsConfiguration build() {
            return new SourceLogsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceLogsConfiguration> {
        public Builder logGroupSelectionCriteria(String var1);

        public Builder encryptedLogGroupStrategy(String var1);

        public Builder encryptedLogGroupStrategy(EncryptedLogGroupStrategy var1);
    }
}

